/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.formplugin.web.mobile;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.EventObject;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.util.third.collect.ImmutableMap;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.util.ArrayUtils;
import kd.wtc.wtp.common.model.teamhome.TeamQuotaIndexQueryDto;
import kd.wtc.wtss.common.constants.MobileTeamConstants;
import kd.wtc.wtss.common.constants.TeamQuotaListMobConstants;

public class TeamQuotaDetailMobPlugin
extends AbstractMobFormPlugin
implements RowClickEventListener {
    private static final String[] PROPERTIES = new String[]{"qttype.name", "usestartdate", "useenddate", "ownvalue", "usablevalue", "freezevalue", "usedvalue", "canbeodvalue", "useodvalue", "cdedvalue", "pastvalue"};

    public void preOpenForm(PreOpenFormEventArgs args) {
        Map customParams = args.getFormShowParameter().getCustomParams();
        if (customParams.get("currentQuotaSourceId") == null) {
            args.setCancel(true);
            args.setCancelMessage(MobileTeamConstants.TIPS_PARAMS_ERROR.loadKDString());
        }
    }

    public void initialize() {
        super.initialize();
        CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
        cardEntry.addRowClickListener((RowClickEventListener)this);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        long personId = Long.parseLong((String)formShowParameter.getCustomParam("personid"));
        long sourceId = Long.parseLong((String)formShowParameter.getCustomParam("currentQuotaSourceId"));
        HRBaseServiceHelper quotaSourceHelper = new HRBaseServiceHelper("wtp_quotasource");
        Optional<DynamicObject> source = Optional.ofNullable(quotaSourceHelper.queryOne("id,name,unit", (Object)sourceId));
        TeamQuotaIndexQueryDto queryDto = (TeamQuotaIndexQueryDto)SerializationUtils.fromJsonString((String)((String)formShowParameter.getCustomParam("teamquotaindexquerydto")), TeamQuotaIndexQueryDto.class);
        Optional<Map> resultMap = Optional.ofNullable(queryDto.getPersonIdAndIndexWithValue());
        String unit = source.map(dy -> (String)TeamQuotaListMobConstants.UNITMAP.get(dy.getString("unit"))).orElseGet(() -> null);
        this.getPageCache().put("unit", unit);
        String quota = resultMap.map(map -> (Map)map.get(personId)).map(map -> (BigDecimal)map.get(sourceId)).map(val -> val.setScale(3, 4).stripTrailingZeros().toPlainString() + unit).orElseGet(() -> "");
        Set quotaDetailIds = Optional.ofNullable(queryDto.getIndexIdAndQuotaDetailIdListMap()).map(map -> (Map)map.get(personId)).map(map -> (Set)map.get(sourceId)).orElseGet(Sets::newHashSet);
        if ("".equals(quota) || quotaDetailIds.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"datapanel"});
            return;
        }
        String quotaDesc = ResManager.loadKDString((String)"{0}\u5171\uff1a{1}", (String)"TeamQuotaDetailMobPlugin_0", (String)"wtc-wtss-formplugin", (Object[])new Object[]{source.map(dy -> dy.getString("name")).orElseGet(() -> ""), quota});
        this.getModel().setValue("quota", (Object)quotaDesc);
        this.setEntryEntity(ImmutableMap.of((Object)"quotaDetailIds", (Object)quotaDetailIds));
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        boolean isDisplay = !Boolean.FALSE.equals(this.getModel().getValue("isdisplay", evt.getRow()));
        this.getModel().setValue("isdisplay", (Object)(!isDisplay ? 1 : 0), evt.getRow());
    }

    private void setEntryEntity(Map<String, Object> params) {
        String selectProperties = String.join((CharSequence)",", PROPERTIES);
        Object quotaDetailIds = params.get("quotaDetailIds");
        QFilter idFilter = new QFilter("id", "in", quotaDetailIds);
        HRBaseServiceHelper detailHelper = new HRBaseServiceHelper("wtss_qtlinedetail");
        Object[] details = detailHelper.query(selectProperties, new QFilter[]{idFilter});
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        if (ArrayUtils.isEmpty((Object[])details)) {
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexnodata"});
        model.batchCreateNewEntryRow("entryentity", details.length);
        for (int i = 0; i < details.length; ++i) {
            Object detail = details[i];
            if (detail == null) continue;
            for (String prop : PROPERTIES) {
                if ("qttype.name".equals(prop)) {
                    model.setValue("qttypename", detail.get(prop), i);
                    continue;
                }
                model.setValue(prop, detail.get(prop), i);
            }
            BigDecimal quota = detail.getBigDecimal("usablevalue").setScale(1, RoundingMode.HALF_UP);
            model.setValue("qttypequota", (Object)(quota + this.getPageCache().get("unit")), i);
        }
    }
}

