/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.formplugin.web.mobile;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.MapUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtss.business.attstatistics.AttStatisticsFormService;
import kd.wtc.wtss.business.servicehelper.common.SchemaServiceHelper;
import kd.wtc.wtss.business.servicehelper.mobile.MobileHomePageBusiness;
import kd.wtc.wtss.common.constants.MobileTeamConstants;
import kd.wtc.wtss.common.dto.mobilehome.AttStatisticQueryParam;
import kd.wtc.wtss.common.enums.attstatistics.StaCombinationTerminal;
import kd.wtc.wtss.formplugin.web.mobile.QuotaTabUtils;

public class TeamQuotaHomeMobPlugin
extends AbstractMobFormPlugin
implements EntryGridBindDataListener,
TabSelectListener {
    private static final Log LOG = LogFactory.getLog(TeamQuotaHomeMobPlugin.class);
    public static final String IS_NOT_FIRST = "isNotFirst";

    public void preOpenForm(PreOpenFormEventArgs args) {
        Map customParams = args.getFormShowParameter().getCustomParams();
        if (customParams.get("cache_rule_id") == null) {
            args.setCancel(true);
            args.setCancelMessage(MobileTeamConstants.TIPS_PARAMS_ERROR.loadKDString());
        }
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        super.loadCustomControlMetas(args);
        Map params = ((MobileFormShowParameter)args.getSource()).getCustomParams();
        long ruleId = Long.parseLong((String)params.get("cache_rule_id"));
        Map quotaItemIds = SchemaServiceHelper.getInstance().getQuotaItemIds(Long.valueOf(ruleId), "1");
        if (MapUtils.isEmpty((Map)quotaItemIds)) {
            return;
        }
        ArrayList<Object> sourceIds = new ArrayList<Object>(quotaItemIds.keySet());
        QuotaTabUtils.loadTabs(args, sourceIds);
        params.put("currentQuotaSourceId", sourceIds.get(0));
        params.put("sourceIds", sourceIds);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Date date = this.getDate(customParams);
        if (date == null) {
            date = new Date();
        }
        this.getModel().setValue("qtdate", (Object)date);
    }

    public void registerListener(EventObject eo) {
        super.registerListener(eo);
        ((Tab)this.getControl("tabap")).addTabSelectListener((TabSelectListener)this);
        ((Container)this.getControl("flextosearch")).addClickListener((ClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String tabKey = QuotaTabUtils.getTabKey(this.getView().getFormShowParameter().getCustomParam("currentQuotaSourceId"));
        this.afterBindDataTableSelect(tabKey);
    }

    public void click(EventObject event) {
        super.click(event);
        String key = ((Control)event.getSource()).getKey();
        if ("flextosearch".equals(key)) {
            MobileFormShowParameter showParameter = new MobileFormShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.Floating);
            showParameter.setFormId("wtss_selteamperson");
            showParameter.getCustomParams().putAll(this.getView().getFormShowParameter().getCustomParams());
            showParameter.setCustomParam("qtdate", (Object)this.getModel().getDataEntity().getDate("qtdate"));
            showParameter.setCustomParam("currentQuotaSourceId", (Object)this.getPageCache().get("currentQuotaSourceId"));
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if ("qtdate".equals(e.getProperty().getName())) {
            AttStatisticQueryParam attStatisticQueryParam = AttStatisticsFormService.getInstance().getCacheAttStatisticQueryParam(this.getView(), StaCombinationTerminal.MOBILE);
            Long orgId = this.getOrgId("cache_admin_org");
            ChangeData[] changeSet = e.getChangeSet();
            if (null != changeSet && changeSet.length != 0) {
                if (!"true".equals(this.getView().getPageCache().get(IS_NOT_FIRST))) {
                    Date newValue = (Date)changeSet[0].getNewValue();
                    Tuple dateTuple = new Tuple((Object)WTCDateUtils.getBeginDayOfYear((Date)newValue), (Object)WTCDateUtils.getEndDayOfYear((Date)newValue));
                    if (!MobileHomePageBusiness.getInstance().checkDates(Boolean.valueOf(true), "3", this.getView(), attStatisticQueryParam, dateTuple, orgId)) {
                        Date oldValue = (Date)changeSet[0].getOldValue();
                        this.getView().getParentView().getPageCache().put("qtdate", WTCDateUtils.date2Str((Date)oldValue, (String)"yyyy-MM-dd"));
                        this.getPageCache().put(IS_NOT_FIRST, "true");
                        this.getModel().getDataEntity().set("qtdate", (Object)oldValue);
                        return;
                    }
                    this.getView().getParentView().getPageCache().put("qtdate", WTCDateUtils.date2Str((Date)newValue, (String)"yyyy-MM-dd"));
                }
                this.getPageCache().remove(IS_NOT_FIRST);
            }
            List sourceIds = (List)this.getView().getFormShowParameter().getCustomParam("sourceIds");
            for (Object sourceId : sourceIds) {
                IFormView view;
                String tabKey = QuotaTabUtils.getTabKey(sourceId);
                String pageId = this.getPageCache().get(tabKey);
                this.getPageCache().remove(tabKey);
                if (StringUtils.isBlank((CharSequence)pageId) || (view = this.getView().getView(pageId)) == null) continue;
                view.close();
            }
            String currentSourceId = this.getPageCache().get("currentQuotaSourceId");
            String currentTabKey = QuotaTabUtils.getTabKey(currentSourceId);
            Tab tab = (Tab)this.getControl("tabap");
            tab.addTabSelectListener((TabSelectListener)this);
            tab.selectTab(currentTabKey);
        }
    }

    public void tabSelected(TabSelectEvent event) {
        String tabKey = event.getTabKey();
        this.afterBindDataTableSelect(tabKey);
    }

    private void afterBindDataTableSelect(String tabKey) {
        HashMap customParams = Maps.newHashMap((Map)this.getView().getFormShowParameter().getCustomParams());
        AttStatisticQueryParam attStatisticQueryParam = AttStatisticsFormService.getInstance().getCacheAttStatisticQueryParam(this.getView(), StaCombinationTerminal.MOBILE);
        Long orgId = this.getOrgId("cache_admin_org");
        Date date = this.getDate(customParams);
        if (null == date) {
            date = (Date)this.getModel().getValue("qtdate");
        }
        Tuple dateTuple = new Tuple((Object)WTCDateUtils.getBeginDayOfYear((Date)date), (Object)WTCDateUtils.getEndDayOfYear((Date)date));
        if (!MobileHomePageBusiness.getInstance().checkDates(Boolean.valueOf(false), "3", this.getView(), attStatisticQueryParam, dateTuple, orgId)) {
            date = new Date();
        }
        customParams.put("qtdate", date);
        QuotaTabUtils.selectTabPlus((AbstractFormPlugin)this, tabKey, "wtss_teamquotalistmob", customParams);
    }

    private Long getOrgId(String cacheAdminOrg) {
        Map customParams;
        Long orgId = 0L;
        IDataModel model = this.getView().getParentView().getModel();
        if (model != null) {
            orgId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)model.getDataEntity(), (String)"affiliateadminorg");
        }
        if (WTCCollections.isEmpty((Map)(customParams = this.getView().getFormShowParameter().getCustomParams()))) {
            return orgId;
        }
        Object orgObj = customParams.get(cacheAdminOrg);
        if (null == orgObj) {
            return orgId;
        }
        if (0L == orgId) {
            orgId = Long.parseLong((String)orgObj);
        }
        return orgId;
    }

    private Date getDate(Map<String, Object> customParams) {
        Date date = null;
        Object dateStr = customParams.get("qtdate");
        if (WTCStringUtils.isNotEmpty((String)((String)dateStr))) {
            try {
                date = WTCDateUtils.parseDate((String)((String)dateStr), (String)"yyyy-MM-dd");
            }
            catch (ParseException ex) {
                LOG.warn("kd.wtc.wtss.formplugin.web.mobile.MobileTeamHomeFormPlugin.refreshQuotaData error ", (Throwable)ex);
            }
        }
        return date;
    }
}

