/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.formplugin.web.mobile;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RaiseEventType;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.rule.RaiseEventSource;
import kd.bos.entity.rule.RuleContainer;
import kd.bos.entity.rule.RuleExecuteContext;
import kd.bos.form.BindingContext;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.PullRefreshEvent;
import kd.bos.form.control.events.PullRefreshListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.rule.FormRuleExecuteContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;
import kd.wtc.wtbs.common.util.third.util.MapUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtp.common.model.teamhome.PersonInfoDto;
import kd.wtc.wtp.common.model.teamhome.TeamQuotaIndexQueryDto;
import kd.wtc.wtss.business.servicehelper.common.QuotaStatisticIndexService;
import kd.wtc.wtss.business.servicehelper.common.TeamHomeServiceHelper;
import kd.wtc.wtss.common.constants.MobileTeamConstants;
import kd.wtc.wtss.common.constants.TeamQuotaListMobConstants;

public class TeamQuotaListMobPlugin
extends AbstractMobFormPlugin
implements RowClickEventListener,
EntryGridBindDataListener,
PullRefreshListener {
    private static final Log LOG = LogFactory.getLog(TeamQuotaListMobPlugin.class);

    public void preOpenForm(PreOpenFormEventArgs args) {
        Map customParams = args.getFormShowParameter().getCustomParams();
        if (customParams.get("cache_rule_id") == null) {
            args.setCancel(true);
            args.setCancelMessage(MobileTeamConstants.TIPS_PARAMS_ERROR.loadKDString());
        }
    }

    public void initialize() {
        super.initialize();
        CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
        cardEntry.addRowClickListener((RowClickEventListener)this);
        cardEntry.addDataBindListener((EntryGridBindDataListener)this);
        cardEntry.addPullRefreshlisteners((PullRefreshListener)this);
    }

    public void entryGridBindData(EntryGridBindDataEvent event) {
        super.entryGridBindData(event);
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        AbstractGrid.GridState entryState = grid.getEntryState();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        long ruleId = Long.parseLong((String)parameter.getCustomParam("cache_rule_id"));
        int pageIndex = entryState.getCurrentPageIndex() - 1;
        int pageSize = entryState.getPageRows();
        List<Long> personIdList = this.getAndCachePersonIdList();
        if (CollectionUtils.isEmpty(personIdList)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexnodata"});
            return;
        }
        Date date = WTCDateUtils.str2Date((String)((String)this.getView().getFormShowParameter().getCustomParam("qtdate")), (String)"yyyy-MM-dd");
        if (date == null) {
            date = new Date();
        }
        Date beginDayOfYear = WTCDateUtils.getBeginDayOfYear((Date)date);
        Date endDayOfYear = WTCDateUtils.getEndDayOfYear((Date)date);
        long adminOrgId = Long.parseLong((String)parameter.getCustomParam("cache_admin_org"));
        TeamQuotaIndexQueryDto queryDto = QuotaStatisticIndexService.getInstance().getTeamQuotaIndexQueryDto(Long.valueOf(ruleId), beginDayOfYear, endDayOfYear, personIdList, pageIndex, pageSize, "0", Long.valueOf(adminOrgId));
        QuotaStatisticIndexService.getInstance().getTeamQuotaStatisticData(queryDto);
        if (LOG.isInfoEnabled()) {
            LOG.info("TeamQuotaListMobPlugin.entryGridBindData.queryDto:{}", (Object)SerializationUtils.toJsonString((Object)queryDto));
        }
        Optional<Map> resultMap = Optional.ofNullable(queryDto.getPersonIdAndIndexWithValue());
        if (MapUtils.isEmpty((Map)queryDto.getPersonInfoMap())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"entryentity"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexnodata"});
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexnodata"});
        int totalCount = Integer.parseInt(this.getPageCache().get("cache_personid_total"));
        int fromIndex = 0;
        int pageCount = 0;
        if (grid.isNeedPaged()) {
            pageCount = totalCount / entryState.getPageRows() + (totalCount % entryState.getPageRows() > 0 ? 1 : 0);
            if (pageCount == 0) {
                pageCount = 1;
            }
            if (entryState.getCurrentPageIndex() < 1) {
                entryState.setCurrentPageIndex(Integer.valueOf(1));
            } else if (entryState.getCurrentPageIndex() > pageCount) {
                entryState.setCurrentPageIndex(Integer.valueOf(pageCount));
            }
            fromIndex = pageIndex * pageSize;
        }
        Long sourceId = Long.parseLong((String)parameter.getCustomParam("currentQuotaSourceId"));
        HRBaseServiceHelper quotaSourceHelper = new HRBaseServiceHelper("wtp_quotasource");
        String unit = Optional.ofNullable(quotaSourceHelper.queryOne("id,name,unit", (Object)sourceId)).map(dy -> (String)TeamQuotaListMobConstants.UNITMAP.get(dy.getString("unit"))).orElseGet(() -> null);
        IDataModel model = this.getModel();
        model.beginInit();
        EntityType entityType = (EntityType)model.getDataEntityType().getAllEntities().get("entryentity");
        int size = queryDto.getPersonInfoMap().size();
        ArrayList rowDataEntityList = Lists.newArrayListWithExpectedSize((int)size);
        ArrayList rows = Lists.newArrayListWithExpectedSize((int)size);
        model.batchCreateNewEntryRow("entryentity", size);
        int rowIndex = fromIndex;
        for (Map.Entry entry : queryDto.getPersonInfoMap().entrySet()) {
            DynamicObject dy2 = new DynamicObject((DynamicObjectType)entityType);
            Long personId = (Long)entry.getKey();
            String quota = resultMap.map(map -> (Map)map.get(personId)).map(map -> (BigDecimal)map.get(sourceId)).map(val -> val.setScale(3, 4).stripTrailingZeros().toPlainString() + unit).orElseGet(() -> "");
            dy2.set("personid", (Object)personId);
            dy2.set("quota", (Object)quota);
            model.setValue("personid", (Object)personId, rowIndex);
            model.setValue("quota", (Object)quota, rowIndex);
            PersonInfoDto personInfo = (PersonInfoDto)entry.getValue();
            if (personInfo != null) {
                dy2.set("avatar", (Object)personInfo.getHeadSculpture());
                dy2.set("name", (Object)personInfo.getPersonName());
                dy2.set("number", (Object)personInfo.getNumber());
                dy2.set("cmpage", (Object)personInfo.getCmpAge());
                dy2.set("position", (Object)personInfo.getPosition());
                model.setValue("avatar", (Object)personInfo.getHeadSculpture(), rowIndex);
                model.setValue("name", (Object)personInfo.getPersonName(), rowIndex);
                model.setValue("number", (Object)personInfo.getNumber(), rowIndex);
                model.setValue("cmpage", (Object)personInfo.getCmpAge(), rowIndex);
                model.setValue("position", (Object)personInfo.getPosition(), rowIndex);
            }
            RowDataEntity rowDataEntity = new RowDataEntity(rowIndex, dy2);
            BindingContext bindCtx = new BindingContext((IDataEntityType)entityType, rowDataEntity.getDataEntity(), rowDataEntity.getRowIndex());
            List rowBindValue = grid.getRowBindValue(bindCtx);
            rowDataEntityList.add(rowDataEntity);
            rows.add(rowBindValue);
            ++rowIndex;
        }
        if (grid.getRuleCount() > 0) {
            RuleContainer ruleContainer = (RuleContainer)this.getView().getService(RuleContainer.class);
            ruleContainer.raise(new RaiseEventSource(RaiseEventType.Initialized, (List)rowDataEntityList, (IDataEntityType)entityType), (RuleExecuteContext)new FormRuleExecuteContext(this.getView()));
        }
        event.getData().put("rowcount", totalCount);
        event.getData().put("rows", rows);
        event.getData().put("pagecount", pageCount);
        event.getData().put("datacount", totalCount);
        model.endInit();
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        DynamicObject entry = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(evt.getRow());
        if (StringUtils.isBlank((CharSequence)entry.getString("quota"))) {
            this.getView().showErrorNotification(MobileTeamConstants.TIPS_NO_QUOTA_DETAIL.loadKDString());
            return;
        }
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId("wtss_teamquotapersonmob");
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.getCustomParams().putAll(this.getView().getFormShowParameter().getCustomParams());
        showParameter.setCustomParam("personid", (Object)String.valueOf(entry.get("personid")));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void pullRefesh(PullRefreshEvent event) {
        this.getView().invokeOperation("refresh");
    }

    private List<Long> getAndCachePersonIdList() {
        ArrayList personIdList;
        String cache = this.getPageCache().get("cache_personid_set");
        if (StringUtils.isBlank((CharSequence)cache)) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Date date = WTCDateUtils.str2Date((String)((String)formShowParameter.getCustomParam("qtdate")), (String)"yyyy-MM-dd");
            Date beginDayOfYear = WTCDateUtils.getBeginDayOfYear((Date)date);
            Date endDayOfYear = WTCDateUtils.getEndDayOfYear((Date)date);
            long orgId = Long.parseLong((String)formShowParameter.getCustomParam("cache_admin_org"));
            HashSet adminOrgIdSet = Sets.newHashSet((Object[])new Long[]{orgId});
            personIdList = new ArrayList(TeamHomeServiceHelper.getInstance().getPersonId(beginDayOfYear, endDayOfYear, (Set)adminOrgIdSet));
            if (CollectionUtils.isNotEmpty(personIdList)) {
                this.getPageCache().put("cache_personid_set", SerializationUtils.toJsonString(personIdList));
                this.getPageCache().put("cache_personid_total", String.valueOf(personIdList.size()));
            }
        } else {
            personIdList = (ArrayList)SerializationUtils.fromJsonString((String)cache, List.class);
        }
        return personIdList;
    }
}

