/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.formplugin.web.mobile;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.DateUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtp.common.model.teamhome.PersonInfoDto;
import kd.wtc.wtp.common.model.teamhome.TeamQuotaIndexQueryDto;
import kd.wtc.wtss.business.servicehelper.common.QuotaStatisticIndexService;
import kd.wtc.wtss.common.constants.MobileTeamConstants;
import kd.wtc.wtss.common.constants.QuotaListMobFilterConstants;
import kd.wtc.wtss.formplugin.web.mobile.QuotaTabUtils;
import org.apache.commons.collections.MapUtils;

public class TeamQuotaPersonMobPlugin
extends AbstractMobFormPlugin
implements EntryGridBindDataListener,
TabSelectListener {
    private static final Log LOG = LogFactory.getLog(TeamQuotaPersonMobPlugin.class);

    public void preOpenForm(PreOpenFormEventArgs args) {
        Map customParams = args.getFormShowParameter().getCustomParams();
        if (customParams.get("cache_rule_id") == null) {
            args.setCancel(true);
            args.setCancelMessage(MobileTeamConstants.TIPS_PARAMS_ERROR.loadKDString());
        }
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        super.loadCustomControlMetas(args);
        QuotaTabUtils.loadTabs(args, (List)((FormShowParameter)args.getSource()).getCustomParam("sourceIds"));
    }

    public void registerListener(EventObject eo) {
        super.registerListener(eo);
        ((Tab)this.getControl("tabap")).addTabSelectListener((TabSelectListener)this);
        ((Container)this.getControl("filterpanel")).addClickListener((ClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        long ruleId = Long.parseLong((String)formShowParameter.getCustomParam("cache_rule_id"));
        long personId = Long.parseLong((String)formShowParameter.getCustomParam("personid"));
        Date qtDate = WTCDateUtils.str2Date((String)((String)formShowParameter.getCustomParam("qtdate")), (String)"yyyy-MM-dd");
        if (qtDate == null) {
            qtDate = new Date();
        }
        String useDate = DateUtils.truncatedEquals((Date)qtDate, (Date)new Date(), (int)1) ? "thisyear" : null;
        Date[] dateRange = new Date[]{WTCDateUtils.getBeginDayOfYear((Date)qtDate), WTCDateUtils.getEndDayOfYear((Date)qtDate)};
        Date startDate = dateRange[0];
        Date endDate = dateRange[1];
        String startDateStr = "";
        String endDateStr = "";
        String dateRangeStr = (String)QuotaListMobFilterConstants.USEDATEMAP.get(useDate);
        if (Objects.isNull(useDate)) {
            startDateStr = WTCDateUtils.date2Str((Date)startDate, (String)"yyyy-MM-dd");
            endDateStr = WTCDateUtils.date2Str((Date)endDate, (String)"yyyy-MM-dd");
            dateRangeStr = startDateStr + " ~ " + endDateStr;
        }
        long adminOrgId = Long.parseLong((String)formShowParameter.getCustomParam("cache_admin_org"));
        TeamQuotaIndexQueryDto queryDto = QuotaStatisticIndexService.getInstance().getTeamQuotaIndexQueryDto(Long.valueOf(ruleId), startDate, endDate, Collections.singletonList(personId), 0, 10, "0", Long.valueOf(adminOrgId));
        QuotaStatisticIndexService.getInstance().getTeamQuotaStatisticData(queryDto);
        String queryDtoJson = SerializationUtils.toJsonString((Object)queryDto);
        LOG.info("TeamQuotaPersonMobPlugin.beforeBindData.queryDto:{}", (Object)queryDtoJson);
        PersonInfoDto personInfo = (PersonInfoDto)queryDto.getPersonInfoMap().get(personId);
        IDataModel model = this.getModel();
        model.setValue("daterange", (Object)dateRangeStr);
        model.setValue("avatar", (Object)personInfo.getHeadSculpture());
        model.setValue("name", (Object)personInfo.getPersonName());
        model.setValue("number", (Object)personInfo.getNumber());
        model.setValue("cmpage", (Object)personInfo.getCmpAge());
        model.setValue("position", (Object)personInfo.getPosition());
        HashMap objectObjectHashMap = Maps.newHashMapWithExpectedSize((int)16);
        objectObjectHashMap.put("usedate", useDate);
        objectObjectHashMap.put("startdate", startDate);
        objectObjectHashMap.put("enddate", endDate);
        objectObjectHashMap.put("originalUseDate", useDate);
        objectObjectHashMap.put("originalStartDate", startDateStr);
        objectObjectHashMap.put("originalEndDate", endDateStr);
        QuotaTabUtils.cacheQuotaListMobFilter(this.getView(), objectObjectHashMap);
        IPageCache pageCache = this.getPageCache();
        pageCache.put("teamquotaindexquerydto", queryDtoJson);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String tabKey = QuotaTabUtils.getTabKey(this.getView().getFormShowParameter().getCustomParam("currentQuotaSourceId"));
        Tab tab = (Tab)this.getControl("tabap");
        tab.activeTab(tabKey);
    }

    public void tabSelected(TabSelectEvent event) {
        HashMap customParams = Maps.newHashMap((Map)this.getView().getFormShowParameter().getCustomParams());
        customParams.put("teamquotaindexquerydto", this.getPageCache().get("teamquotaindexquerydto"));
        QuotaTabUtils.selectTab((AbstractFormPlugin)this, event, "wtss_teamquotadetailmob", customParams);
    }

    public void click(EventObject event) {
        super.click(event);
        String key = ((Control)event.getSource()).getKey();
        if ("filterpanel".equals(key)) {
            MobileFormShowParameter showParameter = new MobileFormShowParameter();
            showParameter.setFormId("wtss_quotalistmobfilter");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "quotalistmobfilter"));
            showParameter.setCustomParam("quotalistmobfilter", (Object)this.getPageCache().get("quotalistmobfilter"));
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        if ("quotalistmobfilter".equals(event.getActionId())) {
            HashMap quotaListMobFilter = Maps.newHashMap((Map)((Map)event.getReturnData()));
            Date[] dateRange = this.getDateRange(quotaListMobFilter);
            Date startDate = dateRange[0];
            Date endDate = dateRange[1];
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            long ruleId = Long.parseLong((String)formShowParameter.getCustomParam("cache_rule_id"));
            long personId = Long.parseLong((String)formShowParameter.getCustomParam("personid"));
            long adminOrgId = Long.parseLong((String)formShowParameter.getCustomParam("cache_admin_org"));
            TeamQuotaIndexQueryDto queryDto = QuotaStatisticIndexService.getInstance().getTeamQuotaIndexQueryDto(Long.valueOf(ruleId), startDate, endDate, Collections.singletonList(personId), 0, 10, "0", Long.valueOf(adminOrgId));
            QuotaStatisticIndexService.getInstance().getTeamQuotaStatisticData(queryDto);
            if (!Optional.ofNullable(queryDto.getIndexIdAndQuotaDetailIdListMap()).map(map -> (Map)map.get(personId)).filter(MapUtils::isNotEmpty).isPresent()) {
                this.getView().showErrorNotification(MobileTeamConstants.TIPS_NO_QUOTA_DETAIL.loadKDString());
                return;
            }
            String useDate = (String)quotaListMobFilter.get("usedate");
            String dateRangeStr = WTCStringUtils.isEmpty((String)useDate) ? WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)WTCDateUtils.str2Date((String)((String)quotaListMobFilter.get("startdate")), (String)"yyyy-MM-dd")) + " ~ " + WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)WTCDateUtils.str2Date((String)((String)quotaListMobFilter.get("enddate")), (String)"yyyy-MM-dd")) : (String)QuotaListMobFilterConstants.USEDATEMAP.get(useDate);
            this.getModel().setValue("daterange", (Object)dateRangeStr);
            QuotaTabUtils.cacheQuotaListMobFilter(this.getView(), quotaListMobFilter);
            String queryDtoJson = SerializationUtils.toJsonString((Object)queryDto);
            this.getPageCache().put("teamquotaindexquerydto", queryDtoJson);
            LOG.info("TeamQuotaPersonMobPlugin.closedCallBack.queryDto:{}", (Object)queryDtoJson);
            QuotaTabUtils.reloadTabs((AbstractFormPlugin)this);
        }
    }

    private Date[] getDateRange(Map<String, Object> params) {
        Date endDate;
        Date startDate;
        String useDate = (String)params.get("usedate");
        Date[] defaultDates = new Date[]{WTCDateUtils.getBeginDayOfYear(), WTCDateUtils.getEndDayOfYear()};
        LocalDate now = LocalDate.now();
        if (StringUtils.isBlank((CharSequence)useDate)) {
            startDate = WTCDateUtils.str2Date((String)((String)params.get("startdate")), (String)"yyyy-MM-dd");
            endDate = WTCDateUtils.getDayEndTime((Date)WTCDateUtils.str2Date((String)((String)params.get("enddate")), (String)"yyyy-MM-dd"));
        } else {
            switch (useDate) {
                case "today": {
                    startDate = Date.from(now.atStartOfDay(ZoneId.systemDefault()).toInstant());
                    endDate = WTCDateUtils.getDayEndTime((Date)startDate);
                    break;
                }
                case "thismonth": {
                    startDate = Date.from(now.with(TemporalAdjusters.firstDayOfMonth()).atStartOfDay(ZoneId.systemDefault()).toInstant());
                    endDate = WTCDateUtils.getEndDayOfMonth((Date)startDate);
                    break;
                }
                case "thisyear": {
                    startDate = Date.from(now.with(TemporalAdjusters.firstDayOfYear()).atStartOfDay(ZoneId.systemDefault()).toInstant());
                    endDate = WTCDateUtils.getEndDayOfYear((Date)startDate);
                    break;
                }
                default: {
                    return defaultDates;
                }
            }
        }
        return new Date[]{startDate, endDate};
    }
}

