/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.formplugin.web.pc;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.sdk.wtc.wtbs.business.custom.WTCCustomControlExtPlugin;
import kd.sdk.wtc.wtbs.common.enums.WTCApplyType;
import kd.sdk.wtc.wtbs.common.enums.WTCBillType;
import kd.sdk.wtc.wtss.business.homepage.BeforeShowApplyPageEvent;
import kd.sdk.wtc.wtss.business.homepage.BillReplaceExtPlugin;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxyFactory;
import kd.wtc.wtbs.business.mobile.MobileCommonServiceHelper;
import kd.wtc.wtbs.business.web.attperiod.PerAttPeriodQueryServiceImpl;
import kd.wtc.wtbs.common.model.mobile.AbnormalDealModel;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.model.period.PerAttPeriodQueryParam;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.WTCMaps;
import kd.wtc.wtbs.common.util.WTCSerializationUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;
import kd.wtc.wtbs.common.util.third.util.NumberUtils;
import kd.wtc.wtbs.common.util.third.util.ObjectUtils;
import kd.wtc.wtp.business.attconfirm.impl.AttConfirmQueryServiceImpl;
import kd.wtc.wtp.common.enums.attconfirm.AttConRecordStatusEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConfirmDataStatusEnum;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordModel;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordQueryParam;
import kd.wtc.wtss.business.attstatistics.AttConfirmServiceHelper;
import kd.wtc.wtss.business.servicehelper.common.HomePageServiceHelper;
import kd.wtc.wtss.business.servicehelper.common.QuotaStatisticIndexService;
import kd.wtc.wtss.business.servicehelper.common.SchemaServiceHelper;
import kd.wtc.wtss.business.servicehelper.mobile.MobileHomePageBusiness;
import kd.wtc.wtss.business.servicehelper.mobile.MobileHomePageServiceHelper;
import kd.wtc.wtss.business.servicehelper.pc.PersonHomePCBusiness;
import kd.wtc.wtss.business.servicehelper.pc.PersonHomePCCountBusiness;
import kd.wtc.wtss.business.servicehelper.pc.StaffPCAppConfigService;
import kd.wtc.wtss.business.servicehelper.summaryconf.SummaryConfigDetailService;
import kd.wtc.wtss.common.constants.PersonHomePCConstants;
import kd.wtc.wtss.common.constants.StaffPCAppConfigConstants;
import kd.wtc.wtss.common.dto.MobileHomeConf;
import kd.wtc.wtss.common.dto.mobilehome.AttRecordModel;
import kd.wtc.wtss.common.dto.mobilehome.CalendarGetDataModel;
import kd.wtc.wtss.common.dto.mobilehome.CalendarInitModel;
import kd.wtc.wtss.common.dto.mobilehome.DateDataModel;
import kd.wtc.wtss.common.dto.summaryconf.SummaryConfDetail;
import kd.wtc.wtss.common.enums.UnitDataEnum;
import kd.wtc.wtss.common.utils.WTSSDateUtils;

public class PersonHomePCPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
PersonHomePCConstants,
TabSelectListener,
BeforeF7SelectListener,
HyperLinkClickListener {
    private static final Log LOG = LogFactory.getLog(PersonHomePCPlugin.class);

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"flexmore", "labelmore", "configap", "labelquestion1", "labelquestion2", "labelquestion3", "btn_attcon"});
        CardEntry appContainer = (CardEntry)this.getView().getControl("fastappentryentity");
        appContainer.addRowClickListener((RowClickEventListener)this);
        CardEntry qtEntryEntityCountContainer = (CardEntry)this.getView().getControl("qtentryentitycount");
        qtEntryEntityCountContainer.addRowClickListener((RowClickEventListener)this);
        qtEntryEntityCountContainer.addHyperClickListener((HyperLinkClickListener)this);
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
        Container container = (Container)this.getControl("attstavector");
        container.addClickListener((ClickListener)this);
        this.addBeforeF7SelectListener("attperiodentry");
        this.addBeforeF7SelectListener("attperiod");
    }

    private void addBeforeF7SelectListener(String key) {
        BasedataEdit personAddEdit = (BasedataEdit)this.getView().getControl(key);
        personAddEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        LOG.info("pcpersonhome beforeBindData begin...");
        this.initCalendar();
        Long userId = MobileCommonServiceHelper.getInstance().getUserId();
        Long employeeId = MobileCommonServiceHelper.getInstance().getEmployeeId();
        this.getPageCache().put("cache_id_userid", String.valueOf(userId));
        this.getPageCache().put("cache_id_employeeid", String.valueOf(employeeId));
        String queryDate = WTCDateUtils.date2Str((Date)new Date(), (String)"yyyy-MM-dd");
        Map attFile = MobileHomePageServiceHelper.getAttFileWithEmployeeId((Long)employeeId, (String)queryDate);
        if (HRMapUtils.isEmpty((Map)attFile)) {
            this.initControlWithoutValidValue();
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u65e0\u6709\u6548\u7684\u8003\u52e4\u6863\u6848\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PersonHomePCPlugin_0", (String)"wtc-wtss-formplugin", (Object[])new Object[0]));
            return;
        }
        long schemeId = MobileHomePageBusiness.getInstance().getSchemeIdWithWorkspace(attFile, "A");
        if (schemeId == 0L) {
            this.initControlWithoutValidValue();
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u672a\u5173\u8054\u5047\u52e4\u81ea\u52a9\u65b9\u6848\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PersonHomePCPlugin_1", (String)"wtc-wtss-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject ruleByScheme = SchemaServiceHelper.getInstance().queryRuleByScheme(schemeId, "A");
        long ruleId = ruleByScheme.getLong("id");
        Long attfileBoid = Long.parseLong((String)attFile.get("boid"));
        LOG.info("pcpersonhome archives schemeId:{} attfileBoid:{}", (Object)schemeId, (Object)attfileBoid);
        this.getPageCache().put("cache_scheme_id", String.valueOf(schemeId));
        this.getPageCache().put("cache_attfile_boid", String.valueOf(attfileBoid));
        this.getPageCache().put("cache_rule_id", String.valueOf(ruleId));
        long quotaConfigId = ruleByScheme.getLong("quotaconfig.id");
        StaffPCAppConfigService.initFastApp((Long)ruleId, (IFormView)this.getView());
        this.initPersonCount(userId, schemeId, quotaConfigId, attfileBoid, employeeId);
        this.initCommonProblem(schemeId);
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        super.propertyChanged(propertyChangedArgs);
        String fieldKey = propertyChangedArgs.getProperty().getName();
        Object newValue = WTCCollectionIndexUtil.getEleFromArr((Object[])propertyChangedArgs.getChangeSet(), (int)0).isPresent() ? ((ChangeData)WTCCollectionIndexUtil.getEleFromArr((Object[])propertyChangedArgs.getChangeSet(), (int)0).get()).getNewValue() : null;
        long userId = Long.parseLong(this.getView().getPageCache().get("cache_id_userid"));
        long employeeId = Long.parseLong(this.getView().getPageCache().get("cache_id_employeeid"));
        LOG.info("pcteamhome.beforeBindData.userid:{}", (Object)userId);
        long schemeId = Long.parseLong(this.getView().getPageCache().get("cache_scheme_id"));
        if (fieldKey.equals("daydate") && ObjectUtils.isNotEmpty((Object)newValue)) {
            Date queryDate = (Date)newValue;
            String nowDateStr = WTCDateUtils.date2Str((Date)queryDate, (String)"yyyy-MM-dd");
            PersonHomePCCountBusiness.getInstance().setDateDetail(Long.valueOf(userId), nowDateStr, schemeId, this.getView(), employeeId);
            CalendarGetDataModel queryDateModel = new CalendarGetDataModel();
            queryDateModel.setChooseDay(nowDateStr);
            List dateRange = WTCDateUtils.getDateRange((Date)WTCDateUtils.getBeginDayOfMonth((Date)queryDate), (Date)WTCDateUtils.getEndDayOfMonth((Date)queryDate)).stream().map(date -> WTCDateUtils.date2Str((Date)date, (String)"yyyy-MM-dd")).collect(Collectors.toList());
            queryDateModel.setDateList(dateRange);
            this.initCalendarState(queryDateModel, true);
        } else if (fieldKey.equals("attperiodentry")) {
            DynamicObject dynamicObject = this.getModel().getDataEntity().getDynamicObject("attperiodentry");
            Long personAttPeriodId = dynamicObject.getLong("id");
            PerAttPeriodQueryServiceImpl instance = PerAttPeriodQueryServiceImpl.getInstance();
            PerAttPeriodQueryParam queryParam = new PerAttPeriodQueryParam();
            queryParam.setExtendQFilter(new QFilter("id", "=", (Object)personAttPeriodId));
            List perAttPeriod = instance.queryPerAttPeriodEntity(queryParam);
            if (!CollectionUtils.isEmpty((Collection)perAttPeriod)) {
                PerAttPeriod entry = (PerAttPeriod)perAttPeriod.get(0);
                this.getView().getPageCache().put("PerAttId", String.valueOf(personAttPeriodId));
                String personAttPeriodIdStr = entry.getId();
                this.getView().getPageCache().put("PerAttIdStr", personAttPeriodIdStr);
                long attFileBid = entry.getFileBoId();
                this.getView().getPageCache().put("cache_attfile_boid", String.valueOf(attFileBid));
                LOG.info("mobilehome initStatistic query begin...");
                Map summaryConfig = SummaryConfigDetailService.getInstance().queryInfo(userId, "A", personAttPeriodIdStr, schemeId, 2, Long.valueOf(attFileBid));
                LOG.info("mobilehome initStatistic query end...");
                List showSummary = (List)summaryConfig.get("show");
                this.setDatePreDetail(showSummary);
            }
            AttConfirmServiceHelper.instance().updateBtnAttConfirmVisible(this.getView());
        } else if ("qtdate".equals(fieldKey)) {
            Date date2 = this.getView().getModel().getDataEntity().getDate("qtdate");
            if (date2 == null) {
                date2 = new Date();
                this.getView().getModel().getDataEntity().set("qtdate", (Object)date2);
            }
            QuotaStatisticIndexService.getInstance().setQuotaDetail(schemeId, Long.valueOf(userId), date2, this.getView(), "2", Long.valueOf(employeeId));
        }
    }

    private void initPersonCount(long userId, long schemeId, long quotaConfigId, Long attfileBid, long employeeId) {
        List userAllPeriods = MobileHomePageServiceHelper.getUserAllPeriodsSimpleWithEmployeeId((Long)employeeId);
        if (CollectionUtils.isEmpty((Collection)userAllPeriods)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap", "dateflex", "perflex", "qtflex", "attstavector"});
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u7684\u6863\u6848\u672a\u6709\u4eba\u5458\u8003\u52e4\u671f\u95f4\uff0c\u5bfc\u81f4\u9996\u9875\u6570\u636e\u65e0\u6cd5\u67e5\u770b\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PersonHomePCPlugin_2", (String)"wtc-wtss-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"attperiod", "flexattperoidconf", "perflex", "qtdate", "qtflex"});
        Date nowDate = WTCDateUtils.addDays((Date)new Date(), (int)-1);
        String nowDateStr = WTCDateUtils.date2Str((Date)nowDate, (String)"yyyy-MM-dd");
        this.getPageCache().put("cache_date", nowDateStr);
        this.getPageCache().put("current_statistic_mode", "mode_day");
        this.getModel().setValue("daydate", (Object)nowDate);
        ArrayList<Long> PerAttIds = new ArrayList<Long>(userAllPeriods.size());
        long nowTime = nowDate.getTime();
        String personAttPeriodId = ((PerAttPeriod)userAllPeriods.get(0)).getPrimaryId() + "";
        String attPeriodId = ((PerAttPeriod)userAllPeriods.get(0)).getAttPeriodId() + "";
        String personAttPeriodIdStr = ((PerAttPeriod)userAllPeriods.get(0)).getId();
        for (PerAttPeriod periodReport : userAllPeriods) {
            if (periodReport.getPerAttBeginDate().getTime() < nowDate.getTime()) {
                PerAttIds.add(periodReport.getPrimaryId());
            }
            HRDateTimeUtils.format((Date)periodReport.getPerAttBeginDate(), (String)"yyyy-MM-dd");
            if (nowTime < periodReport.getPerAttBeginDate().getTime() || nowTime > periodReport.getPerAttEndDate().getTime()) continue;
            personAttPeriodId = periodReport.getPrimaryId() + "";
            attPeriodId = periodReport.getAttPeriodId() + "";
            personAttPeriodIdStr = periodReport.getId();
        }
        this.getModel().setValue("attperiodentry", (Object)personAttPeriodId);
        this.getModel().setValue("attperiod", (Object)attPeriodId);
        this.getPageCache().put("PerAttIds", SerializationUtils.toJsonString(PerAttIds));
        this.getPageCache().put("PerAttId", personAttPeriodId);
        this.getPageCache().put("PerAttIdStr", personAttPeriodIdStr);
        LOG.info("mobilehome initStatistic query begin...");
        Map summaryConfig = SummaryConfigDetailService.getInstance().queryInfo(userId, "A", personAttPeriodIdStr, schemeId, 2, attfileBid);
        LOG.info("mobilehome initStatistic query end...");
        List showSummary = (List)summaryConfig.get("show");
        this.setDatePreDetail(showSummary);
        PersonHomePCCountBusiness.getInstance().setDateDetail(Long.valueOf(userId), nowDateStr, schemeId, this.getView(), employeeId);
        AttConfirmServiceHelper.instance().updateBtnAttConfirmVisible(this.getView());
        if (quotaConfigId == 0L) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"qttabpage"});
            this.getView().updateControlMetadata("tabap", QuotaStatisticIndexService.CUSTOM_MAP);
            return;
        }
        this.getPageCache().put("quotaconfig.id", quotaConfigId + "");
        Date date = this.getView().getModel().getDataEntity().getDate("qtdate");
        QuotaStatisticIndexService.getInstance().setQuotaDetail(schemeId, Long.valueOf(userId), date, this.getView(), "2", Long.valueOf(employeeId));
    }

    private void setDatePreDetail(List<SummaryConfDetail> showSummary) {
        EntryType entryType;
        DynamicObjectCollection dynamicObjects = this.getModel().getDataEntity(true).getDynamicObjectCollection("perentryentitycount");
        if (CollectionUtils.isNotEmpty((Collection)dynamicObjects) && WTCStringUtils.isEmpty((String)this.getPageCache().get("perentryentitycounttype"))) {
            entryType = (EntryType)((DynamicObject)dynamicObjects.get(0)).getDynamicObjectType();
            this.getPageCache().put("perentryentitycounttype", WTCSerializationUtils.serializeToBase64((Object)entryType));
        }
        if (CollectionUtils.isEmpty(showSummary)) {
            this.getModel().deleteEntryData("perentryentitycount");
            return;
        }
        entryType = this.getPerEntryEntityType(dynamicObjects);
        this.getModel().deleteEntryData("perentryentitycount");
        if (entryType == null) {
            return;
        }
        for (SummaryConfDetail summaryConfDetail : showSummary) {
            DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)entryType);
            dynamicObject.set("datasouvaluepre", (Object)summaryConfDetail.getAttItemValue());
            dynamicObject.set("datasounamepre", (Object)(summaryConfDetail.getName() + "(" + UnitDataEnum.getRetDesc((String)summaryConfDetail.getUnit()) + ")"));
            dynamicObjects.add((Object)dynamicObject);
        }
        this.getView().updateView("perentryentitycount");
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        Long ruleId = Long.parseLong(this.getView().getPageCache().get("cache_rule_id"));
        String key = control.getKey();
        Tab tab = (Tab)this.getControl("tabap");
        String staType = tab.getCurrentTab();
        switch (key) {
            case "flexmore": 
            case "labelmore": {
                ListShowParameter showParameter = new ListShowParameter();
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setFormId("wtss_problemlist");
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
            case "configap": {
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("wtss_appconfig");
                OpenStyle openStyle = formShowParameter.getOpenStyle();
                Optional.ofNullable(openStyle).ifPresent(style -> style.setShowType(ShowType.Modal));
                formShowParameter.setCustomParam("ruleId", (Object)ruleId);
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "appConfig"));
                this.getView().showForm(formShowParameter);
                break;
            }
            case "labelquestion1": {
                PersonHomePCBusiness.getInstance().goToProblemDetail(this.getView(), 1);
                break;
            }
            case "labelquestion2": {
                PersonHomePCBusiness.getInstance().goToProblemDetail(this.getView(), 2);
                break;
            }
            case "labelquestion3": {
                PersonHomePCBusiness.getInstance().goToProblemDetail(this.getView(), 3);
                break;
            }
            case "attstavector": {
                if ("daytabpage".equals(staType)) {
                    this.showConfigPage(this.getView(), "A");
                    break;
                }
                if ("pertabpage".equals(staType)) {
                    this.showConfigPage(this.getView(), "B");
                    break;
                }
                if (!"qttabpage".equals(staType)) break;
                this.showConfigPage(this.getView(), "C");
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String opKey = evt.getOperateKey();
        if ("attconf".equals(opKey) && evt.getOperationResult().isSuccess()) {
            this.showAttConfirmPage();
        }
    }

    private void showConfigPage(IFormView view, String configType) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId("wtss_countcig");
        Long ruleId = Long.parseLong(this.getView().getPageCache().get("cache_rule_id"));
        long schemeId = Long.parseLong(this.getPageCache().get("cache_scheme_id"));
        String nowDateStr = this.getView().getPageCache().get("cache_date");
        String personAttPeriodIdStr = this.getPageCache().get("PerAttIdStr");
        HashMap<String, Object> configParams = new HashMap<String, Object>(3);
        configParams.put("cache_rule_id", ruleId);
        configParams.put("cache_schemeId_id", schemeId);
        configParams.put("perioddate", nowDateStr);
        configParams.put("configtype", configType);
        configParams.put("cache_attfile_boid", Long.parseLong(view.getPageCache().get("cache_attfile_boid")));
        configParams.put("PerAttIdStr", personAttPeriodIdStr);
        configParams.put("quotaconfig.id", this.getPageCache().get("quotaconfig.id"));
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "saveconfig");
        showParameter.setCloseCallBack(callBack);
        showParameter.setCustomParams(configParams);
        showParameter.setCaption(ResManager.loadKDString((String)"\u8003\u52e4\u7edf\u8ba1", (String)"AttStaVectorName", (String)"wtc-wtss-formplugin", (Object[])new Object[0]));
        view.showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Long ruleId = Long.parseLong(this.getView().getPageCache().get("cache_rule_id"));
        switch (actionId) {
            case "appConfig": {
                StaffPCAppConfigService.initFastApp((Long)ruleId, (IFormView)this.getView());
                break;
            }
            case "selectAttper": {
                Map returnData = (Map)closedCallBackEvent.getReturnData();
                if (returnData == null || returnData.size() <= 0) break;
                this.getModel().setValue("attperiodentry", returnData.get("pkvalue"));
                this.getModel().setValue("attperiod", returnData.get("attperiod"));
                break;
            }
            case "saveconfig": {
                long quotaConfigId;
                Long userId = Long.parseLong(this.getPageCache().get("cache_id_userid"));
                Long employeeId = Long.parseLong(this.getPageCache().get("cache_id_employeeid"));
                long schemeId = Long.parseLong(this.getPageCache().get("cache_scheme_id"));
                Long attFileBid = Long.parseLong(this.getPageCache().get("cache_attfile_boid"));
                Date queryDate = this.getModel().getDataEntity().getDate("daydate");
                String nowDateStr = WTCDateUtils.date2Str((Date)queryDate, (String)"yyyy-MM-dd");
                PersonHomePCCountBusiness.getInstance().setDateDetail(userId, nowDateStr, schemeId, this.getView(), employeeId.longValue());
                LOG.info("pcpersonhome initStatistic query begin...");
                String personAttPeriodIdStr = this.getView().getPageCache().get("PerAttIdStr");
                Map summaryConfig = SummaryConfigDetailService.getInstance().queryInfo(userId.longValue(), "A", personAttPeriodIdStr, schemeId, 2, attFileBid);
                LOG.info("pcpersonhome initStatistic query end...");
                List showSummary = (List)summaryConfig.get("show");
                this.setDatePreDetail(showSummary);
                String cacheQuotaConfigId = this.getPageCache().get("quotaconfig.id");
                long l = quotaConfigId = NumberUtils.isDigits((String)cacheQuotaConfigId) ? Long.parseLong(cacheQuotaConfigId) : 0L;
                if (quotaConfigId == 0L) break;
                Date date = this.getView().getModel().getDataEntity().getDate("qtdate");
                QuotaStatisticIndexService.getInstance().setQuotaDetail(schemeId, userId, date, this.getView(), "2", employeeId);
                break;
            }
            case "attconf": {
                AttConfirmServiceHelper.instance().updateBtnAttConfirmVisible(this.getView());
                String confirmDate = this.getPageCache().get("confirmDate");
                if (WTCDateUtils.str2Date((String)confirmDate, (String)"yyyy-MM-dd") == null) break;
                this.setAttRecordData(confirmDate);
                break;
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        CardEntry cardEntry = (CardEntry)evt.getSource();
        String entryKey = cardEntry.getEntryKey();
        if ("fastappentryentity".equals(entryKey)) {
            String app;
            int openIndex = this.getModel().getEntryCurrentRowIndex("fastappentryentity");
            String openText = (String)this.getModel().getValue("fastname", openIndex);
            switch (app = StaffPCAppConfigConstants.getBillNumber((String)openText)) {
                case "A": {
                    this.showAddNewPage("wtabm_vaapplyself");
                    break;
                }
                case "B": {
                    this.showAddNewPage("wtom_otbillself");
                    break;
                }
                case "C": {
                    this.showAddNewPage("wts_swshiftselfbill");
                    break;
                }
                case "D": {
                    this.showAddNewPage("wtam_busitripselfbill");
                    break;
                }
                case "E": {
                    this.showAddNewPage("wtpm_supsignself");
                    break;
                }
            }
        } else if ("qtentryentitycount".equals(entryKey)) {
            this.showQTLineDetailList();
        }
    }

    public void customEvent(CustomEventArgs cea) {
        JSONObject jsonEventArgs;
        Object jsonAttConfirmId;
        String key = cea.getKey();
        String eventName = cea.getEventName();
        LOG.info("pcpersonhome key:{} eventName:{} eventArgs:{} ", new Object[]{key, eventName, cea.getEventArgs()});
        if (!StringUtils.isEmpty((CharSequence)this.getPageCache().get("cache_normal_init"))) {
            return;
        }
        if ("customcalendar".equals(key) && "getDateData".equals(eventName)) {
            CalendarGetDataModel getDate = (CalendarGetDataModel)SerializationUtils.fromJsonString((String)cea.getEventArgs(), CalendarGetDataModel.class);
            this.initCalendarState(getDate, false);
            this.getModel().setValue("daydate", (Object)getDate.getChooseDay());
        } else if ("customcalendar".equals(key) && "getAttRecord".equals(eventName)) {
            this.setAttRecordData(cea.getEventArgs());
            this.getModel().setValue("daydate", (Object)cea.getEventArgs());
        } else if ("customcalendar".equals(key) && "abnormalDeal".equals(eventName)) {
            AbnormalDealModel abnormalDealModel = (AbnormalDealModel)SerializationUtils.fromJsonString((String)cea.getEventArgs(), AbnormalDealModel.class);
            PersonHomePCBusiness.getInstance().showAddNewFormForAbnormal(this.getView(), abnormalDealModel);
        } else if ("customcalendar".equals(key) && "attConfirm".equals(eventName) && (jsonAttConfirmId = (jsonEventArgs = JSONObject.parseObject((String)cea.getEventArgs())).get((Object)"attConfirmId")) != null) {
            this.getPageCache().put("attConfirmId", String.valueOf(jsonAttConfirmId));
            this.getPageCache().put("confirmDate", String.valueOf(jsonEventArgs.get((Object)"confirmDate")));
            this.getView().invokeOperation("attconf");
        }
    }

    private void initCalendar() {
        String chooseDay = WTSSDateUtils.getLastDateString();
        LOG.info("pcpersonhome chooseDay : {}", (Object)chooseDay);
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcalendar");
        HashMap<String, String> data = new HashMap<String, String>(16);
        CalendarInitModel calendarInitModel = new CalendarInitModel();
        calendarInitModel.setEarliestMonth("2015-01");
        calendarInitModel.setChooseDay(chooseDay);
        data.put("event", "init");
        data.put("args", (String)calendarInitModel);
        customcontrol.setData(data);
    }

    private void initCalendarState(CalendarGetDataModel getDate, Boolean isLocateDate) {
        long userId = Long.parseLong(this.getView().getPageCache().get("cache_id_userid"));
        long employeeId = Long.parseLong(this.getView().getPageCache().get("cache_id_employeeid"));
        long schemeId = Long.parseLong(this.getView().getPageCache().get("cache_scheme_id"));
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcalendar");
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        Set abnormalConfig = SchemaServiceHelper.getInstance().getAbnormalConfig(schemeId, "A");
        String yearMonth = StringUtils.substring((String)getDate.getChooseDay(), (int)0, (int)7);
        Date beginDayOfMonth = WTCDateUtils.getBeginDayOfMonth((String)yearMonth);
        Date lastDayOfMonth = WTCDateUtils.getLastDayOfMonth((String)yearMonth);
        Map tupleMap = HomePageServiceHelper.getInstance().getAttFileMapWithEmployeeId(Long.valueOf(employeeId), beginDayOfMonth, lastDayOfMonth);
        LOG.info("pcpersonhome initCalendarState queryScheduleInfoByAttFileBoId begin... abnormalConfig:{} tupleMap:{}", (Object)abnormalConfig, (Object)tupleMap);
        Map scheduleInfo = HomePageServiceHelper.getInstance().queryScheduleInfoByMultiBo(userId, tupleMap, getDate.getChooseDay(), abnormalConfig);
        Map dailySourceData = SchemaServiceHelper.getInstance().getPeriodAttItems(schemeId, "A", Long.valueOf(userId), (String)getDate.getDateList().get(0), (String)getDate.getDateList().get(getDate.getDateList().size() - 1), tupleMap, 2);
        if (scheduleInfo != null) {
            LOG.info("pcpersonhome initCalendarState scheduleInfo:{}", (Object)SerializationUtils.toJsonString((Object)scheduleInfo));
        }
        List dateStateModels = HomePageServiceHelper.getInstance().getCalendarData(tupleMap, getDate, scheduleInfo, dailySourceData);
        String dateStateStrings = "";
        if (!CollectionUtils.isEmpty((Collection)dateStateModels)) {
            dateStateStrings = SerializationUtils.serializeToBase64((Object)dateStateModels);
            this.getView().getPageCache().put("cache_id_date_state", dateStateStrings);
        }
        List attRecordModel = HomePageServiceHelper.getInstance().getSignCardDetailWithEmployeeId(Long.valueOf(employeeId), Long.valueOf(schemeId), getDate.getChooseDay(), "0", dateStateStrings, false, null);
        DateDataModel dateDataModel = new DateDataModel();
        dateDataModel.setDateList(dateStateModels);
        dateDataModel.setAttRecord(attRecordModel);
        data.put("event", "dateData");
        data.put("isLocateDate", isLocateDate);
        data.put("args", dateDataModel);
        HomePageServiceHelper.getInstance().setAttConfirmByDate(data, Long.valueOf(employeeId), WTCDateUtils.str2Date((String)getDate.getChooseDay(), (String)"yyyy-MM-dd"));
        HomePageServiceHelper.getInstance().setData(data, attRecordModel, getDate.getChooseDay(), Long.valueOf(employeeId));
        WTCPluginProxy workCalendarExtPlugin = WTCPluginProxyFactory.create(null, WTCCustomControlExtPlugin.class, (String)"kd.sdk.wtc.wtss.business.homepage.WorkCalendarCustomExt", null);
        if (workCalendarExtPlugin.hasPlugin()) {
            JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString(data));
            Map request = WTCMaps.JsonToMap((JSONObject)jsonObject);
            request.put("attPersonId", userId);
            workCalendarExtPlugin.invokeReplace(hrPlugin -> {
                hrPlugin.setCustomData(this.getView().getPageId(), "dateData", (Object)request);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("WorkCalendarCustomExt.class:{},eventName:{}", (Object)hrPlugin.getClass().getName(), (Object)"dateData");
                }
            });
            customcontrol.setData((Object)request);
        } else {
            customcontrol.setData(data);
        }
        LOG.info("pcpersonhome initCalendarState dateDataModel:{}", (Object)SerializationUtils.toJsonString((Object)dateDataModel));
    }

    private void setAttRecordData(String date) {
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcalendar");
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        long employeeId = Long.parseLong(this.getView().getPageCache().get("cache_id_employeeid"));
        long schemeId = Long.parseLong(this.getView().getPageCache().get("cache_scheme_id"));
        String dateState = this.getView().getPageCache().get("cache_id_date_state");
        List attRecordModel = HomePageServiceHelper.getInstance().getSignCardDetailWithEmployeeId(Long.valueOf(employeeId), Long.valueOf(schemeId), date, "0", dateState, false, null);
        LOG.info("pcpersonhome attRecord:{}", (Object)SerializationUtils.toJsonString((Object)attRecordModel));
        attRecordModel.sort(Comparator.comparing(AttRecordModel::getDate));
        data.put("event", "attRecord");
        data.put("attRecord", attRecordModel);
        HomePageServiceHelper.getInstance().setAttConfirmByDate(data, Long.valueOf(employeeId), WTCDateUtils.str2Date((String)date, (String)"yyyy-MM-dd"));
        HomePageServiceHelper.getInstance().setData(data, attRecordModel, date, Long.valueOf(employeeId));
        customcontrol.setData(data);
    }

    private void initCommonProblem(Long schemeId) {
        MobileHomeConf mobileHomeConf = SchemaServiceHelper.getInstance().getSchemeForHome(schemeId.longValue(), "A");
        if (mobileHomeConf == null || !mobileHomeConf.isShowProblem()) {
            LOG.info("pcpersonhome initCommonProblem isShowProblem false");
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexcommproblem"});
            return;
        }
        if (CollectionUtils.isEmpty((Collection)mobileHomeConf.getProblems())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexmore", "flexproblem1", "flexproblem2", "flexproblem3"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"comproblemdeftflex"});
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"comproblemdeftflex"});
        String problemsString = SerializationUtils.serializeToBase64((Object)mobileHomeConf.getProblems());
        LOG.info("pcpersonhome initCommonProblem problemsString: {}", (Object)problemsString);
        this.getView().getPageCache().put("cache_commproblem", problemsString);
        List problems = mobileHomeConf.getProblems();
        if (problems.size() == 1) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexproblem2"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexproblem3"});
        } else if (problems.size() == 2) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexproblem3"});
            ((Label)this.getControl("labelquestion2")).setText("2." + ((MobileHomeConf.CommProblem)problems.get(1)).getProblem());
            ((Label)this.getControl("labeltime2")).setText(WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)((MobileHomeConf.CommProblem)problems.get(1)).getModifyTime()));
        } else {
            ((Label)this.getControl("labelquestion2")).setText("2." + ((MobileHomeConf.CommProblem)problems.get(1)).getProblem());
            ((Label)this.getControl("labeltime2")).setText(WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)((MobileHomeConf.CommProblem)problems.get(1)).getModifyTime()));
            ((Label)this.getControl("labelquestion3")).setText("3." + ((MobileHomeConf.CommProblem)problems.get(2)).getProblem());
            ((Label)this.getControl("labeltime3")).setText(WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)((MobileHomeConf.CommProblem)problems.get(2)).getModifyTime()));
        }
        ((Label)this.getControl("labelquestion1")).setText("1." + ((MobileHomeConf.CommProblem)problems.get(0)).getProblem());
        ((Label)this.getControl("labeltime1")).setText(WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)((MobileHomeConf.CommProblem)problems.get(0)).getModifyTime()));
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        if (tabKey.equals("daytabpage")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"daydate", "dateflex"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"attperiod", "flexattperoidconf", "perflex", "qtflex", "qtdate"});
        } else if (tabKey.equals("pertabpage")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"attperiod", "flexattperoidconf", "perflex"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"daydate", "dateflex", "qtdate", "qtflex"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"qtdate", "qtflex"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"daydate", "dateflex", "attperiod", "flexattperoidconf", "perflex"});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        beforeF7SelectEvent.setCancel(true);
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        listShowParameter.setLookUp(true);
        listShowParameter.setHasRight(true);
        Object[] periodIds = new Object[1];
        DynamicObject dynamicObject = this.getModel().getDataEntity().getDynamicObject("attperiodentry");
        if (dynamicObject != null) {
            periodIds[0] = dynamicObject.get("id");
        }
        listShowParameter.setSelectedRows(periodIds);
        listShowParameter.setFormId("wtss_attperiod_f7list");
        listShowParameter.setBillFormId("wtss_perattperiodquery");
        listShowParameter.setCaption(ResManager.loadKDString((String)"\u4eba\u5458\u8003\u52e4\u671f\u95f4", (String)"PersonHomePCPlugin_5", (String)"wtc-wtss-formplugin", (Object[])new Object[0]));
        StyleCss style = new StyleCss();
        style.setWidth("1000");
        style.setHeight("600");
        listShowParameter.getOpenStyle().setInlineStyleCss(style);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "selectAttper");
        listShowParameter.setCloseCallBack(callBack);
        listShowParameter.setParentPageId(this.getView().getPageId());
        listShowParameter.setMultiSelect(false);
        listShowParameter.setCustomParam("multiType", (Object)Boolean.FALSE);
        List PerAttIds = (List)SerializationUtils.fromJsonString((String)this.getView().getPageCache().get("PerAttIds"), List.class);
        ArrayList qFilters = Lists.newArrayList();
        qFilters.add(new QFilter("id", "in", (Object)PerAttIds));
        ListFilterParameter filterList = new ListFilterParameter((List)qFilters, null);
        listShowParameter.setListFilterParameter(filterList);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        this.showQTLineDetailList();
    }

    private void initControlWithoutValidValue() {
        this.getPageCache().put("cache_normal_init", "true");
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexmore", "flexproblem1", "flexproblem2", "flexproblem3"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"fastappentryentity", "configap"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap", "dateflex", "perflex", "qtflex", "attstavector"});
    }

    private void showAddNewPage(String formId) {
        WTCBillType billType = (WTCBillType)BillCommonService.getInstance().BILL_TYPE_MAP.get(formId);
        BeforeShowApplyPageEvent beforeShowApplyPageEvent = new BeforeShowApplyPageEvent(billType, WTCApplyType.SELF, (FormShowParameter)new BillShowParameter());
        WTCPluginProxy proxy = WTCPluginProxyFactory.create(BillReplaceExtPlugin.class, (String)"kd.sdk.wtc.wtss.business.homepage.BillReplaceExtPlugin");
        proxy.invokeReplace(plugin -> plugin.beforeShowApplyPage(beforeShowApplyPageEvent));
        FormShowParameter formShowParameter = beforeShowApplyPageEvent.getFormShowParameter();
        if (BillCommonService.getInstance().hasFormId(beforeShowApplyPageEvent)) {
            this.getView().showForm(formShowParameter);
            return;
        }
        IFormView view = this.getView();
        BillShowParameter parameter = PersonHomePCBusiness.getInstance().getBillShowParameter(view.getFormShowParameter().getAppId(), formId, view);
        if (parameter == null) {
            return;
        }
        String key = formId + "_addNewPageId";
        String pageId = view.getPageCache().get(key);
        if (StringUtils.isNotBlank((CharSequence)pageId)) {
            parameter.setPageId(pageId);
        } else {
            view.getPageCache().put(key, parameter.getPageId());
        }
        view.showForm((FormShowParameter)parameter);
    }

    private void showQTLineDetailList() {
        int openIndex = this.getModel().getEntryCurrentRowIndex("qtentryentitycount");
        String openName = (String)this.getModel().getValue("datasounameqt", openIndex);
        String quotaConfigId = String.valueOf(this.getModel().getValue("quotasourceid", openIndex));
        List quotaDetailIdList = JSON.parseArray((String)this.getView().getPageCache().get(quotaConfigId), Long.class);
        ListShowParameter listShowParameter = new ListShowParameter();
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        ArrayList qFilters = Lists.newArrayList();
        qFilters.add(new QFilter("id", "in", (Object)quotaDetailIdList));
        listFilterParameter.setQFilters((List)qFilters);
        listShowParameter.setListFilterParameter(listFilterParameter);
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.setBillFormId("wtss_qtlinedetaillayout");
        listShowParameter.setPageId("wtss_qtlinedetaillayout" + this.getView().getPageId() + quotaConfigId);
        listShowParameter.setCustomParam("selectYear", (Object)WTCDateUtils.date2Str((Date)this.getModel().getDataEntity().getDate("qtdate"), (String)"yyyy"));
        listShowParameter.setCaption(ResManager.loadKDString((String)"\u5b9a\u989d\u660e\u7ec6-{0}", (String)"PersonHomePCPlugin_3", (String)"wtc-wtss-formplugin", (Object[])new Object[]{openName}));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void showAttConfirmPage() {
        Long attConfirmId;
        try {
            attConfirmId = Long.valueOf(this.getPageCache().get("attConfirmId"));
        }
        catch (Exception e) {
            LOG.warn("PersonHomePCPlugin.showAttConfirmPage.getAttConfirmIdError:{}", (Object)e.getMessage());
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u8003\u52e4\u786e\u8ba4\u8bb0\u5f55\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"PersonHomePCPlugin_6", (String)"wtc-wtss-formplugin", (Object[])new Object[0]));
        }
        if (attConfirmId == 0L) {
            return;
        }
        AttConfirmRecordQueryParam queryParam = new AttConfirmRecordQueryParam();
        queryParam.setIds(Collections.singleton(attConfirmId));
        queryParam.setQueryNotEffect(true);
        List recordModels = AttConfirmQueryServiceImpl.getInstance().queryAttConfirmRecordModelList(queryParam);
        if (WTCCollections.isEmpty((Collection)recordModels)) {
            return;
        }
        AttConfirmRecordModel currentRecordModel = (AttConfirmRecordModel)recordModels.get(0);
        AttConRecordStatusEnum status = currentRecordModel.getStatus();
        AttConfirmDataStatusEnum dataStatus = currentRecordModel.getDataStatus();
        if (AttConRecordStatusEnum.SEND.equals((Object)status) && AttConfirmDataStatusEnum.EFFECT.equals((Object)dataStatus)) {
            MobileFormShowParameter showParameter = new MobileFormShowParameter();
            showParameter.setFormId("wtss_attconfirmlistpc");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setParentPageId(this.getView().getPageId());
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "attconf"));
            showParameter.setCustomParam("cache_attfile_boid", (Object)this.getPageCache().get("cache_attfile_boid"));
            showParameter.setCustomParam("cache_id_employeeid", (Object)this.getPageCache().get("cache_id_employeeid"));
            showParameter.setCustomParam("currentrecordid", (Object)String.valueOf(attConfirmId));
            showParameter.setCustomParam("confirmtype", (Object)currentRecordModel.getType().getCode());
            this.getView().showForm((FormShowParameter)showParameter);
        } else {
            FormShowParameter detailParameter = new FormShowParameter();
            OpenStyle openStyle = new OpenStyle();
            openStyle.setShowType(ShowType.Modal);
            detailParameter.setOpenStyle(openStyle);
            detailParameter.setParentPageId(this.getView().getPageId());
            detailParameter.setFormId("wtam_attconfirmbill");
            detailParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "attconf"));
            detailParameter.setCustomParam("attConfirmBillId", (Object)attConfirmId);
            detailParameter.setCustomParam("source", (Object)"personhome");
            detailParameter.setCustomParam("attfile", (Object)Long.valueOf(this.getPageCache().get("cache_attfile_boid")));
            this.getView().showForm(detailParameter);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EntryType getPerEntryEntityType(DynamicObjectCollection dynamicObjects) {
        String entryTypeJSONStr = this.getPageCache().get("perentryentitycounttype");
        if (!WTCStringUtils.isEmpty((String)entryTypeJSONStr)) {
            try {
                return (EntryType)WTCSerializationUtils.deSerializeFromBase64((String)entryTypeJSONStr);
            }
            catch (Exception e) {
                LOG.warn("PersonHomePCPlugin.getPerEntryEntityType.Error:", (Throwable)e);
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u671f\u95f4\u7edf\u8ba1\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"PersonHomePCPlugin_7", (String)"wtc-wtss-formplugin", (Object[])new Object[0]));
            }
        }
        if (!WTCCollections.isNotEmpty((Collection)dynamicObjects)) return null;
        EntryType entryType = (EntryType)((DynamicObject)dynamicObjects.get(0)).getDynamicObjectType();
        this.getPageCache().put("perentryentitycounttype", WTCSerializationUtils.toJsonString((Object)entryType));
        return entryType;
    }
}

