/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.formplugin.web.pc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.mobile.MobileCommonServiceHelper;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;
import kd.wtc.wtbs.common.util.third.util.MapUtils;
import kd.wtc.wtss.business.servicehelper.common.SchemaServiceHelper;
import kd.wtc.wtss.business.servicehelper.summaryconf.SummaryConfigDetailService;
import kd.wtc.wtss.common.constants.PersonHomePCConstants;
import kd.wtc.wtss.common.dto.DailySource;
import kd.wtc.wtss.common.dto.summaryconf.SummaryConfDetail;
import org.apache.commons.lang3.StringUtils;

public class PersonPCConfigSettingPlugin
extends AbstractMobFormPlugin
implements RowClickEventListener,
TabSelectListener,
PersonHomePCConstants {
    private static final Log LOG = LogFactory.getLog(PersonPCConfigSettingPlugin.class);

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addClickListeners(new String[]{"unshowicon", "showicon", "btnok", "unshowiconpre", "showiconpre", "showiconqt", "unshowiconqt"});
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("unshowicon".equals(key)) {
            this.setCardChange("showentryentity", "showtext", "showid", "unshowentryentity", "unshowtext", "unshowid");
        } else if ("showicon".equals(key)) {
            this.setCardChange("unshowentryentity", "unshowtext", "unshowid", "showentryentity", "showtext", "showid");
        } else if ("showiconpre".equals(key)) {
            this.setCardChange("unshowentryentitypre", "unshowtextpre", "unshowidpre", "showentryentitypre", "showtextpre", "showidpre");
        } else if ("unshowiconpre".equals(key)) {
            this.setCardChange("showentryentitypre", "showtextpre", "showidpre", "unshowentryentitypre", "unshowtextpre", "unshowidpre");
        } else if ("btnok".equals(key)) {
            Long ruleId = (Long)this.getView().getFormShowParameter().getCustomParam("cache_rule_id");
            Long schemeId = (Long)this.getView().getFormShowParameter().getCustomParam("cache_schemeId_id");
            Long userId = MobileCommonServiceHelper.getInstance().getUserId();
            this.processSet(schemeId, userId, ruleId);
        } else if ("showiconqt".equals(key)) {
            this.setCardChange("unshowentryentityqt", "unshowtextqt", "unshowidqt", "showentryentityqt", "showtextqt", "showidqt");
        } else if ("unshowiconqt".equals(key)) {
            this.setCardChange("showentryentityqt", "showtextqt", "showidqt", "unshowentryentityqt", "unshowtextqt", "unshowidqt");
        }
    }

    private void processSet(Long schemeId, long userId, long ruleId) {
        boolean quotaShowEntryIsEmpty;
        String haveChange = this.getPageCache().get("haveChange");
        if (HRStringUtils.isEmpty((String)haveChange)) {
            this.getView().close();
            return;
        }
        DynamicObjectCollection showEntryEntityCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection("showentryentity");
        DynamicObjectCollection showEntryEntityPreCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection("showentryentitypre");
        DynamicObjectCollection showEntryEntityQTCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection("showentryentityqt");
        boolean quotaConfigIsEmpty = CollectionUtils.isEmpty((Collection)this.getModel().getEntryEntity("showentryentityqt")) && CollectionUtils.isEmpty((Collection)this.getModel().getEntryEntity("unshowentryentityqt"));
        boolean bl = quotaShowEntryIsEmpty = schemeId != null && !quotaConfigIsEmpty && CollectionUtils.isEmpty((Collection)showEntryEntityQTCollection);
        if (CollectionUtils.isEmpty((Collection)showEntryEntityCollection) || CollectionUtils.isEmpty((Collection)showEntryEntityPreCollection) || quotaShowEntryIsEmpty) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u5e38\u7528\u6307\u6807\u3002", (String)"PersonPCConfigSettingPlugin_0", (String)"wtc-wtss-formplugin", (Object[])new Object[0]));
            return;
        }
        this.processDateDailyData(schemeId, userId, ruleId, showEntryEntityCollection);
        this.processPeriodData(schemeId, userId, ruleId, showEntryEntityPreCollection);
        if (!quotaConfigIsEmpty) {
            this.processQTData(schemeId, userId, ruleId, showEntryEntityQTCollection);
        }
        this.getPageCache().remove("haveChange");
        this.getView().close();
    }

    private void processQTData(Long schemeId, long userId, long ruleId, DynamicObjectCollection showEntryEntityQTCollection) {
        String showIds = SerializationUtils.toJsonString((Object)showEntryEntityQTCollection.stream().map(dy -> dy.getString("showidqt")).filter(StringUtils::isNotBlank).toArray());
        DynamicObject queryRule = SchemaServiceHelper.getInstance().queryRuleByScheme(schemeId.longValue(), "A");
        DynamicObject quotaConfig = queryRule.getDynamicObject("quotaconfig");
        long configId = quotaConfig.getLong("id");
        SummaryConfigDetailService.getInstance().updatePC(userId, schemeId.longValue(), ruleId, configId, showIds, "3");
    }

    private void processDateDailyData(Long schemeId, long userId, long ruleId, DynamicObjectCollection showEntryEntityCollection) {
        StringBuilder showList = new StringBuilder("[");
        for (DynamicObject dynamicObject : showEntryEntityCollection) {
            if ("".equals(dynamicObject.getString("showid"))) continue;
            showList.append(dynamicObject.getString("showid"));
            showList.append(',');
        }
        String showListStr = showList.substring(0, showList.length() - 1);
        String teamstatype = "1";
        DynamicObject queryRule = SchemaServiceHelper.getInstance().queryRuleByScheme(schemeId.longValue(), "A");
        DynamicObject dailyConfig = queryRule.getDynamicObject("dailydetconfig");
        long perSumConfigId = dailyConfig.getLong("id");
        SummaryConfigDetailService.getInstance().updatePC(userId, schemeId.longValue(), ruleId, perSumConfigId, showListStr + "]", teamstatype);
    }

    private void processPeriodData(Long schemeId, long userId, long ruleId, DynamicObjectCollection showEntryEntityPreCollection) {
        StringBuilder showList = new StringBuilder("[");
        for (DynamicObject dynamicObject : showEntryEntityPreCollection) {
            if ("".equals(dynamicObject.getString("showidpre"))) continue;
            showList.append(dynamicObject.getString("showidpre"));
            showList.append(',');
        }
        String showListStr = showList.substring(0, showList.length() - 1);
        DynamicObject perSumConfig = SchemaServiceHelper.getInstance().getPerSumConfigByUser(schemeId.longValue(), "A");
        long perSumConfigId = perSumConfig.getLong("id");
        String teamstatype = "2";
        SummaryConfigDetailService.getInstance().updatePC(userId, schemeId.longValue(), ruleId, perSumConfigId, showListStr + "]", teamstatype);
    }

    private void setCardChange(String showentryentity, String showtext, String showid, String unshowentryentity, String unshowtext, String unshowid) {
        this.getPageCache().put("haveChange", "true");
        int unShowIndex = this.getModel().getEntryCurrentRowIndex(showentryentity);
        String unShowText = (String)this.getModel().getValue(showtext, unShowIndex);
        long unShowId = Long.parseLong((String)this.getModel().getValue(showid, unShowIndex));
        this.getModel().deleteEntryRow(showentryentity, unShowIndex);
        this.getModel().batchCreateNewEntryRow(unshowentryentity, 1);
        DynamicObjectCollection dynamicObjects = this.getModel().getDataEntity(true).getDynamicObjectCollection(unshowentryentity);
        this.getModel().setValue(unshowtext, (Object)unShowText, dynamicObjects.size() - 1);
        this.getModel().setValue(unshowid, (Object)unShowId, dynamicObjects.size() - 1);
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        Long schemeId = (Long)this.getView().getFormShowParameter().getCustomParam("cache_schemeId_id");
        Long attFileBoid = (Long)this.getView().getFormShowParameter().getCustomParam("cache_attfile_boid");
        Long userId = MobileCommonServiceHelper.getInstance().getUserId();
        String configType = (String)this.getView().getFormShowParameter().getCustomParam("configtype");
        if ("A".equals(configType)) {
            this.getPageCache().put("dayinit", "1");
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexdayunshow", "flexdayshow"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpreshow", "flexpreunshow", "flexqtshow", "flexqtunshow"});
        } else if ("B".equals(configType)) {
            Tab tab = (Tab)this.getControl("tabap");
            tab.activeTab("pertabpage");
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexdayunshow", "flexdayshow", "flexqtshow", "flexqtunshow"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpreshow", "flexpreunshow"});
            this.getPageCache().put("preinit", "1");
        } else if ("C".equals(configType)) {
            Tab tab = (Tab)this.getControl("tabap");
            tab.activeTab("qttabpage");
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexqtshow", "flexqtunshow"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexdayunshow", "flexdayshow", "flexpreshow", "flexpreunshow"});
        }
        this.initDayDetail(schemeId, userId);
        this.initPreDetail(schemeId, userId, attFileBoid);
        this.initQTDetail(schemeId, userId);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        Long schemeId = (Long)this.getView().getFormShowParameter().getCustomParam("cache_schemeId_id");
        Long attFileBoid = (Long)this.getView().getFormShowParameter().getCustomParam("cache_attfile_boid");
        Long userId = MobileCommonServiceHelper.getInstance().getUserId();
        if (tabKey.equals("daytabpage")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexdayunshow", "flexdayshow"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpreshow", "flexpreunshow", "flexqtshow", "flexqtunshow"});
            String dayInit = this.getPageCache().get("dayinit");
            if (dayInit != null) {
                return;
            }
            this.getPageCache().put("dayinit", "1");
            this.initDayDetail(schemeId, userId);
        } else if (tabKey.equals("pertabpage")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexdayunshow", "flexdayshow", "flexqtshow", "flexqtunshow"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpreshow", "flexpreunshow"});
            String preinit = this.getPageCache().get("preinit");
            if (preinit != null) {
                return;
            }
            this.getPageCache().put("preinit", "1");
            this.initPreDetail(schemeId, userId, attFileBoid);
        } else if (tabKey.equals("qttabpage")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexdayunshow", "flexdayshow", "flexpreshow", "flexpreunshow"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexqtshow", "flexqtunshow"});
            String qtinit = this.getPageCache().get("qtinit");
            if (qtinit != null) {
                return;
            }
            this.getPageCache().put("qtinit", "1");
            this.initQTDetail(schemeId, userId);
        }
    }

    private void initQTDetail(Long schemeId, Long userId) {
        Map dataSourcesMap = SchemaServiceHelper.getInstance().getQTDataSourceByScheme(schemeId.longValue(), "A", userId, "2");
        if (MapUtils.isEmpty((Map)dataSourcesMap)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"qttabpage", "flexqtshow", "flexqtunshow"});
            return;
        }
        List showList = (List)dataSourcesMap.get("showList");
        List unShowList = (List)dataSourcesMap.get("unshowList");
        this.setEntryEntity(showList, "showentryentityqt", "showtextqt", "showidqt", "unshowiconqt");
        this.setEntryEntity(unShowList, "unshowentryentityqt", "unshowtextqt", "unshowidqt", "showiconqt");
    }

    private void initPreDetail(Long schemeId, Long userId, Long attFileBid) {
        String personAttPeriodIdStr = (String)this.getView().getFormShowParameter().getCustomParam("PerAttIdStr");
        LOG.info("mobilehome initStatistic query begin...");
        Map summaryConfig = SummaryConfigDetailService.getInstance().queryInfo(userId.longValue(), "A", personAttPeriodIdStr, schemeId.longValue(), 2, attFileBid);
        LOG.info("mobilehome initStatistic query end...");
        List showList = (List)summaryConfig.get("show");
        List otherTimes = (List)summaryConfig.get("otherTimes");
        List otherDuration = (List)summaryConfig.get("otherDuration");
        ArrayList<SummaryConfDetail> unShowList = new ArrayList<SummaryConfDetail>(8);
        unShowList.addAll(otherTimes);
        unShowList.addAll(otherDuration);
        this.setEntryEntityPre(showList, "showentryentitypre", "showtextpre", "showidpre", "unshowiconpre");
        this.setEntryEntityPre(unShowList, "unshowentryentitypre", "unshowtextpre", "unshowidpre", "showiconpre");
    }

    private void initDayDetail(Long schemeId, Long userId) {
        Map dataSourcesMap = SchemaServiceHelper.getInstance().getDataSourcesByScheme(this.getView(), schemeId.longValue(), "A", userId, 2);
        if (null == dataSourcesMap) {
            return;
        }
        List showList = (List)dataSourcesMap.get("showList");
        List unShowList = (List)dataSourcesMap.get("unshowList");
        this.setEntryEntity(showList, "showentryentity", "showtext", "showid", "unshowicon");
        this.setEntryEntity(unShowList, "unshowentryentity", "unshowtext", "unshowid", "showicon");
    }

    private void setEntryEntity(List<DailySource> list, String entryEntityKey, String textKey, String idKey, String iconKey) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        this.getModel().deleteEntryData(entryEntityKey);
        this.getModel().batchCreateNewEntryRow(entryEntityKey, list.size());
        CardEntry cardEntry = (CardEntry)this.getView().getControl(entryEntityKey);
        for (int index = 0; index < list.size(); ++index) {
            this.getModel().setValue(textKey, (Object)list.get(index).getDatasoureName(), index);
            this.getModel().setValue(idKey, (Object)list.get(index).getDatasoureId(), index);
            cardEntry.setChildVisible(list.get(index).isAdjustment(), index, new String[]{iconKey});
        }
    }

    private void setEntryEntityPre(List<SummaryConfDetail> list, String entryEntityKey, String textKey, String idKey, String iconKey) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        this.getModel().deleteEntryData(entryEntityKey);
        this.getModel().batchCreateNewEntryRow(entryEntityKey, list.size());
        CardEntry cardEntry = (CardEntry)this.getView().getControl(entryEntityKey);
        for (int index = 0; index < list.size(); ++index) {
            this.getModel().setValue(textKey, (Object)list.get(index).getName(), index);
            this.getModel().setValue(idKey, (Object)list.get(index).getSourceId(), index);
            cardEntry.setChildVisible(list.get(index).isAdjustment(), index, new String[]{iconKey});
        }
    }
}

