/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.formplugin.web.pc;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.IListView;
import kd.bos.list.events.EnableCustomSumEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.wtc.wtbs.common.model.DateRange;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;
import kd.wtc.wtp.business.cumulate.trading.QTLineDetailDBService;
import kd.wtc.wtp.business.quota.QTLineDetailNumHelper;
import kd.wtc.wtss.common.utils.WTSSKDStringHelper;

public class QuotaDetailListPlugin
extends AbstractListPlugin {
    public void setFilter(SetFilterEvent event) {
        super.setFilter(event);
        QFilter qfilter = null;
        List filters = event.getQFilters();
        Iterator it = filters.iterator();
        boolean init = false;
        while (it.hasNext()) {
            Date endDate;
            QFilter filter = (QFilter)it.next();
            if (filter == null || !filter.getProperty().equals("usedate")) continue;
            it.remove();
            Date startDate = (Date)filter.getValue();
            Date date = endDate = WTCCollectionIndexUtil.getEleFromList((List)filter.getNests(true), (int)0).isPresent() ? (Date)((QFilter.QFilterNest)filter.getNests(true).get(0)).getFilter().getValue() : null;
            if (startDate == null || endDate == null) continue;
            init = true;
            endDate = WTCDateUtils.addDays((Date)endDate, (int)-1);
            qfilter = DateRange.range((Date)startDate, (Date)endDate).getFilterIntersectionLCRC("usestartdate", "useenddate");
        }
        if (init) {
            event.getQFilters().add(qfilter);
        }
        event.setMainOrgQFilter(null);
        event.setDataPermQFilters(Collections.emptyList());
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map currentCommonFilter = args.getCurrentCommonFilter();
        List fieldNames = (List)currentCommonFilter.get("FieldName");
        for (Object fieldName : fieldNames) {
            if (!"usedate".equals(fieldName)) continue;
            List values = (List)currentCommonFilter.get("Value");
            boolean checkCrossYear = this.checkCrossYear(values);
            if (!checkCrossYear) break;
            this.getView().showTipNotification(WTSSKDStringHelper.getCrossYear());
            values.clear();
            values.add("66");
            break;
        }
    }

    public void setEnableCustomSum(EnableCustomSumEvent args) {
        super.setEnableCustomSum(args);
        args.setEnableCustomSum(false);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        String selectedYear = (String)this.getView().getFormShowParameter().getCustomParam("selectYear");
        Date startDate = WTCDateUtils.getBeginDayOfYear((Date)WTCDateUtils.str2Date((String)selectedYear, (String)"yyyy"));
        Date endDate = WTCDateUtils.getEndDayOfYear((Date)WTCDateUtils.str2Date((String)selectedYear, (String)"yyyy"));
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn filterColumn : filterColumnList) {
            String fieldName = filterColumn.getFieldName();
            if ("usedate".equals(fieldName)) {
                filterColumn.setDefaultValues(new Object[]{WTCDateUtils.date2Str((Date)startDate, (String)"yyyy-MM-dd"), WTCDateUtils.date2Str((Date)endDate, (String)"yyyy-MM-dd")});
                continue;
            }
            if (!"org.name".equals(fieldName)) continue;
            filterColumn.setDefaultValues((List)Lists.newArrayList());
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                DynamicSimpleProperty number = new DynamicSimpleProperty("number", String.class, null);
                Set collect = rows.stream().map(ele -> ele.getLong("id")).collect(Collectors.toSet());
                DynamicObject[] query = QTLineDetailDBService.lineDetailDao.query("id,invalidvalue,settlementvalue", new QFilter("id", "in", collect).toArray());
                HashMap<Long, BigDecimal> tmp = new HashMap<Long, BigDecimal>(query.length);
                HashMap<Long, BigDecimal> cdTmp = new HashMap<Long, BigDecimal>(query.length);
                for (DynamicObject line : query) {
                    tmp.put(line.getLong("id"), line.getBigDecimal("invalidvalue"));
                    cdTmp.put(line.getLong("id"), line.getBigDecimal("settlementvalue"));
                }
                rows.getDynamicObjectType().registerSimpleProperty(number);
                for (DynamicObject row : rows) {
                    long id = row.getLong("id");
                    String num = QTLineDetailNumHelper.convertNum((Long)id);
                    row.set("number", (Object)num);
                    BigDecimal invalidValue = tmp.getOrDefault(id, BigDecimal.ZERO);
                    BigDecimal pastValue = row.getBigDecimal("pastvalue");
                    row.set("pastvalue", (Object)invalidValue.add(pastValue));
                    BigDecimal settlementValue = cdTmp.getOrDefault(id, BigDecimal.ZERO);
                    BigDecimal cdValue = row.getBigDecimal("cdedvalue");
                    row.set("cdedvalue", (Object)cdValue.add(settlementValue));
                }
                return rows;
            }
        });
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        int billDataCount = ((IListView)this.getView()).getListModel().getBillDataCount();
        if (billDataCount < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u672a\u751f\u6210\u5b9a\u989d\u660e\u7ec6\u8bb0\u5f55\u3002", (String)"QuotaDetailListPlugin_0", (String)"wtc-wtss-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean checkCrossYear(List<Object> dateRange) {
        if (CollectionUtils.isEmpty(dateRange) || dateRange.size() != 2) {
            return false;
        }
        boolean crossYear = false;
        String startDateStr = (String)dateRange.get(0);
        String endDateStr = (String)dateRange.get(1);
        Date startDate = WTCDateUtils.str2Date((String)startDateStr, (String)"yyyy-MM-dd");
        Date endDate = WTCDateUtils.str2Date((String)endDateStr, (String)"yyyy-MM-dd");
        Object selectYearObj = this.getView().getFormShowParameter().getCustomParam("selectYear");
        if (selectYearObj instanceof String && startDate != null && endDate != null) {
            String selectYear = String.valueOf(selectYearObj);
            Date selectYearDate = WTCDateUtils.str2Date((String)selectYear, (String)"yyyy");
            Date beginDay = WTCDateUtils.getBeginDayOfYear((Date)selectYearDate);
            Date endDay = WTCDateUtils.getEndDayOfYear((Date)selectYearDate);
            Date nextYearBeginDay = WTCDateUtils.getBeginDayOfYear((Date)WTCDateUtils.getNextDate((Date)endDay));
            if (startDate.compareTo(beginDay) < 0 || endDate.compareTo(nextYearBeginDay) > 0) {
                crossYear = true;
            }
        }
        return crossYear;
    }
}

