/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.formplugin.web.pc;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtss.business.attstatistics.AttStatisticsFormService;
import kd.wtc.wtss.business.attstatistics.AttStatisticsServiceHelper;
import kd.wtc.wtss.business.attstatistics.IAttStatisticsService;
import kd.wtc.wtss.business.servicehelper.common.TeamHomeServiceHelper;
import kd.wtc.wtss.business.servicehelper.mobile.MobileHomePageBusiness;
import kd.wtc.wtss.common.dto.mobilehome.AttDataSourceDetailsModel;
import kd.wtc.wtss.common.dto.mobilehome.AttDataSourceModel;
import kd.wtc.wtss.common.dto.mobilehome.AttStatisticQueryParam;
import kd.wtc.wtss.common.enums.attstatistics.StaCombinationTerminal;
import kd.wtc.wtss.common.enums.attstatistics.StaTypeEnum;
import kd.wtc.wtss.formplugin.web.mobile.HomeDetailListPlugin;

public class TeamHomeAttStatPlugin
extends HRDataBaseEdit
implements TabSelectListener {
    private static final Log LOG = LogFactory.getLog(HomeDetailListPlugin.class);

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void afterCreateNewData(EventObject eventObject) {
        Object cacheTabKeys;
        String periodTabKeyStr;
        String staTypeStr;
        super.afterCreateNewData(eventObject);
        TeamHomeServiceHelper.getInstance().setDateEditRange(null, this.getView(), "datefield", "changeyear");
        long userId = UserServiceHelper.getCurrentUserId();
        AttStatisticQueryParam attStatisticQueryParam = AttStatisticsFormService.getInstance().getCacheAttStatisticQueryParam(this.getView().getPageCache());
        if (attStatisticQueryParam == null) {
            attStatisticQueryParam = (AttStatisticQueryParam)SerializationUtils.fromJsonString((String)((String)this.getView().getFormShowParameter().getCustomParams().get("homeDetailListModel")), AttStatisticQueryParam.class);
        }
        StaTypeEnum staTypeEnum = attStatisticQueryParam.getStaTypeEnum();
        String chickStr = this.getView().getPageCache().get("checkid" + userId);
        if (chickStr != null && !chickStr.isEmpty()) {
            attStatisticQueryParam.setChickSourceId(Long.valueOf(Long.parseLong(chickStr)));
        }
        if (HRStringUtils.isNotEmpty((String)(staTypeStr = this.getView().getPageCache().get("statype" + userId)))) {
            this.getModel().getDataEntity().set("statradiogroup", (Object)staTypeStr);
        }
        Tab tab = (Tab)this.getControl("tabap");
        if (StaTypeEnum.DAILY == staTypeEnum) {
            this.setDayModel(attStatisticQueryParam.getQueryDate());
        } else {
            this.setPreModel(attStatisticQueryParam.getQueryStartDate());
        }
        attStatisticQueryParam.setStaCombinationTerminal(StaCombinationTerminal.PC);
        List showList = AttStatisticsServiceHelper.getInstance().getAttStatisticsService(staTypeEnum).getAttStatisticsData(attStatisticQueryParam);
        if (showList == null || showList.isEmpty()) {
            return;
        }
        AttStatisticQueryParam finalAttStatisticQueryParam = attStatisticQueryParam;
        if (showList.stream().noneMatch(d -> Objects.equals(d.getAttDataSourceId(), finalAttStatisticQueryParam.getChickSourceId()))) {
            attStatisticQueryParam.setChickSourceId(((AttDataSourceModel)showList.get(0)).getAttDataSourceId());
        }
        AttStatisticsFormService.getInstance().cacheAttStatisticQueryParam(this.getPageCache(), attStatisticQueryParam);
        ArrayList<Map> list = new ArrayList<Map>(showList.size());
        String staType = this.getModel().getDataEntity().getString("statradiogroup");
        String dayTabKeyStr = this.getView().getPageCache().get("tabkeys" + userId + "_" + 1);
        if (HRStringUtils.isNotEmpty((String)dayTabKeyStr)) {
            String[] cacheTabKeys2;
            for (String key : cacheTabKeys2 = WTCStringUtils.split((String)dayTabKeyStr, (String)",")) {
                tab.deleteControls(new String[]{key});
            }
        }
        if (HRStringUtils.isNotEmpty((String)(periodTabKeyStr = this.getView().getPageCache().get("tabkeys" + userId + "_" + 2)))) {
            cacheTabKeys = WTCStringUtils.split((String)periodTabKeyStr, (String)",");
            for (String key : cacheTabKeys) {
                tab.deleteControls(new String[]{key});
            }
        }
        cacheTabKeys = new ArrayList(showList.size());
        String activeTab = "";
        for (AttDataSourceModel model : showList) {
            TabPageAp tabPageAp = new TabPageAp();
            int index = showList.indexOf(model);
            String key = model.getAttDataSourceId() + "_" + index;
            if (Objects.equals(model.getAttDataSourceId(), attStatisticQueryParam.getChickSourceId())) {
                activeTab = key;
            }
            tabPageAp.setId(key);
            tabPageAp.setKey(key);
            cacheTabKeys.add(key);
            String name = model.getAttDataSourceName() + "(" + model.getAttDataSourceValue() + ")";
            tabPageAp.setName(new LocaleString(name));
            list.add(tabPageAp.createControl());
        }
        tab.addControls(list);
        if (HRStringUtils.isNotEmpty((String)activeTab)) {
            tab.activeTab(activeTab);
        }
        String cacheTabStr = WTCStringUtils.join((List)cacheTabKeys, (String)",");
        this.getView().getPageCache().put("tabkeys" + userId + "_" + staType, cacheTabStr);
        this.getView().updateView("tabap");
        this.setTabDetail(attStatisticQueryParam, attStatisticQueryParam.getStaTypeEnum());
    }

    private void setPreModel(Date changeYear) {
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"changeyear"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"datefield"});
        this.getModel().setValue("changeyear", (Object)changeYear);
    }

    private void setDayModel(Date queryDate) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"changeyear"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"datefield"});
        this.getModel().setValue("datefield", (Object)queryDate);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        AttStatisticQueryParam attStatisticQueryParam = AttStatisticsFormService.getInstance().getCacheAttStatisticQueryParam(this.getView().getPageCache());
        if (attStatisticQueryParam == null) {
            attStatisticQueryParam = (AttStatisticQueryParam)SerializationUtils.fromJsonString((String)((String)this.getView().getFormShowParameter().getCustomParams().get("homeDetailListModel")), AttStatisticQueryParam.class);
        }
        if (StaTypeEnum.PERIOD == attStatisticQueryParam.getStaTypeEnum()) {
            this.getModel().getDataEntity().set("statradiogroup", (Object)"2");
        }
    }

    private AttStatisticQueryParam getAttStatisticQueryParam() {
        return AttStatisticsFormService.getInstance().getCacheAttStatisticQueryParamEx(this.getView().getPageCache());
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        Object newValue;
        super.propertyChanged(propertyChangedArgs);
        String fieldName = propertyChangedArgs.getProperty().getName();
        Object object = newValue = WTCCollectionIndexUtil.getEleFromArr((Object[])propertyChangedArgs.getChangeSet(), (int)0).isPresent() ? propertyChangedArgs.getChangeSet()[0].getNewValue() : null;
        if (null == newValue) {
            return;
        }
        AttStatisticQueryParam attStatisticQueryParam = this.getAttStatisticQueryParam();
        if (HRStringUtils.equals((String)"datefield", (String)fieldName) || HRStringUtils.equals((String)"changeyear", (String)fieldName)) {
            Date queryDate = (Date)newValue;
            if (!this.check(fieldName, attStatisticQueryParam, queryDate)) {
                return;
            }
            if (HRStringUtils.equals((String)"datefield", (String)fieldName)) {
                attStatisticQueryParam.setQueryDate(queryDate);
            } else if (HRStringUtils.equals((String)"changeyear", (String)fieldName)) {
                attStatisticQueryParam.setQueryStartDate(WTCDateUtils.getBeginDayOfMonth((Date)queryDate));
                attStatisticQueryParam.setQueryEndDate(WTCDateUtils.getEndDayOfMonth((Date)queryDate));
                Set periodEntryIdSet = AttStatisticsServiceHelper.getInstance().getPeriodEntryIdSet(attStatisticQueryParam.getQueryStartDate(), attStatisticQueryParam.getQueryEndDate(), attStatisticQueryParam.getAttFileMap().keySet());
                attStatisticQueryParam.setPeriodEntrySet(periodEntryIdSet);
            }
            AttStatisticsFormService.getInstance().cacheAttStatisticQueryParam(this.getPageCache(), attStatisticQueryParam);
        }
        if (HRStringUtils.equalsIgnoreCase((String)"statradiogroup", (String)fieldName)) {
            String staType = this.getModel().getDataEntity().getString("statradiogroup");
            long userId = UserServiceHelper.getCurrentUserId();
            this.getView().getPageCache().put("statype" + userId, staType);
            if (HRStringUtils.equals((String)"1", (String)staType)) {
                attStatisticQueryParam.setStaTypeEnum(StaTypeEnum.DAILY);
            } else {
                attStatisticQueryParam.setStaTypeEnum(StaTypeEnum.PERIOD);
            }
            AttStatisticsFormService.getInstance().cacheAttStatisticQueryParam(this.getPageCache(), attStatisticQueryParam);
        }
        this.getView().invokeOperation("refresh");
    }

    private boolean check(String fieldName, AttStatisticQueryParam attStatisticQueryParam, Date newQueryDate) {
        if (HRStringUtils.equals((String)"datefield", (String)fieldName)) {
            Tuple tupleDate = new Tuple((Object)newQueryDate, (Object)newQueryDate);
            if (!MobileHomePageBusiness.getInstance().checkDate(true, "1", this.getView(), attStatisticQueryParam, tupleDate)) {
                this.getModel().setValue("datefield", (Object)attStatisticQueryParam.getQueryDate());
                return false;
            }
        } else if (HRStringUtils.equals((String)"changeyear", (String)fieldName) && !MobileHomePageBusiness.getInstance().checkDate(true, "2", this.getView(), attStatisticQueryParam, new Tuple((Object)WTCDateUtils.getBeginDayOfMonth((Date)newQueryDate), (Object)WTCDateUtils.getEndDayOfMonth((Date)newQueryDate)))) {
            this.getModel().setValue("changeyear", (Object)attStatisticQueryParam.getQueryStartDate());
            return false;
        }
        return true;
    }

    private void setTabDetail(AttStatisticQueryParam attStatisticQueryParam, StaTypeEnum staTypeEnum) {
        DynamicObject dailyStaSource = TeamHomeServiceHelper.getInstance().getDynamicObjectByChickSourceId(attStatisticQueryParam);
        if (dailyStaSource == null) {
            return;
        }
        boolean isTeamHomeKpi = StaTypeEnum.DAILY == attStatisticQueryParam.getStaTypeEnum() && "2".equals(dailyStaSource.getString("valtakmethod"));
        this.getView().setVisible(Boolean.valueOf(!isTeamHomeKpi), new String[]{"flexpanelap4"});
        this.getView().setVisible(Boolean.valueOf(isTeamHomeKpi), new String[]{"flexpanelap7"});
        if (isTeamHomeKpi) {
            FormShowParameter parameter = TeamHomeServiceHelper.getInstance().getTargetInfoDiaLogParameter(attStatisticQueryParam, dailyStaSource);
            OpenStyle style = new OpenStyle();
            StyleCss cssValue = new StyleCss();
            cssValue.setWidth("100%");
            style.setInlineStyleCss(cssValue);
            style.setShowType(ShowType.Modal);
            parameter.setOpenStyle(style);
            parameter.getOpenStyle().setTargetKey("flexpanelap7");
            parameter.getOpenStyle().setShowType(ShowType.InContainer);
            parameter.setCustomParam("statype", (Object)StaTypeEnum.DAILY.getStaCombinationType());
            this.getView().showForm(parameter);
        } else {
            IAttStatisticsService attStatisticsService = AttStatisticsServiceHelper.getInstance().getAttStatisticsService(staTypeEnum);
            AttDataSourceModel attStatisticsPersonDetailData = attStatisticsService.getAttStatisticsPersonDetailData(attStatisticQueryParam, 0);
            AttStatisticsFormService.getInstance().fieldNameSet(staTypeEnum, "entryentitydetail", this.getView());
            if (attStatisticsPersonDetailData != null) {
                String clickUnit = attStatisticsPersonDetailData.getUnit();
                List dataList = attStatisticsPersonDetailData.getAttDataSourceDetails();
                if (dataList == null) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info("TeamHomeDetailPlugin#setTabDetail dataList is null");
                    }
                    return;
                }
                String dataStr = "";
                if (StaTypeEnum.DAILY == staTypeEnum) {
                    dataStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)attStatisticQueryParam.getQueryDate());
                } else if (StaTypeEnum.PERIOD == staTypeEnum) {
                    dataStr = WTCDateUtils.date2Str((Date)attStatisticQueryParam.getQueryStartDate(), (String)"yyyy-MM");
                }
                ArrayList<AttDataSourceDetailsModel> resultList = new ArrayList<AttDataSourceDetailsModel>(16);
                for (AttDataSourceDetailsModel attDataSourceDetailsModel : dataList) {
                    if (Objects.nonNull(dailyStaSource) && "1".equals(dailyStaSource.getString("showdimen")) && Double.compare(attDataSourceDetailsModel.getStaValue(), 0.0) == 0) continue;
                    resultList.add(attDataSourceDetailsModel);
                }
                AttStatisticsFormService.getInstance().fillEntityDetail(this.getModel(), this.getView(), "entryentitydetail", clickUnit, dataStr, resultList);
            }
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        Tuple tupleDate;
        String tabKey = tabSelectEvent.getTabKey();
        String staType = this.getModel().getDataEntity().getString("statradiogroup");
        AttStatisticQueryParam attStatisticQueryParam = this.getAttStatisticQueryParam();
        if (HRStringUtils.equals((String)"1", (String)staType)) {
            tupleDate = new Tuple((Object)attStatisticQueryParam.getQueryDate(), (Object)attStatisticQueryParam.getQueryDate());
            if (!MobileHomePageBusiness.getInstance().checkDate(true, "1", this.getView(), attStatisticQueryParam, tupleDate)) {
                return;
            }
            attStatisticQueryParam.setStaTypeEnum(StaTypeEnum.DAILY);
        } else {
            tupleDate = new Tuple((Object)attStatisticQueryParam.getQueryStartDate(), (Object)attStatisticQueryParam.getQueryEndDate());
            if (!MobileHomePageBusiness.getInstance().checkDate(true, "2", this.getView(), attStatisticQueryParam, tupleDate)) {
                return;
            }
            attStatisticQueryParam.setStaTypeEnum(StaTypeEnum.PERIOD);
        }
        String[] tabStr = tabKey.split("_");
        long dataSourceId = Long.parseLong(tabStr[0]);
        long userId = UserServiceHelper.getCurrentUserId();
        this.getView().getPageCache().put("checkid" + userId, dataSourceId + "");
        attStatisticQueryParam.setChickSourceId(Long.valueOf(dataSourceId));
        AttStatisticsFormService.getInstance().cacheAttStatisticQueryParam(this.getPageCache(), attStatisticQueryParam);
        this.getView().invokeOperation("refresh");
    }
}

