/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.formplugin.web.pc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;
import kd.wtc.wtss.business.attstatistics.AttStatisticsFormService;
import kd.wtc.wtss.business.attstatistics.AttStatisticsServiceHelper;
import kd.wtc.wtss.business.attstatistics.IAttStatisticsService;
import kd.wtc.wtss.business.servicehelper.common.SchemaServiceHelper;
import kd.wtc.wtss.business.servicehelper.common.TeamHomeServiceHelper;
import kd.wtc.wtss.business.servicehelper.mobile.MobileHomePageBusiness;
import kd.wtc.wtss.business.servicehelper.mobile.MobileTeamHomeBusiness;
import kd.wtc.wtss.business.servicehelper.mobile.RankingDataServiceHelper;
import kd.wtc.wtss.business.servicehelper.pc.StaffPCAppConfigService;
import kd.wtc.wtss.common.constants.MobileTeamHomeConstants;
import kd.wtc.wtss.common.constants.TeamHomePCConstants;
import kd.wtc.wtss.common.dto.mobilehome.AttDataSourceModel;
import kd.wtc.wtss.common.dto.mobilehome.AttStatisticQueryParam;
import kd.wtc.wtss.common.dto.mobilehome.AttendanceDataModel;
import kd.wtc.wtss.common.enums.attstatistics.StaCombinationConfProEnum;
import kd.wtc.wtss.common.enums.attstatistics.StaCombinationTerminal;
import kd.wtc.wtss.common.enums.attstatistics.StaTypeEnum;
import kd.wtc.wtss.common.utils.WTSSDateUtils;

public class TeamHomePCPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener,
BeforeF7SelectListener,
TeamHomePCConstants {
    private static final Log LOG = LogFactory.getLog(TeamHomePCPlugin.class);
    private final MobileTeamHomeBusiness mobileTeamHomeBusiness = MobileTeamHomeBusiness.getInstance();
    private final MobileHomePageBusiness mobileHomePageBusiness = MobileHomePageBusiness.getInstance();
    private static final String IS_NOT_FIRST = "isNotFirst";
    private static final String IS_NOT_FIRST2 = "isNotFirst2";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"attstavector", "rankvector", "stachavector"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        this.addClickListeners(new String[]{"vacationflex", "overtimeflex", "travelflex", "signflex", "swshiftflex", "seemoreflex", "seemore"});
        this.addClickListeners(new String[]{"barchartap0", "barchartap1", "barchartap2", "barchartap3", "barchartap4", "barchartap5"});
        BasedataEdit orgEdit = (BasedataEdit)this.getControl("org");
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit adminOrgEdit = (BasedataEdit)this.getControl("affiliateadminorg");
        adminOrgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit quotaAttItemEdit = (BasedataEdit)this.getControl("quotaattitem");
        quotaAttItemEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        AttStatisticQueryParam cacheAttStatisticQueryParam = AttStatisticsFormService.getInstance().getCacheAttStatisticQueryParam(this.getView(), StaCombinationTerminal.PC);
        if (cacheAttStatisticQueryParam == null) {
            LOG.info("cacheAttStatisticQueryParam is null ");
            this.initDataFail();
            return;
        }
        if (cacheAttStatisticQueryParam.getRuleId() == 0L) {
            this.initDataFail();
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u5047\u52e4\u81ea\u52a9\u65b9\u6848\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MobileTeamHomeFormPlugin_10", (String)"wtc-wtss-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"attdatanullflex"});
        this.setQuickLaunchVisible(cacheAttStatisticQueryParam.getRuleId());
        Date queryDate = cacheAttStatisticQueryParam.getQueryDate();
        this.getModel().setValue("affiliateadminorg", (Object)cacheAttStatisticQueryParam.getAffiliateAdminOrgId());
        this.getModel().setValue("daydate", (Object)queryDate);
        this.getModel().setValue("changeyear", (Object)queryDate);
        TeamHomeServiceHelper.getInstance().setDateEditRange(queryDate, this.getView(), "daydate", "changeyear");
        this.initDayOrPeriodStatistic(cacheAttStatisticQueryParam);
        this.initAttendance(queryDate, cacheAttStatisticQueryParam.thenAttFileSet());
        this.rankingAndChartInit(cacheAttStatisticQueryParam);
        DynamicObject ruleDy = SchemaServiceHelper.getInstance().queryRuleData(cacheAttStatisticQueryParam.getRuleId().longValue());
        if (ruleDy.get("quotaconfig") == null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"quotapage"});
        } else {
            long quotaConfigId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)ruleDy, (String)"quotaconfig");
            DynamicObject quotaConfigDy = SchemaServiceHelper.getInstance().loadQuotaConfig(quotaConfigId);
            Set quotaSourceIdSet = quotaConfigDy.getDynamicObjectCollection("entryentity").stream().filter(dy -> "0".equals(dy.getString("terminal")) || "2".equals(dy.getString("terminal"))).map(dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"quotasource")).collect(Collectors.toSet());
            cacheAttStatisticQueryParam.setQuotaSourceIdSet(quotaSourceIdSet);
            AttStatisticsFormService.getInstance().cacheAttStatisticQueryParam(this.getPageCache(), cacheAttStatisticQueryParam);
            this.getModel().setValue("quotaattitem", (Object)SchemaServiceHelper.getInstance().querySeqMinQuotaSource(quotaSourceIdSet));
        }
        this.setPageVisible(0, cacheAttStatisticQueryParam);
    }

    private void initDataFail() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"daychartflex", "entityflex"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"rankingentity", "changeyear", "useyear", "quotaattitem"});
        this.getView().setStatus(OperationStatus.VIEW);
        MobileTeamHomeConstants.QUICK_LAUNCH_MAP.keySet().forEach(key -> this.getView().setVisible(Boolean.FALSE, new String[]{(String)MobileTeamHomeConstants.QUICK_LAUNCH_MAP.get(key)}));
        this.getPageCache().put("pagestatus", "1");
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        HashMap adminOrgIdByPersonIdPlusMap = new HashMap(16);
        ArrayList allAdminOrgIdList = new ArrayList(1);
        AttStatisticsFormService.getInstance().collectAdminOrgIdByPersonIdPlusMap(this.getView(), allAdminOrgIdList, adminOrgIdByPersonIdPlusMap);
        AttStatisticQueryParam cacheAttStatisticQueryParam = AttStatisticsFormService.getInstance().getCacheAttStatisticQueryParam(this.getView(), StaCombinationTerminal.PC);
        cacheAttStatisticQueryParam.setAdminOrgIdByPersonIdPlusMap(adminOrgIdByPersonIdPlusMap);
        cacheAttStatisticQueryParam.setAllAdminOrgIdList(allAdminOrgIdList);
        AttStatisticsFormService.getInstance().cacheAttStatisticQueryParam(this.getPageCache(), cacheAttStatisticQueryParam);
        if ("affiliateadminorg".equals(beforeF7SelectEvent.getProperty().getName()) && null != cacheAttStatisticQueryParam) {
            formShowParameter.setFormId("bos_listf7");
            QFilter qFilter = new QFilter("id", "in", (Object)cacheAttStatisticQueryParam.getAllAdminOrgIdList());
            formShowParameter.getListFilterParameter().setFilter(qFilter);
            beforeF7SelectEvent.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u6302\u9760\u884c\u653f\u7ec4\u7ec7", (String)"TeamHomePCPlugin_8", (String)"wtc-wtss-formplugin", (Object[])new Object[0]));
        } else if ("quotaattitem".equals(beforeF7SelectEvent.getProperty().getName()) && null != cacheAttStatisticQueryParam) {
            QFilter qFilter = new QFilter("id", "in", (Object)cacheAttStatisticQueryParam.getQuotaSourceIdSet());
            formShowParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        AttStatisticQueryParam cacheAttStatisticQueryParam = this.getAttStatisticQueryParam();
        String confStr = StaTypeEnum.DAILY == cacheAttStatisticQueryParam.getStaTypeEnum() ? this.getView().getPageCache().get("cache_id_daystatistic") : this.getView().getPageCache().get("cache_id_perstatistic");
        List attDataDayDownModel = SerializationUtils.fromJsonStringToList((String)confStr, AttDataSourceModel.class);
        AttDataSourceModel attDataSourceModel = (AttDataSourceModel)attDataDayDownModel.get(arg0.getRowIndex());
        cacheAttStatisticQueryParam.setStaCombinationConfProEnum(StaCombinationConfProEnum.ATT_STATISTICS);
        cacheAttStatisticQueryParam.setChickSourceId(attDataSourceModel.getAttDataSourceId());
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId("wtss_pcteamattstat");
        showParameter.setCustomParam("homeDetailListModel", (Object)SerializationUtils.toJsonString((Object)cacheAttStatisticQueryParam));
        this.getView().showForm(showParameter);
    }

    private AttStatisticQueryParam getAttStatisticQueryParam() {
        return AttStatisticsFormService.getInstance().getCacheAttStatisticQueryParamEx(this.getView().getPageCache());
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        BillShowParameter formShowParameter = new BillShowParameter();
        AttStatisticQueryParam attStatisticQueryParam = AttStatisticsFormService.getInstance().getCacheAttStatisticQueryParam(this.getView().getPageCache());
        if (attStatisticQueryParam != null) {
            Long ruleId = attStatisticQueryParam.getRuleId();
            StaTypeEnum staTypeEnum = attStatisticQueryParam.getStaTypeEnum();
            switch (key) {
                case "attstavector": {
                    this.showConfigPageByStaType(ruleId, staTypeEnum, "close_wtss_attdayset", "1", "close_wtss_attperset");
                    break;
                }
                case "rankvector": {
                    this.showConfigPageByStaType(ruleId, staTypeEnum, "close_wtss_rankdayset", "2", "close_wtss_rankperset");
                    break;
                }
                case "stachavector": {
                    this.showConfigPageByStaType(ruleId, staTypeEnum, "close_wtss_stadayset", "3", "close_wtss_staperset");
                    break;
                }
                case "vacationflex": {
                    this.genShowOtherBill(formShowParameter, "wtabm_vaapply");
                    break;
                }
                case "overtimeflex": {
                    this.genShowOtherBill(formShowParameter, "wtom_overtimeapplybill");
                    break;
                }
                case "travelflex": {
                    this.genShowOtherBill(formShowParameter, "wtam_busitripbill");
                    break;
                }
                case "signflex": {
                    this.genShowOtherBill(formShowParameter, "wtpm_supsignpc");
                    break;
                }
                case "swshiftflex": {
                    this.genShowOtherBill(formShowParameter, "wts_swshiftbill");
                    break;
                }
                case "seemoreflex": 
                case "seemore": {
                    this.seeMoreRankChartInfo(staTypeEnum, "1", "");
                    break;
                }
                case "barchartap0": 
                case "barchartap1": 
                case "barchartap2": 
                case "barchartap3": 
                case "barchartap4": 
                case "barchartap5": {
                    String number = key.replaceAll("barchartap", "");
                    this.seeMoreRankChartInfo(staTypeEnum, "2", number);
                    break;
                }
            }
        }
    }

    private void genShowOtherBill(BillShowParameter formShowParameter, String wtabmVaapplyOther) {
        formShowParameter.setEnableUserReentrant(true);
        Optional.ofNullable(formShowParameter.getOpenStyle()).ifPresent(style -> style.setShowType(ShowType.MainNewTabPage));
        formShowParameter.setFormId(wtabmVaapplyOther);
        String newPageId = this.getNewPageId(wtabmVaapplyOther, formShowParameter);
        formShowParameter.setPageId(newPageId);
        formShowParameter.setPermissionItemId("47156aff000000ac");
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private void showConfigPageByStaType(Long ruleId, StaTypeEnum staTypeEnum, String closeStadaysetPage, String strThree, String closeStapersetPage) {
        if (this.isRuleNull(staTypeEnum, ruleId)) {
            return;
        }
        if (StaTypeEnum.DAILY == staTypeEnum) {
            CloseCallBack staCloseCallBack = new CloseCallBack((IFormPlugin)this, closeStadaysetPage);
            this.showConfigPage(this.getView(), staCloseCallBack, "A", strThree);
        } else {
            CloseCallBack staCloseCallBack = new CloseCallBack((IFormPlugin)this, closeStapersetPage);
            this.showConfigPage(this.getView(), staCloseCallBack, "B", strThree);
        }
    }

    private String getNewPageId(String targetFormId, BillShowParameter formShowParameter) {
        return this.getView().getFormShowParameter().getRootPageId() + "wtss" + targetFormId + formShowParameter.getFormId();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (null == returnData || !"btndetermine".equals(((Map)returnData).get("op"))) {
            return;
        }
        if (null != returnData && "1".equals(((Map)returnData).get("data_change"))) {
            return;
        }
        AttStatisticQueryParam attStatisticQueryParam = this.getAttStatisticQueryParam();
        Date queryDate = attStatisticQueryParam.getQueryDate();
        switch (actionId) {
            case "close_wtss_attdayset": {
                attStatisticQueryParam.setStaTypeEnum(StaTypeEnum.DAILY);
                this.initDayOrPeriodStatistic(attStatisticQueryParam);
                this.initAttendance(queryDate, attStatisticQueryParam.getAttFileMap().keySet());
                break;
            }
            case "close_wtss_attperset": {
                attStatisticQueryParam.setStaTypeEnum(StaTypeEnum.PERIOD);
                this.initDayOrPeriodStatistic(attStatisticQueryParam);
                break;
            }
            case "close_wtss_rankdayset": {
                this.getView().getPageCache().put("changeNumSelect", "changeNumSelect");
                attStatisticQueryParam.setStaTypeEnum(StaTypeEnum.DAILY);
                this.rankingAndChartInit(attStatisticQueryParam);
                break;
            }
            case "close_wtss_rankperset": {
                this.getView().getPageCache().put("changeNumSelect", "changeNumSelect");
                attStatisticQueryParam.setStaTypeEnum(StaTypeEnum.PERIOD);
                this.rankingAndChartInit(attStatisticQueryParam);
                break;
            }
            case "close_wtss_stadayset": {
                if (closedCallBackEvent.getReturnData() == null) {
                    return;
                }
                attStatisticQueryParam.setStaTypeEnum(StaTypeEnum.DAILY);
                this.rankingAndChartInit(attStatisticQueryParam);
                break;
            }
            case "close_wtss_staperset": {
                if (closedCallBackEvent.getReturnData() == null) {
                    return;
                }
                attStatisticQueryParam.setStaTypeEnum(StaTypeEnum.PERIOD);
                this.rankingAndChartInit(attStatisticQueryParam);
                break;
            }
        }
    }

    private void changeStaType(String staType) {
        this.getView().showLoading(null);
        String pageStatus = this.getView().getPageCache().get("pagestatus");
        if ("1".equals(pageStatus)) {
            return;
        }
        AttStatisticQueryParam attStatisticQueryParam = this.getAttStatisticQueryParam();
        Long ruleId = attStatisticQueryParam.getRuleId();
        if ("1".equals(staType)) {
            this.setPageVisible(0, attStatisticQueryParam);
            attStatisticQueryParam.setStaTypeEnum(StaTypeEnum.DAILY);
            AttStatisticsFormService.getInstance().cacheAttStatisticQueryParam(this.getPageCache(), attStatisticQueryParam);
            if (ruleId == 0L) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"daychartflex", "entityflex"});
                return;
            }
            if (!MobileHomePageBusiness.getInstance().checkDate(false, "1", this.getView(), attStatisticQueryParam, new Tuple((Object)attStatisticQueryParam.getQueryDate(), (Object)attStatisticQueryParam.getQueryDate()))) {
                Date queryDate = WTCDateUtils.getZeroDate((Date)WTSSDateUtils.getLastDate());
                attStatisticQueryParam.setQueryDate(queryDate);
                AttStatisticsFormService.getInstance().cacheAttStatisticQueryParam(this.getPageCache(), attStatisticQueryParam);
                this.getModel().setValue("daydate", (Object)queryDate);
            }
            this.initDayOrPeriodStatistic(attStatisticQueryParam);
            this.rankingAndChartInit(attStatisticQueryParam);
            this.initAttendance(attStatisticQueryParam.getQueryDate(), attStatisticQueryParam.getAttFileMap().keySet());
        } else if ("2".equals(staType)) {
            attStatisticQueryParam.setStaTypeEnum(StaTypeEnum.PERIOD);
            AttStatisticsFormService.getInstance().cacheAttStatisticQueryParam(this.getPageCache(), attStatisticQueryParam);
            this.setPageVisible(1, attStatisticQueryParam);
            Tuple tupleDate = new Tuple((Object)attStatisticQueryParam.getQueryStartDate(), (Object)attStatisticQueryParam.getQueryEndDate());
            if (!MobileHomePageBusiness.getInstance().checkDate(false, "2", this.getView(), attStatisticQueryParam, tupleDate)) {
                Date date = WTCDateUtils.getZeroDate((Date)WTSSDateUtils.getLastDate());
                AttStatisticQueryParam.thenTupleDate((Date)date);
                attStatisticQueryParam.setQueryStartDate(WTCDateUtils.getBeginDayOfMonth((Date)date));
                attStatisticQueryParam.setQueryEndDate(WTCDateUtils.getEndDayOfMonth((Date)date));
                Set periodEntryIdSet = AttStatisticsServiceHelper.getInstance().getPeriodEntryIdSet(attStatisticQueryParam.getQueryStartDate(), attStatisticQueryParam.getQueryEndDate(), attStatisticQueryParam.getAttFileMap().keySet());
                attStatisticQueryParam.setPeriodEntrySet(periodEntryIdSet);
                AttStatisticsFormService.getInstance().cacheAttStatisticQueryParam(this.getPageCache(), attStatisticQueryParam);
                this.getModel().setValue("changeyear", (Object)WTCDateUtils.getBeginDayOfMonth((Date)date));
            }
            this.initDayOrPeriodStatistic(attStatisticQueryParam);
            this.rankingAndChartInit(attStatisticQueryParam);
        } else if ("3".equals(staType)) {
            attStatisticQueryParam.setStaTypeEnum(StaTypeEnum.QUOTA);
            AttStatisticsFormService.getInstance().cacheAttStatisticQueryParam(this.getPageCache(), attStatisticQueryParam);
            this.setPageVisible(2, attStatisticQueryParam);
            this.loadQuotaStatistics(staType);
        }
        this.setQuickLaunchVisible(ruleId);
        this.getView().hideLoading();
    }

    private boolean loadQuotaStatistics(String fieldName) {
        Date useYear = (Date)this.getModel().getValue("useyear");
        if (useYear != null) {
            Date startDate = WTCDateUtils.getBeginDayOfYear((Date)useYear);
            Date endDate = WTCDateUtils.getEndDayOfYear((Date)useYear);
            AttStatisticQueryParam attStatisticQueryParam = AttStatisticsFormService.getInstance().getCacheAttStatisticQueryParam(this.getView().getPageCache());
            Tuple dateTuple = new Tuple((Object)startDate, (Object)endDate);
            switch (fieldName) {
                case "useyear": 
                case "quotaattitem": {
                    if (!"true".equals(this.getView().getPageCache().get(IS_NOT_FIRST)) && !MobileHomePageBusiness.getInstance().checkDate(true, "3", this.getView(), attStatisticQueryParam, dateTuple)) {
                        if (fieldName.contains("useyear")) {
                            this.getPageCache().put(IS_NOT_FIRST, "true");
                            this.getModel().setValue("useyear", (Object)attStatisticQueryParam.getQueryStartDate());
                        }
                        return false;
                    }
                    this.getPageCache().remove(IS_NOT_FIRST);
                    break;
                }
                case "3": {
                    if (MobileHomePageBusiness.getInstance().checkDate(false, "3", this.getView(), attStatisticQueryParam, dateTuple)) break;
                    Date date = WTCDateUtils.getZeroDate((Date)WTSSDateUtils.getLastDate());
                    startDate = WTCDateUtils.getBeginDayOfYear((Date)date);
                    endDate = WTCDateUtils.getEndDayOfYear((Date)date);
                    this.getModel().setValue("useyear", (Object)attStatisticQueryParam.getQueryStartDate());
                    this.getModel().setValue("useyear", (Object)startDate);
                    break;
                }
                case "quotaconfig": {
                    if (MobileHomePageBusiness.getInstance().checkDate(true, "3", this.getView(), attStatisticQueryParam, dateTuple)) break;
                    return false;
                }
            }
            DynamicObject affiliateAdminOrg = (DynamicObject)this.getModel().getValue("affiliateadminorg");
            if (null == affiliateAdminOrg) {
                return false;
            }
            Long affiliateAdminOrgId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)affiliateAdminOrg, (String)"id");
            Set personIdSet = TeamHomeServiceHelper.getInstance().getPersonId(startDate, endDate, Collections.singleton(affiliateAdminOrg.getLong("id")));
            Set attFileIdSet = TeamHomeServiceHelper.getInstance().getAttFileIdSet(personIdSet, affiliateAdminOrgId.longValue(), startDate, endDate);
            QFilter qFilter = new QFilter("id", "in", (Object)attFileIdSet);
            HashMap customParamMap = Maps.newHashMapWithExpectedSize((int)7);
            DynamicObject quotaAttItem = (DynamicObject)this.getModel().getValue("quotaattitem");
            if (quotaAttItem == null) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("loadQuotaStatistics quotaAttItem is null");
                }
                return false;
            }
            customParamMap.put("quotaattitem", quotaAttItem.getLong("id"));
            customParamMap.put("useyear", this.getModel().getValue("useyear"));
            customParamMap.put("attfileid", attFileIdSet);
            customParamMap.put("person", personIdSet);
            customParamMap.put("startdate", startDate);
            customParamMap.put("enddate", endDate);
            customParamMap.put("affiliateadminorg", affiliateAdminOrg.getLong("id"));
            ListShowParameter listShowParameter = this.geQuotatListShowParameter(qFilter, customParamMap);
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
        return true;
    }

    private ListShowParameter geQuotatListShowParameter(QFilter qFilter, Map<String, Object> customParamMap) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        listShowParameter.setBillFormId("wtss_pcquotastatistics");
        listShowParameter.getOpenStyle().setTargetKey("quotastatistics");
        listShowParameter.setFormId("wtbs_onlylist");
        listShowParameter.setCustomParams(customParamMap);
        listShowParameter.getListFilterParameter().setFilter(qFilter);
        return listShowParameter;
    }

    private void setPageVisible(int type, AttStatisticQueryParam attStatisticQueryParam) {
        if (type == 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"daydate", "dayandperiod"});
            this.getView().setVisible(Boolean.valueOf(attStatisticQueryParam.isShowBoard()), new String[]{"daychartflex"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"useyear", "quotaattitem", "quotastatistics", "changeyear"});
        } else if (type == 1) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"daydate", "daychartflex", "useyear", "quotaattitem", "quotastatistics"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"dayandperiod", "changeyear"});
        } else if (type == 2) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"daydate", "daychartflex", "dayandperiod", "changeyear"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"useyear", "quotaattitem", "quotastatistics"});
        }
    }

    private void setQuickLaunchVisible(Long ruleId) {
        List showTeamConfig = StaffPCAppConfigService.getRuleAllApps((Long)ruleId);
        if (LOG.isDebugEnabled()) {
            LOG.debug("setQuickLaunchVisible#showTeamConfig:{} ", (Object)showTeamConfig);
        }
        if (HRCollUtil.isEmpty((Collection)showTeamConfig)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"quickentryflex"});
        }
        for (Map.Entry entry : MobileTeamHomeConstants.QUICK_LAUNCH_MAP.entrySet()) {
            if (!showTeamConfig.contains(entry.getKey())) {
                this.getView().setVisible(Boolean.FALSE, new String[]{(String)MobileTeamHomeConstants.QUICK_LAUNCH_MAP.get(entry.getKey())});
                continue;
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{(String)MobileTeamHomeConstants.QUICK_LAUNCH_MAP.get(entry.getKey())});
        }
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        Object oldValue;
        String fieldName = propertyChangedArgs.getProperty().getName();
        Object newValue = WTCCollectionIndexUtil.getEleFromArr((Object[])propertyChangedArgs.getChangeSet(), (int)0).isPresent() ? propertyChangedArgs.getChangeSet()[0].getNewValue() : null;
        Object object = oldValue = WTCCollectionIndexUtil.getEleFromArr((Object[])propertyChangedArgs.getChangeSet(), (int)0).isPresent() ? propertyChangedArgs.getChangeSet()[0].getOldValue() : null;
        if (newValue == null) {
            if (HRStringUtils.equals((String)"affiliateadminorg", (String)fieldName)) {
                this.getModel().setValue("affiliateadminorg", oldValue);
                return;
            }
            if (HRStringUtils.equals((String)"daydate", (String)fieldName)) {
                this.getModel().setValue("daydate", oldValue);
                return;
            }
            if (HRStringUtils.equals((String)"changeyear", (String)fieldName)) {
                this.getModel().setValue("changeyear", oldValue);
                return;
            }
        }
        if (newValue != null) {
            if (HRStringUtils.equals((String)"daydate", (String)fieldName)) {
                this.dayDateChange(newValue);
            } else if (HRStringUtils.equals((String)"changeyear", (String)fieldName)) {
                this.periodDateChange(newValue);
            } else if (HRStringUtils.equals((String)"affiliateadminorg", (String)fieldName)) {
                DynamicObject dynObj = this.getModel().getDataEntity().getDynamicObject("affiliateadminorg");
                if (dynObj == null) {
                    long attOrgId = Long.parseLong(this.getView().getPageCache().get("cacheid_attorgid"));
                    this.getModel().setValue("affiliateadminorg", (Object)attOrgId);
                    return;
                }
                long attOrgId = dynObj.getLong("id");
                if (!"true".equals(this.getView().getPageCache().get(IS_NOT_FIRST2)) && !this.setTeamPageRef(attOrgId)) {
                    this.getPageCache().put(IS_NOT_FIRST2, "true");
                    AttStatisticQueryParam attStatisticQueryParam = this.getAttStatisticQueryParam();
                    long id = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)((DynamicObject)propertyChangedArgs.getChangeSet()[0].getOldValue()), (String)"id");
                    attStatisticQueryParam.setAffiliateAdminOrgId(id);
                    AttStatisticsFormService.getInstance().cacheAttStatisticQueryParam(this.getPageCache(), attStatisticQueryParam);
                    this.getModel().setValue("affiliateadminorg", propertyChangedArgs.getChangeSet()[0].getOldValue());
                }
                this.getPageCache().remove(IS_NOT_FIRST2);
            } else if (fieldName.contains("numselect")) {
                String attDataSource = this.getView().getPageCache().get("attDataSourceChart");
                List attDataSourceModel = SerializationUtils.fromJsonStringToList((String)attDataSource, AttDataSourceModel.class);
                this.getView().getPageCache().put("changeNumSelect", "changeNumSelect");
                RankingDataServiceHelper.initChart((List)attDataSourceModel, (IFormView)this.getView());
            } else if (fieldName.contains("useyear") || fieldName.contains("quotaattitem")) {
                this.loadQuotaStatistics(fieldName);
            } else if (HRStringUtils.equals((String)"statradiogroup", (String)fieldName)) {
                String staType = String.valueOf(newValue);
                this.changeStaType(staType);
            }
        }
    }

    private void dayDateChange(Object newValue) {
        AttStatisticQueryParam attStatisticQueryParam = this.getAttStatisticQueryParam();
        Date queryDate = attStatisticQueryParam.getQueryDate();
        if (newValue == null) {
            this.getModel().setValue("daydate", (Object)queryDate);
            return;
        }
        if (!MobileHomePageBusiness.getInstance().checkDate(true, "1", this.getView(), attStatisticQueryParam, new Tuple((Object)((Date)newValue), (Object)((Date)newValue)))) {
            this.getModel().setValue("daydate", (Object)queryDate);
            return;
        }
        attStatisticQueryParam.setQueryDate((Date)newValue);
        AttStatisticsFormService.getInstance().cacheAttStatisticQueryParam(this.getPageCache(), attStatisticQueryParam);
        if (attStatisticQueryParam.getRuleId() != 0L) {
            this.initDayOrPeriodStatistic(attStatisticQueryParam);
            this.getView().getPageCache().put("changeNumSelect", "changeNumSelect");
            this.rankingAndChartInit(attStatisticQueryParam);
            this.initAttendance((Date)newValue, attStatisticQueryParam.getAttFileMap().keySet());
        }
    }

    private void periodDateChange(Object newValue) {
        AttStatisticQueryParam attStatisticQueryParam = this.getAttStatisticQueryParam();
        if (newValue == null) {
            this.getModel().setValue("daydate", (Object)attStatisticQueryParam.getQueryStartDate());
            return;
        }
        if (!MobileHomePageBusiness.getInstance().checkDate(true, "2", this.getView(), attStatisticQueryParam, new Tuple((Object)WTCDateUtils.getBeginDayOfMonth((Date)((Date)newValue)), (Object)WTCDateUtils.getEndDayOfMonth((Date)((Date)newValue))))) {
            this.getModel().setValue("changeyear", (Object)attStatisticQueryParam.getQueryStartDate());
            return;
        }
        Tuple tupleDate = AttStatisticQueryParam.thenTupleDate((Date)((Date)newValue));
        attStatisticQueryParam.setQueryStartDate((Date)tupleDate.getKey());
        attStatisticQueryParam.setQueryEndDate((Date)tupleDate.getValue());
        Set periodEntryIdSet = AttStatisticsServiceHelper.getInstance().getPeriodEntryIdSet(attStatisticQueryParam.getQueryStartDate(), attStatisticQueryParam.getQueryEndDate(), attStatisticQueryParam.getAttFileMap().keySet());
        attStatisticQueryParam.setPeriodEntrySet(periodEntryIdSet);
        AttStatisticsFormService.getInstance().cacheAttStatisticQueryParam(this.getPageCache(), attStatisticQueryParam);
        if (attStatisticQueryParam.getRuleId() != 0L) {
            attStatisticQueryParam.setStaTypeEnum(StaTypeEnum.PERIOD);
            this.initDayOrPeriodStatistic(attStatisticQueryParam);
            this.getView().getPageCache().put("changeNumSelect", "changeNumSelect");
            this.rankingAndChartInit(attStatisticQueryParam);
            this.initAttendance((Date)newValue, attStatisticQueryParam.getAttFileMap().keySet());
        }
    }

    private boolean setTeamPageRef(long attOrgId) {
        AttStatisticQueryParam attStatisticQueryParam = this.getAttStatisticQueryParam();
        attStatisticQueryParam.setAffiliateAdminOrgId(attOrgId);
        if (StaTypeEnum.DAILY == attStatisticQueryParam.getStaTypeEnum()) {
            AttStatisticsFormService.getInstance().cacheAttStatisticQueryParam(this.getPageCache(), attStatisticQueryParam);
            Date newValue = (Date)this.getModel().getValue("daydate");
            Tuple tupleDate = new Tuple((Object)newValue, (Object)newValue);
            if (LOG.isInfoEnabled()) {
                LOG.info("kd.wtc.wtss.formplugin.web.pc.TeamHomePCPlugin.setTeamPageRef DAILY key:{},value:{}", tupleDate.getKey(), tupleDate.getValue());
            }
            if (!MobileHomePageBusiness.getInstance().checkDate(true, "1", this.getView(), attStatisticQueryParam, tupleDate)) {
                return false;
            }
            this.initDayOrPeriodStatistic(attStatisticQueryParam);
            this.initAttendance(attStatisticQueryParam.getQueryDate(), attStatisticQueryParam.thenAttFileSet());
            this.getView().getPageCache().put("changeNumSelect", "changeNumSelect");
            this.rankingAndChartInit(attStatisticQueryParam);
        } else if (StaTypeEnum.PERIOD == attStatisticQueryParam.getStaTypeEnum()) {
            AttStatisticsFormService.getInstance().cacheAttStatisticQueryParam(this.getPageCache(), attStatisticQueryParam);
            Tuple tupleDate = new Tuple((Object)attStatisticQueryParam.getQueryStartDate(), (Object)attStatisticQueryParam.getQueryEndDate());
            Object value = this.getModel().getValue("changeyear");
            if (LOG.isInfoEnabled()) {
                LOG.info("kd.wtc.wtss.formplugin.web.pc.TeamHomePCPlugin.setTeamPageRef PERIOD key:{},value:{},v:{}", new Object[]{tupleDate.getKey(), tupleDate.getValue(), value});
            }
            if (!MobileHomePageBusiness.getInstance().checkDate(true, "2", this.getView(), attStatisticQueryParam, tupleDate)) {
                return false;
            }
            this.initDayOrPeriodStatistic(attStatisticQueryParam);
            this.getView().getPageCache().put("changeNumSelect", "changeNumSelect");
            this.rankingAndChartInit(attStatisticQueryParam);
        } else if (StaTypeEnum.QUOTA == attStatisticQueryParam.getStaTypeEnum()) {
            AttStatisticsFormService.getInstance().cacheAttStatisticQueryParam(this.getPageCache(), attStatisticQueryParam);
            return this.loadQuotaStatistics(StaTypeEnum.QUOTA.getStaConfPro());
        }
        return true;
    }

    private void seeMoreRankChartInfo(StaTypeEnum staTypeEnum, String type, String number) {
        String attSourceName;
        AttStatisticQueryParam attStatisticQueryParam;
        if (StaTypeEnum.DAILY == staTypeEnum) {
            attStatisticQueryParam = this.clickRankingMore(staTypeEnum, type, number);
            DynamicObject dailyStaSource = TeamHomeServiceHelper.getInstance().getDynamicObjectByChickSourceId(attStatisticQueryParam);
            if (null == dailyStaSource) {
                return;
            }
            attSourceName = dailyStaSource.getString("name");
            String valMethod = dailyStaSource.getString("valtakmethod");
            if ("2".equals(valMethod)) {
                FormShowParameter formShowParameter = TeamHomeServiceHelper.getInstance().getTargetInfoDiaLogParameter(attStatisticQueryParam, dailyStaSource);
                this.getView().showForm(formShowParameter);
                return;
            }
        } else {
            attStatisticQueryParam = this.clickRankingMore(staTypeEnum, type, number);
            Long attSourceId = attStatisticQueryParam.getChickSourceId();
            DynamicObject perStaSource = RankingDataServiceHelper.PER_STA_SOURCE_SERVICE_HELPER.queryOne((Object)attSourceId);
            attSourceName = perStaSource.getString("name");
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("wtss_pcteamhomerank");
        OpenStyle openStyle = showParameter.getOpenStyle();
        Optional.ofNullable(openStyle).ifPresent(style -> style.setShowType(ShowType.Modal));
        showParameter.setCustomParam("homeDetailListModel", (Object)SerializationUtils.toJsonString((Object)attStatisticQueryParam));
        showParameter.setCaption(attSourceName);
        this.getView().showForm(showParameter);
    }

    private void initDayOrPeriodStatistic(AttStatisticQueryParam attStatisticQueryParam) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("initDayOrPeriodStatistic attStatisticQueryParam = {}", (Object)SerializationUtils.toJsonString((Object)attStatisticQueryParam));
        }
        List attStatisticsData = AttStatisticsFormService.getInstance().getDayOrPeriodStatisticData(attStatisticQueryParam, this.getView());
        if (LOG.isDebugEnabled()) {
            LOG.debug("initDayOrPeriodStatistic attStatisticsData = {}", (Object)attStatisticsData);
        }
        this.statisticShowTop(attStatisticsData);
    }

    private void rankingAndChartInit(AttStatisticQueryParam attStatisticQueryParam) {
        IAttStatisticsService attStatisticsService = AttStatisticsServiceHelper.getInstance().getAttStatisticsService(attStatisticQueryParam.getStaTypeEnum());
        attStatisticQueryParam.setStaCombinationConfProEnum(StaCombinationConfProEnum.ATT_RANKING);
        List attRankData = attStatisticsService.getAttRankOrChartData(attStatisticQueryParam);
        this.getView().getPageCache().put("attDataSourceRanking", SerializationUtils.toJsonString((Object)attRankData));
        RankingDataServiceHelper.initRanking((List)attRankData, (IDataModel)this.getModel(), (IFormView)this.getView());
        attStatisticQueryParam.setStaCombinationConfProEnum(StaCombinationConfProEnum.ATT_CHART);
        List attChartData = attStatisticsService.getAttRankOrChartData(attStatisticQueryParam);
        this.getView().getPageCache().put("attDataSourceChart", SerializationUtils.toJsonString((Object)attChartData));
        RankingDataServiceHelper.initChart((List)attChartData, (IFormView)this.getView());
    }

    private void statisticShowTop(List<AttDataSourceModel> showList) {
        if (!CollectionUtils.isEmpty(showList)) {
            this.getModel().deleteEntryData("entryentity");
            this.getModel().batchCreateNewEntryRow("entryentity", showList.size());
            for (int index = 0; index < showList.size(); ++index) {
                String unit = showList.get(index).getUnit();
                String attDataSourceValue = showList.get(index).getAttDataSourceValue();
                if (unit != null && attDataSourceValue != null) {
                    if (index == 0) {
                        LOG.info("setCardInfo.setCardInfo attDataSourceValue={},unit={}", (Object)attDataSourceValue, (Object)unit);
                    }
                    if ("%".equals(unit)) {
                        int length = attDataSourceValue.length() - unit.length();
                        if (attDataSourceValue.length() != 0 && attDataSourceValue.length() >= length && length >= 0) {
                            attDataSourceValue = attDataSourceValue.substring(0, length);
                        }
                    }
                }
                this.getModel().setValue("datasouname", (Object)showList.get(index).getAttDataSourceName(), index);
                if (!HRStringUtils.equalsIgnoreCase((String)unit, (String)"%")) {
                    String wrapUnit = "(" + unit + ")";
                    this.getModel().setValue("unit", (Object)wrapUnit, index);
                    this.getModel().setValue("datasouvalue", (Object)attDataSourceValue, index);
                    continue;
                }
                String wrapValue = attDataSourceValue + "%";
                this.getModel().setValue("datasouvalue", (Object)wrapValue, index);
            }
            CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
            cardEntry.setChildVisible(false, showList.size() - 1, new String[]{"cardentryflexpanelap14"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"entityflex"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"attdatanullflex"});
        } else {
            this.getModel().deleteEntryData("entryentity");
            this.getView().setVisible(Boolean.TRUE, new String[]{"attdatanullflex"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"entityflex"});
        }
    }

    private void initAttendance(Date queryDate, Set<Long> attFileBoIdSet) {
        CustomControl customcontrol = (CustomControl)this.getView().getControl("gaugepercent");
        AttendanceDataModel attendanceData = AttStatisticsFormService.getInstance().getAttendanceDataModel(queryDate, attFileBoIdSet);
        HashMap<String, String> data = new HashMap<String, String>(16);
        data.put("event", "init");
        data.put("args", (String)attendanceData);
        customcontrol.setData(data);
    }

    private void showConfigPage(IFormView view, CloseCallBack closeCallBack, String configType, String applyLayout) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId("wtss_pcteamconfig");
        HashMap<String, String> configParams = new HashMap<String, String>(3);
        AttStatisticQueryParam attStatisticQueryParam = this.getAttStatisticQueryParam();
        configParams.put("ruleid", attStatisticQueryParam.getRuleId().toString());
        String pageTypeName = "A".equals(configType) ? ResManager.loadKDString((String)"\u65e5\u7edf\u8ba1-", (String)"TeamHomePCPlugin_3", (String)"wtc-wtss-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u671f\u95f4\u7edf\u8ba1-", (String)"TeamHomePCPlugin_4", (String)"wtc-wtss-formplugin", (Object[])new Object[0]);
        if (applyLayout.equals("1")) {
            showParameter.setCaption(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u8003\u52e4\u7edf\u8ba1\u663e\u793a\u4e0e\u6392\u5e8f", (String)"TeamHomePCPlugin_5", (String)"wtc-wtss-formplugin", (Object[])new Object[0]), pageTypeName));
            configParams.put("source", "1");
        } else if (applyLayout.equals("2")) {
            showParameter.setCaption(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u6392\u884c\u699c\u663e\u793a\u4e0e\u6392\u5e8f", (String)"TeamHomePCPlugin_6", (String)"wtc-wtss-formplugin", (Object[])new Object[0]), pageTypeName));
            configParams.put("source", "2");
        } else {
            showParameter.setCaption(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u7edf\u8ba1\u56fe\u8868\u663e\u793a\u4e0e\u6392\u5e8f", (String)"TeamHomePCPlugin_7", (String)"wtc-wtss-formplugin", (Object[])new Object[0]), pageTypeName));
            configParams.put("source", "3");
        }
        configParams.put("configtype", configType);
        configParams.put("applyLayout", applyLayout);
        showParameter.setCustomParams(configParams);
        view.showForm(showParameter);
    }

    private boolean isRuleNull(StaTypeEnum staTypeEnum, Long ruleId) {
        if (ruleId == null || ruleId == 0L) {
            if (StaTypeEnum.DAILY == staTypeEnum) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u672a\u67e5\u5230\u6709\u6548\u65e5\u7edf\u8ba1\u914d\u7f6e\u3002", (String)"MobileTeamHomeFormPlugin_6", (String)"wtc-wtss-formplugin", (Object[])new Object[0]), "kdfont kdfont-Toast-jinggao", MessageTypes.ImageWithText_m, null);
            } else {
                this.getView().showMessage(ResManager.loadKDString((String)"\u672a\u67e5\u5230\u6709\u6548\u671f\u95f4\u7edf\u8ba1\u914d\u7f6e\u3002", (String)"MobileTeamHomeFormPlugin_7", (String)"wtc-wtss-formplugin", (Object[])new Object[0]), "kdfont kdfont-Toast-jinggao", MessageTypes.ImageWithText_m, null);
            }
            return true;
        }
        return false;
    }

    public AttStatisticQueryParam clickRankingMore(StaTypeEnum staTypeEnum, String type, String number) {
        AttStatisticQueryParam attStatisticQueryParam = this.getAttStatisticQueryParam();
        int entryCurrentRowIndex = "1".equals(type) ? this.getModel().getEntryCurrentRowIndex("rankingentity") : Integer.parseInt(number);
        String attDataSource = "1".equals(type) ? this.getView().getPageCache().get("attDataSourceRanking") : this.getView().getPageCache().get("attDataSourceChart");
        List attDataSourceModel = SerializationUtils.fromJsonStringToList((String)attDataSource, AttDataSourceModel.class);
        attStatisticQueryParam.setChickSourceId(((AttDataSourceModel)attDataSourceModel.get(entryCurrentRowIndex)).getAttDataSourceId());
        attStatisticQueryParam.setStaTypeEnum(staTypeEnum);
        StaCombinationConfProEnum attRanking = "1".equals(type) ? StaCombinationConfProEnum.ATT_RANKING : StaCombinationConfProEnum.ATT_CHART;
        attStatisticQueryParam.setStaCombinationConfProEnum(attRanking);
        return attStatisticQueryParam;
    }
}

