/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.formplugin.web.pc;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.mobile.MobileCommonServiceHelper;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;
import kd.wtc.wtss.business.servicehelper.mobile.MobileHomePageBusiness;
import kd.wtc.wtss.business.servicehelper.summaryconf.SummaryTeamConfigDetailService;
import kd.wtc.wtss.common.dto.mobilehome.AttDataSourceModel;

public class TeamPCConfigSettingPlugin
extends AbstractMobFormPlugin
implements RowClickEventListener {
    private static final Log LOG = LogFactory.getLog(TeamPCConfigSettingPlugin.class);

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"btndetermine"});
        this.addClickListeners(new String[]{"btncancel"});
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams != null) {
            long ruleId = this.getRuleId(customParams);
            String configType = (String)customParams.get("configtype");
            String applyLayout = (String)customParams.get("applyLayout");
            this.initStatisticConfig(ruleId, configType, applyLayout);
            DynamicObjectCollection dynObjColl = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
            for (int i = 0; i < dynObjColl.size(); ++i) {
                boolean flag = ((DynamicObject)dynObjColl.get(i)).getBoolean("showmetric");
                boolean adjFlag = ((DynamicObject)dynObjColl.get(i)).getBoolean("adjustment");
                if (!flag || adjFlag) continue;
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"showmetric"});
            }
        }
    }

    private long getRuleId(Map<String, Object> customParams) {
        if (customParams == null) {
            return 0L;
        }
        String ruleStr = customParams.get("ruleid") != null ? (String)customParams.get("ruleid") : "0";
        return Long.parseLong(ruleStr);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (HRStringUtils.equals((String)"btndetermine", (String)key)) {
            LOG.info("pcteammobilehomeconfig.click.starttime: {}}", (Object)System.currentTimeMillis());
            if (!this.checkShowmetric()) {
                return;
            }
            HashMap<String, String> returnData = new HashMap<String, String>(16);
            this.saveConfig(returnData);
            LOG.info("pcteammobilehomeconfig.click.saveConfig.endtime: {}}", (Object)System.currentTimeMillis());
            returnData.put("op", key);
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String propName = args.getProperty().getName();
        ChangeData[] changeSet = args.getChangeSet();
        if (null == changeSet || changeSet.length == 0) {
            return;
        }
        if (!this.checkShowmetric()) {
            this.getModel().setValue(propName, (Object)false, changeSet[0].getRowIndex());
            return;
        }
        if (this.getView().getPageCache().get("datachange") != null && this.getView().getPageCache().get("datachange").equals("true") && propName.equals("showmetric")) {
            if (this.getView().getPageCache().get("fieldvalue") != null && this.getView().getPageCache().get("fieldvalue").equals("true")) {
                this.getModel().setValue(propName, (Object)true, Integer.parseInt(this.getView().getPageCache().get("dataindex")));
            } else {
                this.getModel().setValue(propName, (Object)false, Integer.parseInt(this.getView().getPageCache().get("dataindex")));
            }
            this.getView().getPageCache().put("datachange", "false");
        }
    }

    private void initStatisticConfig(Long ruleId, String configType, String applyLayout) {
        Long userId = MobileCommonServiceHelper.getInstance().getUserId();
        Map staConfig = applyLayout.equals("1") ? SummaryTeamConfigDetailService.getInstance().queryTeamStaConfigList(userId.longValue(), ruleId.longValue(), "2", configType, "1") : (applyLayout.equals("2") ? SummaryTeamConfigDetailService.getInstance().queryTeamStaConfigList(userId.longValue(), ruleId.longValue(), "2", configType, "2") : SummaryTeamConfigDetailService.getInstance().queryTeamStaConfigList(userId.longValue(), ruleId.longValue(), "2", configType, "3"));
        MobileHomePageBusiness.getInstance().setTeamSchRuleCache(this.getView(), ruleId.longValue());
        List staDisCon = (List)staConfig.get("show");
        List staOthersCon = (List)staConfig.get("others");
        this.getView().getPageCache().put("cache_attshow", SerializationUtils.toJsonString((Object)staDisCon));
        this.getView().getPageCache().put("cache_attother", SerializationUtils.toJsonString((Object)staOthersCon));
        staDisCon.addAll(staOthersCon);
        this.createConfigEntry(staDisCon);
    }

    private void createConfigEntry(List<AttDataSourceModel> staDisCon) {
        IDataModel model = this.getModel();
        if (!CollectionUtils.isEmpty(staDisCon)) {
            model.batchCreateNewEntryRow("entryentity", staDisCon.size());
            for (int index = 0; index < staDisCon.size(); ++index) {
                model.setValue("indexname", (Object)staDisCon.get(index).getAttDataSourceName(), index);
                model.setValue("showmetric", (Object)staDisCon.get(index).isDisplay(), index);
                model.setValue("dataid", (Object)staDisCon.get(index).getAttDataSourceId(), index);
                model.setValue("adjustment", (Object)staDisCon.get(index).isAdjustment(), index);
            }
        }
    }

    private void saveConfig(Map<String, String> returnData) {
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        ArrayList<AttDataSourceModel> attDisConfig = new ArrayList<AttDataSourceModel>(dynamicObjectCollection.size());
        for (DynamicObject dDynamicObject : dynamicObjectCollection) {
            if (!dDynamicObject.getBoolean("showmetric")) continue;
            AttDataSourceModel attDataSourceModel = new AttDataSourceModel();
            attDataSourceModel.setAttDataSourceId(Long.valueOf(dDynamicObject.getLong("dataid")));
            attDisConfig.add(attDataSourceModel);
        }
        Long userId = MobileCommonServiceHelper.getInstance().getUserId();
        long schemeId = 0L;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        long ruleId = this.getRuleId(customParams);
        String configType = (String)customParams.get("configtype");
        String teamStaType = configType.equals("A") ? "1" : "2";
        String applyLayout = (String)customParams.get("applyLayout");
        if (applyLayout.equals("1")) {
            SummaryTeamConfigDetailService.getInstance().update(userId.longValue(), schemeId, ruleId, attDisConfig, teamStaType, "1", "2", returnData);
        } else if (applyLayout.equals("2")) {
            SummaryTeamConfigDetailService.getInstance().update(userId.longValue(), schemeId, ruleId, attDisConfig, teamStaType, "2", "2", returnData);
        } else {
            SummaryTeamConfigDetailService.getInstance().update(userId.longValue(), schemeId, ruleId, attDisConfig, teamStaType, "3", "2", returnData);
        }
    }

    private boolean checkShowmetric() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        ArrayList showList = Lists.newArrayListWithCapacity((int)10);
        for (DynamicObject dynamicObject : entryEntity) {
            String o = dynamicObject.getString("showmetric");
            if (!"true".equals(o)) continue;
            showList.add(o);
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String source = (String)customParams.get("source");
        if ("1".equals(source)) {
            if (showList.size() > 12) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u663e\u793a\u6307\u6807\u6700\u591a\u652f\u6301%s\u4e2a\u3002", (String)"TeamPCConfigSettingPlugin_3", (String)"wtc-wtss-formplugin", (Object[])new Object[]{12}));
                return false;
            }
        } else if (("2".equals(source) || "3".equals(source)) && showList.size() > 6) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u663e\u793a\u6307\u6807\u6700\u591a\u652f\u6301%s\u4e2a\u3002", (String)"TeamPCConfigSettingPlugin_3", (String)"wtc-wtss-formplugin", (Object[])new Object[]{6}));
            return false;
        }
        return true;
    }
}

