/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.formplugin.web.pc;

import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.filter.CommonBaseDataFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.IListColumn;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.model.DateRange;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtp.business.cumulate.trading.QTLineDetailDBService;
import kd.wtc.wtp.business.quota.QTLineDetailNumHelper;

public class TeamPCQuotaDetailListPlugin
extends AbstractListPlugin {
    private static final Log LOG = LogFactory.getLog(TeamPCQuotaDetailListPlugin.class);
    private static final String GEN_START_DATE = "genstartdate";
    private static final String QT_TYPE_NUMBER = "qttype.number";

    public void setFilter(SetFilterEvent event) {
        super.setFilter(event);
        QFilter qfilter = null;
        List filters = event.getQFilters();
        Iterator it = filters.iterator();
        boolean init = false;
        while (it.hasNext()) {
            Date endDate;
            QFilter filter = (QFilter)it.next();
            if (filter == null || !filter.getProperty().equals(GEN_START_DATE)) continue;
            it.remove();
            Date startDate = (Date)filter.getValue();
            Date date = endDate = WTCCollectionIndexUtil.getEleFromList((List)filter.getNests(true), (int)0).isPresent() ? (Date)((QFilter.QFilterNest)filter.getNests(true).get(0)).getFilter().getValue() : null;
            if (startDate == null || endDate == null) continue;
            init = true;
            endDate = WTCDateUtils.addDays((Date)endDate, (int)-1);
            qfilter = DateRange.range((Date)startDate, (Date)endDate).getFilterIntersectionLCRC("usestartdate", "useenddate");
        }
        if (init) {
            LOG.info("TeamPCQuotaDetailListPlugin#setFilter qfilter={}", qfilter);
            event.getQFilters().add(qfilter);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        String selectedYear = (String)this.getView().getFormShowParameter().getCustomParam("selectYear");
        Date startDate = WTCDateUtils.getBeginDayOfYear((Date)WTCDateUtils.str2Date((String)selectedYear, (String)"yyyy"));
        Date endDate = WTCDateUtils.getEndDayOfYear((Date)WTCDateUtils.str2Date((String)selectedYear, (String)"yyyy"));
        List fastFilterColumns = args.getFilterContainerInitEvent().getFastFilterColumns();
        for (int i = fastFilterColumns.size() - 1; i >= 0; --i) {
            FilterColumn filterColumn = (FilterColumn)fastFilterColumns.get(i);
            String fieldName = filterColumn.getFieldName();
            if (!"attfileid.number".equals(fieldName) && !"attfileid.name".equals(fieldName) && !"attfileid.attperson.number".equals(fieldName)) continue;
            fastFilterColumns.remove(filterColumn);
        }
        List qtTypeList = ((JSONArray)this.getView().getFormShowParameter().getCustomParam("qttype")).toJavaList(Long.class);
        LOG.info("filterContainerInit qtTypeList={}", (Object)qtTypeList);
        HRBaseServiceHelper qtTypeServiceHelper = new HRBaseServiceHelper("wtp_qttype");
        DynamicObject[] qtTypeDyArr = qtTypeServiceHelper.queryOriginalArray("id", new QFilter[]{new QFilter("id", "not in", (Object)qtTypeList)});
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        List<ComboItem> comboItems = new ArrayList();
        for (int i = filterColumnList.size() - 1; i >= 0; --i) {
            FilterColumn filterColumn = (FilterColumn)filterColumnList.get(i);
            String fieldName = filterColumn.getFieldName();
            if (GEN_START_DATE.equals(fieldName)) {
                filterColumn.setDefaultValues(new Object[]{WTCDateUtils.date2Str((Date)startDate, (String)"yyyy-MM-dd"), WTCDateUtils.date2Str((Date)endDate, (String)"yyyy-MM-dd")});
                continue;
            }
            if ("org.name".equals(fieldName)) {
                filterColumnList.remove(filterColumn);
                continue;
            }
            if (!"qttype.name".equals(fieldName)) continue;
            comboItems = ((CommonBaseDataFilterColumn)filterColumn).getComboItems();
            if (qtTypeDyArr == null || qtTypeDyArr.length <= 0) continue;
            List qtTypeIds = Arrays.stream(qtTypeDyArr).map(emp -> String.valueOf(emp.getLong("id"))).collect(Collectors.toList());
            comboItems.removeIf(next -> qtTypeIds.contains(next.getValue()));
        }
        LOG.info("filterContainerInit comboItems={}", comboItems);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"org.name"});
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        String fieldName = args.getFieldName();
        if ("qttype.name".equals(fieldName)) {
            List qtTypeList = ((JSONArray)this.getView().getFormShowParameter().getCustomParam("qttype")).toJavaList(Long.class);
            List qFilters = args.getQFilters();
            qFilters.add(new QFilter("id", "in", (Object)qtTypeList));
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if ("qttype.name".equals(fieldName)) {
            List qtTypeList = ((JSONArray)this.getView().getFormShowParameter().getCustomParam("qttype")).toJavaList(Long.class);
            List qFilters = args.getQfilters();
            qFilters.add(new QFilter("id", "in", (Object)qtTypeList));
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List listColumns = args.getListColumns();
        for (int i = listColumns.size() - 1; i >= 0; --i) {
            IListColumn listColumn = (IListColumn)listColumns.get(i);
            String listFieldKey = listColumn.getListFieldKey();
            if (!"source".equals(listFieldKey) && !"busstatus".equals(listFieldKey) && !"number".equals(listFieldKey) && !"attfileid.managingscope.name".equals(listFieldKey) && !"attfileid.adminorg.name".equals(listFieldKey) && !"attfileid.empgroup.name".equals(listFieldKey) && !"attfileid.dependency.name".equals(listFieldKey) && !"attfileid.dependencytype.name".equals(listFieldKey) && !"attfileid.agreedlocation.name".equals(listFieldKey) && !"attfileid.workplace.name".equals(listFieldKey)) continue;
            listColumns.remove(listColumn);
        }
        LOG.info("listColumns ={}", (Object)listColumns);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public void setListFields(List<ListField> listFields) {
                ListField listField = new ListField("person.boid");
                listField.setFieldName("person.boid");
                listField.setEntityName(this.getEntityType().getName());
                listFields.add(listField);
                ListField listField1 = new ListField("pastvalue");
                listField1.setFieldName("pastvalue");
                listField1.setEntityName(this.getEntityType().getName());
                listFields.add(listField1);
                ListField listField2 = new ListField("cdedvalue");
                listField2.setFieldName("cdedvalue");
                listField2.setEntityName(this.getEntityType().getName());
                listFields.add(listField2);
                super.setListFields(listFields);
            }

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                DynamicSimpleProperty number = new DynamicSimpleProperty(TeamPCQuotaDetailListPlugin.QT_TYPE_NUMBER, String.class, null);
                Set collect = rows.stream().map(ele -> ele.getLong("id")).collect(Collectors.toSet());
                DynamicObject[] query = QTLineDetailDBService.lineDetailDao.query("id,invalidvalue,settlementvalue", new QFilter("id", "in", collect).toArray());
                HashMap<Long, BigDecimal> tmp = new HashMap<Long, BigDecimal>(query.length);
                HashMap<Long, BigDecimal> cdTmp = new HashMap<Long, BigDecimal>(query.length);
                for (DynamicObject line : query) {
                    tmp.put(line.getLong("id"), line.getBigDecimal("invalidvalue"));
                    cdTmp.put(line.getLong("id"), line.getBigDecimal("settlementvalue"));
                }
                rows.getDynamicObjectType().registerSimpleProperty(number);
                for (DynamicObject row : rows) {
                    long id = row.getLong("id");
                    String num = QTLineDetailNumHelper.convertNum((Long)id);
                    row.set(TeamPCQuotaDetailListPlugin.QT_TYPE_NUMBER, (Object)num);
                    BigDecimal invalidValue = tmp.getOrDefault(id, BigDecimal.ZERO);
                    BigDecimal pastValue = row.getBigDecimal("pastvalue");
                    row.set("pastvalue", (Object)invalidValue.add(pastValue));
                    BigDecimal settlementValue = cdTmp.getOrDefault(id, BigDecimal.ZERO);
                    BigDecimal cdValue = row.getBigDecimal("cdedvalue");
                    row.set("cdedvalue", (Object)cdValue.add(settlementValue));
                }
                return rows;
            }
        });
    }
}

