/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.formplugin.web.pc;

import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.util.SerializationUtils;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.common.enums.AttitemUnitEnum;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtp.business.cumulate.trading.QTLineDetailDBService;
import kd.wtc.wtp.common.model.teamhome.TeamQuotaIndexQueryDto;
import kd.wtc.wtss.business.servicehelper.common.QuotaStatisticIndexService;
import kd.wtc.wtss.business.servicehelper.common.SchemaServiceHelper;

public class TeamQuotaStatisticsListPlugin
extends AbstractListPlugin {
    private static final String WTSS_TEAMQTLINEDETAILLIST = "wtss_teamqtlinedetaillist";

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setCaption(WTCStringUtils.joinStr((String[])new String[]{ResManager.loadKDString((String)"\u5b9a\u989d\u660e\u7ec6-", (String)"MobileTeamHomeFormPlugin_15", (String)"wtc-wtss-formplugin", (Object[])new Object[0]), this.getView().getPageCache().get("quotasource")}));
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.setBillFormId(WTSS_TEAMQTLINEDETAILLIST);
        listShowParameter.setCustomParam("selectYear", customParams.get("startdate"));
        customParams.get("affiliateadminorg");
        Map attFileAttItemDetailIdMap = (Map)SerializationUtils.fromJsonString((String)this.getView().getPageCache().get("indexIdAndQuotaDetailIdListMap"), Map.class);
        Map attFilePersonIdMap = (Map)SerializationUtils.fromJsonString((String)this.getView().getPageCache().get("attfile"), Map.class);
        if (!WTCCollectionIndexUtil.getEleFromList((List)this.getSelectedRows(), (int)0).isPresent()) {
            return;
        }
        DynamicObject[] qtLineDetailArr = QTLineDetailDBService.lineDetailDao.query("qttype", new QFilter[]{new QFilter("id", "in", attFileAttItemDetailIdMap.get(String.valueOf(this.getSelectedRows().get(0).getPrimaryKeyValue())))});
        Set qtTypeSet = Arrays.stream(qtLineDetailArr).map(dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"qttype")).collect(Collectors.toSet());
        listShowParameter.setCustomParam("qttype", qtTypeSet);
        listShowParameter.getListFilterParameter().setFilter(new QFilter("attfileid.affiliateadminorg", "in", customParams.get("affiliateadminorg")));
        listShowParameter.getListFilterParameter().setFilter(new QFilter("attfilebo.attperson.id", "in", attFilePersonIdMap.get(String.valueOf(this.getSelectedRows().get(0).getPrimaryKeyValue()))));
        listShowParameter.getListFilterParameter().setFilter(new QFilter("qttype", "in", qtTypeSet));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                Map customParams = TeamQuotaStatisticsListPlugin.this.getView().getFormShowParameter().getCustomParams();
                if (WTCCollections.isNotEmpty((Map)customParams) && customParams.containsKey("keepEmpty")) {
                    return super.getData(start, limit);
                }
                Date startDate = null;
                Date endDate = null;
                try {
                    startDate = WTCDateUtils.parseDate((String)((String)customParams.get("startdate")), (String)"yyyy-MM-dd");
                    endDate = WTCDateUtils.parseDate((String)((String)customParams.get("enddate")), (String)"yyyy-MM-dd");
                }
                catch (ParseException e) {
                    throw new KDBizException((Throwable)e, new ErrorCode("TeamQuotaStatisticsListPlugin.beforeCreateListDataProvider error", e.getMessage()), new Object[0]);
                }
                Long quotaAttItemId = (Long)customParams.get("quotaattitem");
                DynamicObject quotaAttItem = SchemaServiceHelper.getInstance().loadQuotaSource(quotaAttItemId.longValue());
                TeamQuotaStatisticsListPlugin.this.getView().getPageCache().put("quotasource", quotaAttItem.getString("name"));
                List attItemIdList = TeamQuotaStatisticsListPlugin.this.getAttItemList(customParams);
                HashMap indexIdAndAttItemIdListMap = Maps.newHashMapWithExpectedSize((int)1);
                indexIdAndAttItemIdListMap.put(quotaAttItemId, attItemIdList);
                Long[] personIdSet = (Long[])((JSONArray)customParams.get("person")).toArray((Object[])new Long[0]);
                long affiliateAdminOrgId = Long.parseLong(String.valueOf(customParams.get("affiliateadminorg")));
                DynamicObjectCollection rows = super.getData(start, limit);
                TeamQuotaIndexQueryDto dto = new TeamQuotaIndexQueryDto();
                dto.setStartDate(startDate);
                dto.setEndDate(endDate);
                dto.setPersonIdList(Arrays.asList(personIdSet));
                dto.setIndexIdAndAttItemIdListMap((Map)indexIdAndAttItemIdListMap);
                dto.setAdminOrgId(Long.valueOf(affiliateAdminOrgId));
                QuotaStatisticIndexService.getInstance().getTeamQuotaStatisticData(dto);
                Map personIdAndIndexWithValue = dto.getPersonIdAndIndexWithValue();
                Map indexIdAndQuotaDetailIdListMap = dto.getIndexIdAndQuotaDetailIdListMap();
                HashMap attFileAttItemDetailIdMap = Maps.newHashMapWithExpectedSize((int)rows.size());
                HashMap attFilePersonIdMap = Maps.newHashMapWithExpectedSize((int)rows.size());
                for (int i = 0; i < rows.size(); ++i) {
                    BigDecimal value;
                    long personId = ((DynamicObject)rows.get(i)).getLong("person_id");
                    attFilePersonIdMap.put(((DynamicObject)rows.get(i)).getLong("id"), personId);
                    Map personAttItemMap = (Map)personIdAndIndexWithValue.get(personId);
                    ((DynamicObject)rows.get(i)).set("hisversion", (Object)"0");
                    if (WTCCollections.isNotEmpty((Map)personAttItemMap) && (value = (BigDecimal)personAttItemMap.get(quotaAttItemId)) != null) {
                        String valueStr = value.setScale(3, 4).stripTrailingZeros().toPlainString();
                        ((DynamicObject)rows.get(i)).set("hisversion", (Object)valueStr);
                    }
                    ((DynamicObject)rows.get(i)).set("changedescription", (Object)AttitemUnitEnum.of((String)((String)quotaAttItem.get("unit"))).getDescription());
                    Map quotaAttItemIdMap = (Map)indexIdAndQuotaDetailIdListMap.get(personId);
                    if (!WTCCollections.isNotEmpty((Map)quotaAttItemIdMap)) continue;
                    attFileAttItemDetailIdMap.put(((DynamicObject)rows.get(i)).getLong("id"), quotaAttItemIdMap.get(quotaAttItemId));
                }
                TeamQuotaStatisticsListPlugin.this.getView().getPageCache().put("attfile", SerializationUtils.toJsonString((Object)attFilePersonIdMap));
                TeamQuotaStatisticsListPlugin.this.getView().getPageCache().put("indexIdAndQuotaDetailIdListMap", SerializationUtils.toJsonString((Object)attFileAttItemDetailIdMap));
                return rows;
            }

            public void setListFields(List<ListField> listFields) {
                ListField listField = new ListField("person.boid");
                listField.setFieldName("person.boid");
                listField.setEntityName(this.getEntityType().getName());
                listFields.add(listField);
                super.setListFields(listFields);
            }
        });
    }

    private List<Long> getAttItemList(Map<String, Object> customParams) {
        Long quotaAttItemId = (Long)customParams.get("quotaattitem");
        DynamicObject quotaAttItem = SchemaServiceHelper.getInstance().loadQuotaSource(quotaAttItemId.longValue());
        return quotaAttItem.getDynamicObjectCollection("entryentity").stream().map(dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"attitem")).collect(Collectors.toList());
    }
}

