/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.common.dto;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.wtc.wtbs.common.MultiLangEnumBridge;
import kd.wtc.wtbs.common.enums.bill.BillTypeEnum;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;

public class DailySource
implements Serializable {
    private static final long serialVersionUID = -366635097951878002L;
    private static Map<String, MultiLangEnumBridge> busClassifyMap = Maps.newHashMapWithExpectedSize((int)4);
    private static Map<String, MultiLangEnumBridge> dataTypeMap;
    private static Map<String, MultiLangEnumBridge> unitMap;
    private static Map<String, Integer> SORT_MAP;
    private String busClassify;
    private String busClassifyType;
    private String datasoureName;
    private String datasoureUnit;
    private long datasoureId;
    private boolean adjustment;
    private boolean display;
    private String datasoureValue;
    private String busClassifyNo;
    private int index;
    private List<AttItem> attItems;

    public DailySource() {
    }

    public DailySource(DynamicObject dailySource, DynamicObject attItem, String itemValue) {
        this.busClassify = busClassifyMap.get(dailySource.getString("busclassify")) != null ? busClassifyMap.get(dailySource.getString("busclassify")).loadKDString() : "";
        this.busClassifyType = dailySource.getString("busclassify");
        this.datasoureName = dailySource.getString("name");
        this.datasoureUnit = dailySource.getString("unit");
        this.busClassifyNo = dailySource.getString("busclassify");
        this.datasoureId = dailySource.getLong("id");
        this.index = SORT_MAP.get(this.busClassifyNo);
        this.setAttItemForExist(dailySource, attItem, itemValue);
    }

    public boolean isAdjustment() {
        return this.adjustment;
    }

    public void setAdjustment(boolean adjustment) {
        this.adjustment = adjustment;
    }

    public boolean isDisplay() {
        return this.display;
    }

    public void setDisplay(boolean display) {
        this.display = display;
    }

    public long getDatasoureId() {
        return this.datasoureId;
    }

    public void setDatasoureId(Long datasoureId) {
        this.datasoureId = datasoureId;
    }

    public String getDatasoureName() {
        return this.datasoureName;
    }

    public void setDatasoureName(String datasoureName) {
        this.datasoureName = datasoureName;
    }

    public String getDatasoureUnit() {
        return this.datasoureUnit;
    }

    public void setDatasoureUnit(String datasoureUnit) {
        this.datasoureUnit = datasoureUnit;
    }

    public List<AttItem> getAttItems() {
        return this.attItems;
    }

    public String getDatasoureValue() {
        return this.datasoureValue;
    }

    public void setDatasoureValue(String datasoureValue) {
        this.datasoureValue = datasoureValue;
    }

    public void setAttItems(List<AttItem> attItems) {
        this.attItems = attItems;
    }

    public String getBusClassify() {
        return this.busClassify;
    }

    public void setBusClassify(String busClassify) {
        this.busClassify = busClassify;
    }

    public String getBusClassifyType() {
        return this.busClassifyType;
    }

    public void setBusClassifyType(String busClassifyType) {
        this.busClassifyType = busClassifyType;
    }

    public String getBusClassifyNo() {
        return this.busClassifyNo;
    }

    public void setBusClassifyNo(String busClassifyNo) {
        this.busClassifyNo = busClassifyNo;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public final void setAttItemForExist(DynamicObject dailySource, DynamicObject attItem, String value) {
        AttItem item = new AttItem(dailySource);
        item.setAttItemId(attItem.getLong("id"));
        item.setAttItemName(attItem.getString("name"));
        item.setAttItemValue(new BigDecimal(value).stripTrailingZeros());
        if (CollectionUtils.isEmpty(this.attItems)) {
            ArrayList<AttItem> attItems = new ArrayList<AttItem>(10);
            attItems.add(item);
            this.attItems = attItems;
        } else {
            this.attItems.add(item);
        }
    }

    public String toString() {
        return "DailySource{busClassify='" + this.busClassify + '\'' + "busClassifyType='" + this.busClassifyType + '\'' + ", busClassifyNo='" + this.busClassifyNo + '\'' + ", attItems=" + this.attItems + '}';
    }

    static {
        busClassifyMap.put("1", new MultiLangEnumBridge("\u5f02\u5e38", "DailySource_0", "wtc-wtss-common"));
        busClassifyMap.put("2", new MultiLangEnumBridge("\u4f11\u5047", "DailySource_1", "wtc-wtss-common"));
        busClassifyMap.put("4", new MultiLangEnumBridge("{0}", "DailySource_3", "wtc-wtss-common", new Object[]{BillTypeEnum.EVECTIONBILL}));
        busClassifyMap.put("3", new MultiLangEnumBridge("\u52a0\u73ed", "DailySource_2", "wtc-wtss-common"));
        busClassifyMap.put("5", new MultiLangEnumBridge("\u51fa\u52e4", "DailySource_4", "wtc-wtss-common"));
        dataTypeMap = Maps.newHashMapWithExpectedSize((int)4);
        dataTypeMap.put("0", new MultiLangEnumBridge("\u6b21\u6570", "DailySource_5", "wtc-wtss-common"));
        dataTypeMap.put("1", new MultiLangEnumBridge("\u65f6\u957f", "DailySource_6", "wtc-wtss-common"));
        unitMap = Maps.newHashMapWithExpectedSize((int)4);
        unitMap.put("day", new MultiLangEnumBridge("\u5929", "DailySource_7", "wtc-wtss-common"));
        unitMap.put("hour", new MultiLangEnumBridge("\u5c0f\u65f6", "DailySource_8", "wtc-wtss-common"));
        unitMap.put("minute", new MultiLangEnumBridge("\u5206\u949f", "DailySource_9", "wtc-wtss-common"));
        unitMap.put("second", new MultiLangEnumBridge("\u79d2", "DailySource_10", "wtc-wtss-common"));
        unitMap.put("time", new MultiLangEnumBridge("\u6b21", "DailySource_11", "wtc-wtss-common"));
        SORT_MAP = Maps.newHashMapWithExpectedSize((int)4);
        SORT_MAP.put("2", 0);
        SORT_MAP.put("4", 10);
        SORT_MAP.put("3", 20);
        SORT_MAP.put("1", 30);
        SORT_MAP.put("5", 40);
    }

    public static class AttItem
    implements Serializable {
        private static final long serialVersionUID = 345336690497476107L;
        private long attItemId;
        private String attItemName;
        private BigDecimal attItemValue;
        private String dataType;
        private String unit;

        public AttItem(DynamicObject dailySource) {
            this.dataType = dataTypeMap.get(dailySource.getString("datatype")) != null ? ((MultiLangEnumBridge)dataTypeMap.get(dailySource.getString("datatype"))).loadKDString() : "";
            this.unit = unitMap.get(dailySource.getString("unit")) != null ? ((MultiLangEnumBridge)unitMap.get(dailySource.getString("unit"))).loadKDString() : "";
        }

        public AttItem() {
        }

        public String getDataType() {
            return this.dataType;
        }

        public void setDataType(String dataType) {
            this.dataType = dataType;
        }

        public String getUnit() {
            return this.unit;
        }

        public void setUnit(String unit) {
            this.unit = unit;
        }

        public long getAttItemId() {
            return this.attItemId;
        }

        public void setAttItemId(long attItemId) {
            this.attItemId = attItemId;
        }

        public String getAttItemName() {
            return this.attItemName;
        }

        public void setAttItemName(String attItemName) {
            this.attItemName = attItemName;
        }

        public BigDecimal getAttItemValue() {
            return this.attItemValue;
        }

        public void setAttItemValue(BigDecimal attItemValue) {
            this.attItemValue = attItemValue;
        }

        public String toString() {
            return "AttItem{attItemId=" + this.attItemId + ", attItemName='" + this.attItemName + '\'' + ", attItemValue=" + this.attItemValue + ", dataType='" + this.dataType + '\'' + ", unit='" + this.unit + '\'' + '}';
        }
    }
}

