/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.common.dto;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.util.ArrayUtils;
import kd.wtc.wtss.common.constants.MobileConfConstants;

public class MobileHomeConf
implements Serializable {
    private static final long serialVersionUID = -1940142642330148260L;
    private List<BillType> billTypes;
    private List<CommProblem> problems;
    private boolean showProblem;

    public MobileHomeConf() {
    }

    public MobileHomeConf(DynamicObject mobileRule, DynamicObject[] commPros) {
        MobileConfConstants.BillTypes[] values;
        if (HRObjectUtils.isEmpty((Object)mobileRule)) {
            return;
        }
        String bills = mobileRule.getString("selectedbill");
        String[] split = bills.split(",");
        List billTypes = Arrays.stream(split).filter(HRStringUtils::isNotEmpty).collect(Collectors.toList());
        this.billTypes = Lists.newArrayListWithExpectedSize((int)billTypes.size());
        for (MobileConfConstants.BillTypes value : values = MobileConfConstants.BillTypes.values()) {
            if (!billTypes.contains(value.getType())) continue;
            BillType billType = new BillType();
            billType.setBillType(value.getType());
            billType.setBillName(value.getMultiLang().loadKDString());
            billType.setEntityId(value.getEntityId());
            this.billTypes.add(billType);
        }
        this.showProblem = mobileRule.getBoolean("showproblem");
        if (ArrayUtils.isEmpty((Object[])commPros)) {
            return;
        }
        ArrayList commProblemList = Lists.newArrayListWithExpectedSize((int)commPros.length);
        for (int i = 0; i < commPros.length; ++i) {
            DynamicObject dyProblem = commPros[i];
            CommProblem commProblem = new CommProblem();
            commProblem.setId(dyProblem.getLong("id"));
            commProblem.setIndex(dyProblem.getInt("index"));
            commProblem.setProblem(dyProblem.getString("question"));
            commProblem.setAnswer(dyProblem.getString("answer_tag"));
            commProblem.setModifyTime(dyProblem.getDate("modifytime"));
            commProblemList.add(commProblem);
        }
        this.problems = commProblemList;
    }

    public MobileHomeConf(DynamicObject mobileRule) {
        MobileConfConstants.BillTypes[] values;
        if (HRObjectUtils.isEmpty((Object)mobileRule)) {
            return;
        }
        String bills = mobileRule.getString("selectedbill");
        String[] split = bills.split(",");
        List billTypes = Arrays.stream(split).filter(HRStringUtils::isNotEmpty).collect(Collectors.toList());
        this.billTypes = Lists.newArrayListWithExpectedSize((int)billTypes.size());
        for (MobileConfConstants.BillTypes value : values = MobileConfConstants.BillTypes.values()) {
            if (!billTypes.contains(value.getType())) continue;
            BillType billType = new BillType();
            billType.setBillType(value.getType());
            billType.setBillName(value.getMultiLang().loadKDString());
            billType.setEntityId(value.getEntityId());
            this.billTypes.add(billType);
        }
    }

    public boolean isShowProblem() {
        return this.showProblem;
    }

    public void setShowProblem(boolean showProblem) {
        this.showProblem = showProblem;
    }

    public List<CommProblem> getProblems() {
        return this.problems;
    }

    public void setProblems(List<CommProblem> problems) {
        this.problems = problems;
    }

    public List<BillType> getBillTypes() {
        return this.billTypes;
    }

    public void setBillTypes(List<BillType> billTypes) {
        this.billTypes = billTypes;
    }

    public static class BillType
    implements Serializable {
        private static final long serialVersionUID = 1459353692063684824L;
        private String billName;
        private String entityId;
        private String billType;

        public String getBillName() {
            return this.billName;
        }

        public void setBillName(String billName) {
            this.billName = billName;
        }

        public String getEntityId() {
            return this.entityId;
        }

        public void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        public String getBillType() {
            return this.billType;
        }

        public void setBillType(String billType) {
            this.billType = billType;
        }
    }

    public static class CommProblem
    implements Serializable {
        private static final long serialVersionUID = 1459353692063684824L;
        private long id;
        private int index;
        private String problem;
        private String answer;
        private Date modifyTime;

        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public String getProblem() {
            return this.problem;
        }

        public void setProblem(String problem) {
            this.problem = problem;
        }

        public String getAnswer() {
            return this.answer;
        }

        public void setAnswer(String answer) {
            this.answer = answer;
        }

        public Date getModifyTime() {
            return this.modifyTime;
        }

        public void setModifyTime(Date modifyTime) {
            this.modifyTime = modifyTime;
        }
    }
}

