/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.common.dto.mobilehome;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.wtc.wtss.common.dto.mobilehome.AbnormalDealMethodModel;
import kd.wtc.wtss.common.enums.ExTypeIdMappingEnum;

public class ExRecordModel {
    private String exType;
    private String exTypeStr;
    private List<AbnormalDealMethodModel> dealMethod;
    private String shiftCard;
    private String punchCardPoint;
    private String exProcess;
    private String filterType;

    public ExRecordModel(Map<String, String> exInfo, Boolean isCanDealAbnormal) {
        this.punchCardPoint = exInfo.get("punchcardPoint");
        this.exType = exInfo.get("exType");
        if (this.exType != null) {
            this.exTypeStr = ExTypeIdMappingEnum.getDesc(this.exType);
        }
        this.filterType = exInfo.get("filtertype");
        this.shiftCard = exInfo.get("shiftcard");
        this.exProcess = exInfo.get("exProcess");
        if (isCanDealAbnormal.booleanValue()) {
            this.setExDealMethod();
        }
    }

    private void setExDealMethod() {
        if (StringUtils.isEmpty((CharSequence)this.exProcess)) {
            return;
        }
        String[] split = StringUtils.split((String)this.exProcess, (String)",");
        ArrayList<AbnormalDealMethodModel> abnormalDealMethods = new ArrayList<AbnormalDealMethodModel>(split.length);
        for (String process : split) {
            AbnormalDealMethodModel abnormalDealMethodModel = new AbnormalDealMethodModel();
            abnormalDealMethodModel.setAbnormalMethodMethod(process);
            abnormalDealMethods.add(abnormalDealMethodModel);
        }
        this.setDealMethod(abnormalDealMethods);
    }

    public String getExType() {
        return this.exType;
    }

    public void setExType(String exType) {
        this.exType = exType;
    }

    public String getExTypeStr() {
        return this.exTypeStr;
    }

    public void setExTypeStr(String exTypeStr) {
        this.exTypeStr = exTypeStr;
    }

    public List<AbnormalDealMethodModel> getDealMethod() {
        return this.dealMethod;
    }

    public void setDealMethod(List<AbnormalDealMethodModel> dealMethod) {
        this.dealMethod = dealMethod;
    }

    public String getShiftCard() {
        return this.shiftCard;
    }

    public void setShiftCard(String shiftCard) {
        this.shiftCard = shiftCard;
    }

    public String getPunchCardPoint() {
        return this.punchCardPoint;
    }

    public void setPunchCardPoint(String punchCardPoint) {
        this.punchCardPoint = punchCardPoint;
    }

    public String getExProcess() {
        return this.exProcess;
    }

    public String getFilterType() {
        return this.filterType;
    }

    public void setFilterType(String filterType) {
        this.filterType = filterType;
    }
}

