/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.business.attstatistics;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.util.Pair;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.sdk.wtc.wtss.business.teamhome.AttStatisticTargetQueryParam;
import kd.sdk.wtc.wtss.business.teamhome.AttTargetQueryExpandService;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtss.business.attstatistics.AttStatisticsServiceHelper;
import kd.wtc.wtss.business.attstatistics.AttStatisticsTargetServiceHelper;
import kd.wtc.wtss.business.attstatistics.IAttStatisticsService;
import kd.wtc.wtss.business.attstatistics.IAttTargetQueryService;
import kd.wtc.wtss.common.dto.mobilehome.AttDataSourceModel;
import kd.wtc.wtss.common.dto.mobilehome.AttDataSourceModelConfigData;
import kd.wtc.wtss.common.dto.mobilehome.AttStatisticQueryParam;
import kd.wtc.wtss.common.enums.attstatistics.StaCombinationConfProEnum;
import kd.wtc.wtss.common.enums.attstatistics.StaCombinationTerminal;
import kd.wtc.wtss.common.enums.attstatistics.StaTypeEnum;

public abstract class AbstractTeamAttStatisticsService
implements IAttStatisticsService {
    public static String TARGET_QUERY_EXP_SERVICE = "kd.sdk.wtc.wtss.business.teamhome.AttTargetQueryExpandService";
    private static final int SHOW_RANK_COUNT = 20;

    protected int getShowRankCount(Integer showCount) {
        if (showCount == null) {
            return 20;
        }
        if (showCount == 0) {
            return Integer.MAX_VALUE;
        }
        return showCount;
    }

    public AttDataSourceModelConfigData queryAttDataSourceModel(long userId, long ruleId, StaTypeEnum staTypeEnum, StaCombinationConfProEnum staCombinationConfProEnum, boolean loadConfig, StaCombinationTerminal staCombinationTerminal) {
        AttDataSourceModelConfigData attDataSourceModelConfigData = AttStatisticsServiceHelper.getInstance().queryAttDataSourceModel(userId, ruleId, staTypeEnum, staCombinationConfProEnum, loadConfig, staCombinationTerminal);
        if (attDataSourceModelConfigData != null && WTCCollections.isNotEmpty((Collection)attDataSourceModelConfigData.getShowList())) {
            for (AttDataSourceModel attDataSourceModel : attDataSourceModelConfigData.getShowList()) {
                if (attDataSourceModel.getUnit() != null) continue;
                attDataSourceModel.setUnit("");
            }
        }
        return attDataSourceModelConfigData;
    }

    protected void handlerAttStatisticsData(StaCombinationTerminal staCombinationTerminal, Set<Long> attFileBoIds, List<AttDataSourceModel> showList, List<AttDataSourceModel> attStatisticsData) {
        AttStatisticsServiceHelper.getInstance().handlerAttStatisticsDataPlus(staCombinationTerminal, attFileBoIds, showList, attStatisticsData);
    }

    protected void handlerAttRankData(List<AttDataSourceModel> showList, long affiliateAdminOrgId, Date chooseStartDate, Date chooseEndDate, Map<Long, Long> staticsFileBoIdMap, int showCount, Map<Long, Map<Long, Double>> attItemDetailMap, Map<Long, Set<Long>> sourceToItemsSetMap, DynamicObject[] dailySources) {
        AttStatisticsServiceHelper.getInstance().handlerAttRankData(showList, affiliateAdminOrgId, chooseStartDate, chooseEndDate, staticsFileBoIdMap, showCount, attItemDetailMap, sourceToItemsSetMap, dailySources);
    }

    protected void calcChartKpiData(Map<Long, Map<Long, Double>> attItemDetailMap, AttStatisticQueryParam attStatisticQueryParam, DynamicObject[] dailySources) {
        HashMap attTargetDetailMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject dailySourceDy : dailySources) {
            if (!AttStatisticsTargetServiceHelper.getInstance().beConfigTarget(dailySourceDy)) continue;
            Map<Long, Double> targetChartData = null;
            long kpiId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dailySourceDy, (String)"teamhomekpi");
            HRPluginProxy pluginProxy = HRPlugInProxyFactory.create(null, AttTargetQueryExpandService.class, (String)TARGET_QUERY_EXP_SERVICE, null);
            List expendData = pluginProxy.callReplace(expandService -> expandService.getTargetChartData((AttStatisticTargetQueryParam)attStatisticQueryParam, Long.valueOf(kpiId)));
            if (WTCCollections.isEmpty((Collection)expendData)) {
                IAttTargetQueryService attTargetQueryService = AttStatisticsTargetServiceHelper.getInstance().getAttTargetQueryService(kpiId);
                if (attTargetQueryService != null) {
                    targetChartData = attTargetQueryService.getTargetChartData((AttStatisticTargetQueryParam)attStatisticQueryParam, kpiId);
                }
            } else {
                Map map = (Map)expendData.get(0);
                if (HRMapUtils.isEmpty((Map)map)) {
                    IAttTargetQueryService attTargetQueryService = AttStatisticsTargetServiceHelper.getInstance().getAttTargetQueryService(kpiId);
                    if (attTargetQueryService != null) {
                        targetChartData = attTargetQueryService.getTargetChartData((AttStatisticTargetQueryParam)attStatisticQueryParam, kpiId);
                    }
                } else {
                    targetChartData = (Map<Long, Double>)expendData.get(0);
                }
            }
            if (targetChartData == null) continue;
            for (Map.Entry entries : targetChartData.entrySet()) {
                Map targetMap = attTargetDetailMap.computeIfAbsent(entries.getKey(), key -> Maps.newHashMapWithExpectedSize((int)1));
                targetMap.put(kpiId, entries.getValue());
            }
        }
        for (Map.Entry entry : attTargetDetailMap.entrySet()) {
            Map<Long, Double> existData = attItemDetailMap.get(entry.getKey());
            if (existData != null) {
                Map value = (Map)entry.getValue();
                if (!WTCCollections.isNotEmpty((Map)value)) continue;
                existData.putAll(value);
                continue;
            }
            attItemDetailMap.put((Long)entry.getKey(), (Map<Long, Double>)entry.getValue());
        }
    }

    protected void calcStatisticsKpiData(AttStatisticQueryParam attStatisticQueryParam, DynamicObject[] dailySources, List<AttDataSourceModel> attDataSourceModels) {
        Map dailySourceMap = Arrays.stream(dailySources).collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity(), (v1, v2) -> v2));
        for (AttDataSourceModel attDataSourceModel : attDataSourceModels) {
            DynamicObject daySourceDy = (DynamicObject)dailySourceMap.get(attDataSourceModel.getAttDataSourceId());
            if (!AttStatisticsTargetServiceHelper.getInstance().beConfigTarget(daySourceDy)) continue;
            long kpiId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)daySourceDy, (String)"teamhomekpi");
            Pair<String, String> targetStatisticsData = null;
            HRPluginProxy pluginProxy = HRPlugInProxyFactory.create(null, AttTargetQueryExpandService.class, (String)TARGET_QUERY_EXP_SERVICE, null);
            List pairs = pluginProxy.callReplace(expandService -> expandService.getTargetStatisticsData((AttStatisticTargetQueryParam)attStatisticQueryParam, Long.valueOf(kpiId)));
            if (WTCCollections.isEmpty((Collection)pairs)) {
                IAttTargetQueryService attTargetQueryService = AttStatisticsTargetServiceHelper.getInstance().getAttTargetQueryService(kpiId);
                if (attTargetQueryService != null) {
                    targetStatisticsData = attTargetQueryService.getTargetStatisticsData((AttStatisticTargetQueryParam)attStatisticQueryParam, kpiId);
                }
            } else {
                Pair pair = (Pair)pairs.get(0);
                if (null == pair) {
                    IAttTargetQueryService attTargetQueryService = AttStatisticsTargetServiceHelper.getInstance().getAttTargetQueryService(kpiId);
                    if (attTargetQueryService != null) {
                        targetStatisticsData = attTargetQueryService.getTargetStatisticsData((AttStatisticTargetQueryParam)attStatisticQueryParam, kpiId);
                    }
                } else {
                    targetStatisticsData = (Pair<String, String>)pairs.get(0);
                }
            }
            if (targetStatisticsData == null) continue;
            attDataSourceModel.setAttDataSourceValue((String)targetStatisticsData.getKey());
            attDataSourceModel.setUnit((String)targetStatisticsData.getValue());
        }
    }
}

