/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.business.attstatistics;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtp.business.attconfirm.AttConfirmHelper;
import kd.wtc.wtp.business.attconfirm.impl.AttConfirmQueryServiceImpl;
import kd.wtc.wtp.common.enums.attconfirm.AttConRecordStatusEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConRecordTypeEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConfirmDataStatusEnum;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordModel;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordQueryParam;

public class AttConfirmServiceHelper {
    private static final Log LOG = LogFactory.getLog(AttConfirmServiceHelper.class);
    private static final Set<AttConRecordStatusEnum> statusEnums = new HashSet<AttConRecordStatusEnum>();
    private static AttConfirmServiceHelper INSTANCE;

    private AttConfirmServiceHelper() {
    }

    public static AttConfirmServiceHelper instance() {
        return INSTANCE;
    }

    public AttConfirmRecordModel getAttConfirmWithPeriodId(Long perAttPeriodId) {
        if (perAttPeriodId == null || perAttPeriodId == 0L) {
            return null;
        }
        AttConfirmRecordQueryParam queryParam = new AttConfirmRecordQueryParam();
        queryParam.setPerAttPeriodIdSet(Collections.singleton(perAttPeriodId));
        queryParam.setType(AttConRecordTypeEnum.BY_PERIOD);
        queryParam.setStatus(statusEnums);
        List queryAttConfirmRecords = AttConfirmQueryServiceImpl.getInstance().queryAttConfirmRecordModelList(queryParam);
        if (WTCCollections.isEmpty((Collection)queryAttConfirmRecords)) {
            return null;
        }
        Optional<AttConfirmRecordModel> attConfirmRecord = queryAttConfirmRecords.stream().filter(record -> perAttPeriodId.equals(record.getPerAttPeriod())).findFirst();
        return attConfirmRecord.get();
    }

    @Deprecated
    public AttConfirmRecordModel getAttConfirmWithDate(Long attFileBoId, Date date) {
        if (date == null || attFileBoId == null || attFileBoId == 0L) {
            return null;
        }
        AttConfirmRecordQueryParam queryParam = new AttConfirmRecordQueryParam();
        queryParam.setType(AttConRecordTypeEnum.BY_DATE);
        queryParam.setAttFileBoIdSet(Collections.singleton(attFileBoId));
        queryParam.setStartDate(date);
        queryParam.setEndDate(date);
        queryParam.setStatus(statusEnums);
        List queryAttConfirmRecords = AttConfirmQueryServiceImpl.getInstance().queryAttConfirmRecordModelList(queryParam);
        if (WTCCollections.isEmpty((Collection)queryAttConfirmRecords)) {
            return null;
        }
        Optional<AttConfirmRecordModel> attConfirmRecord = queryAttConfirmRecords.stream().filter(record -> date.compareTo(record.getStartDate()) == 0 && date.compareTo(record.getEndDate()) == 0).findFirst();
        return attConfirmRecord.get();
    }

    public AttConfirmRecordModel getAttConfirmWithDate(Set<Long> attFileBoIdSet, Date date) {
        if (date == null || WTCCollections.isEmpty(attFileBoIdSet)) {
            return null;
        }
        AttConfirmRecordQueryParam queryParam = new AttConfirmRecordQueryParam();
        queryParam.setType(AttConRecordTypeEnum.BY_DATE);
        queryParam.setAttFileBoIdSet(attFileBoIdSet);
        queryParam.setStartDate(date);
        queryParam.setEndDate(date);
        queryParam.setStatus(statusEnums);
        queryParam.setQueryNotEffect(true);
        queryParam.setCustomQFilter(new QFilter("datastatus", "in", Arrays.asList(AttConfirmDataStatusEnum.EFFECT.getCode(), AttConfirmDataStatusEnum.INVALID.getCode())));
        List queryAttConfirmRecords = AttConfirmQueryServiceImpl.getInstance().queryAttConfirmRecordModelList(queryParam);
        if (WTCCollections.isEmpty((Collection)queryAttConfirmRecords)) {
            return null;
        }
        AttConfirmRecordModel resultModel = queryAttConfirmRecords.size() > 1 ? queryAttConfirmRecords.stream().max(Comparator.comparing(AttConfirmRecordModel::getCreateTime)).get() : (AttConfirmRecordModel)queryAttConfirmRecords.get(0);
        return resultModel;
    }

    public DynamicObject loadAttConfirmBillDyWithAttConfId(Long attConfirmRecordId) {
        if (attConfirmRecordId == null || attConfirmRecordId == 0L) {
            return null;
        }
        AttConfirmRecordQueryParam queryParam = new AttConfirmRecordQueryParam();
        queryParam.setIds(Collections.singleton(attConfirmRecordId));
        queryParam.setQueryNotEffect(true);
        List queryAttConfirmRecords = AttConfirmQueryServiceImpl.getInstance().queryAttConfirmRecordModelList(queryParam);
        if (WTCCollections.isEmpty((Collection)queryAttConfirmRecords)) {
            return null;
        }
        AttConfirmRecordModel recordModel = (AttConfirmRecordModel)queryAttConfirmRecords.get(0);
        if (recordModel == null) {
            return null;
        }
        DynamicObject attConfirmDy = null;
        List attConfirmDys = AttConfirmHelper.getInstance().genAttConfirmBillHisData(Collections.singletonList(recordModel), false);
        if (WTCCollections.isNotEmpty((Collection)attConfirmDys)) {
            attConfirmDy = (DynamicObject)attConfirmDys.get(0);
        }
        return attConfirmDy;
    }

    public void updateBtnAttConfirmVisible(IFormView view) {
        String perAttPeriodIdStr = view.getPageCache().get("PerAttId");
        Long attConfirmRecordId = 0L;
        if (!WTCStringUtils.isEmpty((String)perAttPeriodIdStr)) {
            AttConfirmRecordModel queryAttConfirmRecord = this.getAttConfirmWithPeriodId(Long.valueOf(perAttPeriodIdStr));
            view.setVisible(Boolean.valueOf(queryAttConfirmRecord != null), new String[]{"btn_attcon"});
            if (queryAttConfirmRecord != null) {
                attConfirmRecordId = queryAttConfirmRecord.getId();
                AttConRecordStatusEnum status = queryAttConfirmRecord.getStatus();
                Label btnAttConf = (Label)view.getControl("btn_attcon");
                btnAttConf.setText(ResManager.loadKDString((String)"\u8003\u52e4\u786e\u8ba4", (String)"AttConfirmServiceHelper_0", (String)"wtc-wtss-business", (Object[])new Object[0]));
                if (AttConRecordStatusEnum.CONFIRM.equals((Object)status)) {
                    btnAttConf.setText(ResManager.loadKDString((String)"\u67e5\u770b\u786e\u8ba4\u8bb0\u5f55", (String)"AttConfirmServiceHelper_1", (String)"wtc-wtss-business", (Object[])new Object[0]));
                } else if (AttConRecordStatusEnum.REVOKE.equals((Object)status) || AttConRecordStatusEnum.GEN.equals((Object)status)) {
                    view.setVisible(Boolean.valueOf(false), new String[]{"btn_attcon"});
                }
                LOG.warn("AttConfirmServiceHelper.updateBtnAttConfirmVisible.perAttPeriodIdStr:{},attConfirmId:{},confStatus:{}", new Object[]{perAttPeriodIdStr, attConfirmRecordId, status});
            }
        }
        view.getPageCache().put("attConfirmId", String.valueOf(attConfirmRecordId));
    }

    static {
        statusEnums.add(AttConRecordStatusEnum.SEND);
        statusEnums.add(AttConRecordStatusEnum.CONFIRM);
        statusEnums.add(AttConRecordStatusEnum.NOT_CONFIRM);
        INSTANCE = new AttConfirmServiceHelper();
    }
}

