/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.business.attstatistics;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.wtc.wtss.business.teamhome.AfterInitAttStatisticAdminOrgEvent;
import kd.sdk.wtc.wtss.business.teamhome.AttStatisticAdminOrgParam;
import kd.sdk.wtc.wtss.business.teamhome.AttStatisticQueryExtPlugin;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxyFactory;
import kd.wtc.wtbs.business.mobile.MobileCommonServiceHelper;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;
import kd.wtc.wtp.business.mobile.TeamHomeHelper;
import kd.wtc.wtss.business.attstatistics.AttStatisticsServiceHelper;
import kd.wtc.wtss.business.attstatistics.IAttStatisticsService;
import kd.wtc.wtss.business.servicehelper.mobile.MobileHomePageBusiness;
import kd.wtc.wtss.business.servicehelper.mobile.MobileTeamHomeBusiness;
import kd.wtc.wtss.common.constants.team.target.TargetConst;
import kd.wtc.wtss.common.dto.mobilehome.AttDataSourceDetailsModel;
import kd.wtc.wtss.common.dto.mobilehome.AttDataSourceModel;
import kd.wtc.wtss.common.dto.mobilehome.AttStatisticQueryParam;
import kd.wtc.wtss.common.dto.mobilehome.AttendanceDataModel;
import kd.wtc.wtss.common.enums.attstatistics.StaCombinationConfProEnum;
import kd.wtc.wtss.common.enums.attstatistics.StaCombinationTerminal;
import kd.wtc.wtss.common.enums.attstatistics.StaTypeEnum;
import kd.wtc.wtss.common.utils.WTSSDateUtils;

public class AttStatisticsFormService {
    private static final Log LOG = LogFactory.getLog(AttStatisticsFormService.class);
    public static final String CACHE_STA_QUERY_PARAM = "cache_sta_query_param";

    public static AttStatisticsFormService getInstance() {
        return (AttStatisticsFormService)WTCAppContextHelper.getBean(AttStatisticsFormService.class);
    }

    public void cacheAttStatisticQueryParam(IPageCache pageCache, AttStatisticQueryParam attStatisticQueryParam) {
        AttStatisticsServiceHelper.getInstance().getAndSetStaticsFileBoIdMap(attStatisticQueryParam);
        Set<Long> periodEntryIdSet = AttStatisticsServiceHelper.getInstance().getPeriodEntryIdSet(attStatisticQueryParam.getQueryStartDate(), attStatisticQueryParam.getQueryEndDate(), attStatisticQueryParam.getAttFileMap().keySet());
        attStatisticQueryParam.setPeriodEntrySet(periodEntryIdSet);
        String cacheQueryParamStr = SerializationUtils.toJsonString((Object)attStatisticQueryParam);
        if (LOG.isDebugEnabled()) {
            LOG.debug("cacheAttStatisticQueryParam {}", (Object)cacheQueryParamStr);
        }
        pageCache.put(CACHE_STA_QUERY_PARAM, cacheQueryParamStr);
    }

    public AttStatisticQueryParam getCacheAttStatisticQueryParam(IPageCache pageCache) {
        String cacheStr = pageCache.get(CACHE_STA_QUERY_PARAM);
        if (HRStringUtils.isNotEmpty((String)cacheStr)) {
            return (AttStatisticQueryParam)SerializationUtils.fromJsonString((String)cacheStr, AttStatisticQueryParam.class);
        }
        return null;
    }

    public AttStatisticQueryParam getCacheAttStatisticQueryParamEx(IPageCache pageCache) {
        AttStatisticQueryParam cacheAttStatisticQueryParam = this.getCacheAttStatisticQueryParam(pageCache);
        if (cacheAttStatisticQueryParam == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u53d8\u66f4\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"AttStatisticsFormService_0", (String)"wtc-wtss-business", (Object[])new Object[0]));
        }
        return cacheAttStatisticQueryParam;
    }

    public AttStatisticQueryParam getCacheAttStatisticQueryParam(IFormView iFormView, StaCombinationTerminal staCombinationTerminal) {
        AttStatisticQueryParam cacheAttStatisticQueryParam = this.getCacheAttStatisticQueryParam(iFormView.getPageCache());
        if (cacheAttStatisticQueryParam != null) {
            return cacheAttStatisticQueryParam;
        }
        Long personId = MobileCommonServiceHelper.getInstance().getUserId();
        if (personId == null || personId == 0L) {
            iFormView.showErrorNotification(ResManager.loadKDString((String)"\u60a8\u65e0\u6709\u6548\u7684\u8003\u52e4\u6863\u6848\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AttStatisticsFormService_1", (String)"wtc-wtss-business", (Object[])new Object[0]));
            return null;
        }
        Date chooseDate = WTCDateUtils.getZeroDate((Date)WTSSDateUtils.getLastDate());
        ArrayList<Long> allAdminOrgIdList = new ArrayList<Long>(1);
        HashMap<Long, List<Map<String, Object>>> adminOrgIdByPersonIdPlusMap = new HashMap<Long, List<Map<String, Object>>>();
        this.collectAdminOrgIdByPersonIdPlusMap(iFormView, allAdminOrgIdList, adminOrgIdByPersonIdPlusMap);
        if (WTCCollections.isEmpty(adminOrgIdByPersonIdPlusMap)) {
            iFormView.showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6ca1\u6709\u8d1f\u8d23\u7684\u90e8\u95e8\uff0c\u6682\u65f6\u65e0\u6cd5\u67e5\u8be2\u5230\u65e5\u7edf\u8ba1\u6216\u671f\u95f4\u7edf\u8ba1\u6570\u636e\u3002", (String)"AttStatisticsFormService_3", (String)"wtc-wtss-business", (Object[])new Object[0]));
            return null;
        }
        ArrayList matchAdminOrgIdList = Lists.newArrayListWithExpectedSize((int)1);
        ArrayList errMsgList = new ArrayList(2);
        long ruleId = MobileTeamHomeBusiness.getInstance().getRuleIdByAdminOrgId(allAdminOrgIdList, matchAdminOrgIdList, errMsgList);
        if (!CollectionUtils.isEmpty(errMsgList)) {
            iFormView.showErrorNotification((String)errMsgList.get(0));
            return null;
        }
        if (ruleId == 0L) {
            iFormView.showErrorNotification(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u5047\u52e4\u81ea\u52a9\u65b9\u6848\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AttStatisticsFormService_4", (String)"wtc-wtss-business", (Object[])new Object[0]));
            return null;
        }
        long affiliateAdminOrgId = (Long)matchAdminOrgIdList.get(0);
        AttStatisticQueryParam attStatisticQueryParam = this.getAttStatisticQueryParam(personId, chooseDate, ruleId, affiliateAdminOrgId, staCombinationTerminal, allAdminOrgIdList);
        AttStatisticsServiceHelper.getInstance().getAndSetStaticsFileBoIdMap(attStatisticQueryParam);
        Control control = iFormView.getControl("daychartflex");
        if (control != null) {
            attStatisticQueryParam.setShowBoard(TeamHomeHelper.isShowBoardByPkid((Long)ruleId));
            iFormView.setVisible(Boolean.valueOf(attStatisticQueryParam.isShowBoard()), new String[]{"daychartflex"});
        }
        attStatisticQueryParam.setAdminOrgIdByPersonIdPlusMap(adminOrgIdByPersonIdPlusMap);
        this.cacheAttStatisticQueryParam(iFormView.getPageCache(), attStatisticQueryParam);
        return attStatisticQueryParam;
    }

    public void collectAdminOrgIdByPersonIdPlusMap(IFormView iFormView, List<Long> allAdminOrgIdList, Map<Long, List<Map<String, Object>>> adminOrgIdByPersonIdPlusMap) {
        Long personId = MobileCommonServiceHelper.getInstance().getUserId();
        Date chooseDate = WTCDateUtils.getZeroDate((Date)WTSSDateUtils.getLastDate());
        List<Map<String, Object>> allAdminOrgIdByPersonIdPlus = MobileHomePageBusiness.getInstance().getAllAdminOrgIdByPersonIdPlus(personId);
        this.extInitAdminOrg(personId, allAdminOrgIdByPersonIdPlus);
        if (WTCCollections.isEmpty(allAdminOrgIdByPersonIdPlus)) {
            iFormView.showErrorNotification(ResManager.loadKDString((String)"\u60a8\u8fd8\u672a\u6709\u8d1f\u8d23\u90e8\u95e8\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AttStatisticsFormService_2", (String)"wtc-wtss-business", (Object[])new Object[0]));
            return;
        }
        for (Map<String, Object> adminOrgIdByPersonIdPlus : allAdminOrgIdByPersonIdPlus) {
            Date effDt = (Date)adminOrgIdByPersonIdPlus.get("effdt");
            Date leFfDt = (Date)adminOrgIdByPersonIdPlus.get("leffdt");
            Long adminOrgId = (Long)adminOrgIdByPersonIdPlus.get("adminorg");
            if (null == effDt || leFfDt == null || !chooseDate.after(effDt) || !chooseDate.before(leFfDt)) continue;
            allAdminOrgIdList.add(adminOrgId);
            adminOrgIdByPersonIdPlus.put("leffdt", WTCDateUtils.date2Str((Date)leFfDt, (String)"yyyy-MM-dd HH:mm:ss"));
            adminOrgIdByPersonIdPlus.put("effdt", WTCDateUtils.date2Str((Date)effDt, (String)"yyyy-MM-dd HH:mm:ss"));
            List<Map<String, Object>> tuples = adminOrgIdByPersonIdPlusMap.get(adminOrgId);
            if (WTCCollections.isNotEmpty(tuples)) {
                tuples.add(adminOrgIdByPersonIdPlus);
                continue;
            }
            tuples = new ArrayList<Map<String, Object>>();
            tuples.add(adminOrgIdByPersonIdPlus);
            adminOrgIdByPersonIdPlusMap.put(adminOrgId, tuples);
        }
    }

    private void extInitAdminOrg(Long personId, List<Map<String, Object>> adminOrgIdByPersonId) {
        WTCPluginProxy statisticQueryExtPluginProxy = WTCPluginProxyFactory.create(AttStatisticQueryExtPlugin.class, (String)"kd.sdk.wtc.wtss.business.teamhome.AttStatisticQueryExtPlugin");
        if (statisticQueryExtPluginProxy.hasPlugin()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("extInitAdminOrg start personId{},AdminOrgIdList{}", (Object)personId, (Object)JSON.toJSONString(adminOrgIdByPersonId));
            }
            AfterInitAttStatisticAdminOrgEvent afterInitAttStatisticAdminOrgEvent = new AfterInitAttStatisticAdminOrgEvent();
            afterInitAttStatisticAdminOrgEvent.setCurrentPersonId(personId.longValue());
            ArrayList<AttStatisticAdminOrgParam> adminOrgParamArrayList = new ArrayList<AttStatisticAdminOrgParam>(adminOrgIdByPersonId.size());
            afterInitAttStatisticAdminOrgEvent.setAttStatisticAdminOrgParams(adminOrgParamArrayList);
            for (Map<String, Object> adminOrgObjectMap : adminOrgIdByPersonId) {
                AttStatisticAdminOrgParam attStatisticAdminOrgParam = new AttStatisticAdminOrgParam();
                Date effDt = adminOrgObjectMap.get("effdt") == null ? WTCDateUtils.getMinEndDate() : (Date)adminOrgObjectMap.get("effdt");
                Date leFfDt = adminOrgObjectMap.get("leffdt") == null ? WTCDateUtils.getMaxEndDate() : (Date)adminOrgObjectMap.get("leffdt");
                long adminOrgId = adminOrgObjectMap.get("adminorg") == null ? 0L : (Long)adminOrgObjectMap.get("adminorg");
                attStatisticAdminOrgParam.setBoId(adminOrgId);
                attStatisticAdminOrgParam.setStartDate(WTCDateUtils.toLocalDate((Date)effDt));
                attStatisticAdminOrgParam.setEndDate(WTCDateUtils.toLocalDate((Date)leFfDt));
                adminOrgParamArrayList.add(attStatisticAdminOrgParam);
            }
            statisticQueryExtPluginProxy.invokeReplace(extPluginProxy -> extPluginProxy.afterInitAdminOrg(afterInitAttStatisticAdminOrgEvent));
            adminOrgIdByPersonId.clear();
            for (AttStatisticAdminOrgParam attStatisticAdminOrgParam : afterInitAttStatisticAdminOrgEvent.getAttStatisticAdminOrgParams()) {
                HashMap<String, Comparable<Long>> map = new HashMap<String, Comparable<Long>>(16);
                long boId = attStatisticAdminOrgParam.getBoId();
                map.put("adminorg", Long.valueOf(boId));
                map.put("effdt", attStatisticAdminOrgParam.getStartDate() == null ? WTCDateUtils.getMinEndDate() : WTCDateUtils.toDate((LocalDate)attStatisticAdminOrgParam.getStartDate()));
                map.put("leffdt", attStatisticAdminOrgParam.getEndDate() == null ? WTCDateUtils.getMaxEndDate() : WTCDateUtils.toDate((LocalDate)attStatisticAdminOrgParam.getEndDate()));
                adminOrgIdByPersonId.add(map);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("extInitAdminOrg end personId{},AdminOrgIdList{}", (Object)personId, (Object)JSON.toJSONString(adminOrgIdByPersonId));
            }
        }
    }

    private AttStatisticQueryParam getAttStatisticQueryParam(Long personId, Date chooseDate, long ruleId, long affiliateAdminOrgId, StaCombinationTerminal staCombinationTerminal, List<Long> allAdminOrgIdList) {
        AttStatisticQueryParam attStatisticQueryParam = new AttStatisticQueryParam();
        attStatisticQueryParam.setPersonId(personId);
        attStatisticQueryParam.setRuleId(Long.valueOf(ruleId));
        attStatisticQueryParam.setAffiliateAdminOrgId(affiliateAdminOrgId);
        attStatisticQueryParam.setQueryDate(chooseDate);
        Tuple tupleDate = AttStatisticQueryParam.thenTupleDate((Date)chooseDate);
        attStatisticQueryParam.setQueryStartDate((Date)tupleDate.getKey());
        attStatisticQueryParam.setQueryEndDate((Date)tupleDate.getValue());
        Set<Long> periodEntryIdSet = AttStatisticsServiceHelper.getInstance().getPeriodEntryIdSet(attStatisticQueryParam.getQueryStartDate(), attStatisticQueryParam.getQueryEndDate(), attStatisticQueryParam.getAttFileMap().keySet());
        attStatisticQueryParam.setPeriodEntrySet(periodEntryIdSet);
        attStatisticQueryParam.setStaTypeEnum(StaTypeEnum.DAILY);
        attStatisticQueryParam.setStaCombinationTerminal(staCombinationTerminal);
        attStatisticQueryParam.setAllAdminOrgIdList(allAdminOrgIdList);
        return attStatisticQueryParam;
    }

    public List<AttDataSourceModel> getDayOrPeriodStatisticData(AttStatisticQueryParam attStatisticQueryParam, IFormView iFormView) {
        attStatisticQueryParam.setStaCombinationConfProEnum(StaCombinationConfProEnum.ATT_STATISTICS);
        IAttStatisticsService attStatisticsService = AttStatisticsServiceHelper.getInstance().getAttStatisticsService(attStatisticQueryParam.getStaTypeEnum());
        List<AttDataSourceModel> attStatisticsData = attStatisticsService.getAttStatisticsData(attStatisticQueryParam);
        if (StaTypeEnum.DAILY == attStatisticQueryParam.getStaTypeEnum()) {
            iFormView.getPageCache().put("cache_id_daystatistic", SerializationUtils.toJsonString(attStatisticsData));
        } else if (StaTypeEnum.PERIOD == attStatisticQueryParam.getStaTypeEnum()) {
            iFormView.getPageCache().put("cache_id_perstatistic", SerializationUtils.toJsonString(attStatisticsData));
        }
        return attStatisticsData;
    }

    public AttendanceDataModel getAttendanceDataModel(Date queryDate, Set<Long> attFileBoIdSet) {
        AttendanceDataModel attendanceData = new AttendanceDataModel();
        if (queryDate == null || WTCCollections.isEmpty(attFileBoIdSet)) {
            return attendanceData;
        }
        Tuple<Integer, Integer> integerIntegerTuple = AttStatisticsServiceHelper.getInstance().queryResultTuple(queryDate, attFileBoIdSet);
        attendanceData.setValueActual(((Integer)integerIntegerTuple.getKey()).intValue());
        attendanceData.setValueShould(((Integer)integerIntegerTuple.getValue()).intValue());
        return attendanceData;
    }

    public void fillEntityDetail(IDataModel thisModel, IFormView view, String entity, String clickUnit, String dataStr, List<AttDataSourceDetailsModel> resultList) {
        if (CollectionUtils.isEmpty(resultList)) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)thisModel;
        model.deleteEntryData(entity);
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (int i = 0; i < resultList.size(); ++i) {
            AttDataSourceDetailsModel attDataSourceDetailsModel = resultList.get(i);
            TableValueSetter tableValueSetter = vs.addRow(new Object[0]);
            tableValueSetter.set("detailname", (Object)attDataSourceDetailsModel.getPersonName(), i);
            tableValueSetter.set("detailno", (Object)attDataSourceDetailsModel.getPersonNumber(), i);
            tableValueSetter.set("org", (Object)attDataSourceDetailsModel.getOrg(), i);
            tableValueSetter.set("company", (Object)attDataSourceDetailsModel.getCompany(), i);
            tableValueSetter.set("affiliateadminorg", (Object)attDataSourceDetailsModel.getAffiliateAdminOrg(), i);
            tableValueSetter.set("job", (Object)attDataSourceDetailsModel.getJob(), i);
            tableValueSetter.set("position", (Object)attDataSourceDetailsModel.getPosition(), i);
            tableValueSetter.set("attdate", (Object)dataStr, i);
            tableValueSetter.set("unit", (Object)clickUnit, i);
            BigDecimal bigDecimal = BigDecimal.valueOf(attDataSourceDetailsModel.getStaValue());
            String attDataSourceValueStr = bigDecimal.setScale(3, 4).stripTrailingZeros().toPlainString();
            tableValueSetter.set("detailvalue", (Object)attDataSourceValueStr, i);
        }
        model.batchCreateNewEntryRow(entity, vs);
        view.updateView(entity);
    }

    public void fieldNameSet(StaTypeEnum staTypeEnum, String entryGridName, IFormView view) {
        boolean bePeriod = StaTypeEnum.PERIOD == staTypeEnum;
        EntryGrid entryGrid = (EntryGrid)view.getControl(entryGridName);
        if (entryGrid != null) {
            entryGrid.getFieldEdits().forEach(d -> {
                if ("attdate".equals(d.getFieldKey())) {
                    if (bePeriod) {
                        d.setCaption(new LocaleString(TargetConst.COL_MONTH_NAME.loadKDString()));
                    } else {
                        d.setCaption(new LocaleString(TargetConst.COL_ATTDATE.loadKDString()));
                    }
                }
            });
        }
    }
}

