/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.business.attstatistics;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.sdk.wtc.wtp.business.attfile.AttFileVersion;
import kd.sdk.wtc.wtss.business.teamhome.AttStatisticQueryExtPlugin;
import kd.sdk.wtc.wtss.business.teamhome.BeforeQueryAttStatisticEvent;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxyFactory;
import kd.wtc.wtbs.business.servicehelper.WTCServiceHelper;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.attperiod.PerAttPeriodQueryServiceImpl;
import kd.wtc.wtbs.business.web.file.AttFileBusiness;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.enums.file.AttStatusEnum;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.model.period.PerAttPeriodQueryParam;
import kd.wtc.wtbs.common.predata.wtbd.PreDataAttItem;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtss.business.attstatistics.AttStatisticsTargetServiceHelper;
import kd.wtc.wtss.business.attstatistics.IAttStatisticsService;
import kd.wtc.wtss.business.attstatistics.impl.TeamAttDailyStatisticsServiceImpl;
import kd.wtc.wtss.business.attstatistics.impl.TeamAttPeriodStatisticsServiceImpl;
import kd.wtc.wtss.business.servicehelper.common.TeamHomeServiceHelper;
import kd.wtc.wtss.business.servicehelper.summaryconf.SummaryTeamConfigDetailService;
import kd.wtc.wtss.common.constants.MobileTeamHomeConstants;
import kd.wtc.wtss.common.dto.mobilehome.AttDataSourceDetailsModel;
import kd.wtc.wtss.common.dto.mobilehome.AttDataSourceModel;
import kd.wtc.wtss.common.dto.mobilehome.AttDataSourceModelConfigData;
import kd.wtc.wtss.common.dto.mobilehome.AttStatisticQueryParam;
import kd.wtc.wtss.common.enums.attstatistics.StaCombinationConfProEnum;
import kd.wtc.wtss.common.enums.attstatistics.StaCombinationTerminal;
import kd.wtc.wtss.common.enums.attstatistics.StaTypeEnum;

public class AttStatisticsServiceHelper {
    private static final Log LOG = LogFactory.getLog(AttStatisticsServiceHelper.class);

    public static AttStatisticsServiceHelper getInstance() {
        return (AttStatisticsServiceHelper)WTCAppContextHelper.getBean(AttStatisticsServiceHelper.class);
    }

    public IAttStatisticsService getAttStatisticsService(StaTypeEnum staTypeEnum) {
        if (StaTypeEnum.DAILY == staTypeEnum) {
            return TeamAttDailyStatisticsServiceImpl.getInstance();
        }
        return TeamAttPeriodStatisticsServiceImpl.getInstance();
    }

    public DynamicObject getResourceDy(StaTypeEnum staTypeEnum, long dailySourceId) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(staTypeEnum.getItemEntityNum());
        return hrBaseServiceHelper.loadSingle((Object)dailySourceId);
    }

    public AttDataSourceModelConfigData queryAttDataSourceModel(long userId, long ruleId, StaTypeEnum staTypeEnum, StaCombinationConfProEnum staCombinationConfProEnum, boolean loadConfig, StaCombinationTerminal staCombinationTerminal) {
        AttDataSourceModelConfigData attDataSourceModelConfigData = new AttDataSourceModelConfigData();
        this.setTeamStaAttItemData(userId, ruleId, staTypeEnum, staCombinationConfProEnum, loadConfig, staCombinationTerminal, attDataSourceModelConfigData, null);
        return attDataSourceModelConfigData;
    }

    public DynamicObject[] queryTeamStaAttItemDy(long userId, long ruleId, StaTypeEnum staTypeEnum, StaCombinationConfProEnum staCombinationConfProEnum, boolean loadConfig, StaCombinationTerminal staCombinationTerminal) {
        ArrayList<DynamicObject> staAttItemDyList = new ArrayList<DynamicObject>(10);
        this.setTeamStaAttItemData(userId, ruleId, staTypeEnum, staCombinationConfProEnum, loadConfig, staCombinationTerminal, null, staAttItemDyList);
        return staAttItemDyList.toArray(new DynamicObject[0]);
    }

    public Map<Long, Long> getAndSetStaticsFileBoIdMap(AttStatisticQueryParam attStatisticQueryParam) {
        AttFileQueryServiceImpl instance = AttFileQueryServiceImpl.getInstance();
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam(false);
        attFileQueryParam.setAttStatus(AttStatusEnum.ATT_NORMAL);
        attFileQueryParam.setAffiliateAdminOrgSetIds(Collections.singleton(attStatisticQueryParam.getAffiliateAdminOrgId()));
        if (StaTypeEnum.PERIOD == attStatisticQueryParam.getStaTypeEnum()) {
            attFileQueryParam.setStartDate(attStatisticQueryParam.getQueryStartDate());
            attFileQueryParam.setEndDate(attStatisticQueryParam.getQueryEndDate());
        } else {
            attFileQueryParam.setStartDate(attStatisticQueryParam.getQueryDate());
            attFileQueryParam.setEndDate(attStatisticQueryParam.getQueryDate());
        }
        List files = instance.queryAttFiles(attFileQueryParam);
        Map<Long, Long> attFileMap = files.stream().collect(Collectors.toMap(d -> d.getLong("boid"), d -> d.getLong("attperson.id"), (a, b) -> a));
        attStatisticQueryParam.setAttFileMap(attFileMap);
        attStatisticQueryParam.setFileVidSet(files.stream().map(d -> d.getLong("id")).collect(Collectors.toSet()));
        this.beforeAttStatisticSetAttFileParam(attStatisticQueryParam, files, attFileMap);
        return attFileMap;
    }

    private Map<Long, Long> beforeAttStatisticSetAttFileParam(AttStatisticQueryParam attStatisticQueryParam, List<DynamicObject> files, Map<Long, Long> attFileMap) {
        WTCPluginProxy statisticQueryExtPluginProxy = WTCPluginProxyFactory.create(AttStatisticQueryExtPlugin.class, (String)"kd.sdk.wtc.wtss.business.teamhome.AttStatisticQueryExtPlugin");
        if (statisticQueryExtPluginProxy.hasPlugin()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("beforeAttStatisticSetAttFileParam start attFileMap{}", attFileMap);
            }
            Collection attFileVersionCollection = files.stream().map(AttFileBusiness::genAttFileVersion).collect(Collectors.toList());
            BeforeQueryAttStatisticEvent beforeQueryAttStatisticEvent = new BeforeQueryAttStatisticEvent();
            beforeQueryAttStatisticEvent.setAttFileVersions(attFileVersionCollection);
            beforeQueryAttStatisticEvent.setCurrentPersonId(attStatisticQueryParam.getPersonId().longValue());
            statisticQueryExtPluginProxy.invokeReplace(d -> d.beforeAttStatistic(beforeQueryAttStatisticEvent));
            Map<Long, Long> collect = attFileVersionCollection.stream().collect(Collectors.toMap(AttFileVersion::getBoId, AttFileVersion::getAttPerson, (a, b) -> a));
            attStatisticQueryParam.setAttFileMap(collect);
            attStatisticQueryParam.setFileVidSet(files.stream().map(d -> d.getLong("id")).collect(Collectors.toSet()));
            attFileMap.putAll(collect);
            if (LOG.isDebugEnabled()) {
                LOG.debug("beforeAttStatisticSetAttFileParam start attFileMap{}", attFileMap);
            }
        }
        return attFileMap;
    }

    public void handlerAttStatisticsDataPlus(StaCombinationTerminal staCombinationTerminal, Set<Long> attFileBoIds, List<AttDataSourceModel> showList, List<AttDataSourceModel> attStatisticsData) {
        if (attStatisticsData == null || attStatisticsData.size() == 0) {
            for (AttDataSourceModel showModel : showList) {
                showModel.setAttDataSourceValue("0");
            }
        } else {
            for (AttDataSourceModel showModel : showList) {
                for (AttDataSourceModel attData : attStatisticsData) {
                    if (!attData.getAttDataSourceId().equals(showModel.getAttDataSourceId())) continue;
                    if ("%".equals(attData.getUnit())) {
                        showModel.setAttDataSourceValue(attData.getAttDataSourceValue() + attData.getUnit());
                    } else {
                        showModel.setAttDataSourceValue(attData.getAttDataSourceValue());
                    }
                    showModel.setUnit(attData.getUnit());
                }
            }
        }
    }

    public void handlerAttStatisticsData(Set<Long> attFileBoIds, List<AttDataSourceModel> showList, List<AttDataSourceModel> attStatisticsData) {
        this.handlerAttStatisticsDataPlus(StaCombinationTerminal.PC, attFileBoIds, showList, attStatisticsData);
    }

    private long setTeamStaAttItemData(long userId, long ruleId, StaTypeEnum staTypeEnum, StaCombinationConfProEnum staCombinationConfProEnum, boolean loadConfig, StaCombinationTerminal staCombinationTerminal, AttDataSourceModelConfigData attDataSourceModelConfigData, List<DynamicObject> itemSourceDyList) {
        long combinationConfSourceId;
        HRBaseServiceHelper ruleServiceHelper = new HRBaseServiceHelper("wtp_mobilerule");
        DynamicObject ruleDy = ruleServiceHelper.queryOne((Object)ruleId);
        if (null == ruleDy || staTypeEnum == null || staCombinationConfProEnum == null) {
            return 0L;
        }
        DynamicObject combinationConfSource = ruleDy.getDynamicObject(staTypeEnum.getStaConfPro());
        if (null == combinationConfSource) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5047\u52e4\u81ea\u52a9\u65b9\u6848\u7684\u81ea\u52a9\u89c4\u5219\u4e0b\u7684\u6570\u636e\u6e90\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5728\u5de5\u65f6\u5047\u52e4\u89c4\u5219-\u5047\u52e4\u81ea\u52a9\u65b9\u6848\u91cd\u65b0\u8bbe\u7f6e\u540e\u518d\u8bd5\u3002", (String)"AttStatisticsServiceHelper_1", (String)"wtc-wtss-business", (Object[])new Object[0]));
        }
        HRBaseServiceHelper combinationConfSourceServiceHelper = new HRBaseServiceHelper(staTypeEnum.getEntityNum());
        DynamicObject combinationConfSourceDy = combinationConfSourceServiceHelper.queryOne((Object)(combinationConfSourceId = combinationConfSource.getLong("id")));
        if (null == combinationConfSourceDy) {
            return 0L;
        }
        DynamicObjectCollection combinationSourceEntry = combinationConfSourceDy.getDynamicObjectCollection(staCombinationConfProEnum.getEntrySign());
        this.filterCombinationSourceEntry(staCombinationTerminal, combinationSourceEntry, staCombinationConfProEnum.getTerminalSign());
        String staItemSign = staCombinationConfProEnum.getStaItemSign();
        String displaySign = staCombinationConfProEnum.getDisplaySign();
        String adjustmentSign = staCombinationConfProEnum.getAdjustmentSign();
        if (loadConfig) {
            DynamicObject sumConfDetailDy = SummaryTeamConfigDetailService.getInstance().queryOneConfig(userId, ruleId, staTypeEnum.getStaCombinationType(), staCombinationConfProEnum.getShowType(), staCombinationTerminal.getValue());
            ArrayList<DynamicObject> collect = new ArrayList<DynamicObject>(combinationSourceEntry.size());
            if (sumConfDetailDy != null) {
                List userSourceIds = SerializationUtils.fromJsonStringToList((String)sumConfDetailDy.getString("sourcejsonstr"), Long.class);
                for (DynamicObject entity : combinationSourceEntry) {
                    entity.set(displaySign, (Object)Boolean.FALSE);
                }
                block1: for (Long userSourceId : userSourceIds) {
                    for (DynamicObject entity : combinationSourceEntry) {
                        DynamicObject itemSourceDy = entity.getDynamicObject(staItemSign);
                        if (itemSourceDy == null || null == userSourceId || !userSourceId.equals(itemSourceDy.getLong("id"))) continue;
                        entity.set(displaySign, (Object)Boolean.TRUE);
                        collect.add(itemSourceDy);
                        if (attDataSourceModelConfigData == null) continue block1;
                        List showList = attDataSourceModelConfigData.getShowList();
                        AttDataSourceModel attDataSortSource = this.getBaseAttDataSourceModel(itemSourceDy);
                        attDataSortSource.setDisplay(entity.getBoolean(displaySign));
                        attDataSortSource.setAdjustment(entity.getBoolean(adjustmentSign));
                        showList.add(attDataSortSource);
                        continue block1;
                    }
                }
                if (itemSourceDyList != null) {
                    itemSourceDyList.addAll(collect);
                }
            } else {
                if (attDataSourceModelConfigData != null) {
                    List othersConfigList = attDataSourceModelConfigData.getOthersConfigList();
                    List showList = attDataSourceModelConfigData.getShowList();
                    for (DynamicObject entity : combinationSourceEntry) {
                        DynamicObject itemSourceDy = entity.getDynamicObject(staItemSign);
                        AttDataSourceModel attDataSource = new AttDataSourceModel();
                        if (itemSourceDy != null) {
                            attDataSource.setAttDataSourceId(Long.valueOf(itemSourceDy.getLong("id")));
                            attDataSource.setAttDataSourceName(itemSourceDy.getString("name"));
                            attDataSource.setUnit((String)MobileTeamHomeConstants.UNITMAP.get(itemSourceDy.getString("unit")));
                        }
                        attDataSource.setDisplay(entity.getBoolean(displaySign));
                        attDataSource.setAdjustment(entity.getBoolean(adjustmentSign));
                        if (entity.getBoolean(displaySign)) {
                            showList.add(attDataSource);
                            continue;
                        }
                        othersConfigList.add(attDataSource);
                    }
                }
                if (itemSourceDyList != null) {
                    itemSourceDyList.addAll(combinationSourceEntry.stream().filter(staConSou -> staConSou.getBoolean(displaySign)).map(staConSou -> staConSou.getDynamicObject(staItemSign)).collect(Collectors.toList()));
                }
            }
        } else if (itemSourceDyList != null) {
            itemSourceDyList.addAll(combinationSourceEntry.stream().map(staSou -> staSou.getDynamicObject(staItemSign)).collect(Collectors.toList()));
        }
        return combinationConfSourceId;
    }

    public AttDataSourceModel getBaseAttDataSourceModel(DynamicObject itemSourceDy) {
        AttDataSourceModel attDataSortSource = new AttDataSourceModel();
        if (itemSourceDy != null) {
            attDataSortSource.setAttDataSourceId(Long.valueOf(itemSourceDy.getLong("id")));
            attDataSortSource.setAttDataSourceName(itemSourceDy.getString("name"));
            attDataSortSource.setUnit((String)MobileTeamHomeConstants.UNITMAP.get(itemSourceDy.getString("unit")));
        }
        return attDataSortSource;
    }

    private void filterCombinationSourceEntry(StaCombinationTerminal staCombinationTerminal, DynamicObjectCollection staConfigSourceDyn, String terminalPro) {
        ArrayList<DynamicObject> staDelDyn = new ArrayList<DynamicObject>();
        if (StaCombinationTerminal.MOBILE == staCombinationTerminal) {
            for (DynamicObject dynObj : staConfigSourceDyn) {
                if (!StaCombinationTerminal.PC.getValue().equals(dynObj.get(terminalPro))) continue;
                staDelDyn.add(dynObj);
            }
        } else if (StaCombinationTerminal.PC == staCombinationTerminal) {
            for (DynamicObject dynObj : staConfigSourceDyn) {
                if (!StaCombinationTerminal.MOBILE.getValue().equals(dynObj.get(terminalPro))) continue;
                staDelDyn.add(dynObj);
            }
        }
        staConfigSourceDyn.removeAll(staDelDyn);
    }

    public void handlerAttRankData(List<AttDataSourceModel> showList, long affiliateAdminOrgId, Date chooseStartDate, Date chooseEndDate, Map<Long, Long> staticsFileBoIdMap, int count, Map<Long, Map<Long, Double>> attItemDetailMap, Map<Long, Set<Long>> sourceToItemsSetMap, DynamicObject[] dailySources) {
        if (LOG.isInfoEnabled()) {
            LOG.info("AttStatisticsServiceHelper#handlerAttRankData  start");
        }
        Map dailySourceMap = Arrays.stream(dailySources).collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity(), (v1, v2) -> v2));
        HashMap personToAttFileBoMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Map.Entry<Long, Long> entry : staticsFileBoIdMap.entrySet()) {
            Long personId = entry.getValue();
            Long fileBoId = entry.getKey();
            Set fileBoIdSet = personToAttFileBoMap.computeIfAbsent(personId, e -> new HashSet(16));
            fileBoIdSet.add(fileBoId);
        }
        for (AttDataSourceModel attDataSourceModel : showList) {
            Long itemSourceId = attDataSourceModel.getAttDataSourceId();
            DynamicObject dailySourceDy = (DynamicObject)dailySourceMap.get(itemSourceId);
            if (null == dailySourceDy) continue;
            String valMethod = dailySourceDy.getString("valtakmethod");
            attDataSourceModel.setValTakeMethod(valMethod);
            double sourceModelValue = 0.0;
            ArrayList<AttDataSourceDetailsModel> attDataSourceDetailsModelList = new ArrayList<AttDataSourceDetailsModel>(10);
            Set<Long> itemsSet = sourceToItemsSetMap.get(itemSourceId);
            if (CollectionUtils.isEmpty(itemsSet)) {
                attDataSourceModel.setAttDataSourceDetails(Collections.emptyList());
                continue;
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("AttStatisticsServiceHelper#handlerAttRankData personToAttFileBoMap={}", (Object)personToAttFileBoMap.size());
            }
            for (Map.Entry entries : personToAttFileBoMap.entrySet()) {
                Set fileBoIdSet = (Set)entries.getValue();
                Long personId = (Long)entries.getKey();
                AttDataSourceDetailsModel attDataSourceDetailsModel = new AttDataSourceDetailsModel();
                attDataSourceDetailsModel.setPersonId(personId);
                double personSourceDetailsValue = 0.0;
                for (Long fileBoId : fileBoIdSet) {
                    Map<Long, Double> attItemMap = attItemDetailMap.get(fileBoId);
                    if (attItemMap == null) continue;
                    for (Long itemId : itemsSet) {
                        Double attItemValue = attItemMap.get(itemId);
                        if (attItemValue == null) continue;
                        personSourceDetailsValue += attItemValue.doubleValue();
                    }
                }
                attDataSourceDetailsModel.setStaValue(personSourceDetailsValue);
                sourceModelValue += personSourceDetailsValue;
                attDataSourceDetailsModelList.add(attDataSourceDetailsModel);
            }
            BigDecimal bigDecimal = BigDecimal.valueOf(sourceModelValue);
            String attDataSourceValueStr = bigDecimal.setScale(3, 4).stripTrailingZeros().toPlainString();
            attDataSourceModel.setAttDataSourceValue(attDataSourceValueStr);
            attDataSourceModel.setAttDataSourceDetails(attDataSourceDetailsModelList);
        }
        Set<Long> personIdSet = showList.stream().filter(d -> !CollectionUtils.isEmpty((Collection)d.getAttDataSourceDetails())).flatMap(d -> d.getAttDataSourceDetails().stream().map(AttDataSourceDetailsModel::getPersonId)).collect(Collectors.toSet());
        if (LOG.isInfoEnabled()) {
            LOG.info("AttStatisticsServiceHelper#handlerAttRankData get headsculpture start");
        }
        Map personImgMap = AttFileQueryServiceImpl.getInstance().queryPersonImgMap(new ArrayList(personIdSet));
        if (LOG.isInfoEnabled()) {
            LOG.info("AttStatisticsServiceHelper#handlerAttRankData get headsculpture end");
        }
        Map<Long, DynamicObject> attFileMap = TeamHomeServiceHelper.getInstance().getAttFile(personIdSet, affiliateAdminOrgId, chooseStartDate, chooseEndDate);
        if (LOG.isInfoEnabled()) {
            LOG.info("AttStatisticsServiceHelper#handlerAttRankData get file end");
        }
        for (AttDataSourceModel attDataSourceModel : showList) {
            List attDataSourceDetails = attDataSourceModel.getAttDataSourceDetails();
            if (HRCollUtil.isEmpty((Collection)attDataSourceDetails)) continue;
            for (AttDataSourceDetailsModel attDataSourceDetail : attDataSourceDetails) {
                Long personIdL = attDataSourceDetail.getPersonId();
                attDataSourceDetail.setPictureUrl((String)personImgMap.get(personIdL));
                DynamicObject attFileDy = attFileMap.get(personIdL);
                if (attFileDy == null) continue;
                attDataSourceDetail.setBoId(Long.valueOf(attFileDy.getLong("boid")));
                attDataSourceDetail.setDepemp(attFileDy.getString("adminorg.name"));
                attDataSourceDetail.setJob(attFileDy.getString("job.name"));
                attDataSourceDetail.setPosition(attFileDy.getString("position.name"));
                attDataSourceDetail.setAttfileNumber(attFileDy.getString("number"));
                attDataSourceDetail.setPersonName(attFileDy.getString("attperson.name"));
                attDataSourceDetail.setPersonNumber(attFileDy.getString("attperson.number"));
                attDataSourceDetail.setOrg(attFileDy.getString("org.name"));
                attDataSourceDetail.setCompany(attFileDy.getString("company.name"));
                attDataSourceDetail.setAffiliateAdminOrg(attFileDy.getString("affiliateadminorg.name"));
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("AttStatisticsServiceHelper#handlerAttRankData sort start", (Object)personToAttFileBoMap.size());
            }
            attDataSourceDetails = attDataSourceDetails.stream().filter(model -> model.getPersonNumber() != null).collect(Collectors.toList());
            Collections.sort(attDataSourceDetails);
            if (LOG.isInfoEnabled()) {
                LOG.info("AttStatisticsServiceHelper#handlerAttRankData sort end", (Object)personToAttFileBoMap.size());
            }
            if (count != 0 && count < attDataSourceDetails.size()) {
                attDataSourceDetails = new ArrayList(attDataSourceDetails.subList(0, count));
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("AttStatisticsServiceHelper#handlerAttRankData subList end", (Object)personToAttFileBoMap.size());
            }
            attDataSourceModel.setAttDataSourceDetails(attDataSourceDetails);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("AttStatisticsServiceHelper#handlerAttRankData  end");
        }
    }

    public Set<Long> getPeriodEntryIdSet(Date chooseStartDate, Date chooseEndDate, Set<Long> attFileBoIds) {
        PerAttPeriodQueryParam perAttPeriodQueryParam = new PerAttPeriodQueryParam();
        perAttPeriodQueryParam.setAttFileBoIdSet(attFileBoIds);
        perAttPeriodQueryParam.setProperties("periodentry.id");
        if (chooseStartDate != null && chooseEndDate != null) {
            QFilter qFilter = new QFilter("enddate", "<=", (Object)chooseEndDate);
            qFilter.and(new QFilter("startdate", ">=", (Object)chooseStartDate));
            perAttPeriodQueryParam.setExtendQFilter(qFilter);
        }
        return PerAttPeriodQueryServiceImpl.getInstance().queryPerAttPeriodDy(perAttPeriodQueryParam).stream().map(d -> d.getLong("periodentry.id")).collect(Collectors.toSet());
    }

    public Map<Long, Set<Long>> getSourceToItemsSetMap(DynamicObject[] dailySources) {
        if (dailySources == null) {
            return Collections.emptyMap();
        }
        HashMap sourceToItemsSetMap = Maps.newHashMapWithExpectedSize((int)dailySources.length);
        for (DynamicObject dynamicObject : dailySources) {
            long kpiId;
            Long id = dynamicObject.getLong("id");
            if (AttStatisticsTargetServiceHelper.getInstance().beConfigTarget(dynamicObject) && (kpiId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dynamicObject, (String)"teamhomekpi")) != 0L) {
                Set itemSet = sourceToItemsSetMap.computeIfAbsent(id, e -> new HashSet(16));
                itemSet.add(kpiId);
                continue;
            }
            DynamicObjectCollection sourceEntries = dynamicObject.getDynamicObjectCollection("entryentity");
            Set itemSet = sourceToItemsSetMap.computeIfAbsent(id, e -> new HashSet(16));
            for (DynamicObject itemDy : sourceEntries) {
                Long itemId = itemDy.getLong("attitem.id");
                itemSet.add(itemId);
            }
        }
        return sourceToItemsSetMap;
    }

    public Map<Long, Map<Long, Double>> queryDailyAttItemValue(Date queryDate, Set<Long> attFileBoIds, Set<Long> attItemIds) {
        return (Map)WTCServiceHelper.invokeWtcWtteBizService((String)"IAttRecordService", (String)"getDailyAttItemDataByDate", (Object[])new Object[]{new ArrayList<Long>(attItemIds), queryDate, new ArrayList<Long>(attFileBoIds)});
    }

    public Tuple<Integer, Integer> queryResultTuple(Date queryDate, Set<Long> attFileBoIds) {
        HashSet attItemIds = Sets.newHashSet((Object[])new Long[]{PreDataAttItem.PD_OR_1100_S, PreDataAttItem.PD_AT_1010});
        Map<Long, Map<Long, Double>> attItemValueMap = this.queryDailyAttItemValue(queryDate, attFileBoIds, attItemIds);
        int signCardCount = 0;
        int shouldSignCardCount = 0;
        for (Long attFileBoId : attFileBoIds) {
            Double shouldSignCardTime;
            Map<Long, Double> attItemValueOfSingleFileMap = attItemValueMap.get(attFileBoId);
            if (attItemValueOfSingleFileMap == null) continue;
            Double signCardValue = attItemValueOfSingleFileMap.get(PreDataAttItem.PD_OR_1100_S);
            if (signCardValue != null && signCardValue > 0.0) {
                ++signCardCount;
            }
            if ((shouldSignCardTime = attItemValueOfSingleFileMap.get(PreDataAttItem.PD_AT_1010)) == null || !(shouldSignCardTime > 0.0)) continue;
            ++shouldSignCardCount;
        }
        return new Tuple((Object)signCardCount, (Object)shouldSignCardCount);
    }
}

