/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.business.attstatistics;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.util.Pair;
import kd.sdk.wtc.wtp.business.attfile.AttMode;
import kd.wtc.wtbs.business.servicehelper.WTCServiceHelper;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.predata.wtbd.PreDataAttItem;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtss.business.attstatistics.AttStatisticsServiceHelper;
import kd.wtc.wtss.business.attstatistics.IAttTargetQueryService;
import kd.wtc.wtss.business.attstatistics.impl.EarlyArrivalTargetQueryImpl;
import kd.wtc.wtss.business.attstatistics.impl.LackCardTargetQueryImpl;
import kd.wtc.wtss.business.attstatistics.impl.LatestOffWorkTargetQueryImpl;

public class AttStatisticsTargetServiceHelper {
    public static AttStatisticsTargetServiceHelper getInstance() {
        return (AttStatisticsTargetServiceHelper)WTCAppContextHelper.getBean(AttStatisticsTargetServiceHelper.class);
    }

    public IAttTargetQueryService getAttTargetQueryService(long kpiId) {
        if (1771685876779200512L == kpiId) {
            return LackCardTargetQueryImpl.getInstance();
        }
        if (1771695967226047488L == kpiId) {
            return EarlyArrivalTargetQueryImpl.getInstance();
        }
        if (1771696297393269760L == kpiId) {
            return LatestOffWorkTargetQueryImpl.getInstance();
        }
        return null;
    }

    public Pair<String, String> getLackCardTarget(Map<Long, Map<Long, Double>> attItemDetailMap, Set<Long> attFileBoIds) {
        int lackCount = 0;
        int shouldSignCardCount = 0;
        for (Long attFileBoId : attFileBoIds) {
            Double shouldSignCardTime;
            Map<Long, Double> attItemValueOfSingleFileMap = attItemDetailMap.get(attFileBoId);
            if (attItemValueOfSingleFileMap == null) continue;
            Double lackCardValue = attItemValueOfSingleFileMap.get(PreDataAttItem.PD_EX_1030_S);
            if (lackCardValue != null && lackCardValue > 0.0) {
                ++lackCount;
            }
            if ((shouldSignCardTime = attItemValueOfSingleFileMap.get(PreDataAttItem.PD_AT_1010)) == null || !(shouldSignCardTime > 0.0)) continue;
            ++shouldSignCardCount;
        }
        if (shouldSignCardCount == 0) {
            return new Pair((Object)"0", (Object)"");
        }
        return new Pair((Object)String.format("%.3f", (double)lackCount * 100.0 / (double)shouldSignCardCount), (Object)"%");
    }

    public Tuple<Integer, Integer> queryResultTuple(Date queryDate, Set<Long> attFileBoIds) {
        Map<Long, Map<Long, Double>> attItemDetailMap = AttStatisticsServiceHelper.getInstance().queryDailyAttItemValue(queryDate, attFileBoIds, Sets.newHashSet((Object[])new Long[]{PreDataAttItem.PD_OR_1100_S, PreDataAttItem.PD_AT_1010}));
        int aclSignCardCount = 0;
        int shouldSignCardCount = 0;
        for (Long attFileBoId : attFileBoIds) {
            Double shouldSignCardTime;
            Map<Long, Double> attItemValueOfSingleFileMap = attItemDetailMap.get(attFileBoId);
            if (attItemValueOfSingleFileMap == null) continue;
            Double signCardValue = attItemValueOfSingleFileMap.get(PreDataAttItem.PD_OR_1100_S);
            if (signCardValue != null && signCardValue > 0.0) {
                ++aclSignCardCount;
            }
            if ((shouldSignCardTime = attItemValueOfSingleFileMap.get(PreDataAttItem.PD_AT_1010)) == null || !(shouldSignCardTime > 0.0)) continue;
            ++shouldSignCardCount;
        }
        return new Tuple((Object)aclSignCardCount, (Object)shouldSignCardCount);
    }

    public boolean beConfigTarget(DynamicObject daySourceDy) {
        if (daySourceDy == null) {
            return false;
        }
        String valMethod = daySourceDy.getString("valtakmethod");
        return "2".equals(valMethod);
    }

    public Map<Long, Double> getEarlyArrivalTargetData(Date queryDate, Set<Long> attFileBoIds) {
        Map<Long, Map<Date, Map<String, Object>>> signCardInfoMap = this.getSignCardInfoMap(queryDate, attFileBoIds);
        HashMap retMap = Maps.newHashMapWithExpectedSize((int)attFileBoIds.size());
        for (Long attFileBoId : attFileBoIds) {
            Map<String, Object> firstShouldCardDataMap = this.getFirstOrEndSignCardInfo(signCardInfoMap, attFileBoId, queryDate, true);
            if (firstShouldCardDataMap == null) continue;
            String signTimeStr = (String)firstShouldCardDataMap.get("signon");
            String startTimeStr = (String)firstShouldCardDataMap.get("mustsignpoint");
            Date signTime = WTCDateUtils.str2Date((String)signTimeStr, (String)"yyyy-MM-dd HH:mm:ss");
            Date startTime = WTCDateUtils.str2Date((String)startTimeStr, (String)"yyyy-MM-dd HH:mm:ss");
            if (signTime == null || startTime == null) continue;
            long duration = startTime.getTime() - signTime.getTime();
            retMap.put(attFileBoId, Double.parseDouble(String.valueOf(duration)));
        }
        return retMap;
    }

    public Map<Long, Map<Date, Map<String, Object>>> getSignCardInfoMap(Date queryDate, Set<Long> attFileBoIds) {
        HashMap dateMap = Maps.newHashMapWithExpectedSize((int)16);
        dateMap.put("startdate", queryDate);
        dateMap.put("enddate", queryDate);
        HashMap param = Maps.newHashMapWithExpectedSize((int)16);
        for (Long attFileBoId : attFileBoIds) {
            param.put(attFileBoId, dateMap);
        }
        return (Map)WTCServiceHelper.invokeBizService((String)"wtc", (String)"wtpm", (String)"ISignCardService", (String)"getSignCardDetailByAttFileBoIds", (Object[])new Object[]{param});
    }

    private Map<String, Object> getFirstOrEndSignCardInfo(Map<Long, Map<Date, Map<String, Object>>> signCardInfoMap, Long attFileBoId, Date queryDate, boolean isFirst) {
        Map<Date, Map<String, Object>> signCardDataMap = signCardInfoMap.get(attFileBoId);
        if (signCardDataMap == null) {
            return null;
        }
        Map<String, Object> dataMap = signCardDataMap.get(WTCDateUtils.getZeroDate((Date)queryDate));
        if (dataMap == null) {
            return null;
        }
        if (!AttMode.MULTI_PUNCH.getCode().equals(dataMap.get("type"))) {
            return null;
        }
        List signMapList = (List)dataMap.get("sign");
        if (WTCCollections.isEmpty((Collection)signMapList)) {
            return null;
        }
        return isFirst ? (Map)signMapList.get(0) : (Map)signMapList.get(signMapList.size() - 1);
    }

    public Map<Long, Double> getLatestOffWorkTargetData(Date queryDate, Set<Long> thenAttFileSet) {
        HashMap retMap = Maps.newHashMapWithExpectedSize((int)thenAttFileSet.size());
        Map<Long, Map<Date, Map<String, Object>>> signCardInfoMap = this.getSignCardInfoMap(queryDate, thenAttFileSet);
        for (Long attFileBoId : thenAttFileSet) {
            Map<String, Object> shouldCardDataMap = this.getFirstOrEndSignCardInfo(signCardInfoMap, attFileBoId, queryDate, false);
            if (shouldCardDataMap == null) continue;
            String signTimeStr = (String)shouldCardDataMap.get("signoff");
            String endTimeStr = (String)shouldCardDataMap.get("mustsignpoint");
            Date signTime = WTCDateUtils.str2Date((String)signTimeStr, (String)"yyyy-MM-dd HH:mm:ss");
            Date endTime = WTCDateUtils.str2Date((String)endTimeStr, (String)"yyyy-MM-dd HH:mm:ss");
            if (signTime == null || endTime == null) continue;
            long duration = signTime.getTime() - endTime.getTime();
            retMap.put(attFileBoId, Double.parseDouble(String.valueOf(duration)));
        }
        return retMap;
    }

    public Map<Long, Double> getLackCardTargetData(Date queryDate, Set<Long> thenAttFileSet) {
        return null;
    }
}

