/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.business.attstatistics;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.util.Pair;
import kd.sdk.wtc.wtss.business.teamhome.AttStatisticTargetQueryParam;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.ImmutableMap;
import kd.wtc.wtss.common.constants.team.target.TargetConst;

public interface IAttTargetQueryService {
    public Pair<String, String> getTargetStatisticsData(AttStatisticTargetQueryParam var1, Long var2);

    public Map<Long, Double> getTargetChartData(AttStatisticTargetQueryParam var1, Long var2);

    public Map<String, List<Map<String, String>>> getDetailMap(AttStatisticTargetQueryParam var1, DynamicObject var2);

    default public void setBaseTopHeader(List<Map<String, String>> headers) {
        headers.add(ImmutableMap.of((Object)"key", (Object)"name", (Object)"caption", (Object)TargetConst.COL_NAME.loadKDString()));
        headers.add(ImmutableMap.of((Object)"key", (Object)"number", (Object)"caption", (Object)TargetConst.COL_NUMBER.loadKDString()));
        headers.add(ImmutableMap.of((Object)"key", (Object)"position", (Object)"caption", (Object)TargetConst.COL_POSITION.loadKDString()));
        headers.add(ImmutableMap.of((Object)"key", (Object)"shift", (Object)"caption", (Object)TargetConst.COL_SHIFT.loadKDString()));
        headers.add(ImmutableMap.of((Object)"key", (Object)"attdate", (Object)"caption", (Object)TargetConst.COL_ATTDATE.loadKDString()));
    }

    default public void setBaseHeader(List<Map<String, String>> headers) {
        headers.add(ImmutableMap.of((Object)"key", (Object)"org", (Object)"caption", (Object)TargetConst.COL_ORG_NAME.loadKDString()));
        headers.add(ImmutableMap.of((Object)"key", (Object)"company", (Object)"caption", (Object)TargetConst.COL_COMPANY_NAME.loadKDString()));
        headers.add(ImmutableMap.of((Object)"key", (Object)"affiliateadminorg", (Object)"caption", (Object)TargetConst.COL_AFFADMINGORG.loadKDString()));
        headers.add(ImmutableMap.of((Object)"key", (Object)"job", (Object)"caption", (Object)TargetConst.COL_JOB_NAME.loadKDString()));
    }

    default public void setFileBasePro(Map<String, String> rowMap, DynamicObject attFileDy) {
        rowMap.put("name", attFileDy.getString("attperson.name"));
        rowMap.put("number", attFileDy.getString("attperson.number"));
        rowMap.put("org", attFileDy.getString("org.name"));
        rowMap.put("company", attFileDy.getString("company.name"));
        rowMap.put("affiliateadminorg", attFileDy.getString("affiliateadminorg.name"));
        rowMap.put("job", attFileDy.getString("job.name"));
        rowMap.put("position", attFileDy.getString("position.name"));
    }

    default public void transData(List<Map<String, String>> dataMap, String key) {
        dataMap.forEach(k -> {
            String earlyDuration = (String)k.get(key);
            if (WTCStringUtils.isNotEmpty((String)earlyDuration)) {
                k.put(key, this.getDurationLocalString(Long.parseLong(earlyDuration)));
            }
        });
    }

    default public String getDurationLocalString(long seconds) {
        StringBuilder sb = new StringBuilder();
        if (seconds / 3600L != 0L) {
            sb.append(String.format(TargetConst.HOUR.loadKDString(), seconds / 3600L));
        }
        if (seconds % 3600L / 60L != 0L) {
            sb.append(String.format(TargetConst.MIN.loadKDString(), seconds % 3600L / 60L));
        }
        if (seconds % 60L != 0L) {
            sb.append(String.format(TargetConst.SECOND.loadKDString(), seconds % 60L));
        }
        return sb.toString();
    }

    default public Comparator<Map<String, String>> getMapComparator(String key) {
        return (map1, map2) -> {
            int i;
            String earlyDuration = (String)map1.get(key);
            String earlyDurationNext = (String)map2.get(key);
            if (WTCStringUtils.isEmpty((String)earlyDuration)) {
                earlyDuration = "0";
            }
            if (WTCStringUtils.isEmpty((String)earlyDurationNext)) {
                earlyDurationNext = "0";
            }
            if ((i = Double.valueOf(earlyDurationNext).compareTo(Double.valueOf(earlyDuration))) == 0) {
                map1.putIfAbsent("number", "");
                map2.putIfAbsent("number", "");
                return ((String)map2.get("number")).compareTo((String)map1.get("number"));
            }
            return i;
        };
    }
}

