/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.business.attstatistics.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.util.Pair;
import kd.sdk.wtc.wtp.business.attfile.AttMode;
import kd.sdk.wtc.wtss.business.teamhome.AttStatisticTargetQueryParam;
import kd.wtc.wtbs.business.web.evaluation.EvaluationServiceHelper;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.evaluation.DutyShiftResponse;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.ImmutableMap;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtss.business.attstatistics.AttStatisticsTargetServiceHelper;
import kd.wtc.wtss.business.attstatistics.IAttTargetQueryService;
import kd.wtc.wtss.business.servicehelper.common.TeamHomeServiceHelper;
import kd.wtc.wtss.common.constants.team.target.TargetConst;

public class EarlyArrivalTargetQueryImpl
implements IAttTargetQueryService {
    public static EarlyArrivalTargetQueryImpl getInstance() {
        return (EarlyArrivalTargetQueryImpl)WTCAppContextHelper.getBean(EarlyArrivalTargetQueryImpl.class);
    }

    @Override
    public Pair<String, String> getTargetStatisticsData(AttStatisticTargetQueryParam queryParam, Long kpiId) {
        return null;
    }

    @Override
    public Map<Long, Double> getTargetChartData(AttStatisticTargetQueryParam queryParam, Long kpiId) {
        return AttStatisticsTargetServiceHelper.getInstance().getEarlyArrivalTargetData(queryParam.getQueryDate(), queryParam.thenAttFileSet());
    }

    @Override
    public Map<String, List<Map<String, String>>> getDetailMap(AttStatisticTargetQueryParam queryParam, DynamicObject dailyStaSource) {
        Set attFileBoIds = queryParam.thenAttFileSet();
        Date queryDate = queryParam.getQueryDate();
        HashMap retMap = Maps.newHashMapWithExpectedSize((int)16);
        retMap.put("header", this.getHeadersMap());
        Map<Long, Map<Date, Map<String, Object>>> signCardInfoMap = AttStatisticsTargetServiceHelper.getInstance().getSignCardInfoMap(queryDate, attFileBoIds);
        DutyShiftResponse dutyShiftResponse = EvaluationServiceHelper.getDutyShiftsByAttFileBoId(new ArrayList(attFileBoIds), (Date)queryDate, (Date)queryDate);
        HashSet<Long> attPersonSet = new HashSet<Long>(queryParam.getAttFileMap().values());
        Map<Long, DynamicObject> attFileMap = TeamHomeServiceHelper.getInstance().getAttFile(attPersonSet, queryParam.getAffiliateAdminOrgId(), queryDate, queryDate);
        ArrayList dataMap = Lists.newArrayListWithExpectedSize((int)10);
        if (WTCCollections.isNotEmpty(attPersonSet)) {
            for (Long attPersonId : attPersonSet) {
                HashMap rowMap = Maps.newHashMapWithExpectedSize((int)16);
                DynamicObject attFileDy = attFileMap.get(attPersonId);
                if (attFileDy == null) continue;
                this.setFileBasePro(rowMap, attFileDy);
                long attFileBoId = attFileDy.getLong("boid");
                rowMap.put("attdate", WTCDateUtils.date2Str((Date)queryDate, (String)"yyyy-MM-dd"));
                Optional currShiftHis = dutyShiftResponse.getCurrShiftHis(Long.valueOf(attFileBoId), queryDate);
                rowMap.put("shift", currShiftHis.map(Shift::getName).orElse("-"));
                Map<String, Object> firstShouldCardDataMap = this.getFirstSignCardInfo(signCardInfoMap, attFileBoId, queryDate);
                long duration = 0L;
                if (firstShouldCardDataMap == null) {
                    rowMap.put("shouldsignonpoint", "-");
                    rowMap.put("signcardtime", "-");
                } else {
                    String signTimeStr = (String)firstShouldCardDataMap.get("signon");
                    String startTimeStr = (String)firstShouldCardDataMap.get("mustsignpoint");
                    rowMap.put("shouldsignonpoint", startTimeStr);
                    rowMap.put("signcardtime", signTimeStr);
                    Date signTime = WTCDateUtils.str2Date((String)signTimeStr, (String)"yyyy-MM-dd HH:mm:ss");
                    Date startTime = WTCDateUtils.str2Date((String)startTimeStr, (String)"yyyy-MM-dd HH:mm:ss");
                    if (signTime != null && startTime != null) {
                        duration = startTime.getTime() / 1000L - signTime.getTime() / 1000L;
                        rowMap.put("earlyduration", String.valueOf(duration));
                    }
                }
                if (Objects.nonNull(dailyStaSource) && "1".equals(dailyStaSource.getString("showdimen"))) {
                    if (duration <= 0L) continue;
                    dataMap.add(rowMap);
                    continue;
                }
                dataMap.add(rowMap);
            }
        }
        dataMap.sort(this.getMapComparator("earlyduration"));
        this.transData(dataMap, "earlyduration");
        retMap.put("body", dataMap);
        return retMap;
    }

    private List<Map<String, String>> getHeadersMap() {
        ArrayList headers = Lists.newArrayListWithExpectedSize((int)10);
        this.setBaseTopHeader(headers);
        headers.add(ImmutableMap.of((Object)"key", (Object)"shouldsignonpoint", (Object)"caption", (Object)TargetConst.COL_SHOULDSIGNONPOINT.loadKDString()));
        headers.add(ImmutableMap.of((Object)"key", (Object)"signcardtime", (Object)"caption", (Object)TargetConst.COL_SIGNCARDTIME.loadKDString()));
        headers.add(ImmutableMap.of((Object)"key", (Object)"earlyduration", (Object)"caption", (Object)TargetConst.COL_EARLYDURATION.loadKDString()));
        this.setBaseHeader(headers);
        return headers;
    }

    private Map<String, Object> getFirstSignCardInfo(Map<Long, Map<Date, Map<String, Object>>> signCardInfoMap, Long attFileBoId, Date queryDate) {
        Map<Date, Map<String, Object>> signCardDataMap = signCardInfoMap.get(attFileBoId);
        if (signCardDataMap == null) {
            return null;
        }
        Map<String, Object> dataMap = signCardDataMap.get(WTCDateUtils.getZeroDate((Date)queryDate));
        if (dataMap == null) {
            return null;
        }
        if (!AttMode.MULTI_PUNCH.getCode().equals(dataMap.get("type"))) {
            return null;
        }
        List signMapList = (List)dataMap.get("sign");
        if (WTCCollections.isEmpty((Collection)signMapList)) {
            return null;
        }
        return (Map)signMapList.get(0);
    }
}

