/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.business.attstatistics.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.util.Pair;
import kd.sdk.wtc.wtss.business.teamhome.AttStatisticTargetQueryParam;
import kd.wtc.wtbs.business.web.evaluation.EvaluationServiceHelper;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.evaluation.DutyShiftResponse;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtbs.common.predata.wtbd.PreDataAttItem;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.ImmutableMap;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtss.business.attstatistics.AttStatisticsServiceHelper;
import kd.wtc.wtss.business.attstatistics.IAttTargetQueryService;
import kd.wtc.wtss.business.servicehelper.common.TeamHomeServiceHelper;
import kd.wtc.wtss.common.constants.team.target.TargetConst;

public class LackCardTargetQueryImpl
implements IAttTargetQueryService {
    public static LackCardTargetQueryImpl getInstance() {
        return (LackCardTargetQueryImpl)WTCAppContextHelper.getBean(LackCardTargetQueryImpl.class);
    }

    @Override
    public Pair<String, String> getTargetStatisticsData(AttStatisticTargetQueryParam queryParam, Long kpiId) {
        Set attFileBoIds = queryParam.thenAttFileSet();
        Map<Long, Map<Long, Double>> attItemDetailMap = AttStatisticsServiceHelper.getInstance().queryDailyAttItemValue(queryParam.getQueryDate(), attFileBoIds, this.getAttItemIds());
        int lackCount = 0;
        int shouldSignCardCount = 0;
        for (Long attFileBoId : attFileBoIds) {
            Double shouldSignCardTime;
            Map<Long, Double> attItemValueOfSingleFileMap = attItemDetailMap.get(attFileBoId);
            if (attItemValueOfSingleFileMap == null) continue;
            Double lackCardValue = attItemValueOfSingleFileMap.get(PreDataAttItem.PD_EX_1030_S);
            if (lackCardValue != null && lackCardValue > 0.0) {
                ++lackCount;
            }
            if ((shouldSignCardTime = attItemValueOfSingleFileMap.get(PreDataAttItem.PD_AT_1010)) == null || !(shouldSignCardTime > 0.0)) continue;
            ++shouldSignCardCount;
        }
        if (shouldSignCardCount == 0) {
            return new Pair((Object)"0", (Object)"%");
        }
        BigDecimal lackCountBigDecimal = BigDecimal.valueOf((double)lackCount * 100.0);
        BigDecimal shouldSignCardCountBigDecimal = BigDecimal.valueOf(shouldSignCardCount);
        String sumStr = lackCountBigDecimal.divide(shouldSignCardCountBigDecimal, 3, 4).stripTrailingZeros().toPlainString();
        return new Pair((Object)sumStr, (Object)"%");
    }

    private HashSet<Long> getAttItemIds() {
        return Sets.newHashSet((Object[])new Long[]{PreDataAttItem.PD_EX_1030_S, PreDataAttItem.PD_AT_1010});
    }

    @Override
    public Map<Long, Double> getTargetChartData(AttStatisticTargetQueryParam queryParam, Long kpiId) {
        Set attFileBoIds = queryParam.thenAttFileSet();
        Map<Long, Map<Long, Double>> attItemValueMap = AttStatisticsServiceHelper.getInstance().queryDailyAttItemValue(queryParam.getQueryDate(), attFileBoIds, this.getAttItemIds());
        LinkedHashMap resultMap = Maps.newLinkedHashMapWithExpectedSize((int)attFileBoIds.size());
        for (Long attFileBoId : attFileBoIds) {
            Map<Long, Double> attItemValueOfSingleFileMap = attItemValueMap.get(attFileBoId);
            if (attItemValueOfSingleFileMap == null) {
                resultMap.put(attFileBoId, 0.0);
                continue;
            }
            Double lackCardValue = attItemValueOfSingleFileMap.get(PreDataAttItem.PD_EX_1030_S);
            if (lackCardValue != null && lackCardValue > 0.0) {
                resultMap.put(attFileBoId, lackCardValue);
                continue;
            }
            resultMap.put(attFileBoId, 0.0);
        }
        return resultMap;
    }

    @Override
    public Map<String, List<Map<String, String>>> getDetailMap(AttStatisticTargetQueryParam queryParam, DynamicObject dailyStaSource) {
        Set attFileBoIds = queryParam.thenAttFileSet();
        Date queryDate = queryParam.getQueryDate();
        HashMap retMap = Maps.newHashMapWithExpectedSize((int)16);
        retMap.put("header", this.getHeadersMap());
        DutyShiftResponse dutyShiftResponse = EvaluationServiceHelper.getDutyShiftsByAttFileBoId(new ArrayList(attFileBoIds), (Date)queryDate, (Date)queryDate);
        HashSet<Long> attPersonSet = new HashSet<Long>(queryParam.getAttFileMap().values());
        Map<Long, DynamicObject> attFileMap = TeamHomeServiceHelper.getInstance().getAttFile(attPersonSet, queryParam.getAffiliateAdminOrgId(), queryDate, queryDate);
        ArrayList dataMap = Lists.newArrayListWithExpectedSize((int)10);
        Map<Long, Map<Long, Double>> attItemValueMap = AttStatisticsServiceHelper.getInstance().queryDailyAttItemValue(queryParam.getQueryDate(), attFileBoIds, this.getAttItemIds());
        if (WTCCollections.isNotEmpty(attPersonSet)) {
            for (Long attPersonId : attPersonSet) {
                HashMap rowMap = Maps.newHashMapWithExpectedSize((int)16);
                DynamicObject attFileDy = attFileMap.get(attPersonId);
                if (attFileDy == null) continue;
                this.setFileBasePro(rowMap, attFileDy);
                long attFileBoId = attFileDy.getLong("boid");
                rowMap.put("attdate", WTCDateUtils.date2Str((Date)queryDate, (String)"yyyy-MM-dd"));
                Optional currShiftHis = dutyShiftResponse.getCurrShiftHis(Long.valueOf(attFileBoId), queryDate);
                if (currShiftHis.isPresent()) {
                    Shift shift = (Shift)currShiftHis.get();
                    rowMap.put("shift", shift.getName());
                    rowMap.put("shiftstartdate", WTCDateUtils.secondToTime((long)shift.getLastShiftStartDate(), (String)"h:m"));
                    rowMap.put("shiftenddate", WTCDateUtils.secondToTime((long)shift.getLastShiftEndDate(), (String)"h:m"));
                }
                Map<Long, Double> attItemValueOfSingleFileMap = attItemValueMap.get(attFileBoId);
                Double lackCardValue = null;
                if (attItemValueOfSingleFileMap != null && (lackCardValue = attItemValueOfSingleFileMap.get(PreDataAttItem.PD_EX_1030_S)) != null && lackCardValue > 0.0) {
                    rowMap.put("lackcardvalue", lackCardValue.toString());
                }
                if (Objects.nonNull(dailyStaSource) && "1".equals(dailyStaSource.getString("showdimen"))) {
                    if (lackCardValue == null || !(lackCardValue > 0.0)) continue;
                    dataMap.add(rowMap);
                    continue;
                }
                dataMap.add(rowMap);
            }
        }
        dataMap.sort(this.getMapComparator("lackcardvalue"));
        retMap.put("body", dataMap);
        return retMap;
    }

    private List<Map<String, String>> getHeadersMap() {
        ArrayList headers = Lists.newArrayListWithExpectedSize((int)10);
        this.setBaseTopHeader(headers);
        headers.add(ImmutableMap.of((Object)"key", (Object)"shiftstartdate", (Object)"caption", (Object)TargetConst.COL_SHIFT_START_DATE.loadKDString()));
        headers.add(ImmutableMap.of((Object)"key", (Object)"shiftenddate", (Object)"caption", (Object)TargetConst.COL_SHIFT_END_DATE.loadKDString()));
        headers.add(ImmutableMap.of((Object)"key", (Object)"lackcardvalue", (Object)"caption", (Object)TargetConst.COL_LACK_CARD_VALUE.loadKDString()));
        this.setBaseHeader(headers);
        return headers;
    }
}

