/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.business.attstatistics.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtss.business.attstatistics.AbstractTeamAttStatisticsService;
import kd.wtc.wtss.business.attstatistics.AttStatisticsServiceHelper;
import kd.wtc.wtss.business.servicehelper.common.SchemaServiceHelper;
import kd.wtc.wtss.business.servicehelper.mobile.MobileTeamHomeBusiness;
import kd.wtc.wtss.common.dto.mobilehome.AttDataSourceModel;
import kd.wtc.wtss.common.dto.mobilehome.AttDataSourceModelConfigData;
import kd.wtc.wtss.common.dto.mobilehome.AttStatisticQueryParam;
import kd.wtc.wtss.common.enums.attstatistics.StaCombinationConfProEnum;
import kd.wtc.wtss.common.enums.attstatistics.StaTypeEnum;

public class TeamAttDailyStatisticsServiceImpl
extends AbstractTeamAttStatisticsService {
    private static final Log LOG = LogFactory.getLog(TeamAttDailyStatisticsServiceImpl.class);

    public static TeamAttDailyStatisticsServiceImpl getInstance() {
        return (TeamAttDailyStatisticsServiceImpl)WTCAppContextHelper.getBean(TeamAttDailyStatisticsServiceImpl.class);
    }

    @Override
    public List<AttDataSourceModel> getAttStatisticsData(AttStatisticQueryParam attStatisticQueryParam) {
        Map staticsFileBoIdMap = attStatisticQueryParam.getAttFileMap();
        Set<Long> attFileBoIds = staticsFileBoIdMap.keySet();
        AttDataSourceModelConfigData attDataSourceModelConfigData = this.queryAttDataSourceModel(attStatisticQueryParam.getPersonId(), attStatisticQueryParam.getRuleId(), StaTypeEnum.DAILY, StaCombinationConfProEnum.ATT_STATISTICS, true, attStatisticQueryParam.getStaCombinationTerminal());
        List showList = attDataSourceModelConfigData.getShowList();
        LOG.info("TeamAttDailyStatisticsServiceImpl#getAttStatisticsData showList={}", (Object)showList);
        if (CollectionUtils.isEmpty((Collection)showList)) {
            return showList;
        }
        Object[] attDataSourceIdArr = showList.stream().map(AttDataSourceModel::getAttDataSourceId).toArray();
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(StaTypeEnum.DAILY.getItemEntityNum());
        DynamicObject[] dailySources = hrBaseServiceHelper.loadDynamicObjectArray(attDataSourceIdArr);
        List<AttDataSourceModel> attDataSourceModels = this.calAttStatisticsData(attStatisticQueryParam, dailySources);
        this.calcStatisticsKpiData(attStatisticQueryParam, dailySources, attDataSourceModels);
        this.handlerAttStatisticsData(attStatisticQueryParam.getStaCombinationTerminal(), attFileBoIds, showList, attDataSourceModels);
        return showList;
    }

    @Override
    public List<AttDataSourceModel> calAttStatisticsData(AttStatisticQueryParam attStatisticQueryParam, DynamicObject[] dailySources) {
        if (StaTypeEnum.DAILY == attStatisticQueryParam.getStaTypeEnum()) {
            Set<Long> attFileBoIds = attStatisticQueryParam.getAttFileMap().keySet();
            Set<Long> attItemIds = SchemaServiceHelper.getInstance().getAllAttItemIds(dailySources);
            if (LOG.isDebugEnabled()) {
                LOG.debug("call IAttRecordService#getDailyAttItemValueByDate attStatisticQueryParam.getQueryDate() = {}, attItemIds = {}, attFileBoIds = {}", new Object[]{attStatisticQueryParam.getQueryDate(), attItemIds, attFileBoIds});
            }
            Map<Long, Map<Long, Double>> attItemDetailMap = AttStatisticsServiceHelper.getInstance().queryDailyAttItemValue(attStatisticQueryParam.getQueryDate(), attFileBoIds, attItemIds);
            LOG.info("calAttStatisticsData attItemDetailMap={}", attItemDetailMap);
            return MobileTeamHomeBusiness.getInstance().getAttStatisticsSumValue(attStatisticQueryParam.getAttFileMap(), dailySources, new ArrayList<Long>(attFileBoIds), attItemDetailMap);
        }
        return Collections.emptyList();
    }

    @Override
    public List<AttDataSourceModel> getAttRankOrChartData(AttStatisticQueryParam attStatisticQueryParam) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("TeamAttDailyStatisticsServiceImpl#getAttRankOrChartData attStatisticQueryParam = {}", (Object)SerializationUtils.toJsonString((Object)attStatisticQueryParam));
        }
        Map staticsFileBoIdMap = attStatisticQueryParam.getAttFileMap();
        Set attFileBoIds = staticsFileBoIdMap.keySet();
        AttDataSourceModelConfigData attDataSourceModelConfigData = this.queryAttDataSourceModel(attStatisticQueryParam.getPersonId(), attStatisticQueryParam.getRuleId(), StaTypeEnum.DAILY, attStatisticQueryParam.getStaCombinationConfProEnum(), true, attStatisticQueryParam.getStaCombinationTerminal());
        if (LOG.isDebugEnabled()) {
            LOG.debug("TeamAttDailyStatisticsServiceImpl#getAttRankOrChartData attDataSourceModelConfigData = {}", (Object)SerializationUtils.toJsonString((Object)attDataSourceModelConfigData));
        }
        List showList = attDataSourceModelConfigData.getShowList();
        if (CollectionUtils.isEmpty(attFileBoIds) || attStatisticQueryParam.getQueryDate() == null) {
            return showList;
        }
        Object[] attDataSourceIdArr = showList.stream().map(AttDataSourceModel::getAttDataSourceId).toArray();
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(StaTypeEnum.DAILY.getItemEntityNum());
        DynamicObject[] dailySources = hrBaseServiceHelper.loadDynamicObjectArray(attDataSourceIdArr);
        this.calAttRankOrChartData(showList, dailySources, attStatisticQueryParam);
        if (LOG.isDebugEnabled()) {
            LOG.debug("TeamAttDailyStatisticsServiceImpl#getAttRankOrChartData over!");
        }
        return showList;
    }

    @Override
    public List<AttDataSourceModel> calAttRankOrChartData(List<AttDataSourceModel> showList, DynamicObject[] dailySources, AttStatisticQueryParam attStatisticQueryParam) {
        if (StaTypeEnum.DAILY == attStatisticQueryParam.getStaTypeEnum()) {
            Date queryDate = attStatisticQueryParam.getQueryDate();
            Set<Long> attFileBoIds = attStatisticQueryParam.getAttFileMap().keySet();
            Map<Long, Set<Long>> sourceToItemsSetMap = AttStatisticsServiceHelper.getInstance().getSourceToItemsSetMap(dailySources);
            Set<Long> itemsSet = sourceToItemsSetMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
            Map<Long, Map<Long, Double>> attItemDetailMap = AttStatisticsServiceHelper.getInstance().queryDailyAttItemValue(queryDate, attFileBoIds, itemsSet);
            this.calcChartKpiData(attItemDetailMap, attStatisticQueryParam, dailySources);
            if (attItemDetailMap != null) {
                LOG.info("calAttRankOrChartData#attItemDetailMap keys={}", (Object)attItemDetailMap.size());
            }
            this.handlerAttRankData(showList, attStatisticQueryParam.getAffiliateAdminOrgId(), queryDate, queryDate, attStatisticQueryParam.getAttFileMap(), this.getShowRankCount(attStatisticQueryParam.getCount()), attItemDetailMap, sourceToItemsSetMap, dailySources);
        }
        return showList;
    }

    @Override
    public AttDataSourceModel getAttStatisticsPersonDetailData(AttStatisticQueryParam attStatisticQueryParam, int showCount) {
        AttStatisticsServiceHelper instance = AttStatisticsServiceHelper.getInstance();
        StaTypeEnum staTypeEnum = attStatisticQueryParam.getStaTypeEnum();
        DynamicObject dailySource = instance.getResourceDy(staTypeEnum, attStatisticQueryParam.getChickSourceId());
        AttDataSourceModel baseAttDataSourceModel = instance.getBaseAttDataSourceModel(dailySource);
        List<AttDataSourceModel> attDataSourceModels = Collections.singletonList(baseAttDataSourceModel);
        attStatisticQueryParam.setCount(Integer.valueOf(showCount));
        this.calAttRankOrChartData(attDataSourceModels, new DynamicObject[]{dailySource}, attStatisticQueryParam);
        if (LOG.isDebugEnabled()) {
            LOG.debug("getAttStatisticsPersonDetailData#attDataSourceModels={}", attDataSourceModels);
        }
        return attDataSourceModels.get(0);
    }
}

