/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.business.attstatistics.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtss.business.attstatistics.AbstractTeamAttStatisticsService;
import kd.wtc.wtss.business.attstatistics.AttStatisticsServiceHelper;
import kd.wtc.wtss.business.servicehelper.common.SchemaServiceHelper;
import kd.wtc.wtss.business.servicehelper.mobile.MobileTeamHomeBusiness;
import kd.wtc.wtss.common.dto.mobilehome.AttDataSourceModel;
import kd.wtc.wtss.common.dto.mobilehome.AttDataSourceModelConfigData;
import kd.wtc.wtss.common.dto.mobilehome.AttStatisticQueryParam;
import kd.wtc.wtss.common.enums.attstatistics.StaCombinationConfProEnum;
import kd.wtc.wtss.common.enums.attstatistics.StaTypeEnum;

public class TeamAttPeriodStatisticsServiceImpl
extends AbstractTeamAttStatisticsService {
    public static TeamAttPeriodStatisticsServiceImpl getInstance() {
        return (TeamAttPeriodStatisticsServiceImpl)WTCAppContextHelper.getBean(TeamAttPeriodStatisticsServiceImpl.class);
    }

    @Override
    public List<AttDataSourceModel> getAttStatisticsData(AttStatisticQueryParam attStatisticQueryParam) {
        Set<Long> attFileBoIds = attStatisticQueryParam.getAttFileMap().keySet();
        AttDataSourceModelConfigData attDataSourceModelConfigData = this.queryAttDataSourceModel(attStatisticQueryParam.getPersonId(), attStatisticQueryParam.getRuleId(), StaTypeEnum.PERIOD, StaCombinationConfProEnum.ATT_STATISTICS, true, attStatisticQueryParam.getStaCombinationTerminal());
        List showList = attDataSourceModelConfigData.getShowList();
        if (CollectionUtils.isEmpty((Collection)showList)) {
            return showList;
        }
        Object[] attDataSourceIdArr = showList.stream().map(AttDataSourceModel::getAttDataSourceId).toArray();
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(StaTypeEnum.PERIOD.getItemEntityNum());
        DynamicObject[] dailySources = hrBaseServiceHelper.loadDynamicObjectArray(attDataSourceIdArr);
        List<AttDataSourceModel> attDataSourceModels = this.calAttStatisticsData(attStatisticQueryParam, dailySources);
        this.calcStatisticsKpiData(attStatisticQueryParam, dailySources, attDataSourceModels);
        this.handlerAttStatisticsData(attStatisticQueryParam.getStaCombinationTerminal(), attFileBoIds, showList, attDataSourceModels);
        return showList;
    }

    @Override
    public List<AttDataSourceModel> calAttStatisticsData(AttStatisticQueryParam attStatisticQueryParam, DynamicObject[] dailySources) {
        if (StaTypeEnum.PERIOD == attStatisticQueryParam.getStaTypeEnum()) {
            Set attFileIdSet = attStatisticQueryParam.getAttFileMap().keySet();
            Set<Long> attItemIds = SchemaServiceHelper.getInstance().getAllAttItemIds(dailySources);
            Map attItemMap = (Map)DispatchServiceHelper.invokeBizService((String)"wtc", (String)"wtte", (String)"IAttRecordService", (String)"getAttItemValueByPeriodSet", (Object[])new Object[]{new ArrayList(attStatisticQueryParam.getPeriodEntrySet()), new ArrayList<Long>(attItemIds), new ArrayList(attStatisticQueryParam.getFileVidSet()), attStatisticQueryParam.getQueryStartDate(), attStatisticQueryParam.getQueryEndDate()});
            return MobileTeamHomeBusiness.getInstance().getAttStatisticsSumValue(attStatisticQueryParam.getAttFileMap(), dailySources, new ArrayList<Long>(attFileIdSet), attItemMap);
        }
        return Collections.emptyList();
    }

    @Override
    public List<AttDataSourceModel> getAttRankOrChartData(AttStatisticQueryParam attStatisticQueryParam) {
        Map staticsFileBoIdMap = attStatisticQueryParam.getAttFileMap();
        Set attFileBoIds = staticsFileBoIdMap.keySet();
        AttDataSourceModelConfigData attDataSourceModelConfigData = this.queryAttDataSourceModel(attStatisticQueryParam.getPersonId(), attStatisticQueryParam.getRuleId(), StaTypeEnum.PERIOD, attStatisticQueryParam.getStaCombinationConfProEnum(), true, attStatisticQueryParam.getStaCombinationTerminal());
        List showList = attDataSourceModelConfigData.getShowList();
        if (CollectionUtils.isEmpty(attFileBoIds) || CollectionUtils.isEmpty((Collection)showList)) {
            return showList;
        }
        Object[] attDataSourceIdArr = showList.stream().map(AttDataSourceModel::getAttDataSourceId).toArray();
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(StaTypeEnum.PERIOD.getItemEntityNum());
        DynamicObject[] dailySources = hrBaseServiceHelper.loadDynamicObjectArray(attDataSourceIdArr);
        List<AttDataSourceModel> attDataSourceModels = this.calAttRankOrChartData(showList, dailySources, attStatisticQueryParam);
        if (CollectionUtils.isEmpty(attDataSourceModels)) {
            return attDataSourceModels;
        }
        return showList;
    }

    @Override
    public List<AttDataSourceModel> calAttRankOrChartData(List<AttDataSourceModel> showList, DynamicObject[] dailySources, AttStatisticQueryParam attStatisticQueryParam) {
        if (StaTypeEnum.PERIOD == attStatisticQueryParam.getStaTypeEnum()) {
            Map<Long, Set<Long>> sourceToItemsSetMap = AttStatisticsServiceHelper.getInstance().getSourceToItemsSetMap(dailySources);
            Set<Long> attItemIds = SchemaServiceHelper.getInstance().getAllAttItemIds(dailySources);
            Map attItemDetailMap = (Map)DispatchServiceHelper.invokeBizService((String)"wtc", (String)"wtte", (String)"IAttRecordService", (String)"getAttItemValueByPeriodSet", (Object[])new Object[]{new ArrayList(attStatisticQueryParam.getPeriodEntrySet()), new ArrayList<Long>(attItemIds), new ArrayList(attStatisticQueryParam.getFileVidSet()), attStatisticQueryParam.getQueryStartDate(), attStatisticQueryParam.getQueryEndDate()});
            this.calcChartKpiData(attItemDetailMap, attStatisticQueryParam, dailySources);
            this.handlerAttRankData(showList, attStatisticQueryParam.getAffiliateAdminOrgId(), attStatisticQueryParam.getQueryStartDate(), attStatisticQueryParam.getQueryEndDate(), attStatisticQueryParam.getAttFileMap(), this.getShowRankCount(attStatisticQueryParam.getCount()), attItemDetailMap, sourceToItemsSetMap, dailySources);
        }
        return showList;
    }

    @Override
    public AttDataSourceModel getAttStatisticsPersonDetailData(AttStatisticQueryParam attStatisticQueryParam, int showCount) {
        DynamicObject dailySource = AttStatisticsServiceHelper.getInstance().getResourceDy(attStatisticQueryParam.getStaTypeEnum(), attStatisticQueryParam.getChickSourceId());
        AttDataSourceModel baseAttDataSourceModel = AttStatisticsServiceHelper.getInstance().getBaseAttDataSourceModel(dailySource);
        List<AttDataSourceModel> attDataSourceModels = Collections.singletonList(baseAttDataSourceModel);
        attStatisticQueryParam.setCount(Integer.valueOf(showCount));
        this.calAttRankOrChartData(attDataSourceModels, new DynamicObject[]{dailySource}, attStatisticQueryParam);
        return attDataSourceModels.get(0);
    }
}

