/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.business.servicehelper.common;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import kd.bos.util.CollectionUtils;
import kd.wtc.wtbs.business.web.attperiod.PerAttPeriodQueryServiceImpl;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.model.period.PerAttPeriodQueryParam;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.WTCSymbolMultiLanguageUtil;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtp.business.attconfirm.impl.AttConfirmProxyOpServiceImpl;
import kd.wtc.wtp.business.attconfirm.impl.AttConfirmQueryServiceImpl;
import kd.wtc.wtp.common.enums.attconfirm.AttConRecordStatusEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConRecordTypeEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConfirmDataStatusEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConfirmRecordOpEnum;
import kd.wtc.wtp.common.kdstring.AttConfirmKDString;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordModel;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordOpParam;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordQueryParam;
import kd.wtc.wtss.business.servicehelper.common.HomePageServiceHelper;

public class AttConfirmFormHelper {
    private static final Log LOG = LogFactory.getLog(AttConfirmFormHelper.class);
    private static AttConfirmFormHelper INSTANCE = new AttConfirmFormHelper();

    private AttConfirmFormHelper() {
    }

    public static AttConfirmFormHelper getInstance() {
        return INSTANCE;
    }

    public List<AttConfirmRecordModel> queryNeedConfirmList(long employeeId, AttConRecordTypeEnum typeEnumSet, boolean fromMsgCenter, long currentRecordId) {
        AttConfirmRecordQueryParam queryParam;
        if (employeeId == 0L) {
            return Collections.emptyList();
        }
        if (fromMsgCenter) {
            if (currentRecordId == 0L) {
                return Collections.emptyList();
            }
            queryParam = new AttConfirmRecordQueryParam();
            queryParam.setIds(Collections.singleton(currentRecordId));
            queryParam.setQueryNotEffect(true);
            List currentModel = AttConfirmQueryServiceImpl.getInstance().queryAttConfirmRecordModelList(queryParam);
            if (!currentModel.isEmpty()) {
                AttConfirmRecordModel currentRecord = (AttConfirmRecordModel)currentModel.get(0);
                if (currentRecord.getStatus() == AttConRecordStatusEnum.CONFIRM || currentRecord.getDataStatus() != AttConfirmDataStatusEnum.EFFECT) {
                    return currentModel;
                }
            } else {
                LOG.warn("AttConfirmFormHelper.queryNeedConfirmList.warn:current confirm is not exist,recordId:{}", (Object)currentRecordId);
                return Collections.emptyList();
            }
        }
        queryParam = new AttConfirmRecordQueryParam();
        Map<Long, Tuple<Date, Date>> attFileMap = HomePageServiceHelper.getInstance().getAllAttFileMapWithEmployeeId(employeeId);
        if (WTCCollections.isEmpty(attFileMap)) {
            return Collections.emptyList();
        }
        queryParam.setAttFileBoIdSet(attFileMap.keySet());
        queryParam.setStatus(Collections.singleton(AttConRecordStatusEnum.SEND));
        if (typeEnumSet != null) {
            queryParam.setType(typeEnumSet);
        }
        List<AttConfirmRecordModel> recordModels = AttConfirmQueryServiceImpl.getInstance().queryAttConfirmRecordModelList(queryParam);
        recordModels.sort(Comparator.comparing(AttConfirmRecordModel::getStartDate).reversed());
        Map<AttConRecordTypeEnum, List<AttConfirmRecordModel>> recordMapByType = recordModels.stream().collect(Collectors.groupingBy(AttConfirmRecordModel::getType));
        if (recordMapByType.size() > 1) {
            List<AttConfirmRecordModel> periodRecords = recordMapByType.get(AttConRecordTypeEnum.BY_PERIOD);
            List<AttConfirmRecordModel> dateRecords = recordMapByType.get(AttConRecordTypeEnum.BY_DATE);
            periodRecords.addAll(dateRecords);
            recordModels = periodRecords;
        }
        return recordModels;
    }

    @Deprecated
    private void filterDuplicateRecord(List<AttConfirmRecordModel> recordModels, Map<Long, Tuple<Date, Date>> attFileMap, AttConRecordTypeEnum typeEnumSet) {
        if (WTCCollections.isEmpty(recordModels)) {
            return;
        }
        Predicate<AttConfirmRecordModel> periodFilterFunc = recordModel -> false;
        if (typeEnumSet == null || AttConRecordTypeEnum.BY_PERIOD == typeEnumSet) {
            PerAttPeriodQueryParam queryParam = new PerAttPeriodQueryParam();
            queryParam.setAttFileBoIdSet(attFileMap.keySet());
            List perAttPeriodReportList = PerAttPeriodQueryServiceImpl.getInstance().queryPerAttPeriodEntity(queryParam);
            Set validPeriodIdSet = perAttPeriodReportList.stream().map(PerAttPeriod::getPrimaryId).collect(Collectors.toSet());
            periodFilterFunc = recordModel -> attFileMap.get(recordModel.getAttFile()) == null || AttConRecordTypeEnum.BY_PERIOD.equals((Object)recordModel.getType()) && !validPeriodIdSet.contains(recordModel.getPerAttPeriod());
        }
        recordModels.removeIf(periodFilterFunc);
        Predicate<AttConfirmRecordModel> dateFilterFunc = recordModel -> false;
        if (typeEnumSet == null || AttConRecordTypeEnum.BY_DATE == typeEnumSet) {
            dateFilterFunc = recordModel -> attFileMap.get(recordModel.getAttFile()) == null || AttConRecordTypeEnum.BY_DATE.equals((Object)recordModel.getType()) && (recordModel.getStartDate().compareTo((Date)((Tuple)attFileMap.get(recordModel.getAttFile())).getValue()) > 0 || recordModel.getStartDate().compareTo((Date)((Tuple)attFileMap.get(recordModel.getAttFile())).getKey()) < 0);
        }
        recordModels.removeIf(dateFilterFunc);
    }

    public String getTabNameWithRecord(AttConfirmRecordModel recordModel, boolean waitConfirm) {
        String tabName = WTCDateUtils.date2Str((Date)recordModel.getStartDate(), (String)"yyyy-MM-dd");
        if (recordModel.getType() == AttConRecordTypeEnum.BY_PERIOD) {
            tabName = tabName + "~" + WTCDateUtils.date2Str((Date)recordModel.getEndDate(), (String)"yyyy-MM-dd");
        }
        String statusName = "";
        if (waitConfirm) {
            if (AttConRecordStatusEnum.SEND == recordModel.getStatus()) {
                statusName = AttConfirmKDString.toBeConfirmed();
            } else if (AttConRecordStatusEnum.CONFIRM == recordModel.getStatus()) {
                statusName = AttConRecordStatusEnum.CONFIRM.getName().loadKDString();
            }
        } else {
            statusName = AttConRecordStatusEnum.CONFIRM.getName().loadKDString();
        }
        tabName = tabName + WTCSymbolMultiLanguageUtil.getLeftBracketSymbol() + statusName + WTCSymbolMultiLanguageUtil.getRightBracketSymbol();
        return tabName;
    }

    public void tabPageConsumer(LoadCustomControlMetasArgs args) {
        Map params = ((FormShowParameter)args.getSource()).getCustomParams();
        Object employeeId = params.get("cache_id_employeeid");
        if (!(employeeId instanceof String) || WTCStringUtils.isEmpty((String)((String)employeeId))) {
            return;
        }
        Object confirmType = params.get("confirmtype");
        AttConRecordTypeEnum type = null;
        if (confirmType != null) {
            type = AttConRecordTypeEnum.getEnumByCode((String)String.valueOf(confirmType));
        }
        boolean fromMsgCenter = "msgcenter".equals(params.get("source"));
        long currentConfirmId = 0L;
        if (fromMsgCenter) {
            currentConfirmId = Long.parseLong(String.valueOf(params.get("currentrecordid")));
        }
        List<AttConfirmRecordModel> recordModels = this.queryNeedConfirmList(Long.parseLong((String)employeeId), type, fromMsgCenter, currentConfirmId);
        ArrayList tabPages = Lists.newArrayListWithExpectedSize((int)recordModels.size());
        for (AttConfirmRecordModel recordModel : recordModels) {
            String tabName = AttConfirmFormHelper.getInstance().getTabNameWithRecord(recordModel, true);
            TabPageAp tabPageAp = new TabPageAp();
            tabPageAp.setKey(String.valueOf(recordModel.getId()));
            tabPageAp.setName(new LocaleString(tabName));
            tabPages.add(tabPageAp.createControl());
        }
        HashMap<String, Object> cusControlPanelItems = new HashMap<String, Object>();
        cusControlPanelItems.put("id", "tabap");
        cusControlPanelItems.put("items", tabPages);
        args.getItems().add(cusControlPanelItems);
    }

    public void selectCurrentTab(IFormView view) {
        String selectedSourceId = this.initCurrentTabKey(view);
        if (WTCStringUtils.isNotEmpty((String)selectedSourceId)) {
            Tab tab = (Tab)view.getControl("tabap");
            tab.activeTab(selectedSourceId);
        }
    }

    public void cacheAttConfirmRecord(IFormView view) {
        FormShowParameter params = view.getFormShowParameter();
        Object employeeId = params.getCustomParam("cache_id_employeeid");
        if (!(employeeId instanceof String)) {
            return;
        }
        Object confirmType = params.getCustomParam("confirmtype");
        AttConRecordTypeEnum type = null;
        if (confirmType != null) {
            type = AttConRecordTypeEnum.getEnumByCode((String)String.valueOf(confirmType));
        }
        boolean fromMsgCenter = "msgcenter".equals(params.getCustomParam("source"));
        long currentConfirmId = 0L;
        if (fromMsgCenter) {
            currentConfirmId = Long.parseLong((String)params.getCustomParam("currentrecordid"));
        }
        List<AttConfirmRecordModel> records = this.queryNeedConfirmList(Long.parseLong(String.valueOf(employeeId)), type, fromMsgCenter, currentConfirmId);
        params.setCustomParam("cache_attconfirmlist", records);
        view.cacheFormShowParameter();
    }

    public List<AttConfirmRecordModel> getCacheAttConfirmRecord(IFormView view) {
        Object attConfirmCacheObj = view.getFormShowParameter().getCustomParam("cache_attconfirmlist");
        if (!(attConfirmCacheObj instanceof List)) {
            return Collections.emptyList();
        }
        ArrayList records = new ArrayList();
        if (attConfirmCacheObj instanceof JSONArray) {
            for (Object jsonObj : (JSONArray)attConfirmCacheObj) {
                if (!(jsonObj instanceof JSONObject)) continue;
                AttConfirmRecordModel record = (AttConfirmRecordModel)((JSONObject)jsonObj).toJavaObject(AttConfirmRecordModel.class);
                records.add(record);
            }
        } else if (attConfirmCacheObj instanceof ArrayList) {
            records = (ArrayList)attConfirmCacheObj;
        }
        return records;
    }

    public void cacheConfirmSort(IFormView view) {
        List<AttConfirmRecordModel> cacheAttConfirmRecord = this.getCacheAttConfirmRecord(view);
        if (WTCCollections.isEmpty(cacheAttConfirmRecord)) {
            return;
        }
        ArrayList<String> attConfirmIdStrSort = new ArrayList<String>(cacheAttConfirmRecord.size());
        for (int i = 0; i < cacheAttConfirmRecord.size(); ++i) {
            AttConfirmRecordModel record = cacheAttConfirmRecord.get(i);
            if (AttConRecordStatusEnum.CONFIRM.equals((Object)record.getStatus())) continue;
            attConfirmIdStrSort.add(String.valueOf(record.getId()));
        }
        view.getFormShowParameter().setCustomParam("confirmsort", attConfirmIdStrSort);
        view.cacheFormShowParameter();
    }

    public boolean invokeTabPageConfirm(IFormView view) {
        if (view == null) {
            return false;
        }
        Tab tab = (Tab)view.getControl("tabap");
        if (tab == null) {
            return false;
        }
        String tabKey = tab.getCurrentTab();
        if (WTCStringUtils.isEmpty((String)tabKey)) {
            return false;
        }
        IFormView tabPage = view.getView(view.getPageCache().get(tabKey));
        if (tabPage == null) {
            return false;
        }
        if (this.checkCurrentTabWasConfirm(view)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8003\u52e4\u8bb0\u5f55\u5df2\u786e\u8ba4\u3002", (String)"AttConfirmFromHelper_0", (String)"wtc-wtss-business", (Object[])new Object[0]));
            return false;
        }
        boolean success = true;
        AttConfirmRecordOpParam opParam = new AttConfirmRecordOpParam();
        opParam.setOp(AttConfirmRecordOpEnum.COMFIRM);
        opParam.setAttConfirmRecordIds(Collections.singleton(Long.parseLong(tabKey)));
        AttConfirmProxyOpServiceImpl.getInstance().opAttConfirmRecord(opParam);
        List modelList = opParam.getAttConfirmRecordModelList();
        if (CollectionUtils.isNotEmpty((Collection)modelList)) {
            AttConfirmRecordModel recordModel = (AttConfirmRecordModel)modelList.get(0);
            Boolean opStatus = recordModel.getOpStatus();
            if (Boolean.TRUE.equals(opStatus)) {
                view.showSuccessNotification(AttConfirmKDString.getSuccessTips());
            } else {
                success = false;
                String msg = recordModel.getMsg();
                view.showTipNotification(msg);
                Object confirmSortObj = view.getFormShowParameter().getCustomParam("confirmsort");
                if (confirmSortObj instanceof List) {
                    List confirmSort = (List)confirmSortObj;
                    IFormView parentView = view.getParentView();
                    if (confirmSort.size() == 1 && parentView != null) {
                        parentView.showTipNotification(msg);
                        view.sendFormAction(parentView);
                    }
                }
            }
        }
        return success;
    }

    public void afterConfirm(IFormView view, boolean confirmSuccess) {
        Object confirmSortObj = view.getFormShowParameter().getCustomParam("confirmsort");
        if (!(confirmSortObj instanceof List)) {
            return;
        }
        List confirmSort = (List)confirmSortObj;
        if (confirmSort.size() == 1) {
            view.close();
            return;
        }
        String nextTabKey = "";
        String currentTabKey = this.getCurrentTabKey(view);
        int currentIdx = confirmSort.indexOf(currentTabKey);
        if (currentIdx < 0) {
            return;
        }
        confirmSort.remove(currentIdx);
        nextTabKey = currentIdx >= confirmSort.size() ? (String)confirmSort.get(0) : (String)confirmSort.get(currentIdx);
        view.getFormShowParameter().setCustomParam("confirmsort", (Object)confirmSort);
        view.cacheFormShowParameter();
        if (!confirmSuccess) {
            Tab tab = (Tab)view.getControl("tabap");
            tab.deleteControls(new String[]{currentTabKey});
        } else {
            this.updateTabName(view, currentTabKey);
        }
        this.jump2TabPage(view, nextTabKey);
    }

    private String initCurrentTabKey(IFormView view) {
        Map params = view.getFormShowParameter().getCustomParams();
        Object currentObj = params.get("currentrecordid");
        String selectedSourceId = "";
        if (currentObj == null) {
            List<AttConfirmRecordModel> attConfirmRecordModels = this.getCacheAttConfirmRecord(view);
            if (!attConfirmRecordModels.isEmpty()) {
                AttConfirmRecordModel recordModel = attConfirmRecordModels.get(0);
                selectedSourceId = String.valueOf(recordModel.getId());
            }
        } else {
            selectedSourceId = String.valueOf(currentObj);
        }
        return selectedSourceId;
    }

    private String getCurrentTabKey(IFormView view) {
        Tab tab = (Tab)view.getControl("tabap");
        return tab.getCurrentTab();
    }

    private void jump2TabPage(IFormView view, String tabKey) {
        Tab tab = (Tab)view.getControl("tabap");
        tab.activeTab(tabKey);
    }

    public boolean checkCurrentTabWasConfirm(IFormView view) {
        Object confirmSortObj = view.getFormShowParameter().getCustomParam("confirmsort");
        if (!(confirmSortObj instanceof List)) {
            return true;
        }
        List confirmSort = (List)confirmSortObj;
        String currentTabKey = this.getCurrentTabKey(view);
        int currentIdx = confirmSort.indexOf(currentTabKey);
        if (currentIdx < 0) {
            return true;
        }
        return this.syncCheckAttRecordModel(view, currentTabKey);
    }

    private void updateTabName(IFormView view, String tabKey) {
        String tabName = "";
        List<AttConfirmRecordModel> cacheRecords = AttConfirmFormHelper.getInstance().getCacheAttConfirmRecord(view);
        for (AttConfirmRecordModel record : cacheRecords) {
            if (!tabKey.equals(String.valueOf(record.getId()))) continue;
            tabName = this.getTabNameWithRecord(record, false);
            break;
        }
        HashMap<String, LocaleString> map = new HashMap<String, LocaleString>();
        map.put("text", new LocaleString(tabName));
        view.updateControlMetadata(tabKey, map);
    }

    public boolean hasAttConfirmRight(String appId, boolean isView) {
        if (WTCStringUtils.isEmpty((String)appId) || "wftask".equals(appId)) {
            appId = "wtss";
        }
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        return permissionService.checkPermission(RequestContext.get().getCurrUserId(), appId, "wtam_attconfirmbill", isView ? "47150e89000000ac" : "4730fc9f000000ad");
    }

    private boolean syncCheckAttRecordModel(IFormView view, String currentRecordId) {
        if (WTCStringUtils.isNotEmpty((String)currentRecordId)) {
            AttConfirmRecordModel currentRecordModel;
            AttConfirmRecordQueryParam queryParam = new AttConfirmRecordQueryParam();
            queryParam.setIds(Collections.singleton(Long.parseLong(currentRecordId)));
            queryParam.setQueryNotEffect(true);
            List currentRecordModels = AttConfirmQueryServiceImpl.getInstance().queryAttConfirmRecordModelList(queryParam);
            if (WTCCollections.isNotEmpty((Collection)currentRecordModels) && (AttConRecordStatusEnum.SEND != (currentRecordModel = (AttConfirmRecordModel)currentRecordModels.get(0)).getStatus() || AttConfirmDataStatusEnum.EFFECT != currentRecordModel.getDataStatus())) {
                String tabName = WTCDateUtils.date2Str((Date)currentRecordModel.getStartDate(), (String)"yyyy-MM-dd");
                if (currentRecordModel.getType() == AttConRecordTypeEnum.BY_PERIOD) {
                    tabName = tabName + "~" + WTCDateUtils.date2Str((Date)currentRecordModel.getEndDate(), (String)"yyyy-MM-dd");
                }
                if (AttConRecordStatusEnum.CONFIRM == currentRecordModel.getStatus() && AttConfirmDataStatusEnum.EFFECT == currentRecordModel.getDataStatus()) {
                    tabName = tabName + WTCSymbolMultiLanguageUtil.getLeftBracketSymbol() + AttConRecordStatusEnum.CONFIRM.getName().loadKDString() + WTCSymbolMultiLanguageUtil.getRightBracketSymbol();
                }
                HashMap<String, LocaleString> map = new HashMap<String, LocaleString>();
                map.put("text", new LocaleString(tabName));
                view.updateControlMetadata(currentRecordId, map);
                this.removeFormWaitConfCache(view, currentRecordId);
                return true;
            }
        }
        return false;
    }

    private void removeFormWaitConfCache(IFormView view, String tabKey) {
        Object confirmSortObj = view.getFormShowParameter().getCustomParam("confirmsort");
        if (!(confirmSortObj instanceof List)) {
            return;
        }
        List confirmSort = (List)confirmSortObj;
        int currentIdx = confirmSort.indexOf(tabKey);
        if (currentIdx < 0) {
            return;
        }
        confirmSort.remove(currentIdx);
        view.getFormShowParameter().setCustomParam("confirmsort", (Object)confirmSort);
        view.cacheFormShowParameter();
    }
}

