/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.business.servicehelper.common;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.sdk.wtc.wtss.business.homepage.ISignAddressReplacePlugin;
import kd.sdk.wtc.wtss.business.homepage.SignAddressChooseEvent;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxyFactory;
import kd.wtc.wtbs.business.mobile.MobileCommonServiceHelper;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.enums.bill.BillTypeEnum;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCMaps;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtp.business.attstateinfo.AttStateInfoService;
import kd.wtc.wtp.common.enums.attconfirm.AttConfirmDataStatusEnum;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordModel;
import kd.wtc.wtss.business.attstatistics.AttConfirmServiceHelper;
import kd.wtc.wtss.business.servicehelper.common.SchemaServiceHelper;
import kd.wtc.wtss.common.dto.DailySource;
import kd.wtc.wtss.common.dto.mobilehome.AbnormalDealMethodModel;
import kd.wtc.wtss.common.dto.mobilehome.AttRecordModel;
import kd.wtc.wtss.common.dto.mobilehome.BillDetailModel;
import kd.wtc.wtss.common.dto.mobilehome.BillModel;
import kd.wtc.wtss.common.dto.mobilehome.CalendarGetDataModel;
import kd.wtc.wtss.common.dto.mobilehome.CardRecordModel;
import kd.wtc.wtss.common.dto.mobilehome.DateStateModel;
import kd.wtc.wtss.common.dto.mobilehome.ExRecordModel;
import kd.wtc.wtss.common.enums.ExTypeIdMappingEnum;
import kd.wtc.wtss.common.utils.WTSSDateUtils;

public class HomePageServiceHelper {
    private static final Log LOG = LogFactory.getLog(HomePageServiceHelper.class);

    private HomePageServiceHelper() {
    }

    public static HomePageServiceHelper getInstance() {
        return Instance.INSTANCE;
    }

    public Map<Long, Tuple<Date, Date>> getAttFileMap(Long userId, Date beginDayOfMonth, Date lastDayOfMonth) {
        if (userId == null || beginDayOfMonth == null || lastDayOfMonth == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5165\u53c2\u5fc5\u987b\u975e\u7a7a", (String)"HomePageServiceHelper_0", (String)"wtc-wtss-business", (Object[])new Object[0]));
        }
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
        attFileQueryParam.setAuthCheck(Boolean.valueOf(false));
        QFilter dateQFilter = HomePageServiceHelper.getDateFilter(beginDayOfMonth, lastDayOfMonth);
        QFilter userIdQfilter = new QFilter("person_id", "=", (Object)userId);
        userIdQfilter.and(dateQFilter);
        attFileQueryParam.setqFilter(userIdQfilter);
        attFileQueryParam.setProperties(this.getNeedQueryColumn());
        Map<Long, List<DynamicObject>> map = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam).stream().collect(Collectors.groupingBy(ob -> ob.getLong("boid")));
        HashMap tupleMap = Maps.newHashMapWithExpectedSize((int)16);
        map.forEach((boid, dynamicObjectList) -> {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjectList.get(0);
            Date startDate = dynamicObject.getDate("startDate");
            Date endDate = dynamicObject.getDate("endDate");
            if (startDate != null && endDate != null) {
                tupleMap.put(boid, new Tuple((Object)startDate, (Object)(lastDayOfMonth.compareTo(endDate) <= 0 ? lastDayOfMonth : endDate)));
            }
        });
        Optional<Map.Entry> optional = tupleMap.entrySet().stream().min(Comparator.comparing(ob -> (Date)((Tuple)ob.getValue()).getKey()));
        if (optional.isPresent()) {
            Map.Entry entry = optional.get();
            Long boid2 = (Long)entry.getKey();
            Date endDate = (Date)((Tuple)entry.getValue()).getValue();
            tupleMap.put(boid2, new Tuple((Object)beginDayOfMonth, (Object)endDate));
        }
        LOG.info("tupleMap info :{}", (Object)tupleMap);
        return tupleMap;
    }

    public Map<Long, Tuple<Date, Date>> getAttFileMapWithEmployeeId(Long employeeId, Date beginDay, Date lastDay) {
        if (employeeId == null || beginDay == null || lastDay == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5165\u53c2\u5fc5\u987b\u975e\u7a7a", (String)"HomePageServiceHelper_0", (String)"wtc-wtss-business", (Object[])new Object[0]));
        }
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
        attFileQueryParam.setAuthCheck(Boolean.valueOf(false));
        QFilter dateQFilter = HomePageServiceHelper.getDateFilter(beginDay, lastDay);
        attFileQueryParam.setEmpPersonSetIds(Collections.singleton(employeeId));
        attFileQueryParam.setqFilter(dateQFilter);
        attFileQueryParam.setProperties(this.getNeedQueryColumn());
        Map<Long, List<DynamicObject>> map = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam).stream().collect(Collectors.groupingBy(ob -> ob.getLong("boid")));
        HashMap tupleMap = Maps.newHashMapWithExpectedSize((int)16);
        map.forEach((boid, dynamicObjectList) -> {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjectList.get(0);
            Date startDate = dynamicObject.getDate("startDate");
            Date endDate = dynamicObject.getDate("endDate");
            if (startDate != null && endDate != null) {
                tupleMap.put(boid, new Tuple((Object)startDate, (Object)(lastDay.compareTo(endDate) <= 0 ? lastDay : endDate)));
            }
        });
        Optional<Map.Entry> optional = tupleMap.entrySet().stream().min(Comparator.comparing(ob -> (Date)((Tuple)ob.getValue()).getKey()));
        if (optional.isPresent()) {
            Map.Entry entry = optional.get();
            Long boid2 = (Long)entry.getKey();
            Date endDate = (Date)((Tuple)entry.getValue()).getValue();
            tupleMap.put(boid2, new Tuple((Object)beginDay, (Object)endDate));
        }
        LOG.info("tupleMap info :{}", (Object)tupleMap);
        return tupleMap;
    }

    public Map<Long, Tuple<Date, Date>> getAllAttFileMapWithEmployeeId(Long employeeId) {
        if (employeeId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5165\u53c2\u5fc5\u987b\u975e\u7a7a", (String)"HomePageServiceHelper_0", (String)"wtc-wtss-business", (Object[])new Object[0]));
        }
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
        attFileQueryParam.setAuthCheck(Boolean.valueOf(false));
        attFileQueryParam.setEmpPersonSetIds(Collections.singleton(employeeId));
        attFileQueryParam.setProperties(this.getNeedQueryColumn());
        Map<Long, List<DynamicObject>> map = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam).stream().collect(Collectors.groupingBy(ob -> ob.getLong("boid")));
        HashMap tupleMap = Maps.newHashMapWithExpectedSize((int)16);
        map.forEach((boid, dynamicObjectList) -> {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjectList.get(0);
            Date startDate = dynamicObject.getDate("startDate");
            Date endDate = dynamicObject.getDate("endDate");
            if (startDate != null && endDate != null) {
                tupleMap.put(boid, new Tuple((Object)startDate, (Object)endDate));
            }
        });
        LOG.info("tupleMap info :{}", (Object)tupleMap);
        return tupleMap;
    }

    private String getNeedQueryColumn() {
        return WTCStringUtils.joinOnComma((String[])new String[]{"boid", "atttag.attendstatus", "endDate", "startDate"});
    }

    private static QFilter getDateFilter(Date startDate, Date endDate) {
        QFilter dateQFilter = new QFilter("endDate", ">=", (Object)startDate);
        dateQFilter.and(new QFilter("startDate", "<=", (Object)endDate));
        return dateQFilter;
    }

    public Map<String, Map<String, Object>> queryScheduleInfoByAttFileBoId(Long attFileBoId, String chooseDay, Set<Long> abnormalConfig) {
        String yearMonth = StringUtils.substring((String)chooseDay, (int)0, (int)7);
        LOG.info("mobilehome getScheduleInfo chooseDay month:{}", (Object)chooseDay);
        return (Map)DispatchServiceHelper.invokeBizService((String)"wtc", (String)"wts", (String)"IScheduleService", (String)"queryScheduleInfoByAttFileBoId", (Object[])new Object[]{attFileBoId, yearMonth, abnormalConfig});
    }

    public Map<String, Map<String, Object>> queryScheduleInfoByUserId(Long userId, String chooseDay, Set<Long> abnormalConfig) {
        String yearMonth = StringUtils.substring((String)chooseDay, (int)0, (int)7);
        LOG.info("mobilehome getScheduleInfo chooseDay month:{},abnormalConfig:{} userId:{}", new Object[]{chooseDay, abnormalConfig, userId});
        return (Map)DispatchServiceHelper.invokeBizService((String)"wtc", (String)"wts", (String)"IScheduleService", (String)"queryScheduleInfoByPersonId", (Object[])new Object[]{userId, yearMonth, abnormalConfig});
    }

    public Map<String, Map<String, Object>> queryScheduleInfoByMultiBo(long personId, Map<Long, Tuple<Date, Date>> attFileMap, String chooseDay, Set<Long> abnormalConfig) {
        String yearMonth = StringUtils.substring((String)chooseDay, (int)0, (int)7);
        LOG.info("mobilehome getScheduleInfo chooseDay month:{},abnormalConfig:{} attFileMap:{}", new Object[]{chooseDay, abnormalConfig, attFileMap});
        return (Map)DispatchServiceHelper.invokeBizService((String)"wtc", (String)"wts", (String)"IScheduleService", (String)"queryScheduleInfoByPersonIdAndFileBoId", (Object[])new Object[]{personId, yearMonth, abnormalConfig, new ArrayList<Long>(attFileMap.keySet())});
    }

    @Deprecated
    public List<DateStateModel> getCalendarData(CalendarGetDataModel getDate, Map<String, Map<String, Object>> scheduleInfo, Map<String, List<DailySource>> dailySourceData) {
        ArrayList<DateStateModel> dateStateModels = new ArrayList<DateStateModel>(getDate.getDateList().size());
        if (HRMapUtils.isEmpty(scheduleInfo)) {
            return dateStateModels;
        }
        for (String calendarDate : getDate.getDateList()) {
            if (!scheduleInfo.containsKey(calendarDate)) continue;
            DateStateModel dateStateModel = new DateStateModel();
            dateStateModel.setDate(calendarDate);
            Map<String, Object> stringObjectMap = scheduleInfo.get(calendarDate);
            this.dealOffData(dateStateModel, stringObjectMap);
            if (dailySourceData != null) {
                List<DailySource> dailySources = dailySourceData.get(calendarDate);
                this.dealBillData(dateStateModel, dailySources);
            }
            dateStateModels.add(dateStateModel);
        }
        return dateStateModels;
    }

    public List<DateStateModel> getCalendarData(Map<Long, Tuple<Date, Date>> tupleMap, CalendarGetDataModel getDate, Map<String, Map<String, Object>> scheduleInfo, Map<String, List<DailySource>> dailySourceData) {
        List<DateStateModel> dateStateModels = this.getCalendarData(getDate, scheduleInfo, dailySourceData);
        Map<Date, Boolean> swShiftMap = this.loadSwShiftBills(tupleMap);
        dateStateModels.forEach(dateModel -> {
            Date date = WTCDateUtils.str2Date((String)dateModel.getDate(), (String)"yyyy-MM-dd");
            if (swShiftMap.containsKey(date) && ((Boolean)swShiftMap.get(date)).booleanValue()) {
                ArrayList<String> billList = dateModel.getBillList();
                if (WTCCollections.isEmpty((Collection)billList)) {
                    billList = new ArrayList<String>();
                }
                billList.add(BillTypeEnum.ADJUSTMENTBILL.getBillName());
                dateModel.setBillList(billList);
            }
        });
        return dateStateModels;
    }

    private Map<Date, Boolean> loadSwShiftBills(Map<Long, Tuple<Date, Date>> tupleMap) {
        if (WTCMaps.isEmpty(tupleMap)) {
            return Collections.EMPTY_MAP;
        }
        Date queryStartDate = null;
        Date queryEndDate = null;
        ArrayList<Long> boIds = new ArrayList<Long>(tupleMap.size());
        for (Map.Entry<Long, Tuple<Date, Date>> attFileEntry : tupleMap.entrySet()) {
            Long boId = attFileEntry.getKey();
            boIds.add(boId);
            Tuple<Date, Date> dateTuple = attFileEntry.getValue();
            Date boBeginDate = (Date)dateTuple.getKey();
            Date boEndDate = (Date)dateTuple.getValue();
            if (boBeginDate != null && (queryStartDate == null || boBeginDate.before(queryStartDate))) {
                queryStartDate = boBeginDate;
            }
            if (boEndDate == null || queryEndDate != null && !boEndDate.after(queryEndDate)) continue;
            queryEndDate = boEndDate;
        }
        QFilter qFilter = new QFilter("billstatus", "=", (Object)"C");
        Map querySwShiftBillMap = (Map)HRMServiceHelper.invokeBizService((String)"wtc", (String)"wts", (String)"ISwsBillService", (String)"querySwsBill", (Object[])new Object[]{boIds, queryStartDate, queryEndDate, qFilter});
        HashMap<Date, Boolean> result = new HashMap<Date, Boolean>();
        for (Map.Entry queryBillEntry : querySwShiftBillMap.entrySet()) {
            List billList = (List)queryBillEntry.getValue();
            for (DynamicObject swBill : billList) {
                DynamicObjectCollection swBillEntry = swBill.getDynamicObjectCollection("entryentity");
                for (DynamicObject swEntry : swBillEntry) {
                    Date swDate = swEntry.getDate("swdate");
                    result.put(swDate, true);
                }
            }
        }
        return result;
    }

    public void dealOffData(DateStateModel dateStateModel, Map<String, Object> stringObjectMap) {
        dateStateModel.setAbnormal(false);
        if (stringObjectMap == null) {
            dateStateModel.setHoliday("");
            dateStateModel.setDateAttribute("");
            dateStateModel.setOff(false);
            return;
        }
        Object holidaynameset = stringObjectMap.get("holidaynameset");
        if (holidaynameset != null) {
            dateStateModel.setHoliday((String)((Set)holidaynameset).toArray()[0]);
        }
        dateStateModel.setDateAttribute(this.getDateAttribute((String)stringObjectMap.get("dateattributecode")));
        dateStateModel.setOff(((Boolean)stringObjectMap.get("isoff")).booleanValue());
        dateStateModel.setAbnormal(((Boolean)stringObjectMap.get("isexception")).booleanValue());
    }

    public void dealBillData(DateStateModel dateStateModel, List<DailySource> dailySources) {
        if (!CollectionUtils.isEmpty(dailySources)) {
            dailySources.sort(Comparator.comparingInt(DailySource::getIndex));
            LOG.info("mobilehome dealBillData dailySources:{}", (Object)SerializationUtils.toJsonString(dailySources));
            ArrayList<String> billList = new ArrayList<String>(16);
            block0: for (DailySource dailySource : dailySources) {
                if (StringUtils.equals((CharSequence)dailySource.getBusClassifyNo(), (CharSequence)"1") || StringUtils.equals((CharSequence)dailySource.getBusClassifyNo(), (CharSequence)"5")) continue;
                for (DailySource.AttItem attItem : dailySource.getAttItems()) {
                    if (BigDecimal.ZERO.compareTo(attItem.getAttItemValue()) == 0) continue;
                    billList.add(dailySource.getBusClassify());
                    continue block0;
                }
            }
            dateStateModel.setBillList(billList);
        }
    }

    public String getDateAttribute(String dateAttributeCode) {
        if (StringUtils.equals((CharSequence)"DS-0002", (CharSequence)dateAttributeCode)) {
            return "OFFDAY";
        }
        if (StringUtils.equals((CharSequence)"DS-0003", (CharSequence)dateAttributeCode)) {
            return "HOLIDAY";
        }
        return "WORKDAY";
    }

    private static boolean hasAbnormalForPreDateOrNextDate(List<Map<String, String>> exInfoByPersonDay, Map<String, Object> signCardDetail) {
        String offShift;
        if (CollectionUtils.isEmpty(exInfoByPersonDay)) {
            return false;
        }
        List punchcardPointList = exInfoByPersonDay.stream().map(param -> (String)param.get("punchcardPoint")).collect(Collectors.toList());
        String punchcardPointStr = String.join((CharSequence)",", punchcardPointList);
        if (signCardDetail.get("offshift") != null && StringUtils.equals((CharSequence)(offShift = (String)signCardDetail.get("offshift")), (CharSequence)"false")) {
            List shiftList = (List)signCardDetail.get("shift");
            if (CollectionUtils.isEmpty((Collection)shiftList)) {
                return false;
            }
            for (Map map : shiftList) {
                String end;
                String start = WTSSDateUtils.getYYYYMMDDHHMM((String)((String)map.get("start")));
                if (!StringUtils.containsAny((CharSequence)punchcardPointStr, (CharSequence[])new CharSequence[]{start, end = WTSSDateUtils.getYYYYMMDDHHMM((String)((String)map.get("end")))})) continue;
                return true;
            }
        }
        return false;
    }

    public void setData(Map<String, Object> data, List<AttRecordModel> attRecordModel, String date, Long employeeId) {
        this.setData(data, attRecordModel, date);
        Date chooseDate = WTCDateUtils.str2Date((String)date, (String)"yyyy-MM-dd");
        Map<Long, Tuple<Date, Date>> attFileMap = this.getAttFileMapWithEmployeeId(employeeId, chooseDate, chooseDate);
        List attStateInfoDys = AttStateInfoService.getInstance().queryAttStateInfo(attFileMap.keySet());
        Optional<DynamicObject> accountToOptional = attStateInfoDys.stream().filter(dy -> dy.containsProperty("accountto") && dy.get("accountto") != null && dy.get("accountto") instanceof Date).max(Comparator.comparing(dy -> dy.getDate("accountto")));
        if (accountToOptional.isPresent()) {
            DynamicObject attStateInfo = accountToOptional.get();
            Date accountTo = attStateInfo.getDate("accountto");
            if (accountTo == null || chooseDate == null || !accountTo.after(chooseDate)) {
                data.put("abnormal", null);
            }
        } else {
            data.put("abnormal", null);
        }
    }

    @Deprecated
    public void setData(Map<String, Object> data, List<AttRecordModel> attRecordModel, String date) {
        Optional<AttRecordModel> first;
        data.put("chosedate", date);
        List details = new ArrayList();
        if (CollectionUtils.isNotEmpty(attRecordModel) && (first = attRecordModel.stream().filter(att -> att.getDate().equals(date)).findFirst()).isPresent()) {
            details = first.get().getDetails();
        }
        data.put("details", details);
        Optional<AttRecordModel> abnormal = attRecordModel.stream().filter(e -> e.isAbnormal()).findAny();
        data.put("abnormal", abnormal.isPresent());
    }

    private Map<Long, Map<String, Date>> getSignReq(Map<Long, Tuple<Date, Date>> tupleMap) {
        HashMap reqMap = Maps.newHashMapWithExpectedSize((int)16);
        tupleMap.forEach((boid, entry) -> {
            Map map = reqMap.computeIfAbsent(boid, key -> new HashMap());
            map.put("startdate", entry.getKey());
            map.put("enddate", entry.getValue());
        });
        return reqMap;
    }

    @Deprecated
    public List<AttRecordModel> getSignCardDetail(Long userId, Long schemeId, String date, String isFromTeam, String dateState, boolean isMobileClient, String dailySourceStr) {
        Date preDate = WTCDateUtils.getCustomDate((Date)WTCDateUtils.str2Date((String)date, (String)"yyyy-MM-dd"), (Integer)-1);
        Date nextDate = WTCDateUtils.getCustomDate((Date)WTCDateUtils.str2Date((String)date, (String)"yyyy-MM-dd"), (Integer)1);
        Map<Long, Tuple<Date, Date>> tupleMap = HomePageServiceHelper.getInstance().getAttFileMap(userId, preDate, nextDate);
        Map<Long, Map<String, Date>> reqMap = this.getSignReq(tupleMap);
        ArrayList attRecordModelList = Lists.newArrayListWithExpectedSize((int)16);
        Map resMap = (Map)DispatchServiceHelper.invokeBizService((String)"wtc", (String)"wtpm", (String)"ISignCardService", (String)"getSignCardDetailByAttFileBoIds", (Object[])new Object[]{reqMap});
        if (resMap == null || resMap.size() == 0) {
            return attRecordModelList;
        }
        HashMap signCardDetailMap = Maps.newHashMapWithExpectedSize((int)16);
        resMap.forEach((boid, entry) -> signCardDetailMap.putAll(entry));
        LOG.info("getSignCardDetailByAttFileBoIds signCardDetailMap:{}", (Object)signCardDetailMap);
        Set<Long> abnormalConfig = SchemaServiceHelper.getInstance().getAbnormalConfig(schemeId, "A");
        LOG.info("mobilehome getSignCardDetail getExInfoByPersonDay begin... abnormalConfig:{}", abnormalConfig);
        Date curDate = WTCDateUtils.str2Date((String)date, (String)"yyyy-MM-dd");
        List<Map<String, String>> exInfoByPersonDay = Lists.newArrayListWithExpectedSize((int)16);
        LOG.info("mobilehome getExInfoByAttFileBidDay begin... curDate:{}, tupleMap:{}", (Object)curDate, tupleMap);
        for (Map.Entry<Long, Tuple<Date, Date>> entry2 : tupleMap.entrySet()) {
            Tuple<Date, Date> tuple = entry2.getValue();
            if (((Date)tuple.getKey()).compareTo(curDate) > 0 || ((Date)tuple.getValue()).compareTo(curDate) < 0) continue;
            exInfoByPersonDay = MobileCommonServiceHelper.getInstance().getExInfoByAttFileBidDay(entry2.getKey(), date, abnormalConfig);
            break;
        }
        boolean isCanDealAbnormal = !CollectionUtils.isEmpty((Collection)exInfoByPersonDay) && StringUtils.equals((CharSequence)"0", (CharSequence)isFromTeam);
        for (Map.Entry dateMapEntry : signCardDetailMap.entrySet()) {
            Date queryDate = (Date)dateMapEntry.getKey();
            Map signCardDetail = (Map)dateMapEntry.getValue();
            if ((queryDate.compareTo(preDate) == 0 || queryDate.compareTo(nextDate) == 0) && signCardDetail != null && !HomePageServiceHelper.hasAbnormalForPreDateOrNextDate(exInfoByPersonDay, signCardDetail)) continue;
            AttRecordModel attRecordModel = new AttRecordModel();
            attRecordModel.setDate(WTCDateUtils.date2Str((Date)queryDate, (String)"yyyy-MM-dd"));
            attRecordModel.setAbnormal((CollectionUtils.isEmpty((Collection)exInfoByPersonDay) ? Boolean.FALSE : Boolean.TRUE).booleanValue());
            if (isCanDealAbnormal) {
                LOG.info("mobilehome getSignCardDetail exInfoByPersonDay:{}", (Object)SerializationUtils.toJsonString((Object)exInfoByPersonDay));
                String exProcess = (String)((Map)exInfoByPersonDay.get(0)).get("exProcess");
                this.setExProcess(attRecordModel, exProcess);
            }
            if (signCardDetail != null) {
                this.getSignCardRecord(signCardDetail, date, attRecordModel, exInfoByPersonDay, dateState);
                this.replaceSignAddress(attRecordModel);
            }
            if (isMobileClient && queryDate.compareTo(WTCDateUtils.str2Date((String)date, (String)"yyyy-MM-dd")) == 0) {
                this.setDailyDetailData(dailySourceStr, attRecordModel, date);
            }
            attRecordModelList.add(attRecordModel);
        }
        return attRecordModelList;
    }

    public List<AttRecordModel> getSignCardDetailWithEmployeeId(Long employeeId, Long schemeId, String date, String isFromTeam, String dateState, boolean isMobileClient, String dailySourceStr) {
        Date preDate = WTCDateUtils.getCustomDate((Date)WTCDateUtils.str2Date((String)date, (String)"yyyy-MM-dd"), (Integer)-1);
        Date nextDate = WTCDateUtils.getCustomDate((Date)WTCDateUtils.str2Date((String)date, (String)"yyyy-MM-dd"), (Integer)1);
        Map<Long, Tuple<Date, Date>> tupleMap = this.getAttFileMapWithEmployeeId(employeeId, preDate, nextDate);
        Map<Long, Map<String, Date>> reqMap = this.getSignReq(tupleMap);
        ArrayList attRecordModelList = Lists.newArrayListWithExpectedSize((int)16);
        Map resMap = (Map)DispatchServiceHelper.invokeBizService((String)"wtc", (String)"wtpm", (String)"ISignCardService", (String)"getSignCardDetailByAttFileBoIds", (Object[])new Object[]{reqMap});
        if (resMap == null || resMap.size() == 0) {
            return attRecordModelList;
        }
        HashMap signCardDetailMap = Maps.newHashMapWithExpectedSize((int)16);
        resMap.forEach((boid, entry) -> signCardDetailMap.putAll(entry));
        LOG.info("getSignCardDetailByAttFileBoIds signCardDetailMap:{}", (Object)signCardDetailMap);
        Set<Long> abnormalConfig = SchemaServiceHelper.getInstance().getAbnormalConfig(schemeId, "A");
        LOG.info("mobilehome getSignCardDetail getExInfoByPersonDay begin... abnormalConfig:{}", abnormalConfig);
        Date curDate = WTCDateUtils.str2Date((String)date, (String)"yyyy-MM-dd");
        List exInfoByPersonDay = Lists.newArrayListWithExpectedSize((int)16);
        LOG.info("mobilehome getExInfoByAttFileBidDay begin... curDate:{}, tupleMap:{}", (Object)curDate, tupleMap);
        for (Map.Entry<Long, Tuple<Date, Date>> entry2 : tupleMap.entrySet()) {
            Tuple<Date, Date> tuple = entry2.getValue();
            if (((Date)tuple.getKey()).compareTo(curDate) > 0 || ((Date)tuple.getValue()).compareTo(curDate) < 0) continue;
            exInfoByPersonDay = MobileCommonServiceHelper.getInstance().getExInfoByAttFileBidDay(entry2.getKey(), date, abnormalConfig);
            break;
        }
        boolean isCanDealAbnormal = !CollectionUtils.isEmpty((Collection)exInfoByPersonDay) && StringUtils.equals((CharSequence)"0", (CharSequence)isFromTeam);
        for (Map.Entry dateMapEntry : signCardDetailMap.entrySet()) {
            Date queryDate = (Date)dateMapEntry.getKey();
            Map signCardDetail = (Map)dateMapEntry.getValue();
            if ((queryDate.compareTo(preDate) == 0 || queryDate.compareTo(nextDate) == 0) && signCardDetail != null && !HomePageServiceHelper.hasAbnormalForPreDateOrNextDate(exInfoByPersonDay, signCardDetail)) continue;
            AttRecordModel attRecordModel = new AttRecordModel();
            attRecordModel.setDate(WTCDateUtils.date2Str((Date)queryDate, (String)"yyyy-MM-dd"));
            attRecordModel.setAbnormal((CollectionUtils.isEmpty((Collection)exInfoByPersonDay) ? Boolean.FALSE : Boolean.TRUE).booleanValue());
            if (isCanDealAbnormal) {
                LOG.info("mobilehome getSignCardDetail exInfoByPersonDay:{}", (Object)SerializationUtils.toJsonString(exInfoByPersonDay));
                String exProcess = (String)((Map)exInfoByPersonDay.get(0)).get("exProcess");
                this.setExProcess(attRecordModel, exProcess);
            }
            List nonNormalExs = exInfoByPersonDay.stream().filter(exDy -> !"1".equals(exDy.get("filtertype"))).map(ex -> new ExRecordModel(ex, Boolean.valueOf(isCanDealAbnormal))).collect(Collectors.toList());
            attRecordModel.setNonNormalAbnormal(WTCCollections.isNotEmpty(nonNormalExs));
            attRecordModel.setNonNormalAbnormalList(nonNormalExs);
            if (signCardDetail != null) {
                this.getSignCardRecord(signCardDetail, date, attRecordModel, exInfoByPersonDay.stream().filter(exDy -> "1".equals(exDy.get("filtertype"))).collect(Collectors.toList()), dateState);
                this.replaceSignAddress(attRecordModel);
            }
            if (isMobileClient && queryDate.compareTo(WTCDateUtils.str2Date((String)date, (String)"yyyy-MM-dd")) == 0) {
                this.setDailyDetailData(dailySourceStr, attRecordModel, date);
            }
            attRecordModelList.add(attRecordModel);
        }
        return attRecordModelList;
    }

    public void setAttConfirmByDate(Map<String, Object> returnDate, Long employeeId, Date date) {
        Map<Long, Tuple<Date, Date>> attFileTuple = this.getAllAttFileMapWithEmployeeId(employeeId);
        AttConfirmRecordModel attConfirmRecord = AttConfirmServiceHelper.instance().getAttConfirmWithDate(attFileTuple.keySet(), date);
        if (attConfirmRecord != null) {
            returnDate.put("attConfirmId", String.valueOf(attConfirmRecord.getId()));
            if (attConfirmRecord.getStatus() != null) {
                returnDate.put("attConfirmStatus", attConfirmRecord.getStatus().getCode());
            }
            if (AttConfirmDataStatusEnum.INVALID.equals((Object)attConfirmRecord.getDataStatus())) {
                returnDate.put("attConfirmStatus", AttConfirmDataStatusEnum.INVALID.getCode());
            }
        }
    }

    private void setExProcess(AttRecordModel attRecordModel, String exProcess) {
        LOG.info("mobilehome setExProcess exProcess:{}", (Object)exProcess);
        if (StringUtils.isEmpty((CharSequence)exProcess)) {
            return;
        }
        String[] split = StringUtils.split((String)exProcess, (String)",");
        ArrayList<AbnormalDealMethodModel> abnormalDealMethods = new ArrayList<AbnormalDealMethodModel>(split.length);
        for (String process : split) {
            AbnormalDealMethodModel abnormalDealMethodModel = new AbnormalDealMethodModel();
            abnormalDealMethodModel.setAbnormalMethodMethod(process);
            abnormalDealMethods.add(abnormalDealMethodModel);
        }
        attRecordModel.setAbnormalDealMethods(abnormalDealMethods);
    }

    private void getAbnormalData(CardRecordModel cardRecordModel, List<Map<String, String>> exInfoByPersonDay, String startTime, String endTime) {
        for (Map<String, String> exInfo : exInfoByPersonDay) {
            String punchcardPoint = exInfo.get("punchcardPoint");
            String exType = exInfo.get("exType");
            String cardStatus = ExTypeIdMappingEnum.getDesc((String)exType);
            if (StringUtils.equals((CharSequence)punchcardPoint, (CharSequence)startTime)) {
                cardRecordModel.setWorkCardStatus(cardStatus);
                continue;
            }
            if (StringUtils.equals((CharSequence)punchcardPoint, (CharSequence)endTime)) {
                cardRecordModel.setOffCardStatus(cardStatus);
                continue;
            }
            if (!StringUtils.contains((CharSequence)punchcardPoint, (CharSequence)",")) continue;
            if (StringUtils.contains((CharSequence)punchcardPoint, (CharSequence)startTime)) {
                cardRecordModel.setWorkCardStatus(cardStatus);
            }
            if (!StringUtils.contains((CharSequence)punchcardPoint, (CharSequence)endTime)) continue;
            cardRecordModel.setOffCardStatus(cardStatus);
        }
    }

    public void setDailyDetailData(String dailySourceStr, AttRecordModel attRecordModel, String date) {
        LOG.info("mobilehome setDailyDetailData data:{}", (Object)date);
        ArrayList<BillModel> details = new ArrayList<BillModel>();
        if (!StringUtils.isEmpty((CharSequence)dailySourceStr)) {
            Map dailySourceData = (Map)SerializationUtils.deSerializeFromBase64((String)dailySourceStr);
            LOG.info("mobilehome setDailyDetailData dailySourceData:{}", (Object)dailySourceData);
            List dailySources = (List)dailySourceData.get(date);
            if (!CollectionUtils.isEmpty((Collection)dailySources)) {
                dailySources.sort(Comparator.comparingInt(DailySource::getIndex));
                for (DailySource dailySource : dailySources) {
                    BillModel billModel = new BillModel();
                    billModel.setBillType(dailySource.getBusClassify());
                    billModel.setBillTypeCode(dailySource.getBusClassifyType());
                    List attItems = dailySource.getAttItems();
                    if (!CollectionUtils.isEmpty((Collection)attItems)) {
                        ArrayList<BillDetailModel> billList = new ArrayList<BillDetailModel>(attItems.size());
                        for (DailySource.AttItem attItem : attItems) {
                            if (attItem.getAttItemValue() == null || BigDecimal.ZERO.compareTo(attItem.getAttItemValue()) == 0) continue;
                            BillDetailModel billDetailModel = new BillDetailModel();
                            billDetailModel.setBill(attItem.getAttItemName());
                            billDetailModel.setDuration(attItem.getAttItemValue().toPlainString().concat(attItem.getUnit()));
                            billList.add(billDetailModel);
                        }
                        billModel.setBillList(billList);
                    }
                    if (!CollectionUtils.isNotEmpty((Collection)billModel.getBillList())) continue;
                    details.add(billModel);
                }
            }
        }
        attRecordModel.setDetails(details);
    }

    private void setExistAtt(String dateState, AttRecordModel attRecordModel, int abnormalSize) {
        attRecordModel.setExistAtt(true);
        if (!StringUtils.isEmpty((CharSequence)dateState)) {
            LOG.info("mobilehome dateState {}", (Object)dateState);
            List dateStateModels = (List)SerializationUtils.deSerializeFromBase64((String)dateState);
            for (DateStateModel dateStateModel : dateStateModels) {
                if (!StringUtils.equals((CharSequence)dateStateModel.getDate(), (CharSequence)attRecordModel.getDate()) || !dateStateModel.isOff() || !"HOLIDAY".equals(dateStateModel.getDateAttribute()) && !"OFFDAY".equals(dateStateModel.getDateAttribute())) continue;
                LOG.info("mobilehome offday");
                List cardRecords = attRecordModel.getCardRecord();
                boolean flagCard = true;
                if (!CollectionUtils.isEmpty((Collection)cardRecords)) {
                    for (CardRecordModel cardRecordModel : cardRecords) {
                        if (StringUtils.isEmpty((CharSequence)cardRecordModel.getWorkCardTime()) && StringUtils.isEmpty((CharSequence)cardRecordModel.getOffCardTime())) continue;
                        LOG.info("mobilehome flagCard false");
                        flagCard = false;
                    }
                }
                if (!flagCard || abnormalSize != 0) continue;
                LOG.info("mobilehome isExistAtt false");
                attRecordModel.setExistAtt(false);
            }
        }
        LOG.info("mobilehome isExistAtt {}", (Object)attRecordModel.isExistAtt());
    }

    private void getSignCardRecord(Map<String, Object> signCardDetail, String date, AttRecordModel attRecordModel, List<Map<String, String>> exInfoByPersonDay, String dateState) {
        CardRecordModel cardRecordModel;
        LOG.info("mobilehome getSignCardDetail :{} date:{}", (Object)SerializationUtils.toJsonString(signCardDetail), (Object)date);
        String cartType = (String)signCardDetail.get("type");
        attRecordModel.setCardType(cartType);
        List shiftList = (List)signCardDetail.get("shift");
        String offShift = "false";
        if (signCardDetail.get("offshift") != null) {
            offShift = (String)signCardDetail.get("offshift");
        }
        if (StringUtils.equals((CharSequence)cartType, (CharSequence)"1")) {
            List signList = (List)signCardDetail.get("sign");
            if (!CollectionUtils.isEmpty((Collection)signList)) {
                ArrayList<CardRecordModel> cardRecordModels = new ArrayList<CardRecordModel>(signList.size());
                for (int index = 0; index < signList.size(); ++index) {
                    String hassignedoff;
                    String hassignedon;
                    cardRecordModel = new CardRecordModel();
                    Map sign = (Map)signList.get(index);
                    if (StringUtils.equals((CharSequence)offShift, (CharSequence)"false")) {
                        Map shift = (Map)shiftList.get(index);
                        String startTime = WTSSDateUtils.getYYYYMMDDHHMM((String)((String)shift.get("start")));
                        String endTime = WTSSDateUtils.getYYYYMMDDHHMM((String)((String)shift.get("end")));
                        cardRecordModel.setWorkShouldCardTime((String)shift.get("start"));
                        cardRecordModel.setOffShouldCardTime((String)shift.get("end"));
                        this.getAbnormalData(cardRecordModel, exInfoByPersonDay, startTime, endTime);
                    }
                    if (StringUtils.equals((CharSequence)"true", (CharSequence)(hassignedon = (String)sign.get("hassignedon")))) {
                        cardRecordModel.setWorkCardTime(WTSSDateUtils.getNeedTime((String)((String)sign.get("signon"))));
                        cardRecordModel.setWorkCardPosition((String)sign.get("signonaddress"));
                    }
                    if (StringUtils.equals((CharSequence)"true", (CharSequence)(hassignedoff = (String)sign.get("hassignedoff")))) {
                        cardRecordModel.setOffCardTime(WTSSDateUtils.getNeedTime((String)((String)sign.get("signoff"))));
                        cardRecordModel.setOffCardPosition((String)sign.get("signoffaddress"));
                    }
                    String needsignon = (String)sign.get("needsignon");
                    String needsignoff = (String)sign.get("needsignoff");
                    cardRecordModel.setPreSetBiz1((String)sign.get("presetbiz1"));
                    cardRecordModel.setPreSetBiz2((String)sign.get("presetbiz2"));
                    cardRecordModel.setWorkCardShould(Boolean.parseBoolean(needsignon));
                    cardRecordModel.setOffCardShould(Boolean.parseBoolean(needsignoff));
                    cardRecordModels.add(cardRecordModel);
                }
                attRecordModel.setCardRecord(cardRecordModels);
            } else {
                attRecordModel.setCardRecord(this.getShouldCardRecord(shiftList, exInfoByPersonDay));
            }
        } else if (StringUtils.equals((CharSequence)cartType, (CharSequence)"2")) {
            String signString = (String)signCardDetail.get("sign");
            String addressString = (String)signCardDetail.get("signaddress");
            ArrayList<CardRecordModel> cardRecordModels = new ArrayList<CardRecordModel>(1);
            cardRecordModel = new CardRecordModel();
            if (StringUtils.equals((CharSequence)offShift, (CharSequence)"false")) {
                Map shift = (Map)shiftList.get(0);
                String startTime = WTSSDateUtils.getYYYYMMDDHHMM((String)((String)shift.get("start")));
                String endTime = WTSSDateUtils.getYYYYMMDDHHMM((String)((String)shift.get("end")));
                this.getAbnormalData(cardRecordModel, exInfoByPersonDay, startTime, endTime);
                if (!StringUtils.isEmpty((CharSequence)signString)) {
                    cardRecordModel.setWorkCardTime(WTSSDateUtils.getNeedTime((String)signString));
                }
                if (!StringUtils.isEmpty((CharSequence)addressString)) {
                    cardRecordModel.setWorkCardPosition(addressString);
                }
            }
            cardRecordModel.setPreSetBiz1((String)signCardDetail.get("presetbiz1"));
            cardRecordModel.setPreSetBiz2((String)signCardDetail.get("presetbiz2"));
            cardRecordModels.add(cardRecordModel);
            attRecordModel.setCardRecord(cardRecordModels);
        }
        this.setExistAtt(dateState, attRecordModel, CollectionUtils.isEmpty(exInfoByPersonDay) ? 0 : exInfoByPersonDay.size());
        if (!CollectionUtils.isEmpty((Collection)shiftList)) {
            ArrayList<String> shiftPeriod = new ArrayList<String>(shiftList.size());
            for (Map shift : shiftList) {
                String start = (String)shift.get("start");
                String end = (String)shift.get("end");
                shiftPeriod.add(WTSSDateUtils.getNeedTime((String)start).concat("-").concat(WTSSDateUtils.getNeedTime((String)end)));
            }
            attRecordModel.setShiftPeriod(shiftPeriod);
        }
        attRecordModel.setShiftName((String)signCardDetail.get("shiftname"));
    }

    private void replaceSignAddress(AttRecordModel attRecordModel) {
        SignAddressChooseEvent param = new SignAddressChooseEvent();
        WTCPluginProxy instance = WTCPluginProxyFactory.create(ISignAddressReplacePlugin.class, (String)"kd.sdk.wtc.wtss.business.homepage.ISignAddressReplacePlugin");
        instance.invokeReplace(plugin -> {
            if (LOG.isInfoEnabled()) {
                LOG.info("HomPage,\u3010\u4e8c\u5f00\u57cb\u70b9\u3011\u66ff\u6362\u8003\u52e4\u5730\u70b9\u5f00\u59cb,\u8c03\u7528\u6269\u5c55\u7c7b\uff1a{}", (Object)plugin.getClass().getName());
            }
            plugin.replaceSignAddress(param);
        });
        Boolean useSignAddressReplacePlugin = WTCCollections.isNotEmpty((Collection)instance.getPlugins());
        if (useSignAddressReplacePlugin.booleanValue() && CollectionUtils.isNotEmpty((Collection)attRecordModel.getCardRecord())) {
            SignAddressChooseEvent.ChoosePreSetBiz signAddressReplaceColumn = param.getUseColumn() == null ? null : param.getUseColumn();
            for (CardRecordModel cardRecordModel : attRecordModel.getCardRecord()) {
                String replaceAddressStr;
                String string = signAddressReplaceColumn == null ? "" : (replaceAddressStr = signAddressReplaceColumn == SignAddressChooseEvent.ChoosePreSetBiz.PRESETBIZ1 ? cardRecordModel.getPreSetBiz1() : cardRecordModel.getPreSetBiz2());
                if (StringUtils.isNotBlank((CharSequence)cardRecordModel.getWorkCardTime())) {
                    cardRecordModel.setWorkCardPosition(replaceAddressStr);
                }
                if (!StringUtils.isNotBlank((CharSequence)cardRecordModel.getOffCardTime())) continue;
                cardRecordModel.setOffCardPosition(replaceAddressStr);
            }
        }
    }

    private List<CardRecordModel> getShouldCardRecord(List<Map<String, Object>> shiftList, List<Map<String, String>> exInfoByPersonDay) {
        ArrayList<CardRecordModel> cardRecordModels = new ArrayList<CardRecordModel>(shiftList.size());
        for (Map<String, Object> shiftMap : shiftList) {
            CardRecordModel recordModel = new CardRecordModel();
            String startWorkTime = (String)shiftMap.get("start");
            String endWorkTime = (String)shiftMap.get("end");
            boolean isWorkTimeEnd = Boolean.parseBoolean((String)shiftMap.get("isWorkTimeEnd"));
            boolean isWorkTimeStart = Boolean.parseBoolean((String)shiftMap.get("isWorkTimeStart"));
            recordModel.setWorkShouldCardTime(startWorkTime);
            recordModel.setOffShouldCardTime(endWorkTime);
            recordModel.setWorkCardShould(isWorkTimeStart);
            recordModel.setOffCardShould(isWorkTimeEnd);
            this.getAbnormalData(recordModel, exInfoByPersonDay, WTSSDateUtils.getYYYYMMDDHHMM((String)startWorkTime), WTSSDateUtils.getYYYYMMDDHHMM((String)endWorkTime));
            cardRecordModels.add(recordModel);
        }
        return cardRecordModels;
    }

    private static class Instance {
        private static final HomePageServiceHelper INSTANCE = new HomePageServiceHelper();

        private Instance() {
        }
    }
}

