/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.business.servicehelper.common;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntryType;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.business.web.mservice.HRPIMServiceImpl;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCMaps;
import kd.wtc.wtbs.common.util.third.collect.ImmutableMap;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;
import kd.wtc.wtp.business.cumulate.trading.QTLineDetailOuterService;
import kd.wtc.wtp.common.model.personhome.QuotaIndexQueryDto;
import kd.wtc.wtp.common.model.teamhome.PersonInfoDto;
import kd.wtc.wtp.common.model.teamhome.TeamQuotaIndexQueryDto;
import kd.wtc.wtss.business.servicehelper.common.HomePageServiceHelper;
import kd.wtc.wtss.business.servicehelper.common.SchemaServiceHelper;
import kd.wtc.wtss.business.servicehelper.common.TeamHomeServiceHelper;
import kd.wtc.wtss.common.dto.DailySource;
import kd.wtc.wtss.common.enums.UnitDataEnum;

public class QuotaStatisticIndexService {
    private static final Log LOG = LogFactory.getLog(QuotaStatisticIndexService.class);
    private static final QuotaStatisticIndexService INS = (QuotaStatisticIndexService)WTCAppContextHelper.getBean(QuotaStatisticIndexService.class);
    public static final Map<String, Object> CUSTOM_MAP = ImmutableMap.of((Object)"w", (Object)ImmutableMap.of((Object)Lang.zh_CN.toString(), (Object)"170px"));

    public static QuotaStatisticIndexService getInstance() {
        return INS;
    }

    public void setQuotaDetail(long schemeId, Long userId, Date date, IFormView view, String scene) {
        LOG.info("QuotaStatisticIndexService.setQuotaDetail schemeId={}, userId={}, date={}, scene={}", new Object[]{schemeId, userId, date, scene});
        if (schemeId == 0L || userId == 0L || date == null) {
            view.getModel().deleteEntryData("qtentryentitycount");
            return;
        }
        Map<String, Object> quotaSourcesMap = SchemaServiceHelper.getInstance().getQTDataSourceByScheme(schemeId, "A", userId, scene);
        List showQuotaSources = (List)quotaSourcesMap.get("showList");
        if (CollectionUtils.isEmpty((Collection)showQuotaSources)) {
            view.setVisible(Boolean.FALSE, new String[]{"qttabpage"});
            return;
        }
        view.setVisible(Boolean.TRUE, new String[]{"qttabpage"});
        Map<Long, List> indexIdAndAttItemIdList = showQuotaSources.stream().collect(Collectors.toMap(DailySource::getDatasoureId, source -> source.getAttItems().stream().map(DailySource.AttItem::getAttItemId).collect(Collectors.toList()), (oldValue, value) -> oldValue));
        QuotaIndexQueryDto dto = new QuotaIndexQueryDto();
        dto.setPersonId(userId);
        dto.setEndDate(WTCDateUtils.getEndDayOfYear((Date)date));
        dto.setStartDate(WTCDateUtils.getBeginDayOfYear((Date)date));
        dto.setIndexIdAndAttItemIdListMap(indexIdAndAttItemIdList);
        QTLineDetailOuterService.queryByQuotaIndexQueryDto((QuotaIndexQueryDto)dto);
        LOG.info("QTLineDetailOuterService.queryByQuotaIndexQueryDto end dto:{}", (Object)SerializationUtils.toJsonString((Object)dto));
        DynamicObjectCollection dynamicObjects = view.getModel().getDataEntity(true).getDynamicObjectCollection("qtentryentitycount");
        EntryType entryType = (EntryType)dynamicObjects.getDynamicObjectType();
        view.getModel().deleteEntryData("qtentryentitycount");
        Map indexIdAndValueMap = dto.getIndexIdAndValueMap();
        Map indexIdAndQuotaDetailIdListMap = dto.getIndexIdAndQuotaDetailIdListMap();
        IPageCache pageCache = view.getPageCache();
        for (DailySource dailySource : showQuotaSources) {
            long quotaSourceId = dailySource.getDatasoureId();
            BigDecimal value2 = (BigDecimal)indexIdAndValueMap.get(quotaSourceId);
            DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)entryType);
            value2 = value2 == null ? new BigDecimal(0) : value2;
            String attDataSourceValueStr = value2.setScale(2, 4).stripTrailingZeros().toPlainString();
            dynamicObject.set("datasouvalueqt", (Object)attDataSourceValueStr);
            String unitStr = UnitDataEnum.getRetDesc((String)dailySource.getDatasoureUnit());
            if (unitStr == null || unitStr.equals("")) {
                dynamicObject.set("datasounameqt", (Object)dailySource.getDatasoureName());
            } else {
                dynamicObject.set("datasounameqt", (Object)(dailySource.getDatasoureName() + "(" + unitStr + ")"));
            }
            Set quotaDetailIdSet = (Set)indexIdAndQuotaDetailIdListMap.get(quotaSourceId);
            pageCache.put(quotaSourceId + "", JSON.toJSONString((Object)quotaDetailIdSet));
            dynamicObject.set("quotasourceid", (Object)quotaSourceId);
            dynamicObjects.add((Object)dynamicObject);
        }
        view.updateView("qtentryentitycount");
    }

    public void setQuotaDetail(long schemeId, Long userId, Date date, IFormView view, String scene, Long employeeId) {
        Map<String, Object> quotaSourcesMap;
        List showQuotaSources;
        LOG.info("QuotaStatisticIndexService.setQuotaDetail schemeId={}, userId={}, date={}, scene={}, employeeId={}", new Object[]{schemeId, userId, date, scene, employeeId});
        if (schemeId == 0L || userId == 0L || date == null || employeeId == null) {
            view.getModel().deleteEntryData("qtentryentitycount");
            return;
        }
        Map<Long, Tuple<Date, Date>> attFileMap = HomePageServiceHelper.getInstance().getAttFileMapWithEmployeeId(employeeId, WTCDateUtils.getBeginDayOfYear((Date)date), WTCDateUtils.getEndDayOfYear((Date)date));
        if (WTCMaps.isEmpty(attFileMap)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u5df2\u9009\u65e5\u671f\u8303\u56f4\u5185\u65e0\u6b63\u5e38\u8003\u52e4\u7684\u8003\u52e4\u6863\u6848\u3002", (String)"SchemaServiceHelper_0", (String)"wtc-wtss-business", (Object[])new Object[0]));
        }
        if (CollectionUtils.isEmpty((Collection)(showQuotaSources = (List)(quotaSourcesMap = SchemaServiceHelper.getInstance().getQTDataSourceByScheme(schemeId, "A", userId, scene)).get("showList")))) {
            view.setVisible(Boolean.FALSE, new String[]{"qttabpage"});
            return;
        }
        view.setVisible(Boolean.TRUE, new String[]{"qttabpage"});
        Map<Long, List> indexIdAndAttItemIdList = showQuotaSources.stream().collect(Collectors.toMap(DailySource::getDatasoureId, source -> source.getAttItems().stream().map(DailySource.AttItem::getAttItemId).collect(Collectors.toList()), (oldValue, value) -> oldValue));
        QuotaIndexQueryDto dto = new QuotaIndexQueryDto();
        dto.setQueryByFileBoId(true);
        dto.setPersonFileBoIdList(new ArrayList<Long>(attFileMap.keySet()));
        dto.setEndDate(WTCDateUtils.getEndDayOfYear((Date)date));
        dto.setStartDate(WTCDateUtils.getBeginDayOfYear((Date)date));
        dto.setIndexIdAndAttItemIdListMap(indexIdAndAttItemIdList);
        QTLineDetailOuterService.queryByQuotaIndexQueryDto((QuotaIndexQueryDto)dto);
        LOG.info("QTLineDetailOuterService.queryByQuotaIndexQueryDto end dto:{}", (Object)SerializationUtils.toJsonString((Object)dto));
        DynamicObjectCollection dynamicObjects = view.getModel().getDataEntity(true).getDynamicObjectCollection("qtentryentitycount");
        EntryType entryType = (EntryType)dynamicObjects.getDynamicObjectType();
        view.getModel().deleteEntryData("qtentryentitycount");
        Map indexIdAndValueMap = dto.getIndexIdAndValueMap();
        Map indexIdAndQuotaDetailIdListMap = dto.getIndexIdAndQuotaDetailIdListMap();
        IPageCache pageCache = view.getPageCache();
        for (DailySource dailySource : showQuotaSources) {
            long quotaSourceId = dailySource.getDatasoureId();
            BigDecimal value2 = (BigDecimal)indexIdAndValueMap.get(quotaSourceId);
            DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)entryType);
            value2 = value2 == null ? new BigDecimal(0) : value2;
            String attDataSourceValueStr = value2.setScale(2, 4).stripTrailingZeros().toPlainString();
            dynamicObject.set("datasouvalueqt", (Object)attDataSourceValueStr);
            String unitStr = UnitDataEnum.getRetDesc((String)dailySource.getDatasoureUnit());
            if (unitStr == null || unitStr.equals("")) {
                dynamicObject.set("datasounameqt", (Object)dailySource.getDatasoureName());
            } else {
                dynamicObject.set("datasounameqt", (Object)(dailySource.getDatasoureName() + "(" + unitStr + ")"));
            }
            Set quotaDetailIdSet = (Set)indexIdAndQuotaDetailIdListMap.get(quotaSourceId);
            pageCache.put(quotaSourceId + "", JSON.toJSONString((Object)quotaDetailIdSet));
            dynamicObject.set("quotasourceid", (Object)quotaSourceId);
            dynamicObjects.add((Object)dynamicObject);
        }
        view.updateView("qtentryentitycount");
    }

    public void getTeamQuotaStatisticData(TeamQuotaIndexQueryDto dto) {
        if (LOG.isDebugEnabled()) {
            LOG.info("QuotaStatisticIndexService.getTeamQuotaStatisticData,dto= {}", (Object)JSON.toJSONString((Object)dto));
        }
        QTLineDetailOuterService.queryByTeamQuotaIndexQueryDto((TeamQuotaIndexQueryDto)dto);
    }

    public TeamQuotaIndexQueryDto getTeamQuotaIndexQueryDto(Long ruleId, Date startDate, Date endDate, List<Long> allPersonIdList, int currentPage, int pageSize, String terminal, Long adminOrgId) {
        TeamQuotaIndexQueryDto queryDto = new TeamQuotaIndexQueryDto();
        int totalCount = allPersonIdList.size();
        int fromIndex = currentPage * pageSize;
        int toIndex = Math.min(totalCount, fromIndex + pageSize);
        ArrayList<Long> personIdList = new ArrayList<Long>(allPersonIdList.subList(fromIndex, toIndex));
        ArrayList idSets = new ArrayList(personIdList.subList(0, Math.min(personIdList.size(), pageSize)));
        Map<Long, DynamicObject> attFileMap = TeamHomeServiceHelper.getInstance().getAttFile(new HashSet<Long>(idSets), adminOrgId, startDate, endDate);
        Date date = new Date(System.currentTimeMillis());
        List list = HRPIMServiceImpl.getInstance().listIntersectDataSocialworkageAndServicelengthInfo(date, date, personIdList);
        HashMap personAndCmpAgeMap = Maps.newHashMapWithExpectedSize((int)16);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (Map workAgeMap : list) {
                Long personId = (Long)workAgeMap.get("person_id");
                BigDecimal bigDecimal = (BigDecimal)workAgeMap.get("servicelength");
                personAndCmpAgeMap.put(personId, bigDecimal == null ? BigDecimal.ZERO : bigDecimal.setScale(1, 4));
            }
        }
        Map personImgMap = AttFileQueryServiceImpl.getInstance().queryPersonImgMap(personIdList);
        HashMap perInfoMap = Maps.newHashMapWithExpectedSize((int)10);
        for (Map.Entry entry : attFileMap.entrySet()) {
            DynamicObject dy = (DynamicObject)entry.getValue();
            PersonInfoDto personInfoDto = new PersonInfoDto();
            personInfoDto.setPersonName(dy.getString("name"));
            personInfoDto.setNumber(dy.getString("number"));
            BigDecimal cmpAge = (BigDecimal)personAndCmpAgeMap.get(entry.getKey());
            String cmpAgeStr = cmpAge == null ? BigDecimal.ZERO.toString() : (cmpAge.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO.toString() : cmpAge.toString());
            personInfoDto.setCmpAge(MessageFormat.format(ResManager.loadKDString((String)"\u53f8\u9f84{0}\u5e74", (String)"QuotaStatisticIndexService_1", (String)"wtc-wtss-business", (Object[])new Object[0]), cmpAgeStr));
            personInfoDto.setPosition(dy.getString("position.name"));
            personInfoDto.setHeadSculpture((String)personImgMap.get(entry.getKey()));
            perInfoMap.put(entry.getKey(), personInfoDto);
        }
        Map<Long, List<Long>> indexIdAndAttItemIdListMap = SchemaServiceHelper.getInstance().getQuotaItemIds(ruleId, terminal);
        queryDto.setPersonIdList(personIdList);
        queryDto.setStartDate(startDate);
        queryDto.setEndDate(endDate);
        queryDto.setIndexIdAndAttItemIdListMap(indexIdAndAttItemIdListMap);
        queryDto.setPersonInfoMap((Map)perInfoMap);
        queryDto.setAdminOrgId(adminOrgId);
        return queryDto;
    }
}

