/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.business.servicehelper.common;

import com.alibaba.fastjson.JSONArray;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.wtc.wtss.business.spi.homepage.WtssHomepageService;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.mobile.MobileCommonServiceHelper;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.common.predata.wtbd.PreDataExAttribute;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCMaps;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtss.business.servicehelper.common.HomePageServiceHelper;
import kd.wtc.wtss.business.servicehelper.summaryconf.SummaryConfigDetailService;
import kd.wtc.wtss.common.dto.DailySource;
import kd.wtc.wtss.common.dto.MobileHomeConf;
import kd.wtc.wtss.common.dto.summaryconf.SummaryIdBsedModel;

public class SchemaServiceHelper
implements WtssHomepageService {
    private static final Log LOGGER = LogFactory.getLog(SchemaServiceHelper.class);
    private final HRBaseServiceHelper ruleServiceHelper = new HRBaseServiceHelper("wtp_mobilerule");
    private final HRBaseServiceHelper schemeServiceHelper = new HRBaseServiceHelper("wtp_mobilescheme");
    private final HRBaseServiceHelper dailySourceHelper = new HRBaseServiceHelper("wtp_dailydetsource");
    private final HRBaseServiceHelper QUOTASOURCE_HELPER = new HRBaseServiceHelper("wtp_quotasource");
    private final HRBaseServiceHelper QUOTACONFIG_HELPER = new HRBaseServiceHelper("wtp_quotaconfig");
    private static Map<String, Long> EXTYPEMAP = new HashMap<String, Long>(8);

    private SchemaServiceHelper() {
    }

    public static SchemaServiceHelper getInstance() {
        return Instance.INSTANCE;
    }

    public DynamicObject getPerSumConfigByUser(long mobileSchemeId, String workspace) {
        DynamicObject mobileRule = this.queryRuleByScheme(mobileSchemeId, workspace);
        if (null == mobileRule) {
            return null;
        }
        return mobileRule.getDynamicObject("persumconfig");
    }

    public DynamicObject getTeamRuleByUser(long mobileSchemeId, String workspace) {
        return this.queryRuleByScheme(mobileSchemeId, workspace);
    }

    public SummaryIdBsedModel getSchemeAndRule(long mobileSchemeId, String workspace) {
        SummaryIdBsedModel summaryIdBsedModel = new SummaryIdBsedModel();
        DynamicObject mobileRule = this.queryRuleBySchemeWithSummaryModel(mobileSchemeId, workspace, summaryIdBsedModel);
        if (null != mobileRule) {
            summaryIdBsedModel.setRuleId(mobileRule.getLong("id"));
        }
        return summaryIdBsedModel;
    }

    public MobileHomeConf getSchemeForHome(long mobileSchemeId, String workspace) {
        DynamicObject queryRule = this.queryRuleByScheme(mobileSchemeId, workspace);
        if (null == queryRule) {
            return null;
        }
        DynamicObject[] commPros = this.getProblemsByRule(queryRule);
        MobileHomeConf homeConf = new MobileHomeConf(queryRule, commPros);
        return homeConf;
    }

    public Map<String, List<DailySource>> getPeriodAttItemsByScheme(long mobileSchemeId, String workspace, Long userId, String startDateStr, String endDateStr, int sence) {
        Date endDate;
        Date startDate;
        try {
            startDate = HRDateTimeUtils.parseDate((String)startDateStr);
            endDate = HRDateTimeUtils.parseDate((String)endDateStr);
        }
        catch (ParseException e) {
            Date date;
            startDate = date = new Date();
            endDate = date;
            LOGGER.error("\u83b7\u53d6\u8003\u52e4\u79fb\u52a8\u7aef\u9996\u9875(startDateStr or endDateStr)\u65e5\u671f\u5b57\u7b26\u4e32\u89e3\u6790\u5931\u8d25", (Throwable)e);
        }
        DynamicObject queryRule = this.queryRuleByScheme(mobileSchemeId, workspace);
        if (null == queryRule) {
            return null;
        }
        return this.getAttItemByRule(null, queryRule, userId, startDate, endDate, sence);
    }

    public Map<String, List<DailySource>> getPeriodAttItems(long mobileSchemeId, String workspace, Long userId, String startDateStr, String endDateStr, Map<Long, Tuple<Date, Date>> attfileMultBoQueryMap, int sence) {
        Date endDate;
        Date startDate;
        if (attfileMultBoQueryMap == null || attfileMultBoQueryMap.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u9009\u65e5\u671f\u8303\u56f4\u5185\u65e0\u6b63\u5e38\u8003\u52e4\u7684\u8003\u52e4\u6863\u6848\u3002", (String)"SchemaServiceHelper_0", (String)"wtc-wtss-business", (Object[])new Object[0]));
        }
        try {
            startDate = HRDateTimeUtils.parseDate((String)startDateStr);
            endDate = HRDateTimeUtils.parseDate((String)endDateStr);
        }
        catch (ParseException e) {
            Date date;
            startDate = date = new Date();
            endDate = date;
            LOGGER.error("\u83b7\u53d6\u8003\u52e4\u79fb\u52a8\u7aef\u9996\u9875(startDateStr or endDateStr)\u65e5\u671f\u5b57\u7b26\u4e32\u89e3\u6790\u5931\u8d25", (Throwable)e);
        }
        DynamicObject queryRule = this.queryRuleByScheme(mobileSchemeId, workspace);
        if (null == queryRule) {
            return null;
        }
        return this.getAttItemByRule(attfileMultBoQueryMap, queryRule, userId, startDate, endDate, sence);
    }

    public Map<String, Object> getDataSourcesByScheme(long mobileSchemeId, String workspace, Long userId, int sence) {
        Map<String, Object> dataSourcesByScheme = this.getDataSourcesByScheme(null, mobileSchemeId, workspace, userId, sence);
        return dataSourcesByScheme;
    }

    public Map<String, Object> getDataSourcesByScheme(IFormView view, long mobileSchemeId, String workspace, Long userId, int sence) {
        boolean isUserConfigCanWork;
        DynamicObject queryRule = this.queryRuleByScheme(mobileSchemeId, workspace);
        if (null == queryRule) {
            return null;
        }
        if (!StringUtils.equals((CharSequence)queryRule.getString("workspace"), (CharSequence)workspace)) {
            if (null != view) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u5047\u52e4\u81ea\u52a9\u65b9\u6848\u7684\u4f5c\u4e1a\u7a7a\u95f4\u4e0e\u5047\u52e4\u81ea\u52a9\u89c4\u5219\u4e0d\u4e00\u81f4\uff0c\u8bf7\u5728\u5de5\u65f6\u5047\u52e4\u89c4\u5219-\u5047\u52e4\u81ea\u52a9\u65b9\u6848\u91cd\u65b0\u8bbe\u7f6e\u540e\u518d\u8bd5\u3002", (String)"SchemaServiceHelper_1", (String)"wtc-wtss-business", (Object[])new Object[0]));
            }
            return null;
        }
        HashMap<String, Object> returnMap = new HashMap<String, Object>(3);
        DynamicObject dailyConfig = queryRule.getDynamicObject("dailydetconfig");
        DynamicObjectCollection dailySourceEntities = dailyConfig.getDynamicObjectCollection("entryentity");
        ArrayList<DailySource> showDailySources = new ArrayList<DailySource>(8);
        ArrayList<Object> unShowDailySources = new ArrayList<DailySource>(8);
        ArrayList<DailySource> showDailySourcesSort = new ArrayList<DailySource>(8);
        String sceneStr = "2";
        sceneStr = sence == 1 ? sceneStr + "1" : sceneStr + "0";
        DynamicObject queryDay = SummaryConfigDetailService.getInstance().queryDay(userId, 2, 1);
        ArrayList<Long> dailySourceIds = new ArrayList<Long>(8);
        boolean bl = isUserConfigCanWork = queryDay != null;
        if (isUserConfigCanWork) {
            List userSourceIds = SerializationUtils.fromJsonStringToList((String)queryDay.getString("sourcejsonstr"), Long.class);
            this.setShowList(dailySourceEntities, showDailySources, unShowDailySources, sceneStr, userSourceIds);
            Iterator iterator = userSourceIds.iterator();
            while (iterator.hasNext()) {
                long userSourceId = (Long)iterator.next();
                for (DailySource dailySource : showDailySources) {
                    if (dailySource.getDatasoureId() != userSourceId) continue;
                    showDailySourcesSort.add(dailySource);
                    dailySourceIds.add(userSourceId);
                }
            }
            for (DailySource dailySource : showDailySources) {
                boolean isexit = true;
                Iterator iterator2 = userSourceIds.iterator();
                while (iterator2.hasNext()) {
                    long userSourceId = (Long)iterator2.next();
                    if (dailySource.getDatasoureId() != userSourceId) continue;
                    isexit = false;
                }
                if (!isexit) continue;
                showDailySourcesSort.add(dailySource);
                dailySourceIds.add(dailySource.getDatasoureId());
            }
            returnMap.put("showList", showDailySourcesSort);
        }
        if (!isUserConfigCanWork || showDailySourcesSort.size() == 0) {
            dailySourceIds = new ArrayList(8);
            showDailySources = new ArrayList(8);
            unShowDailySources = new ArrayList(8);
            if (dailySourceEntities != null && dailySourceEntities.size() > 0) {
                for (DynamicObject dailySourcefather : dailySourceEntities) {
                    if (!sceneStr.contains(dailySourcefather.getString("terminal")) && dailySourcefather.getString("terminal") != null) continue;
                    boolean isShow = dailySourcefather.getBoolean("display");
                    if (isShow) {
                        this.setDayDataSoure(dailySourcefather, showDailySources);
                        dailySourceIds.add(dailySourcefather.getDynamicObject("dailydetsource").getLong("id"));
                        continue;
                    }
                    this.setDayDataSoure(dailySourcefather, unShowDailySources);
                }
            }
            returnMap.put("showList", showDailySources);
        }
        returnMap.put("unshowList", unShowDailySources);
        returnMap.put("querySourceIds", dailySourceIds);
        return returnMap;
    }

    public Map<String, Object> getQTDataSourceByScheme(long mobileSchemeId, String workspace, Long userId, String scene) {
        boolean isUserConfigCanWork;
        DynamicObject ruleDy = this.queryRuleByScheme(mobileSchemeId, workspace);
        HashMap returnMap = Maps.newHashMapWithExpectedSize((int)16);
        if (null == ruleDy) {
            return returnMap;
        }
        String props = String.join((CharSequence)",", "quotasource", "display", "adjustment", "terminal");
        DynamicObject quotaConfig = this.QUOTACONFIG_HELPER.queryOne(props, (Object)WTCDynamicObjectUtils.getBaseDataId((DynamicObject)ruleDy, (String)"quotaconfig"));
        if (quotaConfig == null) {
            return returnMap;
        }
        DynamicObjectCollection quotaSourceEntities = quotaConfig.getDynamicObjectCollection("entryentity");
        Map<Long, String> quotaSourceIdAndUnitMap = this.queryQuotaSourceUnit(quotaSourceEntities);
        ArrayList showQTSources = Lists.newArrayListWithExpectedSize((int)8);
        ArrayList unShowQTSources = Lists.newArrayListWithExpectedSize((int)8);
        ArrayList showQTSourcesSort = Lists.newArrayListWithExpectedSize((int)8);
        String sceneStr = "2" + ("1".equals(scene) ? "1" : "0");
        DynamicObject queryQT = SummaryConfigDetailService.getInstance().queryOne(userId, 2, "3", (Long)quotaConfig.getPkValue());
        ArrayList quotaSourceIds = new ArrayList(8);
        boolean bl = isUserConfigCanWork = queryQT != null;
        if (isUserConfigCanWork) {
            List userSourceIds = SerializationUtils.fromJsonStringToList((String)queryQT.getString("sourcejsonstr"), Long.class);
            this.setQTShowAndUnShowList(quotaSourceEntities, showQTSources, unShowQTSources, sceneStr, new HashSet<Long>(userSourceIds), quotaSourceIdAndUnitMap);
            Iterator iterator = userSourceIds.iterator();
            while (iterator.hasNext()) {
                long userSourceId = (Long)iterator.next();
                for (DailySource dailySource : showQTSources) {
                    if (dailySource.getDatasoureId() != userSourceId) continue;
                    showQTSourcesSort.add(dailySource);
                    quotaSourceIds.add(userSourceId);
                }
            }
            for (DailySource source : showQTSources) {
                boolean isexit = true;
                Iterator iterator2 = userSourceIds.iterator();
                while (iterator2.hasNext()) {
                    long userSourceId = (Long)iterator2.next();
                    if (source.getDatasoureId() != userSourceId) continue;
                    isexit = false;
                    break;
                }
                if (!isexit) continue;
                showQTSourcesSort.add(source);
                quotaSourceIds.add(source.getDatasoureId());
            }
            returnMap.put("showList", showQTSourcesSort);
        }
        if (!isUserConfigCanWork || showQTSourcesSort.size() == 0) {
            quotaSourceIds = Lists.newArrayListWithExpectedSize((int)8);
            showQTSources = Lists.newArrayListWithExpectedSize((int)8);
            unShowQTSources = Lists.newArrayListWithExpectedSize((int)8);
            if (quotaSourceEntities != null && quotaSourceEntities.size() > 0) {
                for (DynamicObject entity : quotaSourceEntities) {
                    if (!sceneStr.contains(entity.getString("terminal")) && entity.getString("terminal") != null) continue;
                    boolean isShow = entity.getBoolean("display");
                    long quotaSourceId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)entity, (String)"quotasource");
                    if (isShow) {
                        this.setQTDataSource(entity, showQTSources, quotaSourceId, quotaSourceIdAndUnitMap);
                        quotaSourceIds.add(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)entity, (String)"quotasource"));
                        continue;
                    }
                    this.setQTDataSource(entity, unShowQTSources, quotaSourceId, quotaSourceIdAndUnitMap);
                }
            }
            returnMap.put("showList", showQTSources);
        }
        returnMap.put("unshowList", unShowQTSources);
        returnMap.put("querySourceIds", quotaSourceIds);
        return returnMap;
    }

    private Map<Long, String> queryQuotaSourceUnit(DynamicObjectCollection quotaSourceEntities) {
        HashMap quotaSourceIdAndUnitMap = Maps.newHashMapWithExpectedSize((int)16);
        if (quotaSourceEntities == null || quotaSourceEntities.size() == 0) {
            return quotaSourceIdAndUnitMap;
        }
        Set quotaSourceIdSet = quotaSourceEntities.stream().map(quotaSource -> quotaSource.getLong("id")).collect(Collectors.toSet());
        DynamicObject[] quotaSourceDyArr = this.QUOTASOURCE_HELPER.query("unit", new QFilter[]{new QFilter("id", "in", quotaSourceIdSet)});
        return Arrays.stream(quotaSourceDyArr).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getString("unit"), (a, b) -> b));
    }

    public long querySeqMinQuotaSource(Set<Long> quotaSourceIdSet) {
        return this.QUOTASOURCE_HELPER.queryOne(WTCStringUtils.joinOnComma((String[])new String[]{"id"}), new QFilter[]{new QFilter("id", "in", quotaSourceIdSet)}, WTCStringUtils.joinStr((String[])new String[]{"id", " desc"})).getLong("id");
    }

    public DynamicObject loadQuotaSource(long id) {
        return this.QUOTASOURCE_HELPER.loadSingle((Object)id);
    }

    public DynamicObject loadQuotaConfig(long id) {
        return this.QUOTACONFIG_HELPER.loadSingle((Object)id);
    }

    private void setQTShowAndUnShowList(DynamicObjectCollection quotaSourceEntities, List<DailySource> showQTSources, List<DailySource> unShowQTSources, String sceneStr, Set<Long> userSourceIds, Map<Long, String> quotaSourceIdAndUnitMap) {
        if (quotaSourceEntities == null || quotaSourceEntities.size() == 0) {
            return;
        }
        for (DynamicObject qtSource : quotaSourceEntities) {
            if (!sceneStr.contains(qtSource.getString("terminal")) && qtSource.getString("terminal") != null) continue;
            long quotaSourceId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)qtSource, (String)"quotasource");
            if (userSourceIds.contains(quotaSourceId)) {
                this.setQTDataSource(qtSource, showQTSources, quotaSourceId, quotaSourceIdAndUnitMap);
                continue;
            }
            this.setQTDataSource(qtSource, unShowQTSources, quotaSourceId, quotaSourceIdAndUnitMap);
        }
    }

    private void setQTDataSource(DynamicObject qtSource, List<DailySource> dailySources, long quotaSourceId, Map<Long, String> quotaSourceIdAndUnitMap) {
        DailySource dailySource = new DailySource();
        dailySource.setDatasoureId(Long.valueOf(quotaSourceId));
        dailySource.setDatasoureName(qtSource.getDynamicObject("quotasource").getString("name"));
        dailySource.setAdjustment(qtSource.getBoolean("adjustment"));
        dailySource.setDisplay(qtSource.getBoolean("display"));
        dailySource.setDatasoureUnit(quotaSourceIdAndUnitMap.get(quotaSourceId));
        dailySources.add(dailySource);
        ArrayList attItems = Lists.newArrayListWithExpectedSize((int)4);
        DynamicObjectCollection attItemCollection = qtSource.getDynamicObject("quotasource").getDynamicObjectCollection("entryentity");
        for (DynamicObject entity : attItemCollection) {
            DynamicObject attItemDy = entity.getDynamicObject("attitem");
            DailySource.AttItem attItem = new DailySource.AttItem();
            attItem.setAttItemId(attItemDy.getLong("id"));
            attItem.setAttItemName(attItemDy.getString("name"));
            attItems.add(attItem);
        }
        dailySource.setAttItems((List)attItems);
    }

    private void setShowList(DynamicObjectCollection dailySourceEntities, List<DailySource> showDailySources, List<DailySource> unShowDailySources, String sceneStr, List<Long> userSourceIds) {
        if (dailySourceEntities != null && dailySourceEntities.size() > 0) {
            for (DynamicObject dailySourcefather : dailySourceEntities) {
                if (!sceneStr.contains(dailySourcefather.getString("terminal")) && dailySourcefather.getString("terminal") != null) continue;
                boolean isShow = false;
                for (long userSourceId : userSourceIds) {
                    if (dailySourcefather.getDynamicObject("dailydetsource").getLong("id") != userSourceId) continue;
                    this.setDayDataSoure(dailySourcefather, showDailySources);
                    isShow = true;
                }
                if (isShow) continue;
                this.setDayDataSoure(dailySourcefather, unShowDailySources);
            }
        }
    }

    private void setDayDataSoure(DynamicObject dailySourcefather, List<DailySource> dailySources) {
        DynamicObject dailySourcequery = this.dailySourceHelper.queryOne((Object)dailySourcefather.getDynamicObject("dailydetsource").getLong("id"));
        String busclassify = dailySourcequery.getString("busclassify");
        if ("1".equals(busclassify)) {
            return;
        }
        DailySource dailySource = new DailySource();
        dailySource.setDatasoureId(Long.valueOf(dailySourcefather.getDynamicObject("dailydetsource").getLong("id")));
        dailySource.setDatasoureName(dailySourcefather.getDynamicObject("dailydetsource").getString("name"));
        dailySource.setAdjustment(dailySourcefather.getBoolean("adjustment"));
        dailySource.setDisplay(dailySourcefather.getBoolean("display"));
        String unit = dailySourcequery.getString("unit");
        dailySource.setDatasoureUnit(unit);
        dailySource.setBusClassify(busclassify);
        dailySources.add(dailySource);
    }

    public DynamicObject queryRuleByScheme(long mobileSchemeId, String workspace) {
        DynamicObject mobileRule = this.findRuleById(mobileSchemeId, workspace);
        if (mobileRule == null) {
            return null;
        }
        QFilter qFilter = new QFilter("id", "=", (Object)mobileRule.getLong("id"));
        DynamicObject queryRule = this.ruleServiceHelper.queryOne("id,persumconfig,attcommproblem,selectedbill,showproblem,dailydetconfig,dailystaconfig,perstaconfig,quotaconfig,workspace", qFilter);
        return queryRule;
    }

    public MobileHomeConf queryTeamRuleBills(Long ruleId) {
        DynamicObject ruleDy = this.ruleServiceHelper.queryOne("id,selectedbill", (Object)ruleId);
        if (ruleDy == null) {
            return null;
        }
        return new MobileHomeConf(ruleDy);
    }

    public DynamicObject queryRuleData(long ruleId) {
        DynamicObject queryRule = this.ruleServiceHelper.queryOne((Object)ruleId);
        return queryRule;
    }

    private DynamicObject queryRuleBySchemeWithSummaryModel(long mobileSchemeId, String workspace, SummaryIdBsedModel summaryIdBsedModel) {
        DynamicObject mobileRule = this.findRuleByIdWithSummaryModel(mobileSchemeId, workspace, summaryIdBsedModel);
        if (mobileRule == null) {
            return null;
        }
        QFilter qFilter = new QFilter("id", "=", (Object)mobileRule.getLong("id"));
        DynamicObject queryRule = this.ruleServiceHelper.queryOne("id,persumconfig,attcommproblem,selectedbill,showproblem,dailydetconfig", qFilter);
        return queryRule;
    }

    private Map<String, List<DailySource>> getAttItemByRule(Map<Long, Tuple<Date, Date>> attfileMultBoQueryMap, DynamicObject queryRule, Long userId, Date startDate, Date endDate, int sence) {
        DynamicObject dailyConfig = queryRule.getDynamicObject("dailydetconfig");
        if (dailyConfig == null) {
            return new HashMap<String, List<DailySource>>();
        }
        DynamicObjectCollection dailySourceEntities = dailyConfig.getDynamicObjectCollection("entryentity");
        ArrayList<Long> dailySourceIds = new ArrayList<Long>(8);
        String sceneStr = "0";
        sceneStr = sence == 1 ? sceneStr + "1" : sceneStr + "2";
        for (DynamicObject dailyConfigEntity : dailySourceEntities) {
            if (!sceneStr.contains(dailyConfigEntity.getString("terminal")) && dailyConfigEntity.getString("terminal") != null) continue;
            dailySourceIds.add(dailyConfigEntity.getDynamicObject("dailydetsource").getLong("id"));
        }
        LOGGER.info("\u67e5\u8be2\u65e5\u660e\u7ec6id\u96c6\u5408\uff1adailySourceIds={}", (Object)JSONArray.toJSONString(dailySourceIds));
        if (CollectionUtils.isEmpty(dailySourceIds)) {
            return null;
        }
        HRBaseServiceHelper dailySourceHelper = new HRBaseServiceHelper("wtp_dailydetsource");
        DynamicObject[] dailySources = dailySourceHelper.query("id,name,entryentity.attitem,busclassify,datatype,unit", new QFilter("id", "in", dailySourceIds).toArray());
        Set<Long> attItemIds = this.getAllAttItemIds(dailySources);
        LOGGER.info("\u79fb\u52a8\u7aef\u65b9\u6848\u83b7\u53d6\u7684\u8003\u52e4\u9879\u76ee\u5c5e\u6027\u5165\u53c2:userId={},startDate={},endDate={},attItemIds={},attfileMultBoQueryMap={}", new Object[]{userId, startDate, endDate, attItemIds, attfileMultBoQueryMap});
        if (attfileMultBoQueryMap == null) {
            Long employeeId = MobileCommonServiceHelper.getInstance().getEmployeeIdByPersonId(userId);
            attfileMultBoQueryMap = HomePageServiceHelper.getInstance().getAttFileMapWithEmployeeId(employeeId, startDate, endDate);
        }
        if (attfileMultBoQueryMap == null || WTCMaps.isEmpty(attfileMultBoQueryMap)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u9009\u65e5\u671f\u8303\u56f4\u5185\u65e0\u6b63\u5e38\u8003\u52e4\u7684\u8003\u52e4\u6863\u6848\u3002", (String)"SchemaServiceHelper_0", (String)"wtc-wtss-business", (Object[])new Object[0]));
        }
        Map attItemMapping = (Map)DispatchServiceHelper.invokeBizService((String)"wtc", (String)"wtte", (String)"IAttRecordService", (String)"listDetailAttItemsByMutilBo", (Object[])new Object[]{attfileMultBoQueryMap, attItemIds});
        LOGGER.info("\u79fb\u52a8\u7aef\u65b9\u6848\u83b7\u53d6\u7684\u8003\u52e4\u9879\u76ee\u5c5e\u6027:{}", (Object)JSONArray.toJSONString((Object)attItemMapping));
        return this.setAttItemForHome(dailySources, attItemMapping, 1);
    }

    public Set<Long> getAllAttItemIds(DynamicObject[] dailySources) {
        HashSet<Long> attItemIds = new HashSet<Long>(16);
        for (DynamicObject dailySource : dailySources) {
            DynamicObjectCollection dailySourceEntries = dailySource.getDynamicObjectCollection("entryentity");
            for (DynamicObject sourceEntry : dailySourceEntries) {
                attItemIds.add(sourceEntry.getLong("attitem.id"));
            }
        }
        return attItemIds;
    }

    public Map<String, List<DailySource>> setAttItemForHome(DynamicObject[] dailySources, Map<String, List<Map<String, String>>> attItemMapping, int sence) {
        HashMap dailyMap = Maps.newHashMapWithExpectedSize((int)attItemMapping.size());
        for (DynamicObject dailySource : dailySources) {
            DynamicObjectCollection dailySourceEntries = dailySource.getDynamicObjectCollection("entryentity");
            for (DynamicObject sourceEntry : dailySourceEntries) {
                DynamicObject attItem = sourceEntry.getDynamicObject("attitem");
                if (attItem == null) continue;
                this.setDailySourceByAttItem(dailySource, attItem, attItemMapping, dailyMap, sence);
            }
        }
        return dailyMap;
    }

    private void setDailySourceByAttItem(DynamicObject dailySource, DynamicObject attItem, Map<String, List<Map<String, String>>> dailySources, Map<String, List<DailySource>> dailyMap, int sence) {
        for (Map.Entry<String, List<Map<String, String>>> dayAttItemEntry : dailySources.entrySet()) {
            String dateStr = dayAttItemEntry.getKey();
            List listDailySource = dailyMap.getOrDefault(dateStr, new ArrayList(10));
            List<Map<String, String>> attItemValues = dayAttItemEntry.getValue();
            for (Map<String, String> attItemVal : attItemValues) {
                long attItemId = Long.parseLong(attItemVal.get("attitemid"));
                if (attItem.getLong("id") != attItemId) continue;
                DailySource existDailySource = this.hasSameDailySource(listDailySource, dailySource);
                if (existDailySource != null) {
                    existDailySource.setAttItemForExist(dailySource, attItem, attItemVal.get("value"));
                } else {
                    listDailySource.add(new DailySource(dailySource, attItem, attItemVal.get("value")));
                }
                dailyMap.put(dateStr, listDailySource);
            }
        }
    }

    private DailySource hasSameDailySource(List<DailySource> listDailySource, DynamicObject dailySource) {
        if (CollectionUtils.isEmpty(listDailySource)) {
            return null;
        }
        for (DailySource source : listDailySource) {
            String busClassify = dailySource.getString("busclassify");
            long dataSourceId = source.getDatasoureId();
            if (!HRStringUtils.equals((String)source.getBusClassifyNo(), (String)busClassify) || dataSourceId != dailySource.getLong("id")) continue;
            return source;
        }
        return null;
    }

    private DynamicObject[] getProblemsByRule(DynamicObject queryRule) {
        DynamicObjectCollection problemIds = queryRule.getDynamicObjectCollection("attcommproblem");
        List proIds = problemIds.stream().map(id -> id.getLong("fbasedataid_id")).collect(Collectors.toList());
        HRBaseServiceHelper problemHelper = new HRBaseServiceHelper("wtp_attcommproblem");
        return problemHelper.query("id,question,answer_tag,index,modifytime", new QFilter("id", "in", proIds).toArray(), "index asc");
    }

    private DynamicObject findRuleById(Long mobileSchemeId, String workspace) {
        QFilter qFilter = new QFilter("id", "=", (Object)mobileSchemeId);
        String ruleName = this.getRuleName(workspace);
        DynamicObject mobileScheme = this.schemeServiceHelper.queryOne("id," + ruleName, qFilter.toArray());
        if (HRObjectUtils.isEmpty((Object)mobileScheme)) {
            return null;
        }
        return mobileScheme.getDynamicObject(ruleName);
    }

    private DynamicObject findRuleByIdWithSummaryModel(Long mobileSchemeId, String workspace, SummaryIdBsedModel summaryIdBsedModel) {
        QFilter qFilter = new QFilter("id", "=", (Object)mobileSchemeId);
        String ruleName = this.getRuleName(workspace);
        DynamicObject mobileScheme = this.schemeServiceHelper.queryOne("id," + ruleName + "", qFilter.toArray());
        if (HRObjectUtils.isEmpty((Object)mobileScheme)) {
            return null;
        }
        summaryIdBsedModel.setSchemeId(mobileScheme.getLong("id"));
        return mobileScheme.getDynamicObject(ruleName);
    }

    private QFilter getQueryHisNoStatusFilter(Long boId, Date now) {
        QFilter qFilter = WTCHisServiceHelper.boQFilter((Long)boId);
        qFilter.and(WTCHisServiceHelper.dataStatusValidQFilter());
        qFilter.and(WTCHisServiceHelper.isCurrentVersion((boolean)false));
        Date dayStartTime = WTCDateUtils.getDayStartTime((Date)now);
        qFilter.and(new QFilter("bsed", "<=", (Object)dayStartTime));
        qFilter.and(new QFilter("bsled", ">=", (Object)dayStartTime));
        return qFilter;
    }

    public Set<Long> getAbnormalConfig(long mobileSchemeId, String workspace) {
        DynamicObject queryRule = this.queryRuleByScheme(mobileSchemeId, workspace);
        if (null == queryRule) {
            return Collections.emptySet();
        }
        return this.getAbnormalConfigByRule(queryRule);
    }

    private Set<Long> getAbnormalConfigByRule(DynamicObject queryRule) {
        DynamicObject dailyCfg = queryRule.getDynamicObject("dailydetconfig");
        if (null == dailyCfg) {
            return Collections.emptySet();
        }
        DynamicObjectCollection dailySourceEntities = dailyCfg.getDynamicObjectCollection("entryentity");
        List dailySourceIds = dailySourceEntities.stream().map(ds -> ds.getDynamicObject("dailydetsource").getLong("id")).collect(Collectors.toList());
        LOGGER.info("\u67e5\u8be2\u65e5\u660e\u7ec6id\u96c6\u5408\uff1adailySourceIds={}", (Object)JSONArray.toJSONString(dailySourceIds));
        if (CollectionUtils.isEmpty(dailySourceIds)) {
            return Collections.emptySet();
        }
        HRBaseServiceHelper dailySourceHelper = new HRBaseServiceHelper("wtp_dailydetsource");
        QFilter qFilter1 = new QFilter("id", "in", dailySourceIds);
        QFilter qFilter2 = new QFilter("busclassify", "=", (Object)"1");
        DynamicObject[] dailySources = dailySourceHelper.query("id,busclassify,selectedbill", new QFilter[]{qFilter1, qFilter2});
        if (dailySources == null || dailySources.length == 0) {
            return Collections.emptySet();
        }
        HashSet<Long> selectSet = new HashSet<Long>(16);
        for (DynamicObject dailySource : dailySources) {
            String[] split;
            String selectedbill = (String)dailySource.get("selectedbill");
            for (String temp : split = StringUtils.split((String)selectedbill, (String)",")) {
                Long exType = EXTYPEMAP.get(temp);
                if (StringUtils.isEmpty((CharSequence)temp) || !Objects.nonNull(exType)) continue;
                selectSet.add(exType);
            }
        }
        return selectSet;
    }

    private String getRuleName(String workspace) {
        return StringUtils.equals((CharSequence)"A", (CharSequence)workspace) ? "staffmobilerule" : "teammobilerule";
    }

    public Map<Long, List<Long>> getQuotaItemIds(Long ruleId, String terminal) {
        LinkedHashMap returnMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
        DynamicObject ruleDy = this.queryRuleData(ruleId);
        if (ruleDy == null || WTCDynamicObjectUtils.getBaseDataId((DynamicObject)ruleDy, (String)"quotaconfig") == 0L) {
            return returnMap;
        }
        String props = String.join((CharSequence)",", "quotasource", "terminal");
        DynamicObject quotaConfig = this.QUOTACONFIG_HELPER.queryOne(props, (Object)WTCDynamicObjectUtils.getBaseDataId((DynamicObject)ruleDy, (String)"quotaconfig"));
        if (quotaConfig == null) {
            return returnMap;
        }
        DynamicObjectCollection quotaSourceEntities = quotaConfig.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : quotaSourceEntities) {
            String actualTerminal = entry.getString("terminal");
            if (!StringUtils.equalsAny((CharSequence)actualTerminal, (CharSequence[])new CharSequence[]{terminal, "2"})) continue;
            long quotaSourceId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)entry, (String)"quotasource");
            DynamicObjectCollection attItemCollection = entry.getDynamicObject("quotasource").getDynamicObjectCollection("entryentity");
            List attItemIdList = attItemCollection.stream().map(dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"attitem")).collect(Collectors.toList());
            returnMap.put(quotaSourceId, attItemIdList);
        }
        return returnMap;
    }

    public DynamicObject getSchemaByRule() {
        return null;
    }

    static {
        EXTYPEMAP.put("A", PreDataExAttribute.PD_1010_S);
        EXTYPEMAP.put("B", PreDataExAttribute.PD_1020_S);
        EXTYPEMAP.put("C", PreDataExAttribute.PD_1040_S);
        EXTYPEMAP.put("D", PreDataExAttribute.PD_1030_S);
        EXTYPEMAP.put("E", PreDataExAttribute.PD_1050_S);
        EXTYPEMAP.put("F", PreDataExAttribute.PD_1060_S);
    }

    private static class Instance {
        private static SchemaServiceHelper INSTANCE = new SchemaServiceHelper();

        private Instance() {
        }
    }
}

