/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.business.servicehelper.common;

import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.field.DateEdit;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.sdk.wtc.wtss.business.teamhome.AttStatisticTargetQueryParam;
import kd.sdk.wtc.wtss.business.teamhome.AttTargetQueryExpandService;
import kd.wtc.wtbs.business.mobile.MobileCommonServiceHelper;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtp.business.attfile.AttFileHelper;
import kd.wtc.wtss.business.attstatistics.AbstractTeamAttStatisticsService;
import kd.wtc.wtss.business.attstatistics.AttStatisticsTargetServiceHelper;
import kd.wtc.wtss.business.attstatistics.IAttTargetQueryService;
import kd.wtc.wtss.business.servicehelper.mobile.MobileTeamHomeBusiness;
import kd.wtc.wtss.business.servicehelper.mobile.RankingDataServiceHelper;
import kd.wtc.wtss.common.dto.mobilehome.AttStatisticQueryParam;
import kd.wtc.wtss.common.enums.attstatistics.StaTypeEnum;

public class TeamHomeServiceHelper {
    private static TeamHomeServiceHelper INSTANCE = new TeamHomeServiceHelper();

    private TeamHomeServiceHelper() {
    }

    public static TeamHomeServiceHelper getInstance() {
        return INSTANCE;
    }

    public Set<Long> getPersonId(Date startDate, Date endDate, Set<Long> affiliateAdminOrgSetIds) {
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam(false);
        attFileQueryParam.setBeCurrent(Boolean.FALSE);
        attFileQueryParam.setAuthCheck(Boolean.FALSE);
        attFileQueryParam.setStartDate(startDate);
        attFileQueryParam.setEndDate(endDate);
        attFileQueryParam.setAffiliateAdminOrgSetIds(affiliateAdminOrgSetIds);
        attFileQueryParam.setProperties("attperson");
        return AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam).stream().map(dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"attperson")).collect(Collectors.toSet());
    }

    public Map<Long, DynamicObject> getAttFile(Set<Long> attPersonIdSet, long affiliateAdminOrgId, Date startDate, Date endDate) {
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam(false);
        attFileQueryParam.setBeCurrent(Boolean.FALSE);
        attFileQueryParam.setAuthCheck(Boolean.FALSE);
        attFileQueryParam.setStartDate(startDate);
        attFileQueryParam.setEndDate(endDate);
        attFileQueryParam.setAffiliateAdminOrgId(affiliateAdminOrgId);
        attFileQueryParam.setProperties("boid,bsed,name,number,attperson,attperson.id,attperson.name,attperson.number,job,job.name,position,position.name,adminorg,adminorg.name,affiliateadminorg.name,org.name,company.name");
        attFileQueryParam.setPersonSetIds(attPersonIdSet);
        List attFileList = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
        AttFileHelper.sortAttFileList((List)attFileList, (String)"bsed", (boolean)true);
        return attFileList.stream().collect(Collectors.groupingBy(dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"attperson"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
    }

    public Set<Long> getAttFileIdSet(Set<Long> attPersonIdSet, long affiliateAdminOrgId, Date startDate, Date endDate) {
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam(false);
        attFileQueryParam.setBeCurrent(Boolean.FALSE);
        attFileQueryParam.setStartDate(startDate);
        attFileQueryParam.setEndDate(endDate);
        attFileQueryParam.setAuthCheck(Boolean.FALSE);
        attFileQueryParam.setProperties(WTCStringUtils.joinOnComma((String[])new String[]{"id", "bsed", "attperson"}));
        attFileQueryParam.setPersonSetIds(attPersonIdSet);
        attFileQueryParam.setAffiliateAdminOrgId(affiliateAdminOrgId);
        List attFileList = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
        AttFileHelper.sortAttFileList((List)attFileList, (String)"bsed", (boolean)true);
        Map<Long, DynamicObject> personAttFileMap = attFileList.stream().collect(Collectors.groupingBy(dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"attperson"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
        return personAttFileMap.values().stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
    }

    public FormShowParameter getTargetInfoDiaLogParameter(AttStatisticQueryParam cacheAttStatisticQueryParam, DynamicObject dailyStaSource) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("wtss_targetinfodialog");
        formShowParameter.setCaption(dailyStaSource.getString("name"));
        long kpiId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dailyStaSource, (String)"teamhomekpi");
        Map<String, List<Map<String, String>>> detailMap = null;
        HRPluginProxy pluginProxy = HRPlugInProxyFactory.create(null, AttTargetQueryExpandService.class, (String)AbstractTeamAttStatisticsService.TARGET_QUERY_EXP_SERVICE, null);
        List expendData = pluginProxy.callReplace(expandService -> expandService.getDetailMap((AttStatisticTargetQueryParam)cacheAttStatisticQueryParam, Long.valueOf(kpiId)));
        if (WTCCollections.isEmpty((Collection)expendData)) {
            IAttTargetQueryService attTargetQueryService = AttStatisticsTargetServiceHelper.getInstance().getAttTargetQueryService(kpiId);
            if (attTargetQueryService != null) {
                detailMap = attTargetQueryService.getDetailMap((AttStatisticTargetQueryParam)cacheAttStatisticQueryParam, dailyStaSource);
            }
        } else {
            Map map = (Map)expendData.get(0);
            if (HRMapUtils.isEmpty((Map)map)) {
                IAttTargetQueryService attTargetQueryService = AttStatisticsTargetServiceHelper.getInstance().getAttTargetQueryService(kpiId);
                if (attTargetQueryService != null) {
                    detailMap = attTargetQueryService.getDetailMap((AttStatisticTargetQueryParam)cacheAttStatisticQueryParam, dailyStaSource);
                }
            } else {
                detailMap = (Map<String, List<Map<String, String>>>)expendData.get(0);
            }
        }
        if (WTCCollections.isNotEmpty(detailMap)) {
            formShowParameter.setCustomParam("target_info_key", (Object)SerializationUtils.toJsonString((Object)detailMap));
            return formShowParameter;
        }
        return formShowParameter;
    }

    public void setDateEditRange(Date minDate, IFormView view, String dayDateStr, String periodDateStr) {
        Date[] dateRange = MobileTeamHomeBusiness.getInstance().getLatestThreeMonthStartAndEndDate();
        DateEdit dateEdit = (DateEdit)view.getControl(dayDateStr);
        dateEdit.setMinDate(dateRange[0]);
        if (minDate != null) {
            dateEdit.setMaxDate(minDate);
        } else {
            dateEdit.setMaxDate(WTCDateUtils.getBeforeDate((Date)new Date()));
        }
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam(false);
        Long userId = MobileCommonServiceHelper.getInstance().getUserId();
        if (null == userId) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u7528\u6237\u8d26\u53f7\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TeamHomeServiceHelper_0", (String)"wtc-wtss-business", (Object[])new Object[0]));
            view.close();
            return;
        }
        attFileQueryParam.setAttPersonId(userId.longValue());
        attFileQueryParam.setBeCurrent(Boolean.valueOf(true));
        attFileQueryParam.setProperties("startdate, enddate");
        List attFiles = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
        if (attFiles != null && attFiles.size() > 0) {
            attFiles.sort(Comparator.comparing(dy -> dy.getDate("startdate")));
            Date date = ((DynamicObject)attFiles.get(0)).getDate("startdate");
            DateEdit periodDateEdit = (DateEdit)view.getControl(periodDateStr);
            periodDateEdit.setMinDate(date);
            Date preDate = WTCDateUtils.getBeforeDate((Date)new Date());
            periodDateEdit.setMaxDate(preDate);
            view.getModel().setValue("changeyear", (Object)preDate);
        }
    }

    public DynamicObject getDynamicObjectByChickSourceId(AttStatisticQueryParam attStatisticQueryParam) {
        Long chickSourceId = attStatisticQueryParam.getChickSourceId();
        if (chickSourceId == null) {
            return null;
        }
        DynamicObject dailyStaSource = StaTypeEnum.DAILY == attStatisticQueryParam.getStaTypeEnum() ? RankingDataServiceHelper.DAILY_STA_SOURCE_SERVICE_HELPER.queryOne("showdimen, name, valtakmethod, teamhomekpi", (Object)chickSourceId) : RankingDataServiceHelper.PER_STA_SOURCE_SERVICE_HELPER.queryOne((Object)chickSourceId);
        return dailyStaSource;
    }
}

