/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.business.servicehelper.mobile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.mcontrol.mobtable.IMobTablePackageDataHandler;
import kd.bos.form.mcontrol.mobtable.MobTableRowBuilder;
import kd.bos.form.mcontrol.mobtable.MobTableRowData;
import kd.bos.form.mcontrol.mobtable.events.MobTableHandleResult;
import kd.bos.form.mcontrol.mobtable.events.MobTablePackageDataHandlerArgs;

public class AttConfirmBillDataHandler
implements IMobTablePackageDataHandler {
    private List<DynamicObject> adBatchDataList;
    private String modifyType;

    public AttConfirmBillDataHandler(List<DynamicObject> adBatchDataList, String modifyType) {
        this.adBatchDataList = adBatchDataList;
        this.modifyType = modifyType;
    }

    public MobTableHandleResult handleData(MobTablePackageDataHandlerArgs mobTablePackageDataHandlerArgs) {
        List mobTableColumns = mobTablePackageDataHandlerArgs.getMobTableColumns();
        int length = this.adBatchDataList.size();
        ArrayList<MobTableRowData> mobTableRowDataList = new ArrayList<MobTableRowData>(16);
        MobTableHandleResult result = new MobTableHandleResult();
        for (int index = 0; index < length; ++index) {
            DynamicObject adBatchInfo = this.adBatchDataList.get(index);
            MobTableRowData mobTableRowData = MobTableRowBuilder.buildTemplateRowData((int)index, (List)mobTableColumns);
            DynamicObject itemDy = null;
            if (this.modifyType == null) {
                if (adBatchInfo.containsProperty("attitem") && adBatchInfo.get("attitem") instanceof DynamicObject) {
                    itemDy = adBatchInfo.getDynamicObject("attitem");
                }
            } else if (adBatchInfo.containsProperty("diff_attitem") && adBatchInfo.get("diff_attitem") instanceof DynamicObject) {
                itemDy = adBatchInfo.getDynamicObject("diff_attitem");
            }
            if (itemDy == null) continue;
            String itemName = itemDy.getLocaleString("name").getLocaleValue();
            String unitName = "";
            if (itemDy.getDynamicObjectType().getProperties().get((Object)"unit") != null) {
                List unitItem = ((ComboProp)itemDy.getDynamicObjectType().getProperties().get((Object)"unit")).getComboItems();
                Map<String, String> unitItemMap = unitItem.stream().collect(Collectors.toMap(ValueMapItem::getValue, e -> e.getName().getLocaleValue()));
                unitName = unitItemMap.get(itemDy.get("unit"));
            }
            if (this.modifyType == null) {
                mobTableRowData.setValue("attitemname", (Object)itemName);
                mobTableRowData.setValue("attitemresult", adBatchInfo.get("value"));
                mobTableRowData.setValue("attitemunit", (Object)unitName);
                if (adBatchInfo.containsProperty("latestvalue")) {
                    mobTableRowData.setValue("attitemlatestresult", adBatchInfo.get("latestvalue"));
                }
                if (adBatchInfo.containsProperty("lastvalue")) {
                    mobTableRowData.setValue("attitemlastresult", adBatchInfo.get("lastvalue"));
                }
            } else {
                String table_fix = "";
                switch (this.modifyType) {
                    case "A": {
                        table_fix = "_add";
                        break;
                    }
                    case "B": {
                        table_fix = "_modify";
                        break;
                    }
                    case "C": {
                        table_fix = "_remove";
                        break;
                    }
                    case "D": {
                        table_fix = "_all";
                    }
                }
                mobTableRowData.setValue("diff_attitem" + table_fix, (Object)itemName);
                if (adBatchInfo.containsProperty("diff_latestvalue")) {
                    mobTableRowData.setValue("diff_value" + table_fix, adBatchInfo.get("diff_latestvalue"));
                }
                if (adBatchInfo.containsProperty("diff_lastvalue")) {
                    mobTableRowData.setValue("diff_lastvalue" + table_fix, adBatchInfo.get("diff_lastvalue"));
                }
                mobTableRowData.setValue("diff_unit" + table_fix, (Object)unitName);
            }
            mobTableRowDataList.add(mobTableRowData);
        }
        result.setMobTableRowDataList(mobTableRowDataList);
        return result;
    }

    public Map<String, Object> getFmtInfo(MobTablePackageDataHandlerArgs mobTablePackageDataHandlerArgs) {
        return Collections.emptyMap();
    }
}

