/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.business.servicehelper.mobile;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.ORMHint;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sdk.wtc.wtbs.common.enums.WTCBillType;
import kd.sdk.wtc.wtss.business.homepage.BillReplaceExtPlugin;
import kd.sdk.wtc.wtss.business.homepage.MobileBillListDto;
import kd.sdk.wtc.wtss.business.homepage.OnFilterMobileBillListEvent;
import kd.sdk.wtc.wtss.business.homepage.OnQueryMobileBillListEvent;
import kd.wtc.wtbs.business.auth.WTCBizDataPermissionServiceImpl;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.bill.BillUnifyService;
import kd.wtc.wtbs.business.bill.batchbill.BatchBillUnifyService;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxyFactory;
import kd.wtc.wtbs.common.enums.BillSystemParamConfigEnum;
import kd.wtc.wtbs.common.enums.WTCBillChangeEnum;
import kd.wtc.wtbs.common.enums.bill.BillApplyTypeEnum;
import kd.wtc.wtbs.common.model.bill.BillSystemParamRange;
import kd.wtc.wtbs.common.util.SystemParamQueryUtil;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.ImmutableMap;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;
import kd.wtc.wtbs.common.util.third.util.MapUtils;
import kd.wtc.wtbs.common.util.third.util.NumberUtils;
import kd.wtc.wtss.business.servicehelper.mobile.MobileBillListModelBo;
import kd.wtc.wtss.common.dto.mobilebill.AuditBillModel;

public class MobileBillPageBusiness {
    private static final Log logger = LogFactory.getLog(MobileBillPageBusiness.class);
    private static final Map<Integer, Map<String, Object>> QUERY_PARAMS = MobileBillPageBusiness.getQueryParams();
    private static final String SELF_BILL_KEY = "selfBillKey";
    private static final String OTHER_BILL_KEY = "otherBillKey";
    private static final String SELECT_PROPERTIES = "selectProperties";
    private static final String ALL_STATUS = "H";
    private static final String STARTDATE = "startdate";
    private static final String ENDDATE = "enddate";
    private static final String SDATE = "sdate";
    private static final String EDATE = "edate";
    private static final String SUBMITDATE = "submitdate";
    private static final String APPLYDATE = "applydate";
    public static final Map<WTCBillType, String> SELF_BILL_MAP = MobileBillPageBusiness.getSelfBillMap();

    private MobileBillPageBusiness() {
    }

    public static MobileBillPageBusiness getInstance() {
        return Instance.INSTANCE;
    }

    @Deprecated
    public Map<String, Object> queryBills(Long userId, Long personId, Long orgId, List<String> billStatus, Date[] searchDate, int billType, String searchContent, int pageStart, int pageSize) {
        return this.queryBills(userId, personId, orgId, billStatus, searchDate, billType, searchContent, pageStart, pageSize, "wtss");
    }

    public Map<String, Object> queryBills(Long userId, Long personId, Long orgId, List<String> billStatus, Date[] searchDate, int billType, String searchContent, int pageStart, int pageSize, String appId) {
        logger.info("mobilehome querybills userId:{} personId:{} billStatus:{} searchDate:{}", new Object[]{userId, personId, billStatus, SerializationUtils.toJsonString((Object)searchDate)});
        Tuple<Integer, List<MobileBillListModelBo>> res = this.doQuery(userId, personId, orgId, billStatus, searchDate, billType, searchContent, pageStart, pageSize, appId, false);
        int rowCount = (Integer)res.getKey();
        List<Object> auditBillModels = new ArrayList(16);
        if (billType == 2 || billType == 3 || billType == 1) {
            auditBillModels = this.getBillData((List)res.getValue(), billType);
        } else if (billType == 4) {
            auditBillModels = this.getWtpmBillData((List)res.getValue());
        } else if (billType == 5) {
            auditBillModels = this.getWtsBillData((List)res.getValue());
        }
        HashMap<String, Object> returnMap = new HashMap<String, Object>(2);
        returnMap.put("total", rowCount);
        returnMap.put("data", auditBillModels);
        return returnMap;
    }

    public Integer countBills(Long userId, Long personId, Long orgId, List<String> billStatus, Date[] searchDate, int billType, String searchContent, int pageStart, int pageSize, String appId) {
        logger.info("mobilehome.countBills:userId:{} personId:{} billStatus:{} searchDate:{}", new Object[]{userId, personId, billStatus, SerializationUtils.toJsonString((Object)searchDate)});
        Tuple<Integer, List<MobileBillListModelBo>> res = this.doQuery(userId, personId, orgId, billStatus, searchDate, billType, searchContent, pageStart, pageSize, appId, true);
        return (Integer)res.getKey();
    }

    private Tuple<Integer, List<MobileBillListModelBo>> doQuery(Long userId, Long personId, Long orgId, List<String> billStatus, Date[] searchDate, int billType, String searchContent, int pageStart, int pageSize, String appId, boolean onlyCount) {
        List<Object> boList;
        Integer rowCount;
        QFilter excludeDepartFileFilter;
        QFilter qFilter1 = new QFilter("creator", "=", (Object)userId);
        QFilter qFilter2 = new QFilter("personid", "=", (Object)personId);
        QFilter personFilter = qFilter1.or(qFilter2);
        if (orgId != null) {
            personFilter.and(new QFilter("org", "=", (Object)orgId));
        }
        if ((excludeDepartFileFilter = BillCommonService.getInstance().getExcludeAttFileLevelFilter(null, personId, "attfile")) != null) {
            personFilter.and(excludeDepartFileFilter);
        }
        QFilter auditStatusFilter = null;
        if (!CollectionUtils.isEmpty(billStatus)) {
            auditStatusFilter = new QFilter("billstatus", "in", billStatus);
        }
        OnQueryMobileBillListEvent.Builder builder = new OnQueryMobileBillListEvent.Builder().setAppId(appId).setAttPersonId(personId.longValue()).setBillType((WTCBillType)BillCommonService.getInstance().BILL_TYPE_MAP_WTSS.get(billType)).setSearchBillStatus(CollectionUtils.isEmpty(billStatus) ? new ArrayList() : new ArrayList<String>(billStatus)).setOrgId(orgId).setPageSize(pageSize).setPageStart(pageStart).setUserId(userId.longValue()).setSearchPersonName(searchContent).setOnlyCount(onlyCount);
        if (searchDate != null && searchDate.length > 0) {
            if (searchDate[0] != null) {
                builder.setSearchStartDate((Date)searchDate[0].clone());
            }
            if (searchDate.length > 1) {
                builder.setSearchEndDate((Date)searchDate[1].clone());
            }
        }
        OnQueryMobileBillListEvent event = builder.build();
        WTCPluginProxy pluginProxy = WTCPluginProxyFactory.create(BillReplaceExtPlugin.class, (String)"kd.sdk.wtc.wtss.business.homepage.BillReplaceExtPlugin");
        pluginProxy.invokeReplace(plugin -> plugin.onQueryMobileBillList(event));
        if (event.getRowCount() > -1) {
            rowCount = event.getRowCount();
            boList = onlyCount ? new ArrayList() : this.getBoList(event.getBillData());
        } else {
            Map<String, Object> billMap = this.getBillDynamicData(personFilter, auditStatusFilter, searchDate, searchContent, billType, pageStart, pageSize, appId, personId, onlyCount);
            rowCount = (Integer)billMap.get("total");
            boList = onlyCount ? new ArrayList() : this.getBoList((DynamicObject[])billMap.get("data"), billType);
        }
        return new Tuple((Object)rowCount, boList);
    }

    public Map<String, Object> queryBillsForTeamHome(List<String> billStatus, Date[] searchDate, int billType, String searchContent, int pageStart, int pageSize, String appId) {
        logger.info("mobilehome querybills  billStatus:{} searchDate:{}", billStatus, (Object)SerializationUtils.toJsonString((Object)searchDate));
        Tuple<Integer, List<MobileBillListModelBo>> res = this.doQueryForTeamHome(billStatus, searchDate, billType, searchContent, pageStart, pageSize, appId);
        int rowCount = (Integer)res.getKey();
        List<Object> auditBillModels = new ArrayList(16);
        if (billType == 2 || billType == 3 || billType == 1) {
            auditBillModels = this.getBillData((List)res.getValue(), billType);
        } else if (billType == 4) {
            auditBillModels = this.getWtpmBillData((List)res.getValue());
        } else if (billType == 5) {
            auditBillModels = this.getWtsBillData((List)res.getValue());
        }
        HashMap<String, Object> returnMap = new HashMap<String, Object>(2);
        returnMap.put("total", rowCount);
        returnMap.put("data", auditBillModels);
        return returnMap;
    }

    private Tuple<Integer, List<MobileBillListModelBo>> doQueryForTeamHome(List<String> billStatus, Date[] searchDate, int billType, String searchContent, int pageStart, int pageSize, String appId) {
        QFilter auditStatusFilter = null;
        if (!CollectionUtils.isEmpty(billStatus)) {
            auditStatusFilter = new QFilter("billstatus", "in", billStatus);
        }
        Map<String, Object> billMap = this.getBillDynamicDataForTeamHome(auditStatusFilter, searchDate, searchContent, billType, pageStart, pageSize, appId);
        Integer rowCount = (Integer)billMap.get("total");
        List<MobileBillListModelBo> boList = this.getBoList((DynamicObject[])billMap.get("data"), billType);
        return new Tuple((Object)rowCount, boList);
    }

    private Map<String, Object> getBillDynamicDataForTeamHome(QFilter auditstatusFilter, Date[] searchDate, String searchContent, int billType, int pageStart, int pageSize, String appId) {
        QFilter newBillFilter;
        Map<String, Object> params = QUERY_PARAMS.get(billType);
        if (MapUtils.isEmpty(params)) {
            return Maps.newHashMap();
        }
        String selfBill = (String)params.get(SELF_BILL_KEY);
        String otherBill = (String)params.get(OTHER_BILL_KEY);
        String properties = (String)params.get(SELECT_PROPERTIES);
        QFilter dateFilter = this.getDateFilter(billType, searchDate);
        QFilter attPersonFilter = new QFilter("personid", "!=", (Object)0);
        Long currAttPersonId = BillUnifyService.getUserId();
        QFilter excludeDepartFileFilter = BillCommonService.getInstance().getExcludeAttFileLevelFilter(null, currAttPersonId, "attfile");
        if (null != excludeDepartFileFilter) {
            attPersonFilter.and(excludeDepartFileFilter);
        }
        logger.info("excludeDepartFileFilter:{}", (Object)excludeDepartFileFilter);
        ArrayList filters = Lists.newArrayList();
        filters.add(auditstatusFilter);
        filters.add(dateFilter);
        filters.add(attPersonFilter);
        if (billType == 1) {
            newBillFilter = new QFilter(WTCBillChangeEnum.BUSTRIP.getFILTER(), "=", (Object)Boolean.TRUE);
            filters.add(newBillFilter);
        } else if (billType == 2) {
            QFilter haveChangeFilter = new QFilter(WTCBillChangeEnum.VACATION.getFILTER(), "=", (Object)Boolean.FALSE);
            filters.add(haveChangeFilter);
            Tuple batchBillFilterTuple = BatchBillUnifyService.getInstance().addBatchVaShowFilter(BatchBillUnifyService::batchVaIsShowInList, BatchBillUnifyService::batchVaShowBillStatus);
            if (batchBillFilterTuple != null) {
                if (((Boolean)batchBillFilterTuple.getValue()).booleanValue()) {
                    QFilter batchBillFilter = new QFilter("applytyperadio", "in", (Object)Lists.newArrayList((Object[])new String[]{BillApplyTypeEnum.SELF.getCode(), BillApplyTypeEnum.OTHER.getCode()}));
                    filters.add(batchBillFilter.or((QFilter)batchBillFilterTuple.getKey()));
                } else {
                    filters.add(batchBillFilterTuple.getKey());
                }
            }
        } else if (billType == 3) {
            newBillFilter = new QFilter(WTCBillChangeEnum.OTAPPLY.getFILTER(), "=", (Object)Boolean.TRUE);
            filters.add(newBillFilter);
        }
        if (!StringUtils.isEmpty((CharSequence)searchContent)) {
            QFilter personNameFilter = new QFilter("personid.name", "like", (Object)("%" + searchContent + "%"));
            filters.add(personNameFilter);
        }
        QFilter authFilter = this.getAuthFilterForTeamHome(appId, selfBill, otherBill);
        filters.add(authFilter);
        logger.info("authFilter:{}", (Object)authFilter);
        logger.info("filters:{}", (Object)filters);
        Long time = System.currentTimeMillis();
        HashMap<String, Object> returnMap = new HashMap<String, Object>(2);
        int dataCount = "wtpm_supsignself".equals(selfBill) ? this.countSupSignBill(selfBill, filters) : new HRBaseServiceHelper(selfBill).queryDataSet("queryCount", "id", filters.toArray(new QFilter[0])).count("id", true);
        logger.info("dataCount take time :{}", (Object)(System.currentTimeMillis() - time));
        time = System.currentTimeMillis();
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)selfBill, (String)properties, (QFilter[])filters.toArray(new QFilter[0]), (String)"modifytime DESC", (int)pageStart, (int)pageSize);
        logger.info("BusinessDataServiceHelper.load take time :{}", (Object)(System.currentTimeMillis() - time));
        returnMap.put("total", dataCount);
        returnMap.put("data", dynamicObjects);
        return returnMap;
    }

    private QFilter getAuthFilterForTeamHome(String appId, String selfBill, String otherBill) {
        QFilter selfDataRuleFilter = PermissionServiceHelper.getDataRule((long)RequestContext.get().getCurrUserId(), (String)appId, (String)selfBill, (String)"47150e89000000ac");
        HasPermOrgResult result1 = WTCBizDataPermissionServiceImpl.getInstance().getAllPermOrgs(appId, selfBill);
        QFilter selfApplyOrgQFilter = null;
        if (result1 != null && !result1.hasAllOrgPerm() && CollectionUtils.isNotEmpty((Collection)result1.getHasPermOrgs())) {
            selfApplyOrgQFilter = new QFilter("org", "in", (Object)result1.getHasPermOrgs());
        }
        QFilter selfApplyQFilter = selfDataRuleFilter != null && selfApplyOrgQFilter != null ? selfDataRuleFilter.and(selfApplyOrgQFilter) : (selfDataRuleFilter != null ? selfDataRuleFilter : selfApplyOrgQFilter);
        String dataRule2QueryKey = otherBill;
        if ("wtpm_supsignpc".equals(otherBill)) {
            dataRule2QueryKey = "wtpm_supsignpcqueryconf";
        }
        QFilter otherApplyDataRuleFilter = PermissionServiceHelper.getDataRule((long)RequestContext.get().getCurrUserId(), (String)appId, (String)dataRule2QueryKey, (String)"47150e89000000ac");
        HasPermOrgResult result2 = WTCBizDataPermissionServiceImpl.getInstance().getAllPermOrgs(appId, otherBill);
        QFilter otherApplyOrgQFilter = null;
        if (result2 != null && !result2.hasAllOrgPerm() && CollectionUtils.isNotEmpty((Collection)result2.getHasPermOrgs())) {
            otherApplyOrgQFilter = new QFilter("org", "in", (Object)result2.getHasPermOrgs());
        }
        QFilter otherApplyQFilter = otherApplyDataRuleFilter != null && otherApplyOrgQFilter != null ? otherApplyDataRuleFilter.and(otherApplyOrgQFilter) : (otherApplyDataRuleFilter != null ? otherApplyDataRuleFilter : otherApplyOrgQFilter);
        Map<String, Boolean> formRights = MobileBillPageBusiness.getInstance().getFormRightsForOther(appId);
        QFilter authFilter = Boolean.TRUE.equals(formRights.get(otherBill)) ? otherApplyQFilter : (Boolean.TRUE.equals(formRights.get(selfBill)) ? selfApplyQFilter : new QFilter("applytyperadio", "!=", (Object)"0").and(new QFilter("applytyperadio", "!=", (Object)"1")));
        return authFilter;
    }

    private List<AuditBillModel> getBillData(List<MobileBillListModelBo> bills, int billType) {
        ArrayList<AuditBillModel> auditBillModels = new ArrayList<AuditBillModel>(16);
        if (CollectionUtils.isNotEmpty(bills)) {
            SimpleDateFormat dateFormat = WTCInteDateUtil.getUserSimpleDateFormat();
            for (MobileBillListModelBo bill : bills) {
                AuditBillModel auditBillModel = new AuditBillModel();
                auditBillModel.setId(bill.getId().longValue());
                auditBillModel.setBillType(billType);
                auditBillModel.setBillStatus(bill.getBillStatus());
                auditBillModel.setSubmitDate(WTCInteDateUtil.formatByUserTzAndFmt((Date)bill.getSubmitDate()));
                auditBillModel.setStartTime(dateFormat.format(bill.getStartDate()));
                auditBillModel.setEndTime(dateFormat.format(bill.getEndDate()));
                auditBillModel.setModifytime(bill.getModifyTime());
                auditBillModel.setApplyType(this.getApplyType(bill));
                auditBillModel.setPersonId(bill.getPersonId());
                auditBillModel.setPersonName(bill.getPersonName() == null ? "***" : bill.getPersonName());
                auditBillModel.setCreatorid(bill.getCreatorId().longValue());
                auditBillModel.setChange(bill.isChange());
                auditBillModel.setBillTitle(this.getTitleString(auditBillModel));
                auditBillModels.add(auditBillModel);
            }
        }
        return auditBillModels;
    }

    private List<AuditBillModel> getWtpmBillData(List<MobileBillListModelBo> bills) {
        ArrayList<AuditBillModel> auditBillModels = new ArrayList<AuditBillModel>(16);
        if (CollectionUtils.isNotEmpty(bills)) {
            SimpleDateFormat simpleDateFormat = WTCInteDateUtil.getUserSimpleDateFormat();
            for (MobileBillListModelBo bill : bills) {
                AuditBillModel auditBillModel = new AuditBillModel();
                auditBillModel.setId(bill.getId().longValue());
                auditBillModel.setBillType(4);
                auditBillModel.setBillStatus(bill.getBillStatus());
                auditBillModel.setSubmitDate(WTCInteDateUtil.formatByUserTzAndFmt((Date)bill.getSubmitDate()));
                auditBillModel.setModifytime(bill.getModifyTime());
                auditBillModel.setApplyType(this.getApplyType(bill));
                auditBillModel.setPersonId(bill.getPersonId());
                auditBillModel.setPersonName(bill.getPersonName() == null ? "***" : bill.getPersonName());
                auditBillModel.setCreatorid(bill.getCreatorId().longValue());
                auditBillModel.setChange(bill.isChange());
                auditBillModel.setBillTitle(this.getTitleString(auditBillModel));
                DynamicObjectCollection dynamicObjectCollection = bill.getEntryEntity();
                Date startDate = null;
                Date endDate = null;
                for (DynamicObject signEntity : dynamicObjectCollection) {
                    Date signDate = signEntity.getDate("signdate");
                    if (startDate == null) {
                        startDate = signDate;
                        endDate = signDate;
                        continue;
                    }
                    if (signDate.before(startDate)) {
                        startDate = signDate;
                        continue;
                    }
                    if (!signDate.after(endDate)) continue;
                    endDate = signDate;
                }
                auditBillModel.setStartTime(simpleDateFormat.format(startDate));
                auditBillModel.setEndTime(simpleDateFormat.format(endDate));
                auditBillModels.add(auditBillModel);
            }
        }
        return auditBillModels;
    }

    private List<AuditBillModel> getWtsBillData(List<MobileBillListModelBo> bills) {
        ArrayList<AuditBillModel> auditBillModels = new ArrayList<AuditBillModel>(16);
        if (CollectionUtils.isNotEmpty(bills)) {
            SimpleDateFormat dateFormat = WTCInteDateUtil.getUserSimpleDateFormat();
            for (MobileBillListModelBo bill : bills) {
                AuditBillModel auditBillModel = new AuditBillModel();
                auditBillModel.setId(bill.getId().longValue());
                auditBillModel.setBillType(5);
                auditBillModel.setBillStatus(bill.getBillStatus());
                auditBillModel.setSubmitDate(WTCInteDateUtil.formatByUserTzAndFmt((Date)bill.getSubmitDate()));
                auditBillModel.setModifytime(bill.getModifyTime());
                auditBillModel.setApplyType(this.getApplyType(bill));
                auditBillModel.setPersonId(bill.getPersonId());
                auditBillModel.setPersonName(bill.getPersonName() == null ? "***" : bill.getPersonName());
                auditBillModel.setCreatorid(bill.getCreatorId().longValue());
                auditBillModel.setBillTitle(this.getTitleString(auditBillModel));
                DynamicObjectCollection dynamicObjectCollection = bill.getEntryEntity();
                Date startDate = null;
                Date endDate = null;
                for (DynamicObject signEntity : dynamicObjectCollection) {
                    Date signDate = signEntity.getDate("swdate");
                    if (startDate == null) {
                        startDate = signDate;
                        endDate = signDate;
                        continue;
                    }
                    if (signDate.before(startDate)) {
                        startDate = signDate;
                        continue;
                    }
                    if (!signDate.after(endDate)) continue;
                    endDate = signDate;
                }
                auditBillModel.setStartTime(dateFormat.format(startDate));
                auditBillModel.setEndTime(dateFormat.format(endDate));
                auditBillModels.add(auditBillModel);
            }
        }
        return auditBillModels;
    }

    private Map<String, Object> getBillDynamicData(QFilter personFilter, QFilter auditstatusFilter, Date[] searchDate, String searchContent, int billType, int pageStart, int pageSize, String appId, Long personId, boolean onlyCount) {
        QFilter newBillFilter;
        Map<String, Object> params = QUERY_PARAMS.get(billType);
        if (MapUtils.isEmpty(params)) {
            return Maps.newHashMap();
        }
        String selfBill = (String)params.get(SELF_BILL_KEY);
        String otherBill = (String)params.get(OTHER_BILL_KEY);
        String properties = (String)params.get(SELECT_PROPERTIES);
        QFilter dateFilter = this.getDateFilter(billType, searchDate);
        QFilter attPersonFilter = new QFilter("personid", "!=", (Object)0);
        ArrayList filters = Lists.newArrayList();
        filters.add(personFilter);
        filters.add(auditstatusFilter);
        filters.add(dateFilter);
        filters.add(attPersonFilter);
        if (billType == 1) {
            newBillFilter = new QFilter(WTCBillChangeEnum.BUSTRIP.getFILTER(), "=", (Object)Boolean.TRUE);
            filters.add(newBillFilter);
        } else if (billType == 2) {
            QFilter haveChangeFilter = new QFilter(WTCBillChangeEnum.VACATION.getFILTER(), "=", (Object)Boolean.FALSE);
            filters.add(haveChangeFilter);
            Tuple batchBillFilterTuple = BatchBillUnifyService.getInstance().addBatchVaShowFilter(BatchBillUnifyService::batchVaIsShowInList, BatchBillUnifyService::batchVaShowBillStatus);
            if (batchBillFilterTuple != null) {
                if (((Boolean)batchBillFilterTuple.getValue()).booleanValue()) {
                    QFilter batchBillFilter = new QFilter("applytyperadio", "in", (Object)Lists.newArrayList((Object[])new String[]{BillApplyTypeEnum.SELF.getCode(), BillApplyTypeEnum.OTHER.getCode()}));
                    filters.add(batchBillFilter.or((QFilter)batchBillFilterTuple.getKey()));
                } else {
                    filters.add(batchBillFilterTuple.getKey());
                }
            }
        } else if (billType == 3) {
            newBillFilter = new QFilter(WTCBillChangeEnum.OTAPPLY.getFILTER(), "=", (Object)Boolean.TRUE);
            filters.add(newBillFilter);
        } else if (billType == 4) {
            newBillFilter = new QFilter(WTCBillChangeEnum.SUP.getFILTER(), "=", (Object)Boolean.TRUE);
            filters.add(newBillFilter);
        }
        if (!StringUtils.isEmpty((CharSequence)searchContent)) {
            QFilter personNameFilter = new QFilter("personid.name", "like", (Object)("%" + searchContent + "%"));
            filters.add(personNameFilter);
        }
        QFilter authFilter = this.getAuthFilter(personId, appId, selfBill, otherBill);
        filters.add(authFilter);
        HashMap<String, Object> returnMap = new HashMap<String, Object>(2);
        int dataCount = "wtpm_supsignself".equals(selfBill) ? this.countSupSignBill(selfBill, filters) : new HRBaseServiceHelper(selfBill).queryDataSet("queryCount", "id", filters.toArray(new QFilter[0])).count("id", true);
        DynamicObject[] dynamicObjects = onlyCount ? new DynamicObject[]{} : BusinessDataServiceHelper.load((String)selfBill, (String)properties, (QFilter[])filters.toArray(new QFilter[0]), (String)"modifytime DESC", (int)pageStart, (int)pageSize);
        returnMap.put("total", dataCount);
        returnMap.put("data", dynamicObjects);
        return returnMap;
    }

    private int countSupSignBill(String entityNumber, List<QFilter> filters) {
        ORM orm = ORM.create();
        return orm.count("QueryServiceHelper." + entityNumber, entityNumber, "id", filters.toArray(new QFilter[0]), (iDataEntityType, map, qContext) -> true);
    }

    public List<String> getAuditStatusChoose(String auditStatus) {
        if (StringUtils.isEmpty((CharSequence)auditStatus) || StringUtils.contains((CharSequence)auditStatus, (CharSequence)ALL_STATUS)) {
            return null;
        }
        String[] splitStrs = StringUtils.split((String)auditStatus, (String)",");
        return Arrays.stream(splitStrs).filter(strTemp -> !StringUtils.isEmpty((CharSequence)strTemp)).collect(Collectors.toList());
    }

    public static Date[] getStartAndEndDate(String timeRange) {
        if (StringUtils.isEmpty((CharSequence)timeRange)) {
            return null;
        }
        Calendar userCalendar = Calendar.getInstance(WTCInteDateUtil.getUserTimeZone().getTimeZone());
        Date[] billDates = new Date[2];
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        calendar.set(5, userCalendar.get(5));
        calendar.set(2, userCalendar.get(2));
        billDates[1] = calendar.getTime();
        boolean realDateFlag = false;
        switch (timeRange) {
            case "1": {
                calendar.add(5, -2);
                break;
            }
            case "2": {
                calendar.add(5, -6);
                break;
            }
            case "3": {
                calendar.set(5, 1);
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                billDates[0] = calendar.getTime();
                int size = billDates.length;
                calendar.setTime(billDates[size - 1]);
                calendar.add(2, 1);
                calendar.set(5, 0);
                billDates[1] = calendar.getTime();
                break;
            }
            case "4": {
                calendar.add(2, -3);
                break;
            }
            case "5": {
                calendar.add(2, -6);
                break;
            }
            case "6": {
                calendar.add(1, -1);
                break;
            }
            default: {
                realDateFlag = true;
            }
        }
        if (realDateFlag) {
            Object[] splitDate = WTCStringUtils.split((String)timeRange, (String)";");
            if (ArrayUtils.isEmpty((Object[])splitDate) || splitDate.length != 2) {
                return null;
            }
            billDates[0] = WTCDateUtils.str2Date((String)splitDate[0], (String)"yyyy-MM-dd HH:mm:ss");
            billDates[1] = WTCDateUtils.str2Date((String)splitDate[1], (String)"yyyy-MM-dd HH:mm:ss");
            return billDates;
        }
        if (!StringUtils.equals((CharSequence)"3", (CharSequence)timeRange)) {
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            billDates[0] = calendar.getTime();
        }
        return billDates;
    }

    private String getTitleString(AuditBillModel auditBillModel) {
        if (auditBillModel.isChange()) {
            return String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\u7684%2$s\u53d8\u66f4\u7533\u8bf7\u5355", (String)"MobileBillFormPlugin_1", (String)"wtc-wtss-formplugin", (Object[])new Object[0]), auditBillModel.getPersonName(), auditBillModel.getBillTypeName());
        }
        return String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\u7684%2$s\u7533\u8bf7\u5355", (String)"MobileBillFormPlugin_0", (String)"wtc-wtss-formplugin", (Object[])new Object[0]), auditBillModel.getPersonName(), auditBillModel.getBillTypeName());
    }

    public DynamicObject[] getRowDynamicObjects(EntityType entityType, List<AuditBillModel> auditBillModels) {
        DynamicObject[] dataEntitys = new DynamicObject[auditBillModels.size()];
        for (int index = 0; index < auditBillModels.size(); ++index) {
            DynamicObject rowObj = new DynamicObject((DynamicObjectType)entityType);
            rowObj.set("billtitle", (Object)auditBillModels.get(index).getBillTitle());
            rowObj.set("billstatus", (Object)auditBillModels.get(index).getBillStatus());
            rowObj.set("textstarttime", (Object)auditBillModels.get(index).getStartTime());
            rowObj.set("textendtime", (Object)auditBillModels.get(index).getEndTime());
            rowObj.set(SUBMITDATE, (Object)auditBillModels.get(index).getSubmitDate());
            rowObj.set("billapplytype", (Object)auditBillModels.get(index).getApplyType());
            dataEntitys[index] = rowObj;
        }
        return dataEntitys;
    }

    public BillSystemParamRange getBillSystemParamRange(int billType) {
        if (billType == 2) {
            return SystemParamQueryUtil.getBillSystemParamRange((BillSystemParamConfigEnum)BillSystemParamConfigEnum.ABS);
        }
        if (billType == 4) {
            return SystemParamQueryUtil.getBillSystemParamRange((BillSystemParamConfigEnum)BillSystemParamConfigEnum.SUPPLE);
        }
        if (billType == 3) {
            return SystemParamQueryUtil.getBillSystemParamRange((BillSystemParamConfigEnum)BillSystemParamConfigEnum.OT);
        }
        if (billType == 5) {
            return SystemParamQueryUtil.getBillSystemParamRange((BillSystemParamConfigEnum)BillSystemParamConfigEnum.SHIFT);
        }
        return SystemParamQueryUtil.getBillSystemParamRange((BillSystemParamConfigEnum)BillSystemParamConfigEnum.BUSITRIP);
    }

    public boolean dateCheckSuccess(BillSystemParamRange range, List<Object> dateRange) {
        if (range == null || CollectionUtils.isEmpty(dateRange) || dateRange.size() != 2) {
            return true;
        }
        String startDateStr = (String)dateRange.get(0);
        String endDateStr = (String)dateRange.get(1);
        DateTimeFormatter ft = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        startDateStr = StringUtils.substring((String)startDateStr, (int)0, (int)"yyyy-MM-dd".length());
        endDateStr = StringUtils.substring((String)endDateStr, (int)0, (int)"yyyy-MM-dd".length());
        LocalDate startDate = LocalDate.parse(startDateStr, ft);
        LocalDate endDate = LocalDate.parse(endDateStr, ft);
        LocalDate goalDate = startDate;
        switch (range.getUnit()) {
            case "year": {
                goalDate = startDate.plusYears(range.getRange().intValue());
                break;
            }
            case "month": {
                goalDate = startDate.plusMonths(range.getRange().intValue());
                break;
            }
            case "day": {
                goalDate = startDate.plusDays(range.getRange().intValue());
                break;
            }
        }
        return !endDate.isAfter(goalDate) && !endDate.isEqual(goalDate);
    }

    public String genUnitStr(BillSystemParamRange range) {
        String unitStr = StringUtils.equals((CharSequence)range.getUnit(), (CharSequence)"year") ? ResManager.loadKDString((String)"\u5e74", (String)"MobileBillPageBusiness_0", (String)"wtc-wtss-business", (Object[])new Object[0]) : (StringUtils.equals((CharSequence)range.getUnit(), (CharSequence)"month") ? ResManager.loadKDString((String)"\u4e2a\u6708", (String)"MobileBillPageBusiness_1", (String)"wtc-wtss-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u65e5", (String)"MobileBillPageBusiness_2", (String)"wtc-wtss-business", (Object[])new Object[0]));
        return unitStr;
    }

    public boolean hasViewRight(String appId) {
        Map<String, Boolean> formRights = this.getFormRights(appId);
        Map<String, Boolean> billTypeRights = this.getBillTypeRights(formRights);
        return billTypeRights.entrySet().stream().anyMatch(entry -> Boolean.TRUE.equals(entry.getValue()));
    }

    public boolean hasViewRightForOther(String appId) {
        Map<String, Boolean> formRights = this.getFormRightsForOther(appId);
        Map<String, Boolean> billTypeRights = this.getBillTypeRightsForOther(formRights);
        return billTypeRights.entrySet().stream().anyMatch(entry -> Boolean.TRUE.equals(entry.getValue()));
    }

    public Map<String, Boolean> getFormRights(String appId) {
        if (StringUtils.isBlank((CharSequence)appId)) {
            appId = "wtss";
        }
        String appIdKey = "appId";
        String formIdKey = "formId";
        ArrayList forms = Lists.newArrayList((Object[])new Map[]{ImmutableMap.of((Object)appIdKey, (Object)appId, (Object)formIdKey, (Object)"wtom_otbillself"), ImmutableMap.of((Object)appIdKey, (Object)appId, (Object)formIdKey, (Object)"wtabm_vaapplyself"), ImmutableMap.of((Object)appIdKey, (Object)appId, (Object)formIdKey, (Object)"wtam_busitripselfbill"), ImmutableMap.of((Object)appIdKey, (Object)appId, (Object)formIdKey, (Object)"wtpm_supsignself"), ImmutableMap.of((Object)appIdKey, (Object)appId, (Object)formIdKey, (Object)"wts_swshiftselfbill"), ImmutableMap.of((Object)appIdKey, (Object)"wtam", (Object)formIdKey, (Object)"wtom_overtimeapplybill"), ImmutableMap.of((Object)appIdKey, (Object)"wtam", (Object)formIdKey, (Object)"wtabm_vaapply"), ImmutableMap.of((Object)appIdKey, (Object)"wtam", (Object)formIdKey, (Object)"wtam_busitripbill"), ImmutableMap.of((Object)appIdKey, (Object)"wtam", (Object)formIdKey, (Object)"wts_swshiftbill"), ImmutableMap.of((Object)appIdKey, (Object)"wtam", (Object)formIdKey, (Object)"wtpm_supsignpc")});
        HashMap formRights = Maps.newHashMapWithExpectedSize((int)forms.size());
        for (Map form : forms) {
            boolean hasRight = BillCommonService.getInstance().hasViewRight((String)form.get(appIdKey), (String)form.get(formIdKey));
            formRights.put(form.get(formIdKey), hasRight);
        }
        return formRights;
    }

    public Map<String, Boolean> getFormRightsForOther(String appId) {
        if (StringUtils.isBlank((CharSequence)appId)) {
            appId = "wtss";
        }
        String appIdKey = "appId";
        String formIdKey = "formId";
        ArrayList forms = Lists.newArrayList((Object[])new Map[]{ImmutableMap.of((Object)appIdKey, (Object)appId, (Object)formIdKey, (Object)"wtom_otbillself"), ImmutableMap.of((Object)appIdKey, (Object)appId, (Object)formIdKey, (Object)"wtabm_vaapplyself"), ImmutableMap.of((Object)appIdKey, (Object)appId, (Object)formIdKey, (Object)"wtam_busitripselfbill"), ImmutableMap.of((Object)appIdKey, (Object)appId, (Object)formIdKey, (Object)"wtpm_supsignself"), ImmutableMap.of((Object)appIdKey, (Object)appId, (Object)formIdKey, (Object)"wts_swshiftselfbill"), ImmutableMap.of((Object)appIdKey, (Object)appId, (Object)formIdKey, (Object)"wtom_overtimeapplybill"), ImmutableMap.of((Object)appIdKey, (Object)appId, (Object)formIdKey, (Object)"wtabm_vaapply"), ImmutableMap.of((Object)appIdKey, (Object)appId, (Object)formIdKey, (Object)"wtam_busitripbill"), ImmutableMap.of((Object)appIdKey, (Object)appId, (Object)formIdKey, (Object)"wts_swshiftbill"), ImmutableMap.of((Object)appIdKey, (Object)appId, (Object)formIdKey, (Object)"wtpm_supsignpc")});
        HashMap formRights = Maps.newHashMapWithExpectedSize((int)forms.size());
        for (Map form : forms) {
            boolean hasRight = BillCommonService.getInstance().hasViewRight((String)form.get(appIdKey), (String)form.get(formIdKey));
            formRights.put(form.get(formIdKey), hasRight);
        }
        return formRights;
    }

    public String getDefaultBillType(Map<String, Boolean> billTypeRights) {
        return billTypeRights.entrySet().stream().filter(entry -> Boolean.TRUE.equals(entry.getValue())).findFirst().map(Map.Entry::getKey).orElseGet(() -> null);
    }

    public Map<String, Boolean> getBillTypeRights(Map<String, Boolean> formRights) {
        LinkedHashMap billTypeRights = Maps.newLinkedHashMap();
        billTypeRights.put(String.valueOf(3), Boolean.TRUE.equals(formRights.get("wtom_otbillself")) || Boolean.TRUE.equals(formRights.get("wtom_overtimeapplybill")));
        billTypeRights.put(String.valueOf(2), Boolean.TRUE.equals(formRights.get("wtabm_vaapplyself") != false || Boolean.TRUE.equals(formRights.get("wtabm_vaapply"))));
        billTypeRights.put(String.valueOf(1), Boolean.TRUE.equals(formRights.get("wtam_busitripselfbill") != false || Boolean.TRUE.equals(formRights.get("wtam_busitripbill"))));
        billTypeRights.put(String.valueOf(4), Boolean.TRUE.equals(formRights.get("wtpm_supsignself") != false || Boolean.TRUE.equals(formRights.get("wtpm_supsignpc"))));
        billTypeRights.put(String.valueOf(5), Boolean.TRUE.equals(formRights.get("wts_swshiftselfbill") != false || Boolean.TRUE.equals(formRights.get("wts_swshiftbill"))));
        OnFilterMobileBillListEvent event = new OnFilterMobileBillListEvent();
        WTCPluginProxy proxy = WTCPluginProxyFactory.create(BillReplaceExtPlugin.class, (String)"kd.sdk.wtc.wtss.business.homepage.BillReplaceExtPlugin");
        proxy.invokeReplace(plugin -> plugin.onFilterMobileBillList(event));
        Map billTypeRightsExt = event.getBillTypeRights();
        if (MapUtils.isNotEmpty((Map)billTypeRightsExt)) {
            billTypeRightsExt.forEach((type, hasRight) -> {
                String key = String.valueOf(BillCommonService.getInstance().BILL_TYPE_MAP_WTC.get(type));
                billTypeRights.put(key, hasRight);
            });
        }
        return billTypeRights;
    }

    public Map<String, Boolean> getBillTypeRightsForOther(Map<String, Boolean> formRights) {
        LinkedHashMap billTypeRights = Maps.newLinkedHashMap();
        billTypeRights.put(String.valueOf(3), Boolean.TRUE.equals(formRights.get("wtom_overtimeapplybill")));
        billTypeRights.put(String.valueOf(2), Boolean.TRUE.equals(formRights.get("wtabm_vaapply")));
        billTypeRights.put(String.valueOf(1), Boolean.TRUE.equals(formRights.get("wtam_busitripbill")));
        billTypeRights.put(String.valueOf(4), Boolean.TRUE.equals(formRights.get("wtpm_supsignpc")));
        billTypeRights.put(String.valueOf(5), Boolean.TRUE.equals(formRights.get("wts_swshiftbill")));
        return billTypeRights;
    }

    public String[] getBillTypeFormKeys(String billType) {
        LinkedHashMap forms = Maps.newLinkedHashMap();
        forms.put(String.valueOf(3), new String[]{"wtom_otbillself", "wtom_overtimeapplybill"});
        forms.put(String.valueOf(2), new String[]{"wtabm_vaapplyself", "wtabm_vaapply"});
        forms.put(String.valueOf(1), new String[]{"wtam_busitripselfbill", "wtam_busitripbill"});
        forms.put(String.valueOf(4), new String[]{"wtpm_supsignself", "wtpm_supsignpc"});
        forms.put(String.valueOf(5), new String[]{"wts_swshiftselfbill", "wts_swshiftbill"});
        return (String[])forms.get(billType);
    }

    private QFilter getAuthFilter(Long personId, String appId, String selfBill, String otherBill) {
        Map<String, Boolean> formRights;
        HasPermOrgResult result2;
        HasPermOrgResult result1;
        QFilter applyTypeFilter1 = new QFilter("applytyperadio", "=", (Object)"0").or(new QFilter("personid", "=", (Object)personId).and(new QFilter("billstatus", "not in", Arrays.asList("A", "G"))));
        QFilter dataRuleFilter1 = PermissionServiceHelper.getDataRule((long)RequestContext.get().getCurrUserId(), (String)appId, (String)selfBill, (String)"47150e89000000ac");
        if (dataRuleFilter1 != null) {
            applyTypeFilter1.and(dataRuleFilter1);
        }
        if ((result1 = WTCBizDataPermissionServiceImpl.getInstance().getAllPermOrgs(appId, selfBill)) != null && !result1.hasAllOrgPerm() && CollectionUtils.isNotEmpty((Collection)result1.getHasPermOrgs())) {
            applyTypeFilter1.and(new QFilter("org", "in", (Object)result1.getHasPermOrgs()));
        }
        QFilter applyTypeFilter2 = new QFilter("applytyperadio", "in", (Object)Lists.newArrayList((Object[])new String[]{"1", "2"})).and(new QFilter("personid", "!=", (Object)personId));
        String dataRule2QueryKey = otherBill;
        if ("wtpm_supsignpc".equals(otherBill)) {
            dataRule2QueryKey = "wtpm_supsignpcqueryconf";
        }
        String otherBillCheckRightAppId = BillCommonService.getInstance().getOtherBillCheckRightAppId(appId);
        QFilter dataRuleFilter2 = PermissionServiceHelper.getDataRule((long)RequestContext.get().getCurrUserId(), (String)otherBillCheckRightAppId, (String)dataRule2QueryKey, (String)"47150e89000000ac");
        if (dataRuleFilter2 != null) {
            applyTypeFilter2.and(dataRuleFilter2);
        }
        if ((result2 = WTCBizDataPermissionServiceImpl.getInstance().getAllPermOrgs(otherBillCheckRightAppId, otherBill)) != null && !result2.hasAllOrgPerm() && CollectionUtils.isNotEmpty((Collection)result2.getHasPermOrgs())) {
            applyTypeFilter2.and(new QFilter("org", "in", (Object)result2.getHasPermOrgs()));
        }
        QFilter authFilter = Boolean.TRUE.equals((formRights = MobileBillPageBusiness.getInstance().getFormRights(appId)).get(selfBill)) && Boolean.TRUE.equals(formRights.get(otherBill)) ? applyTypeFilter1.or(applyTypeFilter2) : (Boolean.TRUE.equals(formRights.get(selfBill)) ? applyTypeFilter1 : (Boolean.TRUE.equals(formRights.get(otherBill)) ? applyTypeFilter2 : new QFilter("applytyperadio", "!=", (Object)"0").and(new QFilter("applytyperadio", "!=", (Object)"1"))));
        return authFilter;
    }

    private int getApplyType(MobileBillListModelBo bill) {
        String applyTypeRadio = bill.getApplyType();
        return NumberUtils.isDigits((String)applyTypeRadio) ? Integer.parseInt(applyTypeRadio) : 1;
    }

    private List<MobileBillListModelBo> getBoList(DynamicObject[] bills, int billType) {
        String submitDateKey;
        String endDateKey;
        String startDateKey;
        if (billType == 1) {
            startDateKey = SDATE;
            endDateKey = EDATE;
            submitDateKey = APPLYDATE;
        } else {
            startDateKey = STARTDATE;
            endDateKey = ENDDATE;
            submitDateKey = SUBMITDATE;
        }
        return Arrays.stream(bills).map(bill -> {
            MobileBillListModelBo bo = new MobileBillListModelBo();
            bo.setId(bill.getLong("id"));
            bo.setBillStatus(bill.getString("billstatus"));
            if (billType != 4 && billType != 5) {
                bo.setStartDate(bill.getDate(startDateKey));
                bo.setEndDate(bill.getDate(endDateKey));
            }
            bo.setSubmitDate(bill.getDate(submitDateKey));
            bo.setModifyTime(bill.getDate("modifytime"));
            bo.setApplyType(bill.getString("applytyperadio"));
            bo.setPersonId(bill.getLong("personid.id"));
            bo.setPersonName(bill.getString("personid.name"));
            bo.setCreatorId(bill.getLong("creator.id"));
            bo.setCreatorName(bill.getString("creator.name"));
            if (bill.getDataEntityType().getProperties().containsKey((Object)"isChange")) {
                bo.setChange(bill.getBoolean("isChange"));
            }
            if (billType == 4 || billType == 5) {
                bo.setEntryEntity(bill.getDynamicObjectCollection("entryentity"));
            }
            return bo;
        }).collect(Collectors.toList());
    }

    private List<MobileBillListModelBo> getBoList(MobileBillListDto[] bills) {
        return Arrays.stream(bills).map(bill -> {
            MobileBillListModelBo bo = new MobileBillListModelBo();
            bo.setId(bill.getId());
            bo.setBillStatus(bill.getBillStatus());
            bo.setStartDate(bill.getStartDate());
            bo.setEndDate(bill.getEndDate());
            bo.setSubmitDate(bill.getSubmitDate());
            bo.setModifyTime(bill.getModifyTime());
            bo.setApplyType(bill.getApplyType());
            bo.setPersonId(bill.getPersonId());
            bo.setPersonName(bill.getPersonName());
            bo.setCreatorId(bill.getCreatorId());
            bo.setCreatorName(bill.getCreatorName());
            return bo;
        }).collect(Collectors.toList());
    }

    private QFilter getDateFilter(int billType, Date[] searchDate) {
        if (ArrayUtils.isEmpty((Object[])searchDate)) {
            return null;
        }
        QFilter dateFilter = null;
        int length = searchDate.length;
        if (billType == 2) {
            QFilter entryDateFilter = new QFilter("entryentity.entrystartdate", "<=", (Object)searchDate[length - 1]).and(new QFilter("entryentity.entryenddate", ">=", (Object)searchDate[0]));
            QFilter dateFilter1 = new QFilter(STARTDATE, "<=", (Object)searchDate[length - 1]).and(ENDDATE, ">=", (Object)searchDate[0]);
            dateFilter = entryDateFilter.and(dateFilter1);
        } else if (billType == 3) {
            QFilter dateFilter1 = new QFilter("scentry.otdate", "<=", (Object)searchDate[length - 1]).and("scentry.otdate", ">=", (Object)searchDate[0]);
            QFilter dateFilter2 = new QFilter("sdentry.otdutydate", "<=", (Object)searchDate[length - 1]).and("sdentry.otdutydate", ">=", (Object)searchDate[0]);
            QFilter entryDateFilter = dateFilter1.or(dateFilter2);
            QFilter dateFilterSc = new QFilter("scentry.otdate", "<=", (Object)searchDate[length - 1]).and("scentry.otdate", ">=", (Object)searchDate[0]);
            QFilter scentryLeftJoin = QFilter.join((String)"id", (String)"scentry.id", (QFilter)dateFilterSc, (ORMHint.JoinHint)ORMHint.JoinHint.LEFT, (boolean)true);
            QFilter dateFilterSd = new QFilter("sdentry.otdutydate", "<=", (Object)searchDate[length - 1]).and("sdentry.otdutydate", ">=", (Object)searchDate[0]);
            QFilter sdentryLeftJoin = QFilter.join((String)"id", (String)"sdentry.id", (QFilter)dateFilterSd, (ORMHint.JoinHint)ORMHint.JoinHint.LEFT, (boolean)true);
            QFilter dateFilter3 = new QFilter(STARTDATE, "<=", (Object)searchDate[length - 1]).and(ENDDATE, ">=", (Object)searchDate[0]);
            QFilter leftJoinQFilter = scentryLeftJoin.and(sdentryLeftJoin);
            QFilter notnullQFilter = new QFilter("scentry.id", "!=", (Object)0).or(new QFilter("sdentry.id", "!=", (Object)0));
            dateFilter = dateFilter3.and(entryDateFilter).and(leftJoinQFilter).and(notnullQFilter);
        } else if (billType == 1) {
            QFilter entryDateFilter = new QFilter("entryentity.startdate", "<=", (Object)searchDate[length - 1]).and("entryentity.enddate", ">=", (Object)searchDate[0]);
            QFilter dateFilter1 = new QFilter(SDATE, "<=", (Object)searchDate[length - 1]).and(EDATE, ">=", (Object)searchDate[0]);
            dateFilter = entryDateFilter.and(dateFilter1);
        } else if (billType == 4) {
            dateFilter = new QFilter("entryentity.signdate", "<=", (Object)searchDate[length - 1]).and("entryentity.signdate", ">=", (Object)searchDate[0]);
        } else if (billType == 5) {
            dateFilter = new QFilter("entryentity.swdate", "<=", (Object)searchDate[length - 1]).and("entryentity.swdate", ">=", (Object)searchDate[0]);
        }
        return dateFilter;
    }

    private static Map<Integer, Map<String, Object>> getQueryParams() {
        String otProperties = "id,creator,personid,billstatus,submitdate,startdate,enddate,isChange,modifytime,applytyperadio";
        String buProperties = "id,creator,personid,billstatus,applydate,sdate,edate,isChange,modifytime,applytyperadio";
        String vaProperties = "id,creator,personid,billstatus,submitdate,startdate,enddate,isChange,modifytime,applytyperadio";
        String suProperties = "id,creator,personid,billstatus,createtime,entryentity.signdate,modifytime,applytyperadio,submitdate,isChange";
        String swProperties = "id,creator,personid,billstatus,createtime,entryentity.swdate,modifytime,applytyperadio,submitdate";
        HashMap map = Maps.newHashMapWithExpectedSize((int)4);
        map.put(1, ImmutableMap.of((Object)SELF_BILL_KEY, (Object)"wtam_busitripselfbill", (Object)SELECT_PROPERTIES, (Object)buProperties, (Object)OTHER_BILL_KEY, (Object)"wtam_busitripbill"));
        map.put(2, ImmutableMap.of((Object)SELF_BILL_KEY, (Object)"wtabm_vaapplyself", (Object)SELECT_PROPERTIES, (Object)vaProperties, (Object)OTHER_BILL_KEY, (Object)"wtabm_vaapply"));
        map.put(3, ImmutableMap.of((Object)SELF_BILL_KEY, (Object)"wtom_otbillself", (Object)SELECT_PROPERTIES, (Object)otProperties, (Object)OTHER_BILL_KEY, (Object)"wtom_overtimeapplybill"));
        map.put(4, ImmutableMap.of((Object)SELF_BILL_KEY, (Object)"wtpm_supsignself", (Object)SELECT_PROPERTIES, (Object)suProperties, (Object)OTHER_BILL_KEY, (Object)"wtpm_supsignpc"));
        map.put(5, ImmutableMap.of((Object)SELF_BILL_KEY, (Object)"wts_swshiftselfbill", (Object)SELECT_PROPERTIES, (Object)swProperties, (Object)OTHER_BILL_KEY, (Object)"wts_swshiftbill"));
        return map;
    }

    private static Map<WTCBillType, String> getSelfBillMap() {
        HashMap map = Maps.newHashMap();
        map.put(WTCBillType.VA, "wtabm_vaapplyself");
        map.put(WTCBillType.OT, "wtom_otbillself");
        map.put(WTCBillType.BU, "wtam_busitripselfbill");
        map.put(WTCBillType.SU, "wtpm_supsignself");
        return ImmutableMap.copyOf((Map)map);
    }

    private static class Instance {
        private static final MobileBillPageBusiness INSTANCE = new MobileBillPageBusiness();

        private Instance() {
        }
    }
}

