/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.business.servicehelper.mobile;

import com.alibaba.fastjson.JSON;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.wtc.wtbs.business.mobilescheme.ISchemeMatchPlugin;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxyFactory;
import kd.wtc.wtbs.business.mobile.MobileCommonServiceHelper;
import kd.wtc.wtbs.business.mobile.MobileSchemeServiceHelper;
import kd.wtc.wtbs.business.util.WTCBrmSceneHelper;
import kd.wtc.wtbs.business.web.WTCAttFileService;
import kd.wtc.wtbs.business.web.mservice.HRPIMServiceImpl;
import kd.wtc.wtbs.common.model.attfileauth.Assign;
import kd.wtc.wtbs.common.model.attfileauth.AttFileAuthBase;
import kd.wtc.wtbs.common.model.attfileauth.AttFileInfo;
import kd.wtc.wtbs.common.model.attfileauth.AttPerson;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.ImmutableMap;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;
import kd.wtc.wtp.business.mobile.TeamHomeHelper;
import kd.wtc.wtss.business.servicehelper.common.SchemaServiceHelper;
import kd.wtc.wtss.business.servicehelper.mobile.MobileHomePageServiceHelper;
import kd.wtc.wtss.business.servicehelper.mobile.MobileTeamHomeBusiness;
import kd.wtc.wtss.common.dto.MobileHomeConf;
import kd.wtc.wtss.common.dto.mobilehome.AttStatisticQueryParam;
import kd.wtc.wtss.common.dto.mobilehome.PeriodDetailModel;
import kd.wtc.wtss.common.dto.mobilehome.PeriodModel;
import kd.wtc.wtss.common.dto.mobilehome.PeriodYearModel;
import kd.wtc.wtss.common.enums.attstatistics.StaTypeEnum;
import kd.wtc.wtss.common.utils.WTSSDateUtils;

public class MobileHomePageBusiness {
    private static final Log logger = LogFactory.getLog(MobileHomePageBusiness.class);
    public static final String DAY_START_TIME = " 00:00:00";
    public static final String DAY_END_TIME = " 23:59:59";

    private MobileHomePageBusiness() {
    }

    public static MobileHomePageBusiness getInstance() {
        return Instance.INSTANCE;
    }

    public String getEndDateValue(PeriodDetailModel periodDetailModel) {
        if (periodDetailModel == null) {
            return null;
        }
        try {
            if (StringUtils.isBlank((CharSequence)periodDetailModel.getEndDate()) || HRDateTimeUtils.parseDate((String)periodDetailModel.getEndDate()).getTime() > System.currentTimeMillis()) {
                return WTCDateUtils.date2Str((Date)new Date(), (String)"yyyy-MM-dd");
            }
        }
        catch (ParseException parseException) {
            logger.error("mobilehome getDateValue ParseException", (Throwable)parseException);
        }
        return periodDetailModel.getEndDate();
    }

    public void setSchRuleCache(IFormView view, long userId) {
        Date nowDate = WTSSDateUtils.getLastDate();
        String nowDateStr = WTCDateUtils.date2Str((Date)nowDate, (String)"yyyy-MM-dd");
        Long employeeId = MobileCommonServiceHelper.getInstance().getEmployeeIdByPersonId(Long.valueOf(userId));
        Map<String, String> attFile = MobileHomePageServiceHelper.getAttFileWithEmployeeId(employeeId, nowDateStr);
        long schemeId = MobileHomePageBusiness.getInstance().getSchemeIdWithWorkspace(attFile, "A");
        long ruleId = MobileTeamHomeBusiness.getInstance().getRuleId(attFile);
        view.getPageCache().put("cache_id_scheme", String.valueOf(schemeId));
        view.getPageCache().put("cache_id_rule", String.valueOf(ruleId));
    }

    public void setTeamSchRuleCache(IFormView view, long ruleId) {
        long personId = MobileCommonServiceHelper.getInstance().getUserId();
        List<Long> allAdminOrgIdList = MobileHomePageBusiness.getInstance().getAllAdminOrgIdByPersonId(personId);
        long schemeId = TeamHomeHelper.queryTeamSchemeIdByAdminOrgIdList(allAdminOrgIdList);
        view.getPageCache().put("cache_id_scheme", String.valueOf(schemeId));
        view.getPageCache().put("cache_id_rule", String.valueOf(ruleId));
    }

    @Deprecated
    public long getSchemeId(Map<String, String> attFiles) {
        HashMap<String, String> mobileSchemeMap = new HashMap<String, String>(16);
        mobileSchemeMap.put("attfilebase.wtp_attfilebase.workplace.id", attFiles.get("workplace"));
        mobileSchemeMap.put("attfilebase.wtp_attfilebase.affiliateadminorg.id", attFiles.get("affiliateadminorg"));
        mobileSchemeMap.put("attfilebase.wtp_attfilebase.empgroup.id", attFiles.get("empgroup"));
        mobileSchemeMap.put("attfilebase.wtp_attfilebase.dependency.id", attFiles.get("dependency"));
        mobileSchemeMap.put("managingscope.hrpi_cmpemp.managingscope.id", attFiles.get("managescope"));
        return MobileSchemeServiceHelper.getFinalMobileSchemeWithWorkspace(mobileSchemeMap, (String)"A");
    }

    public long getSchemeIdWithWorkspace(Map<String, String> attFiles, String workspace) {
        LinkedHashMap allMobileScheme = MobileSchemeServiceHelper.getAllMobileSchemeWithWorkspace((String)workspace);
        WTCPluginProxy pluginProxy = WTCPluginProxyFactory.create(ISchemeMatchPlugin.class, (String)"kd.sdk.wtc.wtbs.business.mobilescheme.ISchemeMatchPlugin");
        if (pluginProxy.hasPlugin()) {
            String fileIdStr = attFiles.get("id");
            Long attFileId = Long.valueOf(fileIdStr);
            List allMatchScheme = MobileSchemeServiceHelper.getSchemeIdListWithWorkspace(attFiles, (LinkedHashMap)allMobileScheme);
            return (Long)WTCBrmSceneHelper.matchSchemeExt((WTCPluginProxy)pluginProxy, (Map)ImmutableMap.of((Object)attFileId, (Object)allMatchScheme), (String)"wtc_scene_mobilescheme", (LinkedHashMap)allMobileScheme).get(attFileId);
        }
        long schemeId = MobileSchemeServiceHelper.getSchemeIdWithWorkspace(attFiles, (LinkedHashMap)allMobileScheme);
        return schemeId;
    }

    public PeriodDetailModel periodDataInit(List<PerAttPeriod> perAttPeriodReportList, String queryDate, CustomControl customcontrol) {
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        List periodOldList = perAttPeriodReportList.stream().map(PerAttPeriod::getAscriptionYearMonth).distinct().collect(Collectors.toList());
        long nowTime = Objects.requireNonNull(WTCDateUtils.str2Date((String)queryDate, (String)"yyyy-MM-dd")).getTime();
        PeriodModel periodModel = new PeriodModel();
        periodModel.setType(1);
        PeriodDetailModel currentPeriod = new PeriodDetailModel();
        ArrayList<PeriodYearModel> periodList = new ArrayList<PeriodYearModel>(periodOldList.size());
        ArrayList allYearPeriod = new ArrayList(16);
        Date nowDate = new Date();
        for (String periodYear : periodOldList) {
            Iterator<PerAttPeriod> iteratorPeriod = perAttPeriodReportList.iterator();
            PeriodYearModel periodYearModel = new PeriodYearModel();
            periodYearModel.setYear(periodYear);
            ArrayList<PeriodDetailModel> yearPeriod = new ArrayList<PeriodDetailModel>(16);
            while (iteratorPeriod.hasNext()) {
                PerAttPeriod perattPeriod = iteratorPeriod.next();
                if (perattPeriod.getPerAttBeginDate().after(nowDate) || !periodYear.equals(perattPeriod.getAscriptionYearMonth())) continue;
                PeriodDetailModel periodDetailModel = new PeriodDetailModel();
                periodDetailModel.setAttFileBid(String.valueOf(perattPeriod.getFileBoId()));
                periodDetailModel.setId(perattPeriod.getId());
                periodDetailModel.setBeginDate(HRDateTimeUtils.format((Date)perattPeriod.getPerAttBeginDate(), (String)"yyyy-MM-dd"));
                periodDetailModel.setEndDate(HRDateTimeUtils.format((Date)perattPeriod.getPerAttEndDate(), (String)"yyyy-MM-dd"));
                String periodBegin = StringUtils.replace((String)periodDetailModel.getBeginDate(), (String)"-", (String)"");
                String periodEnd = StringUtils.replace((String)periodDetailModel.getEndDate(), (String)"-", (String)"");
                String periodName = perattPeriod.getPerAttPeriodName() + "(" + periodBegin + "~" + periodEnd + ")";
                periodDetailModel.setPeriod(periodName);
                periodDetailModel.setOriginalPeriodId(String.valueOf(perattPeriod.getAttPeriodId()));
                yearPeriod.add(periodDetailModel);
                allYearPeriod.addAll(yearPeriod);
                try {
                    if (nowTime > HRDateTimeUtils.parseDate((String)periodDetailModel.getEndDate().concat(DAY_END_TIME)).getTime() || nowTime < HRDateTimeUtils.parseDate((String)periodDetailModel.getBeginDate().concat(DAY_START_TIME)).getTime()) continue;
                    this.setCurrentPeriod(periodModel, currentPeriod, periodDetailModel);
                }
                catch (ParseException parseException) {
                    logger.error("getUserAllPeriods ParseException", (Throwable)parseException);
                }
            }
            yearPeriod.sort((p1, p2) -> p2.getBeginDate().compareTo(p1.getBeginDate()));
            periodYearModel.setAttList(yearPeriod);
            if (yearPeriod.size() <= 0) continue;
            periodList.add(periodYearModel);
        }
        periodList.sort((p1, p2) -> p2.getYear().compareTo(p1.getYear()));
        if (HRStringUtils.isEmpty((String)periodModel.getCurPeriod()) && !CollectionUtils.isEmpty(allYearPeriod)) {
            this.setCurrentPeriod(periodModel, currentPeriod, (PeriodDetailModel)allYearPeriod.get(0));
        }
        periodModel.setPeriodList(periodList);
        logger.info("periodDataInit {}", (Object)SerializationUtils.toJsonString((Object)periodModel));
        data.put("event", "init");
        data.put("args", periodModel);
        data.put("timestamp", System.currentTimeMillis());
        customcontrol.setData(data);
        return currentPeriod;
    }

    private void setCurrentPeriod(PeriodModel periodModel, PeriodDetailModel currentPeriod, PeriodDetailModel periodDetailModel) {
        periodModel.setCurPeriod(periodDetailModel.getPeriod());
        periodModel.setAttFileBid(String.valueOf(periodDetailModel.getAttFileBid()));
        currentPeriod.setPeriod(periodDetailModel.getPeriod());
        currentPeriod.setId(periodDetailModel.getId());
        currentPeriod.setBeginDate(periodDetailModel.getBeginDate());
        currentPeriod.setEndDate(periodDetailModel.getEndDate());
        currentPeriod.setOriginalPeriodId(periodDetailModel.getOriginalPeriodId());
        currentPeriod.setAttFileBid(periodDetailModel.getAttFileBid());
    }

    public MobileFormShowParameter getShowParameter(String formId, ShowType showType) {
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(showType);
        return showParameter;
    }

    public boolean isNotHaveStaffAuthority(IFormView view, Map<String, String> archives, long schemeId) {
        MobileHomeConf mobileHomeConf;
        boolean notExist;
        boolean bl = notExist = archives.get("boid") == null || schemeId == 0L;
        if (!notExist && (mobileHomeConf = SchemaServiceHelper.getInstance().getSchemeForHome(schemeId, "A")) == null) {
            notExist = true;
        }
        if (notExist) {
            logger.info("mobilehome archives:{}", (Object)SerializationUtils.toJsonString(archives));
            view.setVisible(Boolean.FALSE, new String[]{"flexnormal"});
            view.setVisible(Boolean.TRUE, new String[]{"flexnoauthor"});
        }
        return notExist;
    }

    public void setPersonLabInfo(Long attfileBoid, Label labName, Label labNumber, Label labPostAndOrg, Image imgHead) {
        String headsculpture;
        AttFileInfo attFileAuth;
        List attFileInfos = WTCAttFileService.queryAttFileInfoByIds(Collections.singletonList(attfileBoid));
        AttFileInfo attFileInfo = attFileAuth = CollectionUtils.isEmpty((Collection)attFileInfos) ? null : (AttFileInfo)attFileInfos.get(0);
        if (attFileAuth == null) {
            return;
        }
        AttPerson attPerson = attFileAuth.getAttPerson();
        Assign assign = attFileAuth.getAssign();
        String name = attPerson.getName();
        String number = attPerson.getNumber();
        String adminOrg = "-";
        String post = "-";
        if (assign != null) {
            AttFileAuthBase position = assign.getPosition();
            logger.info("mobilehome.headerInfoAssignment.position:{}", (Object)position);
            AttFileAuthBase job = assign.getJob();
            logger.info("mobilehome.headerInfoAssignment.job:{}", (Object)job);
            adminOrg = assign.getAdminOrg().getName();
            post = position != null ? position.getName() : (job != null ? job.getName() : "");
        }
        logger.info("mobilehome.headerInfoAssignment.post:{}", (Object)post);
        Long boid = attPerson.getBoid();
        logger.info("mobilehome.headerInfoAssignment.boid:{}", (Object)boid);
        Map personBaseInfo = HRPIMServiceImpl.getInstance().getPersonBaseInfo(boid);
        if (personBaseInfo != null && personBaseInfo.get("headsculpture") != null && !HRStringUtils.isEmpty((String)(headsculpture = personBaseInfo.get("headsculpture").toString())) && !"/images/pc/emotion/default_person_82_82.png".equals(headsculpture)) {
            imgHead.setUrl(HRImageUrlUtil.getImageFullUrl((String)headsculpture));
        }
        labName.setText(name);
        labNumber.setText(number);
        if (post == null) {
            labPostAndOrg.setText(adminOrg);
        } else {
            labPostAndOrg.setText(post + " \u00b7 " + adminOrg);
        }
    }

    public List<Long> getAllAdminOrgIdByPersonId(long personId) {
        List<Long> adminOrgIdList;
        ArrayList allAdminOrgIdList = Lists.newArrayListWithExpectedSize((int)1);
        if (personId != 0L && WTCCollections.isNotEmpty(adminOrgIdList = this.getAdminOrgIdByOwner(personId, new Date()))) {
            allAdminOrgIdList.addAll(adminOrgIdList);
        }
        return allAdminOrgIdList;
    }

    public List<Map<String, Object>> getAllAdminOrgIdByPersonIdPlus(long personId) {
        List<Map<String, Object>> adminOrgIdByOwnerPlus;
        ArrayList allAdminOrgIdListPlus = Lists.newArrayListWithExpectedSize((int)1);
        if (personId != 0L && WTCCollections.isNotEmpty(adminOrgIdByOwnerPlus = this.getAdminOrgIdByOwnerPlus(personId, new Date()))) {
            allAdminOrgIdListPlus.addAll(adminOrgIdByOwnerPlus);
        }
        return allAdminOrgIdListPlus;
    }

    public List<Long> getAdminOrgIdByOwner(long personId, Date queryDate) {
        List ownerAdminOrgIdList;
        Map adminOrgIdByOwnerMap;
        if (personId != 0L && WTCCollections.isNotEmpty((Map)(adminOrgIdByOwnerMap = HRPIMServiceImpl.getInstance().queryChargeByPersonId(Collections.singletonList(personId), queryDate))) && WTCCollections.isNotEmpty((Collection)(ownerAdminOrgIdList = (List)adminOrgIdByOwnerMap.get(personId)))) {
            return ownerAdminOrgIdList.stream().filter(adminOrg -> (Boolean)adminOrg.get("isagencycharge") == false).map(adminOrg -> (Long)adminOrg.get("adminorg")).collect(Collectors.toList());
        }
        return new ArrayList<Long>(10);
    }

    public List<Map<String, Object>> getAdminOrgIdByOwnerPlus(long personId, Date queryDate) {
        List ownerAdminOrgIdList;
        Map adminOrgIdByOwnerMap;
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(16);
        if (personId != 0L && WTCCollections.isNotEmpty((Map)(adminOrgIdByOwnerMap = HRPIMServiceImpl.getInstance().queryChargeByPersonId(Collections.singletonList(personId), queryDate))) && WTCCollections.isNotEmpty((Collection)(ownerAdminOrgIdList = (List)adminOrgIdByOwnerMap.get(personId)))) {
            for (Map adminOrg : ownerAdminOrgIdList) {
                if (((Boolean)adminOrg.get("isagencycharge")).booleanValue()) continue;
                resultList.add(adminOrg);
            }
        }
        return resultList;
    }

    private void getIdsAndPositonType(List<Long> ids, Map<Long, Boolean> positionIdMap, List<Object> personList, Map<String, List<Map<String, Object>>> dataMap) {
        Date lastDate = WTSSDateUtils.getLastDate();
        for (Object person : personList) {
            List<Map<String, Object>> dataList = dataMap.get(person.toString());
            if (dataList == null) continue;
            logger.info("isHaveTeamAuthority listEmpOrgRelGroup dataList:{}", dataList);
            for (Map<String, Object> data : dataList) {
                Date endDate = (Date)data.get("enddate");
                Object posType = data.get("postype");
                boolean isFullPosition = (endDate == null || lastDate.before(endDate)) && ResManager.loadKDString((String)"\u5168\u804c\u4efb\u804c", (String)"MobileBillPageBusiness_3", (String)"wtc-wtss-business", (Object[])new Object[0]).equals(posType);
                boolean isPartPositon = (endDate == null || lastDate.before(endDate)) && ResManager.loadKDString((String)"\u517c\u804c\u4efb\u804c", (String)"MobileBillPageBusiness_4", (String)"wtc-wtss-business", (Object[])new Object[0]).equals(posType);
                Object position = data.get("position_id");
                if (isFullPosition) {
                    if (position == null) continue;
                    positionIdMap.put(Long.parseLong(position.toString()), Boolean.TRUE);
                    ids.add(Long.parseLong(position.toString()));
                    continue;
                }
                if (!isPartPositon || position == null) continue;
                positionIdMap.put(Long.parseLong(position.toString()), Boolean.FALSE);
                ids.add(Long.parseLong(position.toString()));
            }
        }
    }

    public boolean checkDates(Boolean showErr, String type, IFormView view, AttStatisticQueryParam attStatisticQueryParam, Tuple<Date, Date> tupleDate, Long id) {
        attStatisticQueryParam.setAffiliateAdminOrgId(id.longValue());
        return this.checkDate(showErr, type, view, attStatisticQueryParam, tupleDate);
    }

    public boolean checkDate(boolean showErr, String type, IFormView view, AttStatisticQueryParam attStatisticQueryParam, Tuple<Date, Date> tupleDate) {
        Long affiliateAdminOrgId = attStatisticQueryParam.getAffiliateAdminOrgId();
        Map adminOrgIdByPersonIdPlusMap = attStatisticQueryParam.getAdminOrgIdByPersonIdPlusMap();
        List adminOrgIdByPersonIdPlus = (List)adminOrgIdByPersonIdPlusMap.get(affiliateAdminOrgId);
        if (logger.isInfoEnabled()) {
            logger.info("kd.wtc.wtss.business.servicehelper.mobile.MobileHomePageBusiness.adminOrgIdByPersonIdPlus {}, key:{},value:{}", new Object[]{JSON.toJSONString((Object)adminOrgIdByPersonIdPlus), tupleDate.getKey(), tupleDate.getValue()});
        }
        if (WTCCollections.isEmpty((Collection)adminOrgIdByPersonIdPlus)) {
            return false;
        }
        Boolean checked = false;
        for (Map entry : adminOrgIdByPersonIdPlus) {
            Date leFfDt;
            Date effDt;
            block6: {
                effDt = null;
                leFfDt = null;
                try {
                    effDt = WTCDateUtils.parseDate((String)((String)entry.get("effdt")), (String)"yyyy-MM-dd HH:mm:ss");
                    leFfDt = WTCDateUtils.parseDate((String)((String)entry.get("leffdt")), (String)"yyyy-MM-dd HH:mm:ss");
                }
                catch (ParseException e) {
                    if (!logger.isInfoEnabled()) break block6;
                    logger.info("kd.wtc.wtss.business.servicehelper.mobile.MobileHomePageBusiness.checkDate ", (Object)e);
                }
            }
            Date stDt = (Date)tupleDate.getKey();
            Date endDt = (Date)tupleDate.getValue();
            checked = this.doCheck(type, checked, effDt, leFfDt, stDt, endDt);
        }
        if (!checked.booleanValue() && showErr) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u8303\u56f4\u5185\u6ca1\u6709\u8d1f\u8d23\u7684\u90e8\u95e8\uff0c\u6682\u65f6\u65e0\u6cd5\u67e5\u8be2\u5230\u65e5\u7edf\u8ba1\u3001\u671f\u95f4\u7edf\u8ba1\u6570\u636e\u6216\u5b9a\u989d\u7edf\u8ba1\u7684\u76f8\u5173\u6570\u636e\uff0c\u8bf7\u66f4\u6362\u67e5\u8be2\u65f6\u95f4\u6216\u7edf\u8ba1\u7c7b\u578b\u3002", (String)"MobileHomePageBusiness_1", (String)"wtc-wtss-business", (Object[])new Object[0]));
        }
        return checked;
    }

    private boolean doCheck(String type, Boolean checked, Date effDt, Date leFfDt, Date stDt, Date endDt) {
        StaTypeEnum staTypeEnum = StaTypeEnum.getStaTypeEnum((String)type);
        if (null == staTypeEnum) {
            return checked;
        }
        switch (staTypeEnum) {
            case DAILY: {
                if (null == effDt || null == leFfDt || null == stDt || null == endDt || stDt.compareTo(effDt) < 0 || endDt.compareTo(leFfDt) > 0) break;
                checked = true;
                break;
            }
            case PERIOD: 
            case QUOTA: {
                if (null == effDt || null == leFfDt || null == stDt || null == endDt || leFfDt.getTime() < stDt.getTime() || effDt.getTime() > endDt.getTime()) break;
                checked = true;
                break;
            }
        }
        return checked;
    }

    private static class Instance {
        private static final MobileHomePageBusiness INSTANCE = new MobileHomePageBusiness();

        private Instance() {
        }
    }
}

