/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.business.servicehelper.mobile;

import com.alibaba.fastjson.JSON;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.business.mobile.MobileSchemeServiceHelper;
import kd.wtc.wtbs.business.mobile.WtcPermHelper;
import kd.wtc.wtbs.business.web.attperiod.PerAttPeriodQueryServiceImpl;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.model.period.PerAttPeriodQueryParam;
import kd.wtc.wtbs.common.model.period.PerAttPeriodReport;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCMaps;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.tuple.Pair;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;
import kd.wtc.wtss.business.servicehelper.common.HomePageServiceHelper;
import kd.wtc.wtss.common.dto.mobilebill.AuditBillModel;

public class MobileHomePageServiceHelper {
    private static final Log logger = LogFactory.getLog(MobileHomePageServiceHelper.class);
    public static final String DAY_START_TIME = " 00:00:00";
    public static final String DAY_END_TIME = " 23:59:59";

    public static List<PerAttPeriod> getUserAllPeriodsSimple(Long userId) {
        PerAttPeriodQueryParam queryParam = new PerAttPeriodQueryParam();
        queryParam.setAttPersonIdSet(Collections.singleton(userId));
        List perAttPeriodReportList = PerAttPeriodQueryServiceImpl.getInstance().queryPerAttPeriodEntity(queryParam);
        if (CollectionUtils.isEmpty((Collection)perAttPeriodReportList)) {
            logger.info("userId : {} getUserAllPeriods is null", (Object)userId);
            return null;
        }
        logger.info("mobilehome MobileHomePageServiceHelper getUserAllPeriods :{}", (Object)SerializationUtils.toJsonString((Object)perAttPeriodReportList));
        for (PerAttPeriod periodReport : perAttPeriodReportList) {
            periodReport.setAscriptionYearMonth(periodReport.getAscriptionYearMonth().substring(0, 4));
        }
        perAttPeriodReportList.sort(Comparator.comparing(PerAttPeriod::getPerAttBeginDate));
        return perAttPeriodReportList;
    }

    public static List<PerAttPeriod> getUserAllPeriodsSimpleWithEmployeeId(Long employeeId) {
        Map<Long, Tuple<Date, Date>> attFileMap = HomePageServiceHelper.getInstance().getAllAttFileMapWithEmployeeId(employeeId);
        if (WTCMaps.isEmpty(attFileMap)) {
            return Collections.emptyList();
        }
        PerAttPeriodQueryParam queryParam = new PerAttPeriodQueryParam();
        queryParam.setAttFileBoIdSet(attFileMap.keySet());
        List perAttPeriodReportList = PerAttPeriodQueryServiceImpl.getInstance().queryPerAttPeriodEntity(queryParam);
        if (CollectionUtils.isEmpty((Collection)perAttPeriodReportList)) {
            logger.info("attFileBoIds : {} getUserAllPeriodsSimpleWithEmployeeId is null", attFileMap.keySet());
            return null;
        }
        logger.info("mobilehome MobileHomePageServiceHelper getUserAllPeriodsSimpleWithEmployeeId :{}", (Object)SerializationUtils.toJsonString((Object)perAttPeriodReportList));
        for (PerAttPeriod periodReport : perAttPeriodReportList) {
            periodReport.setAscriptionYearMonth(periodReport.getAscriptionYearMonth().substring(0, 4));
        }
        perAttPeriodReportList.sort(Comparator.comparing(PerAttPeriod::getPerAttBeginDate));
        return perAttPeriodReportList;
    }

    public static List<PerAttPeriodReport> getUserAllPeriods(Long userId) {
        List<PerAttPeriodReport> perAttPeriodReportList = MobileHomePageServiceHelper.getPerAttPeriodReportByPersonId(userId);
        if (CollectionUtils.isEmpty(perAttPeriodReportList)) {
            logger.info("userId : {} getUserAllPeriods is null", (Object)userId);
            return null;
        }
        logger.info("mobilehome MobileHomePageServiceHelper getUserAllPeriods :{}", (Object)SerializationUtils.toJsonString(perAttPeriodReportList));
        for (PerAttPeriod perAttPeriod : perAttPeriodReportList) {
            perAttPeriod.setAscriptionYearMonth(perAttPeriod.getAscriptionYearMonth().substring(0, 4));
        }
        perAttPeriodReportList.sort(Comparator.comparing(PerAttPeriod::getPerAttBeginDate));
        return perAttPeriodReportList;
    }

    private static List<PerAttPeriodReport> getPerAttPeriodReportByPersonId(long attPersonId) {
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
        attFileQueryParam.setAttPersonId(attPersonId);
        attFileQueryParam.setAuthCheck(Boolean.valueOf(false));
        return PerAttPeriodQueryServiceImpl.getInstance().getPerAttPeriodReport(arg_0 -> ((AttFileQueryServiceImpl)AttFileQueryServiceImpl.getInstance()).queryAttFiles(arg_0), attFileQueryParam, null, null, null);
    }

    @Deprecated
    public static Map<String, String> getAttFile(Long userId, String chooseDate) {
        if (null == userId || userId == 0L) {
            return Collections.emptyMap();
        }
        Date date = WTCDateUtils.str2Date((String)chooseDate, (String)"yyyy-MM-dd");
        if (date == null) {
            return Collections.emptyMap();
        }
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
        attFileQueryParam.setQueryDate(date);
        attFileQueryParam.setAttPersonId(userId.longValue());
        attFileQueryParam.setAuthCheck(Boolean.valueOf(false));
        attFileQueryParam.setProperties(WTCStringUtils.joinStr((String[])new String[]{AttFileQueryParam.baseProperties, ",", "affiliateadminorg.id", ",", "cmpemp.managingscope.id", ",", "dependency.id", ",", "empgroup.id", ",", "workplace.id", ",", "org.id", ",", "adminorg.id"}));
        DynamicObject fileDy = AttFileQueryServiceImpl.getInstance().queryOneAttFiles(attFileQueryParam);
        if (fileDy == null) {
            if (logger.isDebugEnabled()) {
                logger.info("query null attFileQueryParam {}", (Object)JSON.toJSONString((Object)attFileQueryParam));
            }
            return resultMap;
        }
        resultMap.put("id", fileDy.getString("id"));
        resultMap.put("boid", fileDy.getString("boid"));
        resultMap.put("affiliateadminorg", String.valueOf(fileDy.getLong("affiliateadminorg.id")));
        resultMap.put("managescope", String.valueOf(fileDy.getLong("cmpemp.managingscope.id")));
        resultMap.put("dependency", String.valueOf(fileDy.getLong("dependency.id")));
        resultMap.put("empgroup", String.valueOf(fileDy.getLong("empgroup.id")));
        resultMap.put("workplace", String.valueOf(fileDy.getLong("workplace.id")));
        resultMap.put("org", String.valueOf(fileDy.getLong("org.id")));
        resultMap.put("adminorg", String.valueOf(fileDy.getLong("adminorg.id")));
        if (logger.isDebugEnabled()) {
            logger.info("getAttFile query result {}", (Object)JSON.toJSONString((Object)resultMap));
        }
        return resultMap;
    }

    public static Map<String, String> getAttFileWithEmployeeId(Long employeeId, String chooseDate) {
        if (null == employeeId || employeeId == 0L) {
            return Collections.emptyMap();
        }
        Date date = WTCDateUtils.str2Date((String)chooseDate, (String)"yyyy-MM-dd");
        if (date == null) {
            return Collections.emptyMap();
        }
        Map resultMap = Maps.newHashMapWithExpectedSize((int)16);
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
        attFileQueryParam.setQueryDate(date);
        attFileQueryParam.setEmpPersonSetIds(Collections.singleton(employeeId));
        attFileQueryParam.setAuthCheck(Boolean.valueOf(false));
        attFileQueryParam.setProperties(WTCStringUtils.joinStr((String[])new String[]{AttFileQueryParam.baseProperties, ",", "affiliateadminorg.id", ",", "cmpemp.managingscope.id", ",", "dependency.id", ",", "empgroup.id", ",", "workplace.id", ",", "org.id", ",", "adminorg.id"}));
        DynamicObject fileDy = AttFileQueryServiceImpl.getInstance().queryOneAttFiles(attFileQueryParam);
        if (fileDy == null) {
            if (logger.isDebugEnabled()) {
                logger.info("query null attFileQueryParam {}", (Object)JSON.toJSONString((Object)attFileQueryParam));
            }
            return resultMap;
        }
        resultMap = MobileSchemeServiceHelper.getAttFileMatchSchemeMap((DynamicObject)fileDy);
        if (logger.isDebugEnabled()) {
            logger.info("getAttFile query result {}", (Object)JSON.toJSONString((Object)resultMap));
        }
        return resultMap;
    }

    public static boolean canApplySelf(String formId) {
        String appNumber = StringUtils.substring((String)formId, (int)0, (int)StringUtils.indexOf((CharSequence)formId, (CharSequence)"_"));
        String pageNumber = "";
        if (StringUtils.equals((CharSequence)appNumber, (CharSequence)"wtam")) {
            pageNumber = "wtam_busitripselfbill";
        } else if (StringUtils.equals((CharSequence)appNumber, (CharSequence)"wtabm")) {
            pageNumber = "wtabm_vaapplyself";
        } else if (StringUtils.equals((CharSequence)appNumber, (CharSequence)"wtom")) {
            pageNumber = "wtom_otbillself";
        } else if (StringUtils.equals((CharSequence)appNumber, (CharSequence)"wtpm")) {
            pageNumber = "wtpm_supsignself";
        }
        Pair pair = WtcPermHelper.getAllPermOrg((String)"wtam", (String)pageNumber, (String)"2J22DLG+6425");
        return ((List)pair.getRight()).size() > 0;
    }

    public static boolean canApplyOther(String formId) {
        String appNumber = StringUtils.substring((String)formId, (int)0, (int)StringUtils.indexOf((CharSequence)formId, (CharSequence)"_"));
        String pageNumber = "";
        if (StringUtils.equals((CharSequence)appNumber, (CharSequence)"wtam")) {
            pageNumber = "wtam_busitripbill";
        } else if (StringUtils.equals((CharSequence)appNumber, (CharSequence)"wtabm")) {
            pageNumber = "wtabm_vaapply";
        } else if (StringUtils.equals((CharSequence)appNumber, (CharSequence)"wtom")) {
            pageNumber = "wtom_overtimeapplybill";
        } else if (StringUtils.equals((CharSequence)appNumber, (CharSequence)"wtpm")) {
            pageNumber = "wtpm_supsignpc";
        } else if (StringUtils.equals((CharSequence)appNumber, (CharSequence)"wts")) {
            pageNumber = "wts_swshiftbill";
        }
        Pair pair = WtcPermHelper.getAllPermOrg((String)"wtam", (String)pageNumber, (String)"47156aff000000ac");
        return ((List)pair.getRight()).size() > 0;
    }

    public static String getApplyFormId(String formId, boolean canApplySelf) {
        String appNumber = StringUtils.substring((String)formId, (int)0, (int)StringUtils.indexOf((CharSequence)formId, (CharSequence)"_"));
        String pageNumber = "";
        if (canApplySelf) {
            if (StringUtils.equals((CharSequence)appNumber, (CharSequence)"wtam")) {
                pageNumber = "wtam_busitripselfbillmob";
            } else if (StringUtils.equals((CharSequence)appNumber, (CharSequence)"wtabm")) {
                pageNumber = "wtabm_vaapplymob_self";
            } else if (StringUtils.equals((CharSequence)appNumber, (CharSequence)"wtom")) {
                pageNumber = "wtom_otbillselef_m";
            } else if (StringUtils.equals((CharSequence)appNumber, (CharSequence)"wtpm")) {
                pageNumber = "wtpm_supsignself_m";
            } else if (StringUtils.equals((CharSequence)appNumber, (CharSequence)"wts")) {
                pageNumber = "wts_swshiftselfbill_m";
            }
            return pageNumber;
        }
        if (StringUtils.equals((CharSequence)appNumber, (CharSequence)"wtam")) {
            pageNumber = "wtam_busitripbillmob";
        } else if (StringUtils.equals((CharSequence)appNumber, (CharSequence)"wtabm")) {
            pageNumber = "wtabm_vaapplymob";
        } else if (StringUtils.equals((CharSequence)appNumber, (CharSequence)"wtom")) {
            pageNumber = "wtom_otbillother_m";
        } else if (StringUtils.equals((CharSequence)appNumber, (CharSequence)"wtpm")) {
            pageNumber = "wtpm_supsignpc_addm";
        } else if (StringUtils.equals((CharSequence)appNumber, (CharSequence)"wts")) {
            pageNumber = "wts_swshiftbill_m";
        }
        return pageNumber;
    }

    public static String getApplyName(String formId) {
        String appNumber = StringUtils.substring((String)formId, (int)0, (int)StringUtils.indexOf((CharSequence)formId, (CharSequence)"_"));
        if (StringUtils.equals((CharSequence)appNumber, (CharSequence)"wtam")) {
            return AuditBillModel.getBillTypeName((int)1);
        }
        if (StringUtils.equals((CharSequence)appNumber, (CharSequence)"wtabm")) {
            return AuditBillModel.getBillTypeName((int)2);
        }
        if (StringUtils.equals((CharSequence)appNumber, (CharSequence)"wtom")) {
            return AuditBillModel.getBillTypeName((int)3);
        }
        if (StringUtils.equals((CharSequence)appNumber, (CharSequence)"wtpm")) {
            return AuditBillModel.getBillTypeName((int)4);
        }
        if (StringUtils.equals((CharSequence)appNumber, (CharSequence)"wts")) {
            return AuditBillModel.getBillTypeName((int)5);
        }
        return null;
    }
}

