/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.business.servicehelper.mobile;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarChart;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.control.Label;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtss.common.dto.mobilehome.AttDataSourceDetailsModel;
import kd.wtc.wtss.common.dto.mobilehome.AttDataSourceModel;

public class MobileRankingDataServiceHelper {
    private static final int MOBILE_DETAIL_SHOW_COUNT = 5;
    private static final int SHOW_CHART_COUNT = 6;

    public static MobileRankingDataServiceHelper getInstance() {
        return SingletonInstance.singleton;
    }

    public static void initRanking(String suffix, List<AttDataSourceModel> attDataSource, IDataModel model, IFormView view) {
        model.deleteEntryData("rankingentity" + suffix);
        if (attDataSource == null || attDataSource.size() == 0) {
            MobileRankingDataServiceHelper.rankingVisible(Boolean.FALSE, suffix, view);
            return;
        }
        MobileRankingDataServiceHelper.rankingVisible(Boolean.TRUE, suffix, view);
        CardEntry cardEntry = (CardEntry)view.getControl("rankingentity" + suffix);
        int size = Math.min(attDataSource.size(), 6);
        model.batchCreateNewEntryRow("rankingentity" + suffix, size);
        for (int index = 0; index < size; ++index) {
            String sourceName = attDataSource.get(index).getAttDataSourceName();
            model.setValue("rankingname" + suffix, (Object)sourceName, index);
            List attDataSourceDetailsModelList = attDataSource.get(index).getAttDataSourceDetails();
            if (attDataSourceDetailsModelList == null || attDataSourceDetailsModelList.isEmpty()) {
                cardEntry.setChildVisible(false, index, new String[]{"rankingdataflex" + suffix});
                continue;
            }
            cardEntry.setChildVisible(false, index, new String[]{"rankingnodatalabflex" + suffix});
            for (int num = 1; num <= 3; ++num) {
                if (num > attDataSourceDetailsModelList.size()) {
                    cardEntry.setChildVisible(false, index, new String[]{"rankingflex" + num + suffix});
                    continue;
                }
                String pictureUrl = ((AttDataSourceDetailsModel)attDataSourceDetailsModelList.get(num - 1)).getPictureUrl();
                if (!HRStringUtils.isEmpty((String)pictureUrl) && !pictureUrl.contains("default_person_82_82")) {
                    model.setValue("rankingpic" + num + suffix, (Object)HRImageUrlUtil.getImageFullUrl((String)pictureUrl), index);
                }
                String personName = ((AttDataSourceDetailsModel)attDataSourceDetailsModelList.get(num - 1)).getPersonName();
                model.setValue("rankingpername" + num + suffix, (Object)personName, index);
                double staValue = ((AttDataSourceDetailsModel)attDataSourceDetailsModelList.get(num - 1)).getStaValue();
                BigDecimal bigDecimal = BigDecimal.valueOf(staValue);
                if ("2".equals(attDataSource.get(index).getValTakeMethod())) {
                    long seconds = bigDecimal.setScale(3, 4).stripTrailingZeros().longValue() / 1000L;
                    model.setValue("rankingsta" + num + suffix, (Object)MobileRankingDataServiceHelper.getInstance().secondToSpecifiedFormatStr(seconds), index);
                    continue;
                }
                String staValueStr = bigDecimal.setScale(3, 4).stripTrailingZeros().toPlainString();
                String unit = attDataSource.get(index).getUnit();
                model.setValue("rankingsta" + num + suffix, (Object)(staValueStr + unit), index);
            }
        }
    }

    public static void initChart(String prefix, String suffix, List<AttDataSourceModel> attDataSource, IFormView view) {
        if (attDataSource == null || attDataSource.isEmpty()) {
            MobileRankingDataServiceHelper.chartVisible(Boolean.FALSE, suffix, view);
            return;
        }
        MobileRankingDataServiceHelper.chartVisible(Boolean.TRUE, suffix, view);
        for (int index = 0; index < 6; ++index) {
            if (index >= attDataSource.size()) {
                view.setVisible(Boolean.FALSE, new String[]{"chartapflex" + index + suffix});
                continue;
            }
            view.setVisible(Boolean.TRUE, new String[]{"chartapflex" + index + suffix});
            List attDataSourceDetailsModelList = attDataSource.get(index).getAttDataSourceDetails();
            if (attDataSourceDetailsModelList == null || attDataSourceDetailsModelList.isEmpty()) {
                view.setVisible(Boolean.FALSE, new String[]{prefix + index});
                view.setVisible(Boolean.TRUE, new String[]{"chartnodatalabflex" + index + suffix});
            } else {
                view.setVisible(Boolean.TRUE, new String[]{prefix + index});
                view.setVisible(Boolean.FALSE, new String[]{"chartnodatalabflex" + index + suffix});
            }
            BarChart barchart = (BarChart)view.getControl(prefix + index);
            String sourceName = attDataSource.get(index).getAttDataSourceName();
            Label chartName = (Label)view.getControl("chartname" + index + suffix);
            chartName.setText(sourceName);
            List attDataSourceDetailsModelList2 = attDataSource.get(index).getAttDataSourceDetails();
            ArrayList<String> xDataList = new ArrayList<String>(10);
            ArrayList<Number> yDataList = new ArrayList<Number>(10);
            String yUnit = attDataSource.get(index).getUnit();
            if (attDataSourceDetailsModelList2 == null) continue;
            for (AttDataSourceDetailsModel attDataSourceDetailsModel : attDataSourceDetailsModelList2) {
                String personName = attDataSourceDetailsModel.getPersonName();
                xDataList.add(personName);
                double staValue = attDataSourceDetailsModel.getStaValue();
                BigDecimal bigDecimal = BigDecimal.valueOf(staValue);
                BigDecimal staValueFormat = bigDecimal.setScale(3, 4).stripTrailingZeros();
                yDataList.add(staValueFormat);
                if (xDataList.size() != 5) continue;
                break;
            }
            MobileRankingDataServiceHelper.chartSetValue(barchart, sourceName, xDataList, yDataList, yUnit);
        }
    }

    public static void chartSetValue(BarChart barchart, String sourceName, List<String> xDataList, List<Number> yDataList, String yUnit) {
        Axis xAxis = barchart.createXAxis(ResManager.loadKDString((String)"\u59d3\u540d", (String)"MobileRankingDataServiceHelper_4", (String)"wtc-wtss-business", (Object[])new Object[0]), AxisType.category);
        Axis yAxis = barchart.createYAxis(yUnit, AxisType.value);
        xDataList = MobileRankingDataServiceHelper.xAxisFormat(xDataList, xAxis);
        xAxis.setPropValue("data", xDataList);
        HashMap<String, Object> yStyleMap = new HashMap<String, Object>(16);
        int[] paddingArray = new int[]{0, 0, 0, -20};
        yStyleMap.put("padding", paddingArray);
        yStyleMap.put("fontSize", 10);
        yAxis.setPropValue("nameTextStyle", yStyleMap);
        BarSeries barseries = barchart.createSeries(sourceName);
        barseries.setData(yDataList.toArray(new Number[0]));
        barseries.setBarWidth("24px");
        barchart.addTooltip("trigger", (Object)"axis");
        HashMap<String, String> axisPointer = new HashMap<String, String>(16);
        axisPointer.put("type", "shadow");
        barchart.addTooltip("axisPointer", axisPointer);
        ArrayList<String> toolTipFuncPath = new ArrayList<String>(10);
        MobileRankingDataServiceHelper.setChartFormattor(barchart, yUnit);
        toolTipFuncPath.add("tooltip");
        toolTipFuncPath.add("formatter");
        barchart.addFuncPath(toolTipFuncPath);
        barchart.setShowTooltip(true);
        barchart.refresh();
    }

    public static List<String> xAxisFormat(List<String> xDataList, Axis xAxis) {
        ArrayList<String> xNewDataList = new ArrayList<String>(10);
        boolean isNameTooLong = false;
        for (String xData : xDataList) {
            if (xDataList.size() == 5) {
                if (xData != null && xData.length() > 4) {
                    isNameTooLong = true;
                    if (xData.length() > 6) {
                        xData = xData.substring(0, 6) + "...";
                    }
                }
            } else if (xDataList.size() == 4) {
                if (xData != null && xData.length() > 5) {
                    isNameTooLong = true;
                    if (xData.length() > 6) {
                        xData = xData.substring(0, 6) + "...";
                    }
                }
            } else if (xDataList.size() == 3) {
                if (xData != null && xData.length() > 6) {
                    isNameTooLong = true;
                    xData = xData.substring(0, 6) + "...";
                }
            } else if ((xDataList.size() == 2 || xDataList.size() == 1) && xData != null && xData.length() > 6) {
                xData = xData.substring(0, 6) + "...";
            }
            xNewDataList.add(xData);
        }
        HashMap<String, Integer> xStyleMap = new HashMap<String, Integer>(16);
        xStyleMap.put("interval", 0);
        if (isNameTooLong) {
            xStyleMap.put("rotate", 30);
        } else {
            xStyleMap.put("rotate", 0);
        }
        xAxis.setPropValue("axisLabel", xStyleMap);
        return xNewDataList;
    }

    public static void setChartFormattor(BarChart barchart, String yUnit) {
        if (ResManager.loadKDString((String)"\u5929", (String)"MobileRankingDataServiceHelper_0", (String)"wtc-wtss-business", (Object[])new Object[0]).equals(yUnit)) {
            String dayFormatter = ResManager.loadKDString((String)"function (params) {return params[0].seriesName + '\uff1a' + params[0].data + '\u5929';}", (String)"MobileRankingDataServiceHelper_6", (String)"wtc-wtss-business", (Object[])new Object[0]);
            barchart.addTooltip("formatter", (Object)dayFormatter);
        } else if (ResManager.loadKDString((String)"\u5c0f\u65f6", (String)"MobileRankingDataServiceHelper_1", (String)"wtc-wtss-business", (Object[])new Object[0]).equals(yUnit)) {
            String hourFormatter = ResManager.loadKDString((String)"function (params) {return params[0].seriesName + '\uff1a' + params[0].data + '\u5c0f\u65f6';}", (String)"MobileRankingDataServiceHelper_7", (String)"wtc-wtss-business", (Object[])new Object[0]);
            barchart.addTooltip("formatter", (Object)hourFormatter);
        } else if (ResManager.loadKDString((String)"\u5206\u949f", (String)"MobileRankingDataServiceHelper_2", (String)"wtc-wtss-business", (Object[])new Object[0]).equals(yUnit)) {
            String minuteFormatter = ResManager.loadKDString((String)"function (params) {return params[0].seriesName + '\uff1a' + params[0].data + '\u5206\u949f';}", (String)"MobileRankingDataServiceHelper_8", (String)"wtc-wtss-business", (Object[])new Object[0]);
            barchart.addTooltip("formatter", (Object)minuteFormatter);
        } else if (ResManager.loadKDString((String)"\u79d2", (String)"MobileRankingDataServiceHelper_3", (String)"wtc-wtss-business", (Object[])new Object[0]).equals(yUnit)) {
            String secondFormatter = ResManager.loadKDString((String)"function (params) {return params[0].seriesName + '\uff1a' + params[0].data + '\u79d2';}", (String)"MobileRankingDataServiceHelper_9", (String)"wtc-wtss-business", (Object[])new Object[0]);
            barchart.addTooltip("formatter", (Object)secondFormatter);
        } else if (ResManager.loadKDString((String)"\u6b21", (String)"MobileRankingDataServiceHelper_5", (String)"wtc-wtss-business", (Object[])new Object[0]).equals(yUnit)) {
            String timeFormatter = ResManager.loadKDString((String)"function (params) {return params[0].seriesName + '\uff1a' + params[0].data + '\u6b21';}", (String)"MobileRankingDataServiceHelper_10", (String)"wtc-wtss-business", (Object[])new Object[0]);
            barchart.addTooltip("formatter", (Object)timeFormatter);
        }
    }

    public static void rankingVisible(Boolean hasData, String suffix, IFormView view) {
        view.setVisible(hasData, new String[]{"rankingentity" + suffix});
        view.setVisible(Boolean.valueOf(hasData == false), new String[]{"rankingnodataflex" + suffix});
        view.setVisible(hasData, new String[]{"rankingmoreflex" + suffix});
    }

    public static void chartVisible(Boolean hasData, String suffix, IFormView view) {
        view.setVisible(hasData, new String[]{"chartdataflex" + suffix});
        view.setVisible(Boolean.valueOf(hasData == false), new String[]{"chartnodataflex" + suffix});
        if ("1".equals(suffix)) {
            view.setVisible(hasData, new String[]{"periodchartmoreflex"});
        } else {
            view.setVisible(hasData, new String[]{"dailychartmoreflex"});
        }
    }

    public String secondToSpecifiedFormatStr(long seconds) {
        String str;
        long minutes;
        StringBuilder stringBuilder = new StringBuilder();
        long hours = seconds / 3600L;
        if (hours != 0L) {
            stringBuilder.append(hours).append(ResManager.loadKDString((String)"\u5c0f\u65f6", (String)"HomeDetailListPlugin_2", (String)"wtc-wtss-formplugin", (Object[])new Object[0]));
        }
        if ((minutes = (seconds %= 3600L) / 60L) != 0L) {
            stringBuilder.append(minutes).append(ResManager.loadKDString((String)"\u5206", (String)"HomeDetailListPlugin_6", (String)"wtc-wtss-formplugin", (Object[])new Object[0]));
        }
        if ((seconds %= 60L) != 0L) {
            stringBuilder.append(seconds).append(ResManager.loadKDString((String)"\u79d2", (String)"HomeDetailListPlugin_7", (String)"wtc-wtss-formplugin", (Object[])new Object[0]));
        }
        return HRStringUtils.isEmpty((String)(str = stringBuilder.toString())) ? "-" : str;
    }

    private static class SingletonInstance {
        private static final MobileRankingDataServiceHelper singleton = new MobileRankingDataServiceHelper();

        private SingletonInstance() {
        }
    }
}

