/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.business.servicehelper.mobile;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.auth.WTCBizDataPermissionServiceImpl;
import kd.wtc.wtbs.business.mobile.BillContainerService;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.util.WTCPermUtils;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.tuple.Pair;
import kd.wtc.wtp.business.mobile.TeamHomeHelper;
import kd.wtc.wtss.business.servicehelper.common.SchemaServiceHelper;
import kd.wtc.wtss.business.servicehelper.mobile.MobileBillPageBusiness;
import kd.wtc.wtss.business.servicehelper.mobile.MobileHomePageBusiness;
import kd.wtc.wtss.business.servicehelper.mobile.MobileHomePageServiceHelper;
import kd.wtc.wtss.common.constants.team.target.TargetConst;
import kd.wtc.wtss.common.dto.MobileHomeConf;
import kd.wtc.wtss.common.dto.mobilehome.AttDataSourceModel;
import kd.wtc.wtss.common.dto.mobilehome.PeriodModel;
import kd.wtc.wtss.common.enums.UnitDataEnum;

public class MobileTeamHomeBusiness {
    private static final Log LOG = LogFactory.getLog(MobileTeamHomeBusiness.class);
    private static final String STATISTIC_BY_PERSON = "1";
    private static final String STATISTIC_BY_TIMES = "2";

    private MobileTeamHomeBusiness() {
    }

    public static MobileTeamHomeBusiness getInstance() {
        return Instance.INSTANCE;
    }

    public long getRuleId(Map<String, String> archives) {
        if (archives == null) {
            LOG.info("teamhome archives is null");
            return 0L;
        }
        long schemeId = MobileHomePageBusiness.getInstance().getSchemeIdWithWorkspace(archives, "B");
        LOG.info("teamhome schemeId is {}", (Object)schemeId);
        DynamicObject ruleByScheme = SchemaServiceHelper.getInstance().queryRuleByScheme(schemeId, "B");
        if (ruleByScheme == null) {
            LOG.info("teamhome ruleByScheme is null");
            return 0L;
        }
        return ruleByScheme.getLong("id");
    }

    public Map<Long, Long> getAttFileMap(List<DynamicObject> attFileList) {
        if (CollectionUtils.isEmpty(attFileList)) {
            return null;
        }
        return attFileList.stream().collect(Collectors.toMap(attfile -> attfile.getLong("boid"), attfile -> attfile.getLong("attperson.id")));
    }

    public List<AttDataSourceModel> getAttStatisticsSumValue(Map<Long, Long> attFileMap, DynamicObject[] dailySources, List<Long> attFileBoids, Map<Long, Map<Long, Double>> attItemMap) {
        ArrayList<AttDataSourceModel> resultList = new ArrayList<AttDataSourceModel>(dailySources.length);
        for (DynamicObject dailySource : dailySources) {
            Double sum;
            AttDataSourceModel attDataSourceModel = new AttDataSourceModel();
            attDataSourceModel.setAttDataSourceId(Long.valueOf(dailySource.getLong("id")));
            String showDimen = dailySource.getString("showdimen");
            if (STATISTIC_BY_PERSON.equals(showDimen)) {
                sum = WTCCollections.isEmpty(attItemMap) ? Double.valueOf(0.0) : this.getAttStatisticsSumValueByPerson(attFileMap, attFileBoids, attItemMap, dailySource);
                LOG.info("STATISTIC_BY_PERSON sum={}", (Object)sum);
                attDataSourceModel.setUnit(TargetConst.PERSON_NAME.loadKDString());
            } else {
                sum = WTCCollections.isEmpty(attItemMap) ? Double.valueOf(0.0) : this.getAttStatisticsSumValueByTime(attFileBoids, attItemMap, dailySource);
                if (STATISTIC_BY_TIMES.equals(showDimen)) {
                    attDataSourceModel.setUnit(UnitDataEnum.getRetDesc((String)dailySource.getString("unit")));
                    LOG.info("STATISTIC_BY_TIMES sum={}", (Object)sum);
                } else {
                    attDataSourceModel.setUnit(TargetConst.TIMES_NAME.loadKDString());
                    LOG.info("sum={}", (Object)sum);
                }
            }
            BigDecimal bigDecimal = new BigDecimal(String.valueOf(sum));
            String sumStr = bigDecimal.setScale(3, 4).stripTrailingZeros().toPlainString();
            attDataSourceModel.setAttDataSourceValue(sumStr);
            attDataSourceModel.setAttDataSourceName(dailySource.getString("name"));
            resultList.add(attDataSourceModel);
        }
        return resultList;
    }

    public Double getAttStatisticsSumValueByPerson(Map<Long, Long> attFileMap, List<Long> attFileBoids, Map<Long, Map<Long, Double>> attItemMap, DynamicObject dailySource) {
        LOG.info("getAttStatisticsSumValueByPerson attFileBoids ={},attItemMap={}", attFileBoids, attItemMap);
        HashSet<Long> count = new HashSet<Long>();
        block0: for (Long attFileBoid : attFileBoids) {
            Map<Long, Double> itemMap = attItemMap.get(attFileBoid);
            if (itemMap == null) continue;
            DynamicObjectCollection dailySourceEntries = dailySource.getDynamicObjectCollection("entryentity");
            Long aLong = attFileMap.get(attFileBoid);
            List attitemIds = dailySourceEntries.stream().filter(ds -> null != ds.getDynamicObject("attitem")).map(ds -> ds.getDynamicObject("attitem").getLong("id")).collect(Collectors.toList());
            for (Long attitemId : attitemIds) {
                Double attitemValue = itemMap.get(attitemId);
                if (attitemValue == null || Double.compare(attitemValue, 0.0) == 0) continue;
                count.add(aLong);
                continue block0;
            }
        }
        Double size = new Double(count.size());
        return size;
    }

    public Double getAttStatisticsSumValueByTime(List<Long> attFileBoids, Map<Long, Map<Long, Double>> attItemMap, DynamicObject dailySource) {
        Double sum = 0.0;
        for (Long attFileBoid : attFileBoids) {
            Map<Long, Double> itemMap = attItemMap.get(attFileBoid);
            if (itemMap == null) continue;
            DynamicObjectCollection dailySourceEntries = dailySource.getDynamicObjectCollection("entryentity");
            List attitemIds = dailySourceEntries.stream().filter(ds -> null != ds.getDynamicObject("attitem")).map(ds -> ds.getDynamicObject("attitem").getLong("id")).collect(Collectors.toList());
            for (Long attitemId : attitemIds) {
                Double attitemValue = itemMap.get(attitemId);
                if (attitemValue == null) continue;
                sum = sum + attitemValue;
            }
        }
        return sum;
    }

    public String getOrgName(long orgId) {
        QFilter qFilter = new QFilter("id", "=", (Object)orgId);
        HRBaseServiceHelper bosOrgHelper = new HRBaseServiceHelper("haos_adminorghr");
        DynamicObject bosOrgInfos = bosOrgHelper.queryOne("name", qFilter.toArray());
        return bosOrgInfos.getString("name");
    }

    @Deprecated
    public long getPermOrg() {
        long orgId = 0L;
        HasPermOrgResult allPermOrg = WTCPermUtils.getAllPermOrgs((String)"wtam", (String)"wtp_attfilebase");
        if (allPermOrg == null || !allPermOrg.hasAllOrgPerm() && WTCCollections.isEmpty((Collection)allPermOrg.getHasPermOrgs())) {
            LOG.info("MobileTeamHomeBusiness getPermOrg is null");
        } else {
            LOG.info("MobileTeamHomeBusiness getPermOrg:{} RequestContext orgId:{}", (Object)SerializationUtils.toJsonString((Object)allPermOrg), (Object)RequestContext.get().getOrgId());
            if (allPermOrg.getHasPermOrgs().contains(RequestContext.get().getOrgId())) {
                orgId = RequestContext.get().getOrgId();
            }
            if (orgId < 1L) {
                orgId = 100000L;
            }
        }
        return orgId;
    }

    public long getPermAdminRootOrg() {
        List allPermAdminOrg = WTCPermUtils.getPermAdminOrgIds((String)"wtam", (String)"wtp_attfilebase", (String)"affiliateadminorg", (String)"47150e89000000ac", (boolean)false);
        LOG.info("MobileTeamHomeBusiness getPermAdminRootOrg:{}", (Object)allPermAdminOrg);
        if (CollectionUtils.isEmpty((Collection)allPermAdminOrg)) {
            return 0L;
        }
        return (Long)allPermAdminOrg.stream().min(Long::compare).get();
    }

    public Date[] getLatestThreeMonthStartAndEndDate() {
        Date[] rangeDates = new Date[2];
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        rangeDates[1] = calendar.getTime();
        calendar.add(2, -3);
        rangeDates[0] = calendar.getTime();
        return rangeDates;
    }

    public void periodDataInit(PeriodModel periodModel, CustomControl customcontrol) {
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        LOG.info("periodDataInit {}", (Object)SerializationUtils.toJsonString((Object)periodModel));
        data.put("event", "init");
        data.put("args", periodModel);
        data.put("timestamp", System.currentTimeMillis());
        customcontrol.setData(data);
    }

    public long getRuleIdByAdminOrgId(List<Long> adminOrgIdList, List<Long> matchAdminOrgIdList) {
        long ruleIdByAdminOrgId = this.getRuleIdByAdminOrgId(adminOrgIdList, matchAdminOrgIdList, null);
        return ruleIdByAdminOrgId;
    }

    public long getRuleIdByAdminOrgId(List<Long> adminOrgIdList, List<Long> matchAdminOrgIdList, List errMsgList) {
        DynamicObject mobileRule;
        if (CollectionUtils.isEmpty(adminOrgIdList)) {
            return 0L;
        }
        DynamicObject planDy = TeamHomeHelper.queryTeamMobileSchemeByAdminOrgIdList(adminOrgIdList, (String)"id,name,teammobilerule,adminorgentry.adminorgname");
        if (planDy == null) {
            return 0L;
        }
        if (matchAdminOrgIdList != null) {
            Set planRelateAdminOrgSet = planDy.getDynamicObjectCollection("adminorgentry").stream().map(dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"adminorgname")).collect(Collectors.toSet());
            adminOrgIdList.forEach(adminOrgId -> {
                if (planRelateAdminOrgSet.contains(adminOrgId)) {
                    matchAdminOrgIdList.add((Long)adminOrgId);
                }
            });
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("kd.wtc.wtss.business.servicehelper.mobile.MobileTeamHomeBusiness.getRuleIdByAdminOrgId planDyId:{}", (Object)planDy.getLong("id"));
        }
        if ("A".equals((mobileRule = TeamHomeHelper.queryTeamMobileRule((long)WTCDynamicObjectUtils.getBaseDataId((DynamicObject)planDy, (String)"teammobilerule"))).getString("workspace"))) {
            if (null != errMsgList) {
                errMsgList.add(ResManager.loadKDString((String)"\u5047\u52e4\u81ea\u52a9\u65b9\u6848\u7684\u4f5c\u4e1a\u7a7a\u95f4\u4e0e\u5047\u52e4\u81ea\u52a9\u89c4\u5219\u4e0d\u4e00\u81f4\uff0c\u8bf7\u5728\u5de5\u65f6\u5047\u52e4\u89c4\u5219-\u5047\u52e4\u81ea\u52a9\u65b9\u6848\u91cd\u65b0\u8bbe\u7f6e\u540e\u518d\u8bd5\u3002", (String)"SchemaServiceHelper_1", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
            }
            return 0L;
        }
        return WTCDynamicObjectUtils.getBaseDataId((DynamicObject)planDy, (String)"teammobilerule");
    }

    public boolean isShowBillList(String appId) {
        return MobileBillPageBusiness.getInstance().hasViewRightForOther(appId);
    }

    public boolean isShowBillQuickEntry(long ruleId) {
        MobileHomeConf mobileHomeConf = SchemaServiceHelper.getInstance().queryTeamRuleBills(ruleId);
        List billTypes = mobileHomeConf.getBillTypes();
        return CollectionUtils.isNotEmpty((Collection)billTypes);
    }

    public boolean canApplyOtherForNew(String formId) {
        String appNumber = StringUtils.substring((String)formId, (int)0, (int)StringUtils.indexOf((CharSequence)formId, (CharSequence)"_"));
        String pageNumber = "";
        if (StringUtils.equals((CharSequence)appNumber, (CharSequence)"wtam")) {
            pageNumber = "wtam_busitripbill";
        } else if (StringUtils.equals((CharSequence)appNumber, (CharSequence)"wtabm")) {
            pageNumber = "wtabm_vaapply";
        } else if (StringUtils.equals((CharSequence)appNumber, (CharSequence)"wtom")) {
            pageNumber = "wtom_overtimeapplybill";
        } else if (StringUtils.equals((CharSequence)appNumber, (CharSequence)"wtpm")) {
            pageNumber = "wtpm_supsignpc";
        } else if (StringUtils.equals((CharSequence)appNumber, (CharSequence)"wts")) {
            pageNumber = "wts_swshiftbill";
        }
        Pair pair = WTCBizDataPermissionServiceImpl.getInstance().getAllPermOrg("wtss", pageNumber, "47156aff000000ac");
        return ((List)pair.getRight()).size() > 0;
    }

    public void toApplyPage(String pageId, IFormView view, Long ruleId) {
        IPageCache cache = view.getPageCache();
        String timeStamp = cache.get("cacheTimestamp");
        if (!StringUtils.isEmpty((CharSequence)timeStamp)) {
            long lastTimeStamp = Long.parseLong(timeStamp);
            if (System.currentTimeMillis() - lastTimeStamp < 2000L) {
                return;
            }
        }
        cache.put("cacheTimestamp", String.valueOf(System.currentTimeMillis()));
        if (!StringUtils.isEmpty((CharSequence)pageId)) {
            String formId = MobileHomePageServiceHelper.getApplyFormId(pageId, false);
            boolean showApplyTypes = MobileTeamHomeBusiness.getInstance().canApplyOtherForNew(pageId);
            if (showApplyTypes) {
                HashMap<String, Object> customParams = new HashMap<String, Object>(2);
                customParams.put("billapplyType", 1);
                customParams.put("isAbnormal", Boolean.FALSE);
                customParams.put("sourceApp", "teamTime");
                BillContainerService.getInstance().openContainer("wtss", customParams, formId, view);
            } else {
                long ruleIdStr = ruleId;
                MobileHomeConf mobileHomeConf = SchemaServiceHelper.getInstance().queryTeamRuleBills(ruleIdStr);
                List billTypes = mobileHomeConf.getBillTypes();
                for (MobileHomeConf.BillType billType : billTypes) {
                    if (!pageId.equals(billType.getEntityId())) continue;
                    view.showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c{0}\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MobileTeamHomeBusiness_0", (String)"wtc-wtss-business", (Object[])new Object[]{billType.getBillName()}));
                    return;
                }
            }
        }
    }

    private static class Instance {
        private static final MobileTeamHomeBusiness INSTANCE = new MobileTeamHomeBusiness();

        private Instance() {
        }
    }
}

