/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.business.servicehelper.mobile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Html;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;

public class PrivacyHelper {
    private static final HRBaseServiceHelper SERVICE_HELPER = new HRBaseServiceHelper("inte_language");

    public static void showMobileForm(IFormView view, String formId, ShowType type, Map<String, Object> params) {
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(type);
        if (params != null && !params.isEmpty()) {
            showParameter.setCustomParams(params);
        }
        view.showForm((FormShowParameter)showParameter);
    }

    public static void setContent(IFormView view) {
        Object content;
        Map map = view.getFormShowParameter().getCustomParams();
        Object v0 = content = map == null ? null : map.get("content");
        if (!HRObjectUtils.isEmpty(content)) {
            Html htmlAp = (Html)view.getControl("htmlap");
            htmlAp.setConent(String.valueOf(content));
        }
    }

    public static Tuple<Boolean, Object> signPrivacy(IFormView view) {
        Map map = view.getFormShowParameter().getCustomParams();
        Long id = HRJSONUtils.getLongValOfCustomParam(map == null ? null : map.get("id"));
        Tuple<Boolean, Object> result = PrivacyHelper.signPrivacy(id);
        if (!((Boolean)result.item1).booleanValue()) {
            String errMsg = result.item2 == null ? ResManager.loadKDString((String)"\u7b7e\u7f72\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"PrivacyHelper_1", (String)"wtc-wtss-business", (Object[])new Object[0]) : String.valueOf(result.item2);
            view.showErrorNotification(errMsg);
        }
        return result;
    }

    public static Tuple<Boolean, Object> queryPrivacy(String method) {
        HashMap<String, Object> requestMap = new HashMap<String, Object>(16);
        requestMap.put("user", String.valueOf(RequestContext.get().getCurrUserId()));
        requestMap.put("system", Boolean.TRUE);
        HashMap group = new HashMap(16);
        String page = "wtss_mobilehomepage";
        HashSet<Long> localeSet = new HashSet<Long>();
        localeSet.add(PrivacyHelper.getLocaleId());
        group.put(page, localeSet);
        requestMap.put("group", group);
        Map responseMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSPrivacyService", (String)method, (Object[])new Object[]{requestMap});
        if (responseMap != null && "200".equals(responseMap.get("responseCode"))) {
            List data = (List)responseMap.get("data");
            Map dataMap = CollectionUtils.isEmpty((Collection)data) ? null : (Map)data.get(0);
            return new Tuple((Object)Boolean.TRUE, (Object)dataMap);
        }
        return new Tuple((Object)Boolean.FALSE, responseMap == null ? null : responseMap.get("errMessage"));
    }

    public static Tuple<Boolean, Object> signPrivacy(Long id) {
        HashMap<String, Object> requestMap = new HashMap<String, Object>(16);
        requestMap.put("user", String.valueOf(RequestContext.get().getCurrUserId()));
        requestMap.put("system", Boolean.TRUE);
        requestMap.put("id", id);
        requestMap.put("modifyTime", new Date());
        ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>(16);
        list.add(requestMap);
        Map responseMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSPrivacyService", (String)"signPrivacy", (Object[])new Object[]{list});
        return responseMap != null && "200".equals(responseMap.get("responseCode")) ? new Tuple((Object)Boolean.TRUE, null) : new Tuple((Object)Boolean.FALSE, responseMap == null ? null : responseMap.get("errMessage"));
    }

    public static Long getLocaleId() {
        DynamicObject dy = SERVICE_HELPER.queryOne("id", new QFilter("number", "=", (Object)RequestContext.get().getLang()));
        return dy == null ? null : Long.valueOf(dy.getLong("id"));
    }

    public static void handlePrivacyCheck(PreOpenFormEventArgs evt) {
        MobileFormShowParameter showParameter = (MobileFormShowParameter)evt.getSource();
        Tuple<Boolean, Object> result = PrivacyHelper.queryPrivacy("getPrivacySigningList");
        if (((Boolean)result.item1).booleanValue()) {
            Map respnoseMap = HRJSONUtils.convertJSONObjectToMap((Object)result.item2);
            if (respnoseMap == null) {
                PrivacyHelper.cancelForm(evt, showParameter, ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\uff0c\u914d\u7f6e\u9690\u79c1\u58f0\u660e\u3002", (String)"PrivacyHelper_2", (String)"wtc-wtss-business", (Object[])new Object[0]));
            } else if (!"1".equals(respnoseMap.get("isAgree"))) {
                Object content = respnoseMap.get("content");
                Object id = respnoseMap.get("id");
                if (content != null && id != null) {
                    HashMap customs = new HashMap(16);
                    customs.put("content", content);
                    customs.put("name", respnoseMap.get("name"));
                    customs.put("id", id);
                    customs.put("isAgree", Boolean.FALSE);
                    showParameter.getCustomParams().putAll(customs);
                } else {
                    PrivacyHelper.cancelForm(evt, showParameter, ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\uff0c\u914d\u7f6e\u9690\u79c1\u58f0\u660e\u3002", (String)"PrivacyHelper_2", (String)"wtc-wtss-business", (Object[])new Object[0]));
                }
            } else {
                showParameter.getCustomParams().remove("isAgree");
            }
        } else {
            PrivacyHelper.cancelForm(evt, showParameter, ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff1a\u9690\u79c1\u58f0\u660e\u63a5\u53e3\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"PrivacyHelper_3", (String)"wtc-wtss-business", (Object[])new Object[0]));
        }
    }

    private static void cancelForm(PreOpenFormEventArgs evt, MobileFormShowParameter showParameter, String content) {
        evt.setCancel(true);
        showParameter.setCustomParam("formName", (Object)ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"PrivacyHelper_4", (String)"wtc-wtss-business", (Object[])new Object[0]));
        evt.setCancelMessage(String.valueOf(content));
    }
}

