/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.business.servicehelper.mobile;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarChart;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.control.Label;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtss.business.servicehelper.mobile.MobileRankingDataServiceHelper;
import kd.wtc.wtss.common.dto.mobilehome.AttDataSourceDetailsModel;
import kd.wtc.wtss.common.dto.mobilehome.AttDataSourceModel;

public class RankingDataServiceHelper {
    private static final Log LOG = LogFactory.getLog(RankingDataServiceHelper.class);
    public static final HRBaseServiceHelper PER_STA_SOURCE_SERVICE_HELPER = new HRBaseServiceHelper("wtp_perstasource");
    public static final HRBaseServiceHelper DAILY_STA_SOURCE_SERVICE_HELPER = new HRBaseServiceHelper("wtp_dailystasource");

    public static void initRanking(List<AttDataSourceModel> attDataSource, IDataModel model, IFormView view) {
        LOG.info("RankingDataServiceHelper initRanking start");
        model.deleteEntryData("rankingentity");
        if (attDataSource == null || attDataSource.size() == 0) {
            RankingDataServiceHelper.rankingVisible(Boolean.FALSE, view);
            return;
        }
        RankingDataServiceHelper.rankingVisible(Boolean.TRUE, view);
        CardEntry cardEntry = (CardEntry)view.getControl("rankingentity");
        int rankDataSource = attDataSource.size() > 6 ? 6 : attDataSource.size();
        model.batchCreateNewEntryRow("rankingentity", rankDataSource);
        for (int index = 0; index < rankDataSource; ++index) {
            String sourceName = attDataSource.get(index).getAttDataSourceName();
            model.setValue("rankingname", (Object)sourceName, index);
            List attDataSourceDetailsModelList = attDataSource.get(index).getAttDataSourceDetails();
            if (attDataSourceDetailsModelList == null || attDataSourceDetailsModelList.size() == 0) {
                cardEntry.setChildVisible(false, index, new String[]{"rankingalldataflex"});
                cardEntry.setChildVisible(false, index, new String[]{"seemoreflex"});
                continue;
            }
            cardEntry.setChildVisible(false, index, new String[]{"rankingnoalldataflex"});
            for (int num = 1; num <= 3; ++num) {
                if (num > attDataSourceDetailsModelList.size()) {
                    cardEntry.setChildVisible(false, index, new String[]{"rankingflex" + num});
                    continue;
                }
                String pictureUrl = ((AttDataSourceDetailsModel)attDataSourceDetailsModelList.get(num - 1)).getPictureUrl();
                if (!HRStringUtils.isEmpty((String)pictureUrl) && !pictureUrl.contains("default_person_82_82")) {
                    model.setValue("rankingpic" + num, (Object)HRImageUrlUtil.getImageFullUrl((String)pictureUrl), index);
                }
                String personName = ((AttDataSourceDetailsModel)attDataSourceDetailsModelList.get(num - 1)).getPersonName();
                model.setValue("rankingpername" + num, (Object)personName, index);
                double staValue = ((AttDataSourceDetailsModel)attDataSourceDetailsModelList.get(num - 1)).getStaValue();
                BigDecimal bigDecimal = BigDecimal.valueOf(staValue);
                if ("2".equals(attDataSource.get(index).getValTakeMethod())) {
                    long seconds = bigDecimal.setScale(3, 4).stripTrailingZeros().longValue() / 1000L;
                    model.setValue("rankingsta" + num, (Object)MobileRankingDataServiceHelper.getInstance().secondToSpecifiedFormatStr(seconds), index);
                    continue;
                }
                String staValueStr = bigDecimal.setScale(3, 4).stripTrailingZeros().toPlainString();
                String unit = attDataSource.get(index).getUnit();
                model.setValue("rankingsta" + num, (Object)(staValueStr + unit), index);
            }
        }
        LOG.info("RankingDataServiceHelper initRanking end");
    }

    public static void initChart(List<AttDataSourceModel> attDataSource, IFormView view) {
        int index;
        LOG.info("RankingDataServiceHelper initChart start");
        String changeNumSelect = view.getPageCache().get("changeNumSelect");
        if ("changeNumSelect".equals(changeNumSelect)) {
            view.getPageCache().remove("changeNumSelect");
        } else {
            for (index = 0; index < 6; ++index) {
                view.getModel().setValue("numselect" + index, (Object)"5");
            }
        }
        if (attDataSource == null || attDataSource.size() == 0) {
            RankingDataServiceHelper.chartVisible(Boolean.FALSE, view);
            return;
        }
        RankingDataServiceHelper.chartVisible(Boolean.TRUE, view);
        for (index = 0; index < 6; ++index) {
            if (index >= attDataSource.size()) {
                view.setVisible(Boolean.FALSE, new String[]{"chartapflex" + index});
                continue;
            }
            view.setVisible(Boolean.TRUE, new String[]{"chartapflex" + index});
            List attDataSourceDetailsModelList = attDataSource.get(index).getAttDataSourceDetails();
            if (attDataSourceDetailsModelList == null || attDataSourceDetailsModelList.size() == 0) {
                view.setVisible(Boolean.FALSE, new String[]{"barchartap" + index});
                view.setVisible(Boolean.TRUE, new String[]{"chartnodatalabflex" + index});
            } else {
                view.setVisible(Boolean.TRUE, new String[]{"barchartap" + index});
                view.setVisible(Boolean.FALSE, new String[]{"chartnodatalabflex" + index});
            }
            BarChart barchart = (BarChart)view.getControl("barchartap" + index);
            barchart.clearData();
            String sourceName = attDataSource.get(index).getAttDataSourceName();
            Label chartName = (Label)view.getControl("chartname" + index);
            chartName.setText(sourceName);
            List attDataSourceDetailsModelList2 = attDataSource.get(index).getAttDataSourceDetails();
            ArrayList<String> xDataList = new ArrayList<String>(10);
            ArrayList<Number> yDataList = new ArrayList<Number>(10);
            String yUnit = attDataSource.get(index).getUnit();
            if (attDataSourceDetailsModelList2 == null) continue;
            for (AttDataSourceDetailsModel attDataSourceDetailsModel : attDataSourceDetailsModelList2) {
                String personName = attDataSourceDetailsModel.getPersonName();
                if (personName != null && personName.length() > 6) {
                    personName = personName.substring(0, 6) + "...";
                }
                xDataList.add(StringUtils.defaultString((String)personName, (String)""));
                double staValue = attDataSourceDetailsModel.getStaValue();
                BigDecimal bigDecimal = BigDecimal.valueOf(staValue);
                BigDecimal staValueFormat = bigDecimal.setScale(3, 4).stripTrailingZeros();
                yDataList.add(staValueFormat);
                Object num = view.getModel().getValue("numselect" + index);
                if (xDataList.size() != Integer.parseInt(num.toString())) continue;
                break;
            }
            LOG.info("RankingDataServiceHelper initChart xDataList:{}", xDataList);
            LOG.info("RankingDataServiceHelper initChart yDataList:{}", yDataList);
            RankingDataServiceHelper.chartSetValue(barchart, sourceName, xDataList, yDataList, yUnit, index);
            LOG.info("RankingDataServiceHelper initChart end");
        }
    }

    public static void chartSetValue(BarChart barchart, String sourceName, List<String> xDataList, List<Number> yDataList, String yUnit, int index) {
        Axis xAxis = barchart.createXAxis(ResManager.loadKDString((String)"\u59d3\u540d", (String)"MobileRankingDataServiceHelper_4", (String)"wtc-wtss-business", (Object[])new Object[0]), AxisType.category);
        Axis yAxis = barchart.createYAxis(yUnit, AxisType.value);
        xAxis.setPropValue("data", xDataList);
        xAxis.setInterval((Number)new BigDecimal("0"));
        HashMap<String, Object> axisLabelMap = new HashMap<String, Object>();
        if (xDataList.size() >= 10) {
            axisLabelMap.put("rotate", "-22.5");
        }
        axisLabelMap.put("interval", 0);
        xAxis.setPropValue("axisLabel", axisLabelMap);
        HashMap<String, Object> yStyleMap = new HashMap<String, Object>(16);
        int[] paddingArray = new int[]{0, 0, 0, -16};
        yStyleMap.put("padding", paddingArray);
        yStyleMap.put("fontSize", 12);
        yAxis.setPropValue("nameTextStyle", yStyleMap);
        BarSeries barseries = barchart.createSeries(sourceName);
        if (index % 2 == 0) {
            barseries.setColor("#40A9FF");
        } else {
            barseries.setColor("#45DAD1");
        }
        barseries.setData(yDataList.toArray(new Number[0]));
        barseries.setBarWidth("24px");
        barchart.addTooltip("trigger", (Object)"axis");
        HashMap<String, String> axisPointer = new HashMap<String, String>(16);
        axisPointer.put("type", "shadow");
        barchart.addTooltip("axisPointer", axisPointer);
        ArrayList<String> toolTipFuncPath = new ArrayList<String>(10);
        MobileRankingDataServiceHelper.setChartFormattor(barchart, yUnit);
        toolTipFuncPath.add("tooltip");
        toolTipFuncPath.add("formatter");
        barchart.addFuncPath(toolTipFuncPath);
        barchart.setShowTooltip(true);
        barchart.setMerge(false);
        barchart.refresh();
    }

    public static void rankingVisible(Boolean hasData, IFormView view) {
        view.setVisible(hasData, new String[]{"rankingentity"});
        view.setVisible(Boolean.valueOf(hasData == false), new String[]{"rankingnodataflex"});
    }

    public static void chartVisible(Boolean hasData, IFormView view) {
        view.setVisible(hasData, new String[]{"flexpanelap7"});
        view.setVisible(Boolean.valueOf(hasData == false), new String[]{"chartnodataflex"});
    }
}

