/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.business.servicehelper.pc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtss.common.constants.StaffPCAppConfigConstants;

public class StaffPCAppConfigService {
    public static HRBaseServiceHelper appConfDetailServiceHelper = new HRBaseServiceHelper("wtp_appconfdetail");
    public static HRBaseServiceHelper mobileRuleServiceHelper = new HRBaseServiceHelper("wtp_mobilerule");

    public static List<String> getShowAppConfig(Long ruleId) {
        long currentUserId = UserServiceHelper.getCurrentUserId();
        DynamicObject appConfDetail = appConfDetailServiceHelper.loadDynamicObject(new QFilter("user", "=", (Object)currentUserId));
        List<String> ruleAllApps = StaffPCAppConfigService.getRuleAllApps(ruleId);
        if (appConfDetail == null) {
            return ruleAllApps;
        }
        String appConfigStr = appConfDetail.getString("fastapp");
        String[] apps = appConfigStr.split(",");
        ArrayList<String> resultList = new ArrayList<String>(10);
        for (String app : apps) {
            if (!ruleAllApps.contains(app)) continue;
            resultList.add(app);
        }
        return resultList;
    }

    public static List<String> getUnShowAppConfig(Long ruleId) {
        List<String> allBillsList = StaffPCAppConfigService.getRuleAllApps(ruleId);
        List<String> showAppConfig = StaffPCAppConfigService.getShowAppConfig(ruleId);
        allBillsList.removeAll(showAppConfig);
        return allBillsList;
    }

    public static List<String> getRuleAllApps(Long ruleId) {
        DynamicObject mobileRule = mobileRuleServiceHelper.loadDynamicObject(new QFilter("id", "=", (Object)ruleId));
        String selectedBill = mobileRule.getString("selectedbill");
        if (WTCStringUtils.isEmpty((String)selectedBill)) {
            return new ArrayList<String>();
        }
        selectedBill = selectedBill.substring(1);
        String[] bills = selectedBill.split(",");
        StaffPCAppConfigService.rearrange(bills);
        return Arrays.stream(bills).filter(StaffPCAppConfigConstants.NEW_BILLNAMEMAP::containsKey).distinct().collect(Collectors.toList());
    }

    public static void saveAppConfig(IFormView view) {
        long currentUserId;
        DynamicObject appConfDetailExist;
        DynamicObjectCollection showEntryEntities = view.getModel().getEntryEntity("showentryentity");
        StringBuilder showAppBuilder = new StringBuilder();
        for (DynamicObject showEntryEntity : showEntryEntities) {
            String showText = showEntryEntity.getString("showtext");
            String showTextNumber = StaffPCAppConfigConstants.getBillNumber((String)showText);
            showAppBuilder.append(',').append(showTextNumber);
        }
        String showApp = showAppBuilder.toString();
        if (!"".equals(showApp)) {
            showApp = showApp.substring(1);
        }
        if ((appConfDetailExist = appConfDetailServiceHelper.loadDynamicObject(new QFilter("user", "=", (Object)(currentUserId = UserServiceHelper.getCurrentUserId())))) == null) {
            DynamicObject appConfDetail = appConfDetailServiceHelper.generateEmptyDynamicObject();
            appConfDetail.set("fastapp", (Object)showApp);
            appConfDetail.set("user", (Object)currentUserId);
            appConfDetailServiceHelper.saveOne(appConfDetail);
        } else {
            appConfDetailExist.set("fastapp", (Object)showApp);
            appConfDetailServiceHelper.updateOne(appConfDetailExist);
        }
    }

    public static void rearrange(String[] bills) {
        int bIndex = Arrays.binarySearch(bills, "B");
        int dIndex = Arrays.binarySearch(bills, "D");
        if (bIndex >= 0 && dIndex >= 0) {
            bills[bIndex] = "D";
            bills[dIndex] = "B";
        }
    }

    public static void initFastApp(Long ruleId, IFormView view) {
        view.getModel().deleteEntryData("fastappentryentity");
        List<String> showAppConfig = StaffPCAppConfigService.getShowAppConfig(ruleId);
        if (showAppConfig.size() == 0) {
            view.setVisible(Boolean.FALSE, new String[]{"fastappentryentity"});
            return;
        }
        view.getModel().batchCreateNewEntryRow("fastappentryentity", showAppConfig.size());
        for (int index = 0; index < showAppConfig.size(); ++index) {
            String imageUrl = (String)StaffPCAppConfigConstants.BILLPICMAP.get(showAppConfig.get(index));
            view.getModel().setValue("fastpic", (Object)StaffPCAppConfigService.imageUrlTransform(imageUrl), index);
            view.getModel().setValue("fastname", (Object)StaffPCAppConfigConstants.getBillName((String)showAppConfig.get(index)), index);
        }
        view.setVisible(Boolean.FALSE, new String[]{"quicklaunchdefaultflex"});
    }

    public static String imageUrlTransform(String imageUrl) {
        if (imageUrl == null) {
            return "";
        }
        String imageFullUrl = HRImageUrlUtil.getImageFullUrl((String)imageUrl);
        if (imageFullUrl.contains("/attachment/downloadImage")) {
            imageFullUrl = imageFullUrl.replaceAll("/attachment/downloadImage", "");
        }
        return imageFullUrl;
    }
}

