/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.business.servicehelper.summaryconf;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtss.business.servicehelper.common.SchemaServiceHelper;
import kd.wtc.wtss.common.dto.summaryconf.SummaryConfDetail;

public class SummaryConfigDetailService
extends HRBaseServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(SummaryConfigDetailService.class);
    HRBaseServiceHelper perSumConfigServiceHelper = new HRBaseServiceHelper("wtp_persumconfig");
    private final HRBaseServiceHelper QUOTASOURCE_HELPER = new HRBaseServiceHelper("wtp_quotasource");
    private final HRBaseServiceHelper QUOTACONFIG_HELPER = new HRBaseServiceHelper("wtp_quotaconfig");

    public void insert(long schemeId, long ruleId, long perSumConfigId, long userId, List<SummaryConfDetail> showList, int scene, String teamstatype) {
        LOGGER.info("insert param perSumConfigId:{},userId:{},showList:{}", new Object[]{perSumConfigId, userId, SerializationUtils.toJsonString(showList)});
        DynamicObject dynamicObject = this.generateEmptyDynamicObject();
        dynamicObject.set("sourcejsonstr", (Object)this.getSourceListToString(showList));
        dynamicObject.set("user", (Object)userId);
        dynamicObject.set("persumconfig", (Object)perSumConfigId);
        dynamicObject.set("mobilescheme", (Object)schemeId);
        dynamicObject.set("mobilerule", (Object)ruleId);
        dynamicObject.set("homepagetype", (Object)"1");
        dynamicObject.set("teamstatype", (Object)teamstatype);
        dynamicObject.set("scene", (Object)(scene + ""));
        dynamicObject.set("id", (Object)ID.genLongId());
        dynamicObject.set("createtime", (Object)WTCDateUtils.toDate((LocalDateTime)LocalDateTime.now()));
        dynamicObject.set("modifytime", (Object)WTCDateUtils.toDate((LocalDateTime)LocalDateTime.now()));
        this.saveOne(dynamicObject);
    }

    public void insertPC(long schemeId, long ruleId, long perSumConfigId, long userId, String showList, String teamstatype) {
        LOGGER.info("insert param perSumConfigId:{},userId:{},showList:{}", new Object[]{perSumConfigId, userId, SerializationUtils.toJsonString((Object)showList)});
        DynamicObject dynamicObject = this.generateEmptyDynamicObject();
        dynamicObject.set("sourcejsonstr", (Object)showList);
        dynamicObject.set("user", (Object)userId);
        dynamicObject.set("persumconfig", (Object)perSumConfigId);
        dynamicObject.set("mobilescheme", (Object)schemeId);
        dynamicObject.set("mobilerule", (Object)ruleId);
        dynamicObject.set("homepagetype", (Object)"1");
        dynamicObject.set("teamstatype", (Object)teamstatype);
        dynamicObject.set("scene", (Object)"2");
        dynamicObject.set("id", (Object)ID.genLongId());
        dynamicObject.set("createtime", (Object)WTCDateUtils.toDate((LocalDateTime)LocalDateTime.now()));
        dynamicObject.set("modifytime", (Object)WTCDateUtils.toDate((LocalDateTime)LocalDateTime.now()));
        this.saveOne(dynamicObject);
    }

    public Map<String, Object> queryInfo(long userId, String type, String personAttPeriodId, long mobileSchemeId, int scene, Long attFileBid) {
        ArrayList<SummaryConfDetail> showSummarySort;
        Map<String, Object> map;
        boolean isUserConfigCanWork;
        LOGGER.info("query param userId:{},type:{},personAttPeriodId:{},mobileSchemeId:{},attFileBid{}", new Object[]{userId, type, personAttPeriodId, mobileSchemeId, attFileBid});
        DynamicObject perSumConfig = SchemaServiceHelper.getInstance().getPerSumConfigByUser(mobileSchemeId, type);
        if (perSumConfig == null) {
            HashMap<String, Object> map2 = new HashMap<String, Object>(6);
            map2.put("show", new ArrayList(1));
            map2.put("otherTimes", new ArrayList(1));
            map2.put("otherDuration", new ArrayList(1));
            return map2;
        }
        long perSumConfigId = perSumConfig.getLong("id");
        DynamicObject perSumConfigDyn = this.perSumConfigServiceHelper.queryOne((Object)perSumConfigId);
        DynamicObject query = this.queryOne(userId, scene, "2", perSumConfigId);
        DynamicObjectCollection perSumConfigSourceDyn = perSumConfigDyn.getDynamicObjectCollection("entryentity");
        boolean bl = isUserConfigCanWork = query != null;
        if (isUserConfigCanWork) {
            List userSourceIds = SerializationUtils.fromJsonStringToList((String)query.getString("sourcejsonstr"), Long.class);
            if (CollectionUtils.isNotEmpty((Collection)userSourceIds)) {
                userSourceIds = userSourceIds.stream().distinct().collect(Collectors.toList());
            }
            LOGGER.info("query userSourceIds\uff1a{}", (Object)SerializationUtils.toJsonString((Object)userSourceIds));
            block0: for (DynamicObject entity : perSumConfigSourceDyn) {
                for (Long userSourceId : userSourceIds) {
                    entity.set("display", (Object)Boolean.FALSE);
                    if (entity.getDynamicObject("persumsource").getLong("id") != userSourceId.longValue()) continue;
                    entity.set("display", (Object)Boolean.TRUE);
                    continue block0;
                }
            }
            map = this.assemblyReturnValue(attFileBid, personAttPeriodId, perSumConfigId, perSumConfigSourceDyn, scene);
            List showSummary = (List)map.get("show");
            showSummarySort = new ArrayList<SummaryConfDetail>(showSummary.size());
            Iterator iterator = userSourceIds.iterator();
            while (iterator.hasNext()) {
                long userSourceId = (Long)iterator.next();
                for (SummaryConfDetail confDetail : showSummary) {
                    if (confDetail.getSourceId() != userSourceId) continue;
                    showSummarySort.add(confDetail);
                }
            }
        } else {
            return this.assemblyReturnValue(attFileBid, personAttPeriodId, perSumConfigId, perSumConfigSourceDyn, scene);
        }
        map.put("show", showSummarySort);
        List showList = (List)map.get("show");
        if (showList == null || showList.size() == 0) {
            return this.assemblyReturnValue(attFileBid, personAttPeriodId, perSumConfigId, perSumConfigSourceDyn, scene);
        }
        return map;
    }

    @Deprecated
    public Map<String, Object> query(long userId, String type, String personAttPeriodId, long mobileSchemeId, int scene) {
        ArrayList<SummaryConfDetail> showSummarySort;
        Map<String, Object> map;
        boolean isUserConfigCanWork;
        LOGGER.info("query param userId:{},type:{},personAttPeriodId:{},mobileSchemeId:{}", new Object[]{userId, type, personAttPeriodId, mobileSchemeId});
        DynamicObject perSumConfig = SchemaServiceHelper.getInstance().getPerSumConfigByUser(mobileSchemeId, type);
        if (perSumConfig == null) {
            HashMap<String, Object> map2 = new HashMap<String, Object>(6);
            map2.put("show", new ArrayList(1));
            map2.put("otherTimes", new ArrayList(1));
            map2.put("otherDuration", new ArrayList(1));
            return map2;
        }
        long perSumConfigId = perSumConfig.getLong("id");
        DynamicObject perSumConfigDyn = this.perSumConfigServiceHelper.queryOne((Object)perSumConfigId);
        DynamicObject query = this.queryOne(userId, scene, "2", perSumConfigId);
        DynamicObjectCollection perSumConfigSourceDyn = perSumConfigDyn.getDynamicObjectCollection("entryentity");
        boolean bl = isUserConfigCanWork = query != null;
        if (isUserConfigCanWork) {
            List userSourceIds = SerializationUtils.fromJsonStringToList((String)query.getString("sourcejsonstr"), Long.class);
            if (CollectionUtils.isNotEmpty((Collection)userSourceIds)) {
                userSourceIds = userSourceIds.stream().distinct().collect(Collectors.toList());
            }
            LOGGER.info("query userSourceIds\uff1a{}", (Object)SerializationUtils.toJsonString((Object)userSourceIds));
            block0: for (DynamicObject entity : perSumConfigSourceDyn) {
                for (Long userSourceId : userSourceIds) {
                    entity.set("display", (Object)Boolean.FALSE);
                    if (entity.getDynamicObject("persumsource").getLong("id") != userSourceId.longValue()) continue;
                    entity.set("display", (Object)Boolean.TRUE);
                    continue block0;
                }
            }
            map = this.assemblyReturnValueByUserId(userId, personAttPeriodId, perSumConfigId, perSumConfigSourceDyn, scene);
            List showSummary = (List)map.get("show");
            showSummarySort = new ArrayList<SummaryConfDetail>(showSummary.size());
            Iterator iterator = userSourceIds.iterator();
            while (iterator.hasNext()) {
                long userSourceId = (Long)iterator.next();
                for (SummaryConfDetail confDetail : showSummary) {
                    if (confDetail.getSourceId() != userSourceId) continue;
                    showSummarySort.add(confDetail);
                }
            }
        } else {
            return this.assemblyReturnValueByUserId(userId, personAttPeriodId, perSumConfigId, perSumConfigSourceDyn, scene);
        }
        map.put("show", showSummarySort);
        List showList = (List)map.get("show");
        if (showList == null || showList.size() == 0) {
            return this.assemblyReturnValueByUserId(userId, personAttPeriodId, perSumConfigId, perSumConfigSourceDyn, scene);
        }
        return map;
    }

    public Map<String, Object> queryQT(long userId, String type, Long quotaConfigId, int scene) {
        ArrayList<SummaryConfDetail> showSummarySort;
        Map<String, Object> map;
        boolean isUserConfigCanWork;
        LOGGER.info("queryQT param userId:{},type:{},personAttPeriodId:{}", new Object[]{userId, type, quotaConfigId});
        DynamicObject quotaConfig = this.QUOTACONFIG_HELPER.queryOne((Object)quotaConfigId);
        if (quotaConfig == null) {
            HashMap<String, Object> map2 = new HashMap<String, Object>(6);
            map2.put("show", new ArrayList(1));
            map2.put("otherTimes", new ArrayList(1));
            map2.put("otherDuration", new ArrayList(1));
            return map2;
        }
        DynamicObject query = this.queryOne(userId, scene, "3", quotaConfigId);
        DynamicObjectCollection quotaSourceDyn = quotaConfig.getDynamicObjectCollection("entryentity");
        boolean bl = isUserConfigCanWork = query != null;
        if (isUserConfigCanWork) {
            List userSourceIds = SerializationUtils.fromJsonStringToList((String)query.getString("sourcejsonstr"), Long.class);
            if (CollectionUtils.isNotEmpty((Collection)userSourceIds)) {
                userSourceIds = userSourceIds.stream().distinct().collect(Collectors.toList());
            }
            LOGGER.info("query userSourceIds\uff1a{}", (Object)SerializationUtils.toJsonString((Object)userSourceIds));
            block0: for (DynamicObject dy : quotaSourceDyn) {
                for (Long userSourceId : userSourceIds) {
                    dy.set("display", (Object)Boolean.FALSE);
                    if (WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"quotasource") != userSourceId) continue;
                    dy.set("display", (Object)Boolean.TRUE);
                    continue block0;
                }
            }
            map = this.assemblyReturnValueForQT(quotaConfigId, quotaSourceDyn, scene);
            List showSummary = (List)map.get("show");
            showSummarySort = new ArrayList<SummaryConfDetail>(showSummary.size());
            Iterator iterator = userSourceIds.iterator();
            while (iterator.hasNext()) {
                long userSourceId = (Long)iterator.next();
                for (SummaryConfDetail confDetail : showSummary) {
                    if (confDetail.getSourceId() != userSourceId) continue;
                    showSummarySort.add(confDetail);
                }
            }
        } else {
            return this.assemblyReturnValueForQT(quotaConfigId, quotaSourceDyn, scene);
        }
        map.put("show", showSummarySort);
        List showList = (List)map.get("show");
        if (showList == null || showList.size() == 0) {
            return this.assemblyReturnValueForQT(quotaConfigId, quotaSourceDyn, scene);
        }
        return map;
    }

    private Map<String, Object> assemblyReturnValueByUserId(long userId, String personAttPeriodId, long perSumConfigId, DynamicObjectCollection perSumConfigSourceDyn, int scene) {
        ArrayList<SummaryConfDetail> showList = new ArrayList<SummaryConfDetail>(perSumConfigSourceDyn.size());
        ArrayList<SummaryConfDetail> frequencyList = new ArrayList<SummaryConfDetail>(perSumConfigSourceDyn.size());
        ArrayList<SummaryConfDetail> durationList = new ArrayList<SummaryConfDetail>(perSumConfigSourceDyn.size());
        String sceneStr = "2";
        sceneStr = scene == 1 ? sceneStr + "1" : sceneStr + "0";
        for (DynamicObject entity : perSumConfigSourceDyn) {
            if (!sceneStr.contains(entity.getString("terminal")) && entity.getString("terminal") != null) continue;
            SummaryConfDetail scd = new SummaryConfDetail();
            DynamicObject source = entity.getDynamicObject("persumsource");
            scd.setSourceId(source.getLong("id"));
            scd.setName(source.getString("name"));
            scd.setDisplay(entity.getBoolean("display"));
            scd.setAdjustment(entity.getBoolean("adjustment"));
            scd.setDatatype(source.getString("datatype"));
            scd.setUnit(source.getString("unit"));
            if (scd.isDisplay()) {
                this.calculateAttItemStatisticsByUserId(source, scd, personAttPeriodId, userId);
                showList.add(scd);
                continue;
            }
            if (HRStringUtils.equals((String)scd.getDatatype(), (String)"0")) {
                frequencyList.add(scd);
                continue;
            }
            if (!HRStringUtils.equals((String)scd.getDatatype(), (String)"1")) continue;
            durationList.add(scd);
        }
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("sourceId", perSumConfigId);
        map.put("show", showList);
        map.put("otherTimes", frequencyList);
        map.put("otherDuration", durationList);
        LOGGER.info("query return map:{}", (Object)SerializationUtils.toJsonString(map));
        return map;
    }

    private Map<String, Object> assemblyReturnValue(Long attFileBid, String personAttPeriodId, long perSumConfigId, DynamicObjectCollection perSumConfigSourceDyn, int scene) {
        ArrayList<SummaryConfDetail> showList = new ArrayList<SummaryConfDetail>(perSumConfigSourceDyn.size());
        ArrayList<SummaryConfDetail> frequencyList = new ArrayList<SummaryConfDetail>(perSumConfigSourceDyn.size());
        ArrayList<SummaryConfDetail> durationList = new ArrayList<SummaryConfDetail>(perSumConfigSourceDyn.size());
        String sceneStr = "2";
        sceneStr = scene == 1 ? sceneStr + "1" : sceneStr + "0";
        for (DynamicObject entity : perSumConfigSourceDyn) {
            if (!sceneStr.contains(entity.getString("terminal")) && entity.getString("terminal") != null) continue;
            SummaryConfDetail scd = new SummaryConfDetail();
            DynamicObject source = entity.getDynamicObject("persumsource");
            scd.setSourceId(source.getLong("id"));
            scd.setName(source.getString("name"));
            scd.setDisplay(entity.getBoolean("display"));
            scd.setAdjustment(entity.getBoolean("adjustment"));
            scd.setDatatype(source.getString("datatype"));
            scd.setUnit(source.getString("unit"));
            if (scd.isDisplay()) {
                this.calculateAttItemStatistics(source, scd, personAttPeriodId, attFileBid);
                showList.add(scd);
                continue;
            }
            if (HRStringUtils.equals((String)scd.getDatatype(), (String)"0")) {
                frequencyList.add(scd);
                continue;
            }
            if (!HRStringUtils.equals((String)scd.getDatatype(), (String)"1")) continue;
            durationList.add(scd);
        }
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("sourceId", perSumConfigId);
        map.put("show", showList);
        map.put("otherTimes", frequencyList);
        map.put("otherDuration", durationList);
        LOGGER.info("query return map:{}", (Object)SerializationUtils.toJsonString(map));
        return map;
    }

    private Map<String, Object> assemblyReturnValueForQT(Long quotaConfigId, DynamicObjectCollection quotaSourceDyn, int scene) {
        ArrayList<SummaryConfDetail> showList = new ArrayList<SummaryConfDetail>(quotaSourceDyn.size());
        ArrayList<SummaryConfDetail> frequencyList = new ArrayList<SummaryConfDetail>(quotaSourceDyn.size());
        ArrayList<SummaryConfDetail> durationList = new ArrayList<SummaryConfDetail>(quotaSourceDyn.size());
        String sceneStr = "2" + ("1".equals(String.valueOf(scene)) ? "1" : "0");
        for (DynamicObject entity : quotaSourceDyn) {
            if (!sceneStr.contains(entity.getString("terminal")) && entity.getString("terminal") != null) continue;
            SummaryConfDetail scd = new SummaryConfDetail();
            DynamicObject source = entity.getDynamicObject("quotasource");
            DynamicObjectCollection attItemCollection = source.getDynamicObjectCollection("entryentity");
            Set attItemIdSet = attItemCollection.stream().map(attitem -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)attitem, (String)"attitem")).collect(Collectors.toSet());
            scd.setSourceId(source.getLong("id"));
            scd.setName(source.getString("name"));
            scd.setDisplay(entity.getBoolean("display"));
            scd.setAdjustment(entity.getBoolean("adjustment"));
            scd.setDatatype(source.getString("datatype"));
            scd.setUnit(source.getString("unit"));
            scd.setAttItems(attItemIdSet);
            if (scd.isDisplay()) {
                showList.add(scd);
                continue;
            }
            if (HRStringUtils.equals((String)scd.getDatatype(), (String)"0")) {
                frequencyList.add(scd);
                continue;
            }
            if (!HRStringUtils.equals((String)scd.getDatatype(), (String)"1")) continue;
            durationList.add(scd);
        }
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("sourceId", quotaConfigId);
        map.put("show", showList);
        map.put("otherTimes", frequencyList);
        map.put("otherDuration", durationList);
        LOGGER.info("quota query return map:{}", (Object)SerializationUtils.toJsonString(map));
        return map;
    }

    public void update(long userId, long schemeId, long ruleId, long perSumConfigId, List<SummaryConfDetail> showList, int scene, String teamStaType) {
        LOGGER.info("update param perSumConfigId:{},userId:{},showList:{}", new Object[]{perSumConfigId, userId, SerializationUtils.toJsonString(showList)});
        DynamicObject query = this.queryOne(userId, scene, teamStaType, perSumConfigId);
        if (query == null) {
            this.insert(schemeId, ruleId, perSumConfigId, userId, showList, scene, teamStaType);
            return;
        }
        query.set("scene", (Object)(scene + ""));
        query.set("mobilescheme", (Object)schemeId);
        query.set("mobilerule", (Object)ruleId);
        query.set("modifytime", (Object)WTCDateUtils.toDate((LocalDateTime)LocalDateTime.now()));
        query.set("sourcejsonstr", (Object)this.getSourceListToString(showList));
        query.set("teamstatype", (Object)teamStaType);
        this.updateOne(query);
    }

    public void updatePC(long userId, long schemeId, long ruleId, long perSumConfigId, String showList, String teamstatype) {
        LOGGER.info("update param perSumConfigId:{},userId:{},showList:{}", new Object[]{perSumConfigId, userId, showList});
        DynamicObject query = this.queryOnePC(userId, teamstatype, "1");
        if (query == null) {
            this.insertPC(schemeId, ruleId, perSumConfigId, userId, showList, teamstatype);
            return;
        }
        query.set("scene", (Object)"2");
        query.set("mobilescheme", (Object)schemeId);
        query.set("mobilerule", (Object)ruleId);
        query.set("modifytime", (Object)WTCDateUtils.toDate((LocalDateTime)LocalDateTime.now()));
        query.set("sourcejsonstr", (Object)showList);
        query.set("persumconfig", (Object)perSumConfigId);
        this.updateOne(query);
    }

    public DynamicObject queryOnePC(long userId, String teamstatype, String homePageType) {
        String join = String.join((CharSequence)",", "sourcejsonstr", "user", "persumconfig", "modifytime", "mobilescheme", "mobilerule", "scene");
        return this.queryOne(join, new QFilter[]{new QFilter("user", "=", (Object)userId), new QFilter("scene", "=", (Object)"2"), new QFilter("teamstatype", "=", (Object)teamstatype), new QFilter("homepagetype", "=", (Object)homePageType)});
    }

    private String getSourceListToString(List<SummaryConfDetail> showList) {
        return SerializationUtils.toJsonString(showList.stream().map(SummaryConfDetail::getSourceId).collect(Collectors.toList()));
    }

    private Set<Long> getAttItemSet(DynamicObject source) {
        DynamicObjectCollection entityCollection = source.getDynamicObjectCollection("entryentity");
        return entityCollection.stream().map(entity -> entity.getDynamicObject("attitem").getLong("id")).collect(Collectors.toSet());
    }

    private void calculateAttItemStatisticsByUserId(DynamicObject source, SummaryConfDetail scd, String personAttPeriodId, long userId) {
        if (HRStringUtils.isNotEmpty((String)personAttPeriodId)) {
            Map<String, Double> collect;
            OptionalDouble optionalDouble;
            LOGGER.info("query source idList:{}", (Object)SerializationUtils.toJsonString(this.getAttItemSet(source)));
            List<Map<String, String>> valueList = this.queryAttItemValue(personAttPeriodId, userId, this.getAttItemSet(source));
            LOGGER.info("query source valueList:{}", (Object)SerializationUtils.toJsonString(valueList));
            BigDecimal value = BigDecimal.ZERO;
            if (HRStringUtils.equals((String)source.getString("treatmentmeth"), (String)"1")) {
                value = BigDecimal.valueOf(valueList.stream().mapToDouble(map -> Double.parseDouble((String)map.get("value"))).sum()).setScale(2, RoundingMode.HALF_UP);
            } else if (HRStringUtils.equals((String)source.getString("treatmentmeth"), (String)"2") && (optionalDouble = (collect = valueList.stream().collect(Collectors.groupingBy(map -> (String)map.get("attitemid"), Collectors.summingDouble(map -> Double.parseDouble((String)map.get("value")))))).entrySet().stream().mapToDouble(Map.Entry::getValue).average()).isPresent()) {
                value = BigDecimal.valueOf(optionalDouble.getAsDouble()).setScale(2, RoundingMode.HALF_UP);
            }
            scd.setAttItemValue(BigDecimal.ZERO.compareTo(value) == 0 ? "0" : value.stripTrailingZeros().toPlainString());
        }
    }

    private void calculateAttItemStatistics(DynamicObject source, SummaryConfDetail scd, String personAttPeriodId, Long attFileBid) {
        if (HRStringUtils.isNotEmpty((String)personAttPeriodId)) {
            Map<String, Double> collect;
            OptionalDouble optionalDouble;
            LOGGER.info("query source idList:{}", (Object)SerializationUtils.toJsonString(this.getAttItemSet(source)));
            List<Map<String, String>> valueList = this.queryAttItemValueByAttFileBid(personAttPeriodId, this.getAttItemSet(source), attFileBid);
            LOGGER.info("query source valueList:{}", (Object)SerializationUtils.toJsonString(valueList));
            BigDecimal value = BigDecimal.ZERO;
            if (HRStringUtils.equals((String)source.getString("treatmentmeth"), (String)"1")) {
                value = BigDecimal.valueOf(valueList.stream().mapToDouble(map -> Double.parseDouble((String)map.get("value"))).sum()).setScale(2, RoundingMode.HALF_UP);
            } else if (HRStringUtils.equals((String)source.getString("treatmentmeth"), (String)"2") && (optionalDouble = (collect = valueList.stream().collect(Collectors.groupingBy(map -> (String)map.get("attitemid"), Collectors.summingDouble(map -> Double.parseDouble((String)map.get("value")))))).entrySet().stream().mapToDouble(Map.Entry::getValue).average()).isPresent()) {
                value = BigDecimal.valueOf(optionalDouble.getAsDouble()).setScale(2, RoundingMode.HALF_UP);
            }
            scd.setAttItemValue(BigDecimal.ZERO.compareTo(value) == 0 ? "0" : value.stripTrailingZeros().toPlainString());
        }
    }

    private List<Map<String, String>> queryAttItemValue(String personAttPeriodId, long userId, Set<Long> attItemSet) {
        return (List)DispatchServiceHelper.invokeBizService((String)"wtc", (String)"wtte", (String)"IAttRecordService", (String)"listSummaryAttItems", (Object[])new Object[]{userId, personAttPeriodId, attItemSet});
    }

    private List<Map<String, String>> queryAttItemValueByAttFileBid(String personAttPeriodId, Set<Long> attItemSet, Long attFileBid) {
        return (List)DispatchServiceHelper.invokeBizService((String)"wtc", (String)"wtte", (String)"IAttRecordService", (String)"listSummaryAttItemsByAttFileBo", (Object[])new Object[]{attFileBid, personAttPeriodId, attItemSet});
    }

    public DynamicObject queryOne(long userId, int scene, String statisticType, Long configId) {
        String join = String.join((CharSequence)",", "sourcejsonstr", "user", "persumconfig", "modifytime", "mobilescheme", "mobilerule", "scene", "teamstatype");
        return this.queryOne(join, new QFilter[]{new QFilter("user", "=", (Object)userId), new QFilter("scene", "=", (Object)(scene + "")), new QFilter("teamstatype", "=", (Object)statisticType), new QFilter("persumconfig", "=", (Object)configId)});
    }

    public DynamicObject queryDay(long userId, int scene, int homePageType) {
        String join = String.join((CharSequence)",", "sourcejsonstr", "user", "persumconfig", "modifytime", "mobilescheme", "mobilerule");
        return this.queryOne(join, new QFilter[]{new QFilter("user", "=", (Object)userId), new QFilter("teamstatype", "=", (Object)"1"), new QFilter("scene", "=", (Object)(scene + "")), new QFilter("homepagetype", "=", (Object)(homePageType + ""))});
    }

    private SummaryConfigDetailService() {
        super("wtp_sumconfdetail");
    }

    public static SummaryConfigDetailService getInstance() {
        return SummaryConfigDetailServiceHelper.SUM_CONF_DETAIL;
    }

    private static class SummaryConfigDetailServiceHelper {
        private static final SummaryConfigDetailService SUM_CONF_DETAIL = new SummaryConfigDetailService();

        private SummaryConfigDetailServiceHelper() {
        }
    }
}

