/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.business.servicehelper.summaryconf;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtss.business.servicehelper.common.SchemaServiceHelper;
import kd.wtc.wtss.common.dto.mobilehome.AttDataSourceModel;

public class SummaryTeamConfigDetailService
extends HRBaseServiceHelper {
    private static final Log LOG = LogFactory.getLog(SummaryTeamConfigDetailService.class);
    HRBaseServiceHelper daiStaConfigServiceHelper = new HRBaseServiceHelper("wtp_dailystaconfig");
    HRBaseServiceHelper perStaConfigServiceHelper = new HRBaseServiceHelper("wtp_perstaconfig");

    private SummaryTeamConfigDetailService() {
        super("wtp_sumconfdetail");
    }

    public static SummaryTeamConfigDetailService getInstance() {
        return SummaryConfigDetailServiceHelper.SUM_CONF_DETAIL;
    }

    public void insert(long schemeId, long ruleId, long userId, List<AttDataSourceModel> showList, String configType, String applyLayout, String scene) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("insert param userId:{},showList:{}", (Object)userId, (Object)SerializationUtils.toJsonString(showList));
        }
        DynamicObject dynamicObject = this.generateEmptyDynamicObject();
        dynamicObject.set("sourcejsonstr", (Object)this.getSourceListToString(showList));
        dynamicObject.set("user", (Object)userId);
        dynamicObject.set("mobilescheme", (Object)schemeId);
        dynamicObject.set("mobilerule", (Object)ruleId);
        dynamicObject.set("homepagetype", (Object)"2");
        dynamicObject.set("teamstatype", (Object)configType);
        dynamicObject.set("applylayout", (Object)applyLayout);
        dynamicObject.set("scene", (Object)scene);
        dynamicObject.set("id", (Object)ID.genLongId());
        dynamicObject.set("createtime", (Object)WTCDateUtils.toDate((LocalDateTime)LocalDateTime.now()));
        dynamicObject.set("modifytime", (Object)WTCDateUtils.toDate((LocalDateTime)LocalDateTime.now()));
        this.saveOne(dynamicObject);
    }

    public Map<String, Object> queryTeamStaConfigList(long userId, long ruleId, String userType, String configType, String applyLayout) {
        String terminal;
        String entryAdjName;
        String entryDisplayName;
        String entryBaseName;
        DynamicObjectCollection staConfigSourceDyn;
        DynamicObject staConfigDyn;
        String teamStaType;
        long staConfigId;
        DynamicObject staConfig;
        LOG.info("teamhome queryTeamStaConfigList start ruleId:{}", (Object)ruleId);
        DynamicObject mobileRule = SchemaServiceHelper.getInstance().queryRuleData(ruleId);
        if (null == mobileRule || null == mobileRule.getDynamicObject("dailystaconfig")) {
            return null;
        }
        if (configType.equals("A")) {
            staConfig = mobileRule.getDynamicObject("dailystaconfig");
            staConfigId = staConfig.getLong("id");
            teamStaType = "1";
            staConfigDyn = this.daiStaConfigServiceHelper.queryOne((Object)staConfigId);
        } else {
            staConfig = mobileRule.getDynamicObject("perstaconfig");
            if (staConfig == null) {
                return null;
            }
            staConfigId = staConfig.getLong("id");
            teamStaType = "2";
            staConfigDyn = this.perStaConfigServiceHelper.queryOne((Object)staConfigId);
        }
        if (applyLayout.equals("1")) {
            staConfigSourceDyn = staConfigDyn.getDynamicObjectCollection("entryentity");
            entryBaseName = "stasource";
            entryDisplayName = "display";
            entryAdjName = "adjustment";
            terminal = "terminal";
        } else if (applyLayout.equals("2")) {
            staConfigSourceDyn = staConfigDyn.getDynamicObjectCollection("rankentryentity");
            entryBaseName = "rankstasource";
            entryDisplayName = "rankdisplay";
            entryAdjName = "rankadjustment";
            terminal = "rankterminal";
        } else {
            staConfigSourceDyn = staConfigDyn.getDynamicObjectCollection("chartentryentity");
            entryBaseName = "chartstasource";
            entryDisplayName = "chartdisplay";
            entryAdjName = "chartadjustment";
            terminal = "chartterminal";
        }
        this.setEntityInfo(userType, staConfigSourceDyn, terminal);
        ArrayList<AttDataSourceModel> attDataSourceModel = new ArrayList<AttDataSourceModel>(staConfigSourceDyn.size());
        DynamicObject query = this.queryOneConfig(userId, ruleId, teamStaType, applyLayout, userType);
        ArrayList<AttDataSourceModel> showSortList = new ArrayList<AttDataSourceModel>(staConfigSourceDyn.size());
        if (query != null) {
            List userSourceIds = SerializationUtils.fromJsonStringToList((String)query.getString("sourcejsonstr"), Long.class);
            for (DynamicObject entity : staConfigSourceDyn) {
                entity.set(entryDisplayName, (Object)Boolean.FALSE);
            }
            block1: for (Long userSourceId : userSourceIds) {
                for (DynamicObject entity : staConfigSourceDyn) {
                    if (entity.getDynamicObject(entryBaseName) == null || userSourceId == null || entity.getDynamicObject(entryBaseName).getLong("id") != userSourceId.longValue()) continue;
                    entity.set(entryDisplayName, (Object)Boolean.TRUE);
                    AttDataSourceModel attDataSortSource = new AttDataSourceModel();
                    attDataSortSource.setAttDataSourceId(Long.valueOf(entity.getDynamicObject(entryBaseName).getLong("id")));
                    attDataSortSource.setAttDataSourceName(entity.getDynamicObject(entryBaseName).getString("name"));
                    attDataSortSource.setDisplay(entity.getBoolean(entryDisplayName));
                    attDataSortSource.setAdjustment(entity.getBoolean(entryAdjName));
                    showSortList.add(attDataSortSource);
                    continue block1;
                }
            }
        }
        for (DynamicObject entity : staConfigSourceDyn) {
            AttDataSourceModel attDataSource = new AttDataSourceModel();
            if (entity.getDynamicObject(entryBaseName) != null) {
                attDataSource.setAttDataSourceId(Long.valueOf(entity.getDynamicObject(entryBaseName).getLong("id")));
                attDataSource.setAttDataSourceName(entity.getDynamicObject(entryBaseName).getString("name"));
            }
            attDataSource.setDisplay(entity.getBoolean(entryDisplayName));
            attDataSource.setAdjustment(entity.getBoolean(entryAdjName));
            attDataSourceModel.add(attDataSource);
        }
        LOG.info("teamhome queryTeamStaConfigList end");
        return this.returnConfigData(attDataSourceModel, staConfigId, showSortList);
    }

    private void setEntityInfo(String userType, DynamicObjectCollection staConfigSourceDyn, String terminal) {
        ArrayList<DynamicObject> staDelDyn = new ArrayList<DynamicObject>();
        if ("1".equals(userType)) {
            for (DynamicObject dynObj : staConfigSourceDyn) {
                if (!dynObj.get(terminal).equals("0")) continue;
                staDelDyn.add(dynObj);
            }
        } else {
            for (DynamicObject dynObj : staConfigSourceDyn) {
                if (!dynObj.get(terminal).equals("1")) continue;
                staDelDyn.add(dynObj);
            }
        }
        staConfigSourceDyn.removeAll(staDelDyn);
    }

    public Map<String, Object> returnConfigData(List<AttDataSourceModel> dayAttStatisticsData, long dayConfigId, List<AttDataSourceModel> showSortList) {
        ArrayList<AttDataSourceModel> showList = new ArrayList<AttDataSourceModel>(dayAttStatisticsData.size());
        ArrayList<AttDataSourceModel> othersConfigList = new ArrayList<AttDataSourceModel>(dayAttStatisticsData.size());
        for (AttDataSourceModel attDataSou : dayAttStatisticsData) {
            if (attDataSou.isDisplay()) {
                showList.add(attDataSou);
                continue;
            }
            othersConfigList.add(attDataSou);
        }
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("sourceId", dayConfigId);
        if (showSortList.size() == 0) {
            map.put("show", showList);
        } else {
            map.put("show", showSortList);
        }
        map.put("others", othersConfigList);
        if (LOG.isDebugEnabled()) {
            LOG.debug("returnConfigData return map:{}", (Object)SerializationUtils.toJsonString(map));
        }
        return map;
    }

    public void update(long userId, long schemeId, long ruleId, List<AttDataSourceModel> showList, String configType, String applyLayout, String scene, Map<String, String> returnData) {
        DynamicObject query;
        if (null == showList) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("update param userId:{},showList:{}", (Object)userId, (Object)SerializationUtils.toJsonString(showList));
        }
        if ((query = this.queryOneConfig(userId, ruleId, configType, applyLayout, scene)) == null) {
            this.insert(schemeId, ruleId, userId, showList, configType, applyLayout, scene);
            return;
        }
        if (this.getSourceListToString(showList).equals(query.get("sourcejsonstr"))) {
            returnData.put("data_change", "1");
            return;
        }
        query.set("mobilescheme", (Object)schemeId);
        query.set("mobilerule", (Object)ruleId);
        query.set("modifytime", (Object)WTCDateUtils.toDate((LocalDateTime)LocalDateTime.now()));
        query.set("sourcejsonstr", (Object)this.getSourceListToString(showList));
        this.updateOne(query);
    }

    private String getSourceListToString(List<AttDataSourceModel> showList) {
        return SerializationUtils.toJsonString(showList.stream().map(AttDataSourceModel::getAttDataSourceId).collect(Collectors.toList()));
    }

    public DynamicObject queryOneConfig(long userId, long ruleId, String teamStaType, String applyLayout, String scene) {
        scene = "1".equals(scene) ? "1" : "2";
        String join = String.join((CharSequence)",", "sourcejsonstr", "user", "persumconfig", "modifytime", "mobilescheme", "mobilerule");
        return this.queryOne(join, new QFilter[]{new QFilter("user", "=", (Object)userId), new QFilter("mobilerule", "=", (Object)ruleId), new QFilter("homepagetype", "=", (Object)"2"), new QFilter("teamstatype", "=", (Object)teamStaType), new QFilter("applylayout", "=", (Object)applyLayout), new QFilter("scene", "=", (Object)scene)});
    }

    private static class SummaryConfigDetailServiceHelper {
        private static final SummaryTeamConfigDetailService SUM_CONF_DETAIL = new SummaryTeamConfigDetailService();

        private SummaryConfigDetailServiceHelper() {
        }
    }
}

