/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.common.enums;

import kd.wtc.wtbs.common.enums.BillTypeConstants;

public enum BillTypeInfoEnum {
    VACATIONBILL(BillTypeConstants.VOCATION_ID, "va", "wtabm_vaapplyself", "wtabm_vaapply"),
    EVECTIONBILL(BillTypeConstants.TRAVEL_ID, "tp", "wtam_busitripselfbill", "wtam_busitripbill"),
    OVERTIMEBILL(BillTypeConstants.OVERTIME_ID, "ot", "wtom_otbillself", "wtom_overtimeapplybill"),
    SUPPLEMENTBILL(BillTypeConstants.SUPPLY_SIGN_ID, "ad", "wtpm_supsignself", "wtpm_supsignpc");

    private long billTypeId;
    private String billTypeTag;
    private String selfForm;
    private String otherForm;

    private BillTypeInfoEnum(long billTypeId, String billTypeTag, String selfForm, String otherForm) {
        this.billTypeId = billTypeId;
        this.billTypeTag = billTypeTag;
        this.selfForm = selfForm;
        this.otherForm = otherForm;
    }

    public static BillTypeInfoEnum getByTag(String tag) {
        for (BillTypeInfoEnum value : BillTypeInfoEnum.values()) {
            if (!value.getBillTypeTag().equals(tag)) continue;
            return value;
        }
        return null;
    }

    public static BillTypeInfoEnum getByTypeId(long billTypeId) {
        for (BillTypeInfoEnum value : BillTypeInfoEnum.values()) {
            if (value.getBillTypeId() != billTypeId) continue;
            return value;
        }
        return null;
    }

    public long getBillTypeId() {
        return this.billTypeId;
    }

    public String getBillTypeTag() {
        return this.billTypeTag;
    }

    public String getSelfForm() {
        return this.selfForm;
    }

    public String getOtherForm() {
        return this.otherForm;
    }
}

