/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.common.utils;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.mulentities.QuerySelectField;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class AttRecordFilterGridUtils {
    public static final Map<String, String> FIELDNAME_ATTRECORD_MAP = Maps.newLinkedHashMapWithExpectedSize((int)14);
    public static final Map<String, String> FIELDNAME_ATTRECORDSUM_MAP = Maps.newLinkedHashMapWithExpectedSize((int)14);

    public static void formatFilterGrid(Control filtergridap, String formId) {
        FilterGrid filterGrid = (FilterGrid)filtergridap;
        Map<String, String> fieldMap = AttRecordFilterGridUtils.buildNameMap(formId);
        List fieldColumns = filterGrid.getFilterColumns();
        Iterator iterator = fieldColumns.iterator();
        Map<String, Integer> sortIndexMap = AttRecordFilterGridUtils.getSortIndexMap(fieldMap);
        while (iterator.hasNext()) {
            Map map = (Map)iterator.next();
            String fieldName = (String)map.get("fieldName");
            if (WTCStringUtils.isNotEmpty((String)fieldMap.get(fieldName))) {
                map.put("fieldCaption", fieldMap.get(fieldName));
                map.put("sort", sortIndexMap.get(fieldName));
                continue;
            }
            iterator.remove();
        }
        fieldColumns.sort(Comparator.comparingInt(field -> (Integer)field.get("sort")));
    }

    private static Map<String, Integer> getSortIndexMap(Map<String, String> fieldMap) {
        HashMap sortIndexMap = Maps.newHashMapWithExpectedSize((int)fieldMap.size());
        int index = 0;
        for (Map.Entry<String, String> entry : fieldMap.entrySet()) {
            sortIndexMap.put(entry.getKey(), index++);
        }
        return sortIndexMap;
    }

    private static Map<String, String> buildNameMap(String formId) {
        if ("wtte_recordreport".equals(formId)) {
            return FIELDNAME_ATTRECORD_MAP;
        }
        if ("wtte_recordsumreport".equals(formId)) {
            return FIELDNAME_ATTRECORDSUM_MAP;
        }
        if ("wtte_dailydetailslist".equals(formId)) {
            return FIELDNAME_ATTRECORD_MAP;
        }
        if ("wtte_attperiodtotallist".equals(formId)) {
            return FIELDNAME_ATTRECORDSUM_MAP;
        }
        return Collections.emptyMap();
    }

    public static void initFilterCondition(String queryEntityNumber, Control filtergridap, String entityNumber) {
        FilterGrid filterGrid = (FilterGrid)filtergridap;
        filterGrid.setEntityNumber(entityNumber);
        QueryEntityType queryEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)queryEntityNumber);
        List fields = queryEntityType.getSelectFields();
        List fieldList = fields.stream().map(QuerySelectField::getAlias).collect(Collectors.toList());
        filterGrid.setFilterFieldKeys(fieldList);
    }

    static {
        FIELDNAME_ATTRECORD_MAP.put("attfilevid.dependency.name", ResManager.loadKDString((String)"\u56fd\u5bb6/\u5730\u533a", (String)"AttRecordFilterGridUtils_0", (String)"wtc-wtte-common", (Object[])new Object[0]));
        FIELDNAME_ATTRECORD_MAP.put("attfilevid.dependencytype.name", ResManager.loadKDString((String)"\u5c5e\u5730\u5458\u5de5\u7c7b\u522b", (String)"AttRecordFilterGridUtils_1", (String)"wtc-wtte-common", (Object[])new Object[0]));
        FIELDNAME_ATTRECORD_MAP.put("attfilevid.agreedlocation.name", ResManager.loadKDString((String)"\u534f\u8bae\u5de5\u4f5c\u5730", (String)"AttRecordFilterGridUtils_2", (String)"wtc-wtte-common", (Object[])new Object[0]));
        FIELDNAME_ATTRECORD_MAP.put("attfilevid.workplace.name", ResManager.loadKDString((String)"\u8003\u52e4\u5730\u70b9", (String)"AttRecordFilterGridUtils_3", (String)"wtc-wtte-common", (Object[])new Object[0]));
        FIELDNAME_ATTRECORD_MAP.put("attfilevid.position.name", ResManager.loadKDString((String)"\u5c97\u4f4d", (String)"AttRecordFilterGridUtils_4", (String)"wtc-wtte-common", (Object[])new Object[0]));
        FIELDNAME_ATTRECORD_MAP.put("attfilevid.job.name", ResManager.loadKDString((String)"\u804c\u4f4d", (String)"AttRecordFilterGridUtils_7", (String)"wtc-wtte-common", (Object[])new Object[0]));
        FIELDNAME_ATTRECORD_MAP.put("mode", ResManager.loadKDString((String)"\u8003\u52e4\u65b9\u5f0f", (String)"AttRecordFilterGridUtils_5", (String)"wtc-wtte-common", (Object[])new Object[0]));
        FIELDNAME_ATTRECORD_MAP.put("shiftid.name", ResManager.loadKDString((String)"\u73ed\u6b21", (String)"AttRecordFilterGridUtils_6", (String)"wtc-wtte-common", (Object[])new Object[0]));
        FIELDNAME_ATTRECORD_MAP.put("reckoner.name", ResManager.loadKDString((String)"\u64cd\u4f5c\u4eba", (String)"AttRecordFilterGridUtils_12", (String)"wtc-wtte-common", (Object[])new Object[0]));
        FIELDNAME_ATTRECORD_MAP.put("calculatedate", ResManager.loadKDString((String)"\u64cd\u4f5c\u65f6\u95f4", (String)"AttRecordFilterGridUtils_13", (String)"wtc-wtte-common", (Object[])new Object[0]));
        FIELDNAME_ATTRECORDSUM_MAP.put("attfilevid.dependency.name", ResManager.loadKDString((String)"\u56fd\u5bb6/\u5730\u533a", (String)"AttRecordFilterGridUtils_0", (String)"wtc-wtte-common", (Object[])new Object[0]));
        FIELDNAME_ATTRECORDSUM_MAP.put("attfilevid.dependencytype.name", ResManager.loadKDString((String)"\u5c5e\u5730\u5458\u5de5\u7c7b\u522b", (String)"AttRecordFilterGridUtils_1", (String)"wtc-wtte-common", (Object[])new Object[0]));
        FIELDNAME_ATTRECORDSUM_MAP.put("attfilevid.agreedlocation.name", ResManager.loadKDString((String)"\u534f\u8bae\u5de5\u4f5c\u5730", (String)"AttRecordFilterGridUtils_2", (String)"wtc-wtte-common", (Object[])new Object[0]));
        FIELDNAME_ATTRECORDSUM_MAP.put("attfilevid.workplace.name", ResManager.loadKDString((String)"\u8003\u52e4\u5730\u70b9", (String)"AttRecordFilterGridUtils_3", (String)"wtc-wtte-common", (Object[])new Object[0]));
        FIELDNAME_ATTRECORDSUM_MAP.put("attfilevid.position.name", ResManager.loadKDString((String)"\u5c97\u4f4d", (String)"AttRecordFilterGridUtils_4", (String)"wtc-wtte-common", (Object[])new Object[0]));
        FIELDNAME_ATTRECORDSUM_MAP.put("attfilevid.job.name", ResManager.loadKDString((String)"\u804c\u4f4d", (String)"AttRecordFilterGridUtils_7", (String)"wtc-wtte-common", (Object[])new Object[0]));
        FIELDNAME_ATTRECORDSUM_MAP.put("reckoner.name", ResManager.loadKDString((String)"\u64cd\u4f5c\u4eba", (String)"AttRecordFilterGridUtils_12", (String)"wtc-wtte-common", (Object[])new Object[0]));
        FIELDNAME_ATTRECORDSUM_MAP.put("calculatedate", ResManager.loadKDString((String)"\u64cd\u4f5c\u65f6\u95f4", (String)"AttRecordFilterGridUtils_13", (String)"wtc-wtte-common", (Object[])new Object[0]));
    }
}

