/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.report;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ColumnStyle;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.sdk.wtc.wtte.business.attrecord.report.AttRecordRptExtPlugin;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.common.util.SystemParamQueryUtil;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtte.business.attreport.AttReportService;
import kd.wtc.wtte.business.viewcalsteps.AttRecordService;
import kd.wtc.wtte.common.enums.attsettle.LockStatusEnum;
import kd.wtc.wtte.common.enums.attsettle.StorageStatusEnum;

public class AttReportPlugin
extends AbstractReportListDataPlugin {
    protected Map<String, String> attItemMap;
    protected Map<String, Integer> attItemTypeMap;
    protected LinkedList<String> selectCol = new LinkedList();
    protected Map<String, String> sortColMap;
    Set<String> settleInfos;

    protected void initQfilter(ReportQueryParam queryParam) {
        Map columnMap = AttReportService.getAttItemAndColumnMap((ReportQueryParam)queryParam);
        this.attItemMap = (Map)columnMap.get("attiem");
        this.attItemTypeMap = AttReportService.queryAttItemTypeMap(this.attItemMap);
        this.selectCol = new LinkedList(((Map)columnMap.get("normal")).keySet());
        this.selectCol.addAll(((Map)columnMap.get("sort")).keySet());
        LinkedList tempSelectCol = new LinkedList();
        this.settleInfos = new HashSet<String>();
        this.selectCol.forEach(str -> {
            if (str.startsWith("settleinfo")) {
                int index = str.indexOf(46);
                if (index >= 0) {
                    this.settleInfos.add(str.substring(index + 1));
                }
            } else {
                tempSelectCol.add(str);
            }
        });
        this.selectCol = tempSelectCol;
        this.sortColMap = (Map)columnMap.get("sorttype");
    }

    public ReportColumn createRptColumn(LocaleString caption, String fieldVal, String fieldType, boolean isHyperlink, Map<String, Integer> typeMap) {
        ReportColumn reportColumn = new ReportColumn();
        ColumnStyle style = new ColumnStyle();
        style.setTextAlign("center");
        reportColumn.setStyle(style);
        reportColumn.setCaption(caption);
        reportColumn.setFieldKey(fieldVal);
        switch (fieldType) {
            case "amount": {
                reportColumn.setFieldType("amount");
                reportColumn.setZeroShow(true);
                break;
            }
            case "decimal": {
                reportColumn.setFieldType("decimal");
                reportColumn.setZeroShow(true);
                if (typeMap.get(fieldVal) == null) break;
                reportColumn.setScale(typeMap.get(fieldVal).intValue());
                break;
            }
            case "integer": {
                reportColumn.setFieldType("integer");
                reportColumn.setZeroShow(true);
                break;
            }
            case "date": {
                reportColumn.setFieldType("date");
                if (!"calculatedate".equals(fieldVal)) break;
                reportColumn.setFieldType("text");
                break;
            }
            case "checkbox": {
                reportColumn.setFieldType("checkbox");
                break;
            }
            default: {
                reportColumn.setFieldType("text");
            }
        }
        reportColumn.setHideSingleColumnRow(false);
        reportColumn.setWidth(new LocaleString("200px"));
        reportColumn.setHyperlink(isHyperlink);
        return reportColumn;
    }

    public String apendSqlForLock(String str) {
        LockStatusEnum locked = LockStatusEnum.LOCKED;
        LockStatusEnum unlock = LockStatusEnum.UNLOCK;
        LockStatusEnum lockPart = LockStatusEnum.LOCK_PART;
        return " CASE WHEN " + str + " IS NOT NULL AND " + str + " = '" + locked.getLockStatusCode() + "'  THEN '" + locked.getMsg().loadKDString() + "' WHEN " + str + " IS NOT NULL AND " + str + " = '" + unlock.getLockStatusCode() + "' THEN '" + unlock.getMsg().loadKDString() + "' ELSE '" + lockPart.getMsg().loadKDString() + "' END AS " + str;
    }

    public String apendSqlForStorage(String str) {
        StorageStatusEnum unStorage = StorageStatusEnum.UN_STORAGE;
        StorageStatusEnum storage = StorageStatusEnum.STORAGE;
        return " CASE WHEN " + str + " IS NOT NULL AND " + str + " = '" + unStorage.getStorageStatusCode() + "'  THEN '" + unStorage.getMsg().loadKDString() + "' WHEN " + str + " IS NOT NULL AND " + str + " = '" + storage.getStorageStatusCode() + "' THEN '" + storage.getMsg().loadKDString() + "' END AS " + str;
    }

    public String getRowMetaStr(DataSet dataSet) {
        return dataSet.getRowMeta().toString().replace("RowMeta[", "").replace("]", "").replace(" ", "");
    }

    public DataSet query(ReportQueryParam reportQueryParam, Object obj) {
        return null;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List reportColumns = super.getColumns(columns);
        this.columns(reportColumns);
        return reportColumns;
    }

    protected void columns(List<AbstractReportColumn> reportColumns) {
        LinkedHashMap displayMap = (LinkedHashMap)this.getQueryParam().getCustomParam();
        reportColumns.clear();
        for (Map.Entry mapEntry : displayMap.entrySet()) {
            Map map = (Map)mapEntry.getValue();
            if ("sorttype".equals(map.get("fieldSourceType"))) continue;
            String key = String.valueOf(map.get("number"));
            String fieldType = String.valueOf(map.get("fieldtype"));
            boolean isHyperlink = Boolean.parseBoolean(String.valueOf(map.get("ishyperlink")));
            boolean freeze = Boolean.parseBoolean(String.valueOf(map.get("freeze")));
            boolean isHide = Boolean.parseBoolean(String.valueOf(map.get("isHide")));
            String fieldSourceType = String.valueOf(map.get("fieldSourceType"));
            if ("attmain.personid.name".equals(key)) {
                this.genAttPersonNameColumns(reportColumns, map, key, fieldType, freeze, isHide);
                continue;
            }
            String name = String.valueOf(map.get("name"));
            String number = String.valueOf(map.get("number"));
            ReportColumn column = "attiem".equals(fieldSourceType) ? this.createRptColumn(new LocaleString(name), number, fieldType, isHyperlink, this.attItemTypeMap) : this.createRptColumn(new LocaleString(String.valueOf(map.get("name"))), key, fieldType, isHyperlink, this.attItemTypeMap);
            column.setFreeze(freeze);
            column.setHide(isHide);
            reportColumns.add((AbstractReportColumn)column);
        }
    }

    private void genAttPersonNameColumns(List<AbstractReportColumn> reportColumns, Map<String, Object> map, String key, String fieldType, boolean freeze, boolean isHide) {
        ReportColumnGroup reportColumnGroup = null;
        if (!reportColumns.isEmpty() && reportColumns.get(0) instanceof ReportColumnGroup) {
            reportColumnGroup = (ReportColumnGroup)reportColumns.get(0);
        }
        if (reportColumnGroup == null) {
            ReportColumn column = this.createRptColumn(new LocaleString(String.valueOf(map.get("name"))), key, fieldType, true, this.attItemTypeMap);
            column.setFreeze(freeze);
            column.setHide(isHide);
            reportColumns.add((AbstractReportColumn)column);
        } else {
            List children = reportColumnGroup.getChildren();
            if (Boolean.FALSE.equals(SystemParamQueryUtil.isFrozenOpen())) {
                children.remove(1);
            } else {
                ((ReportColumn)children.get(1)).setFreeze(freeze);
            }
            ReportColumn reportColumn = (ReportColumn)children.get(0);
            reportColumn.setHyperlink(true);
            reportColumn.setFreeze(freeze);
            reportColumn.setCaption(new LocaleString(String.valueOf(map.get("name"))));
            reportColumns.add((AbstractReportColumn)reportColumnGroup);
        }
    }

    protected DataSet sortData(DataSet dataSet) {
        ArrayList<String> sortList = new ArrayList<String>(this.sortColMap.size());
        for (Map.Entry<String, String> mapEntry : this.sortColMap.entrySet()) {
            String key = mapEntry.getKey();
            String value = mapEntry.getValue();
            String sortType = "";
            if ("0".equals(value)) {
                sortType = "asc";
            } else if ("1".equals(value)) {
                sortType = "desc";
            }
            sortList.add(WTCStringUtils.joinStr((String[])new String[]{key, " ", sortType}));
        }
        return dataSet.orderBy(sortList.toArray(new String[0]));
    }

    protected String getSort(String defaultSort) {
        StringBuilder sortBuffer = new StringBuilder();
        if (WTCCollections.isNotEmpty(this.sortColMap)) {
            Set<Map.Entry<String, String>> entries = this.sortColMap.entrySet();
            for (Map.Entry<String, String> next : entries) {
                sortBuffer.append(next.getKey());
                sortBuffer.append(WTCStringUtils.equals((String)"0", (String)next.getValue()) ? " asc" : " desc");
                sortBuffer.append(" ,");
            }
        }
        if (WTCStringUtils.isEmpty((String)sortBuffer.toString())) {
            sortBuffer.append(defaultSort);
        } else {
            sortBuffer.deleteCharAt(sortBuffer.length() - 1);
        }
        String defSort = sortBuffer.toString();
        return this.getSortExt(defSort);
    }

    private String getBaseSortExt(String defSort) {
        String extBaseSort;
        String defBaseSort = defSort;
        WTCPluginProxy<? extends AttRecordRptExtPlugin> extPlugin = this.getExtPlugin();
        if (CollectionUtils.isNotEmpty((Collection)extPlugin.getPlugins()) && StringUtils.isNotEmpty((String)(extBaseSort = AttRecordService.getExtBaseSort(extPlugin, (String)defBaseSort)))) {
            defBaseSort = extBaseSort;
        }
        return defBaseSort;
    }

    protected WTCPluginProxy<? extends AttRecordRptExtPlugin> getExtPlugin() {
        return null;
    }

    private String getSortExt(String defSort) {
        String baseSort = this.getBaseSortExt(defSort);
        if (StringUtils.isEmpty((String)baseSort)) {
            return defSort;
        }
        return baseSort;
    }

    protected void addSortSelect() {
        String sort = this.getSort("");
        if (WTCStringUtils.isNotEmpty((String)sort)) {
            String[] split;
            for (String orderSelect : split = sort.replace("asc", "").replace("desc", "").split(",")) {
                String file = WTCStringUtils.trim((String)orderSelect);
                if (this.selectCol.contains(file)) continue;
                this.selectCol.add(orderSelect);
            }
        }
    }
}

