/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.report.attrecord;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.events.FormatShowFilterEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.auth.HRAuthService;
import kd.wtc.wtbs.business.util.attfilef7.AttFileF7Utils;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.business.web.mservice.HRCSMServiceImpl;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtp.business.attfile.AttFileHelper;
import kd.wtc.wtte.business.attrecord.AttReportComUtil;
import kd.wtc.wtte.business.viewcalsteps.AttRecordService;
import kd.wtc.wtte.business.viewcalsteps.AttRecordUtils;
import kd.wtc.wtte.common.constants.IAttRecordReportConstants;
import kd.wtc.wtte.common.utils.AttRecordFilterGridUtils;

public class AttRecordNewRFPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener,
IAttRecordReportConstants,
BeforeF7SelectListener,
RowClickEventListener {
    public void preOpenForm(PreOpenFormEventArgs evt) {
        super.preOpenForm(evt);
        FormShowParameter parameter = evt.getFormShowParameter();
        if ("wtte_recordreport".equals(parameter.getFormId())) {
            parameter.setCaption(ResManager.loadKDString((String)"\u8003\u52e4\u8bb0\u5f55-\u660e\u7ec6\u9879\u76ee", (String)"AttRecordRFPlugin_0", (String)"wtc-wtte-report", (Object[])new Object[0]));
        } else if ("wtte_recordsumreport".equals(parameter.getFormId())) {
            parameter.setCaption(ResManager.loadKDString((String)"\u8003\u52e4\u8bb0\u5f55-\u6c47\u603b\u9879\u76ee", (String)"AttRecordRFPlugin_1", (String)"wtc-wtte-report", (Object[])new Object[0]));
        }
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        ReportList reportListAp = (ReportList)this.getView().getControl("reportlistap");
        reportListAp.addHyperClickListener((HyperLinkClickListener)this);
        reportListAp.addRowClickListener((RowClickEventListener)this);
        this.addListen("con_adminorg");
        this.addListen("con_affiliateadminorg");
        this.addListen("con_attperson");
        this.addListen("con_empgroup");
        this.addListen("con_org");
        this.addListen("con_attperiod");
        this.addListen("con_attitem");
    }

    private void addListen(String controlKey) {
        BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl(controlKey);
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void entryRowClick(RowClickEvent evt) {
        DynamicObject rowData = ((ReportList)evt.getSource()).getReportModel().getRowData(evt.getRow());
        if (rowData != null) {
            AttRecordService.cacheCurrentData((IFormView)this.getView(), (DynamicObject)rowData);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String name = event.getProperty().getName();
        if ("con_attperson".equals(name)) {
            QFilter authQFilter = this.getF7ViewAuthQFilter("attfilevid");
            if (authQFilter != null) {
                event.addCustomQFilter(authQFilter);
            }
            ListShowParameter listShowParameter = (ListShowParameter)event.getFormShowParameter();
            this.setAuthAttFileTree(listShowParameter);
        } else if ("con_adminorg".equals(name)) {
            String entityNum = null;
            if ("wtte_recordreport".equals(this.getView().getFormShowParameter().getFormId())) {
                entityNum = "wtdtd_attrecordbase";
            } else if ("wtte_recordsumreport".equals(this.getView().getFormShowParameter().getFormId())) {
                entityNum = "wtctd_atttotalbase";
            }
            this.getView().getFormShowParameter().setCustomParam("customHREntityNumber", (Object)entityNum);
            this.getView().getFormShowParameter().setCustomParam("customHRPermItemId", (Object)"47150e89000000ac");
            this.getView().getFormShowParameter().setCustomParam("custom_parent_f7_prop", (Object)"attfilevid.adminorg");
            this.getView().cacheFormShowParameter();
            String appId = this.getView().getFormShowParameter().getAppId();
            QFilter dataRuleForBdProp = HRCSMServiceImpl.getInstance().getDataRuleForBdProp(Long.valueOf(UserServiceHelper.getCurrentUserId()), appId, entityNum, "attfilevid.adminorg.id", "47150e89000000ac", null);
            if (dataRuleForBdProp != null) {
                event.addCustomQFilter(dataRuleForBdProp);
            }
        } else if ("con_affiliateadminorg".equals(name)) {
            String entityNum = null;
            if ("wtte_recordreport".equals(this.getView().getFormShowParameter().getFormId())) {
                entityNum = "wtdtd_attrecordbase";
            } else if ("wtte_recordsumreport".equals(this.getView().getFormShowParameter().getFormId())) {
                entityNum = "wtctd_atttotalbase";
            }
            this.getView().getFormShowParameter().setCustomParam("customHREntityNumber", (Object)entityNum);
            this.getView().getFormShowParameter().setCustomParam("customHRPermItemId", (Object)"47150e89000000ac");
            this.getView().getFormShowParameter().setCustomParam("custom_parent_f7_prop", (Object)"attfilevid.affiliateadminorg");
            this.getView().cacheFormShowParameter();
            String appId = this.getView().getFormShowParameter().getAppId();
            QFilter dataRuleForBdProp = HRCSMServiceImpl.getInstance().getDataRuleForBdProp(Long.valueOf(UserServiceHelper.getCurrentUserId()), appId, entityNum, "attfilevid.affiliateadminorg.id", "47150e89000000ac", null);
            if (dataRuleForBdProp != null) {
                event.addCustomQFilter(dataRuleForBdProp);
            }
        } else if ("con_empgroup".equals(name)) {
            QFilter authQFilter = this.getF7ViewAuthQFilter("attfilevid.empgroup.number");
            if (authQFilter != null) {
                event.addCustomQFilter(authQFilter);
            }
            event.addCustomQFilter(new QFilter("bussinessfield", "in", (Object)AttFileHelper.getAuthEmpGroupType()));
        } else if ("con_org".equals(name)) {
            QFilter authQFilter = this.getOrgQFilter();
            if (authQFilter != null) {
                event.addCustomQFilter(authQFilter);
            }
        } else if ("con_attperiod".equals(name)) {
            DynamicObject orgDy = this.getModel().getDataEntity().getDynamicObject("con_org");
            if (!AttRecordUtils.checkOrg((DynamicObject)orgDy, (IFormView)this.getView())) {
                event.setCancel(true);
                return;
            }
            event.getFormShowParameter().setCustomParam("useorg", orgDy.get("id"));
        } else if ("con_attitem".equals(name)) {
            QFilter itemType = null;
            if ("wtte_recordreport".equals(this.getView().getFormShowParameter().getFormId())) {
                itemType = new QFilter("itemtype", "in", Arrays.asList("1", "2"));
            } else if ("wtte_recordsumreport".equals(this.getView().getFormShowParameter().getFormId())) {
                itemType = new QFilter("itemtype", "in", Arrays.asList("2", "3"));
            }
            if (null != itemType) {
                event.getCustomQFilters().add(itemType);
            }
        }
    }

    private QFilter getOrgQFilter() {
        if ("wtte_recordreport".equals(this.getView().getFormShowParameter().getFormId())) {
            return HRAuthService.getInstance().getAllPermOrgs("wtte", "wtdtd_attrecordbase", "id");
        }
        if ("wtte_recordsumreport".equals(this.getView().getFormShowParameter().getFormId())) {
            return HRAuthService.getInstance().getAllPermOrgs("wtte", "wtctd_atttotalbase", "id");
        }
        return null;
    }

    private QFilter getF7ViewAuthQFilter(String propKey) {
        if ("wtte_recordreport".equals(this.getView().getFormShowParameter().getFormId())) {
            return AttReportComUtil.getAttRecordF7ViewAuthQFilter((String)propKey);
        }
        if ("wtte_recordsumreport".equals(this.getView().getFormShowParameter().getFormId())) {
            return AttReportComUtil.getAttRecordTotalF7ViewAuthQFilter((String)propKey);
        }
        return null;
    }

    private void setAuthAttFileTree(ListShowParameter listShowParameter) {
        listShowParameter.setCustomParam("orgAppId", (Object)"wtte");
        if ("wtte_recordreport".equals(this.getView().getFormShowParameter().getFormId())) {
            listShowParameter.setCustomParam("orgEntityId", (Object)"wtdtd_attrecordbase");
            AttFileQueryServiceImpl.getInstance().setFileF7OrgPerm((FormShowParameter)listShowParameter, "wtdtd_attrecordbase", "wtte");
        } else if ("wtte_recordsumreport".equals(this.getView().getFormShowParameter().getFormId())) {
            listShowParameter.setCustomParam("orgEntityId", (Object)"wtctd_atttotalbase");
            AttFileQueryServiceImpl.getInstance().setFileF7OrgPerm((FormShowParameter)listShowParameter, "wtctd_atttotalbase", "wtte");
        }
        listShowParameter.setCustomParam("orgField", (Object)"attfilevid.affiliateadminorg");
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("con_attperson".equals(actionId)) {
            AttFileF7Utils.dealCallbackSetSelectRows((IDataModel)this.getModel(), (Object)closedCallBackEvent.getReturnData(), (String)"con_attperson");
        }
    }

    public void formatDisplayFilterField(FormatShowFilterEvent evt) {
        super.formatDisplayFilterField(evt);
        List filterItems = evt.getFilter().getFilterItems();
        for (FilterItemInfo filterItem : filterItems) {
            Object value = filterItem.getValue();
            if (null == value || !(value instanceof BigDecimal)) continue;
            String str = ((BigDecimal)value).toPlainString();
            String stripTrailingZeros = ((BigDecimal)value).stripTrailingZeros().toPlainString();
            FieldEdit fieldEdit = (FieldEdit)this.getView().getControl(filterItem.getPropName());
            String displayName = fieldEdit.getProperty().getDisplayName().toString() + "\uff1a";
            String filterStr = evt.getFormatedFilterString().replace(displayName + str, displayName + stripTrailingZeros);
            evt.setFormatedFilterString(filterStr);
        }
    }

    public void initialize() {
        super.initialize();
        if (this.getPageCache().get("hasInitializeFlag") == null) {
            if ("wtte_recordreport".equals(this.getView().getFormShowParameter().getFormId())) {
                AttRecordFilterGridUtils.initFilterCondition((String)"wtte_attrecord_query", (Control)this.getControl("filtergridap"), (String)"wtte_attrecord_query");
            } else if ("wtte_recordsumreport".equals(this.getView().getFormShowParameter().getFormId())) {
                AttRecordFilterGridUtils.initFilterCondition((String)"wtte_attrecordsum_query", (Control)this.getControl("filtergridap"), (String)"wtte_attrecordsum_query");
            }
            this.getPageCache().put("hasInitializeFlag", "true");
        }
    }

    public void afterBindData(EventObject env) {
        super.afterBindData(env);
        AttRecordFilterGridUtils.formatFilterGrid((Control)this.getControl("filtergridap"), (String)this.getView().getFormShowParameter().getFormId());
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        AttRecordService.genShowPageByLinkClick((IFormPlugin)this, (HyperLinkClickEvent)event, (HRBaseServiceHelper)this.getHrBaseServiceHelper(), (IFormView)this.getView());
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            String operateKey = ((FormOperate)args.getSource()).getOperateKey();
            AttRecordService.genShowPageByOpareteColumn((String)operateKey, (IFormView)this.getView(), (HRBaseServiceHelper)this.getHrBaseServiceHelper());
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        boolean mustFlag;
        super.verifyQuery(queryParam);
        FilterInfo filterInfo = queryParam.getFilter();
        String formId = this.getView().getFormShowParameter().getFormId();
        if (!AttRecordUtils.checkOrg((DynamicObject)filterInfo.getDynamicObject("con_org"), (IFormView)this.getView())) {
            return false;
        }
        boolean bl = mustFlag = filterInfo.getDynamicObject("con_attperiod") == null && (filterInfo.getDate("con_begindate") == null || filterInfo.getDate("con_enddate") == null);
        if (mustFlag) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u8003\u52e4\u671f\u95f4\u201d\u548c\u201c\u5f52\u5c5e\u65e5\u671f\u201d\u81f3\u5c11\u586b\u4e00\u4e2a\u3002", (String)"AttRecordRFPlugin_3", (String)"wtc-wtte-report", (Object[])new Object[0]));
            return false;
        }
        String value = filterInfo.getString("con_value");
        if (WTCStringUtils.isNotEmpty((String)value) && "3".equals(value)) {
            String minValue = filterInfo.getString("con_minvalue");
            String maxValue = filterInfo.getString("con_maxvalue");
            if (WTCStringUtils.isNotEmpty((String)minValue) && WTCStringUtils.isNotEmpty((String)maxValue) && new BigDecimal(minValue).compareTo(new BigDecimal(maxValue)) > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u5927\u503c\u5e94\u5927\u4e8e\u6216\u7b49\u4e8e\u6700\u5c0f\u503c\u3002", (String)"AttRecordRFPlugin_4", (String)"wtc-wtte-report", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private HRBaseServiceHelper getHrBaseServiceHelper() {
        String formId = this.getView().getFormShowParameter().getFormId();
        HRBaseServiceHelper serviceHelper = null;
        if ("wtte_recordreport".equals(formId)) {
            serviceHelper = new HRBaseServiceHelper("wtdtd_attrecorddetail");
        } else if ("wtte_recordsumreport".equals(formId)) {
            serviceHelper = new HRBaseServiceHelper("wtctd_atttotaldetail");
        }
        return serviceHelper;
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        String name;
        super.propertyChanged(propertyChangedArgs);
        switch (name = propertyChangedArgs.getProperty().getName()) {
            case "con_org": {
                HashSet clearSet = Sets.newHashSetWithExpectedSize((int)16);
                clearSet.add("con_attperiod");
                AttRecordUtils.clearViewKey((Set)clearSet, (IDataModel)this.getModel());
                break;
            }
            case "con_begindate": {
                AttRecordUtils.checkQwndate((String)"con_begindate", (String)"con_enddate", (IFormView)this.getView(), (String)name);
                break;
            }
            case "con_enddate": {
                AttRecordUtils.checkQwndate((String)"con_begindate", (String)"con_enddate", (IFormView)this.getView(), (String)name);
                break;
            }
            case "con_value": {
                Object value = this.getModel().getValue("con_value");
                if ("3".equals(value)) break;
                AttRecordUtils.clearViewKey((Set)Sets.newHashSet((Object[])new String[]{"con_minvalue", "con_maxvalue"}), (IDataModel)this.getModel());
                break;
            }
        }
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        if ("wtte_recordsumreport".equals(this.getView().getFormShowParameter().getFormId())) {
            for (DynamicObject row : rowData) {
                BigDecimal valueLong = row.getBigDecimal("valuelong");
                int dataAccuracy = row.getInt("dataaccuracy");
                row.set("valuelong", (Object)valueLong.setScale(dataAccuracy, 5));
            }
        }
    }
}

