/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.report.attrecord.batchquery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.sdk.wtc.wtte.business.attrecord.report.AttRecordDailyItemRptExtPlugin;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtte.business.attreport.ReportListHelper;
import kd.wtc.wtte.business.viewcalsteps.AttRecordService;
import kd.wtc.wtte.report.attrecord.batchquery.Callable;

public class AttRecordListBatchQuery
implements Callable<DataSet> {
    private static final String SELECTS_DETAIL = "id,case when attitemtype = '0' then '1' when attitemtype = '1' then 'false' end attitemtype,valuestring,attmain attmain,attitemid.name attitemname,attitemid.number attitemnumber,attitemvid";
    private static final String SELECTS_BASE = "id attmain,personid personid,owndate owndate,datetype datetype ,shiftvid shiftvid,orgid orgid,departmentvid departmentvid,companyvid companyvid,positionvid positionvid,jobvid jobvid,mode mode,perattperiodid attperiod,calculatedate calculatedate,createtime createtime,reckoner reckoner,attfilevid attfilevid,attfilevid.personnum attpersonnumber,personid.number,attfileid attfileid,attfileid attfile,attfilevid.empgroup empgroup,affiliateadminorgvid affiliateadminorgvid,attfilevid.dependencytype dependencytype,managescopevid managescopevid,attfilevid.agreedlocation agreedworkplace,attfilevid.workplace workplace,attfilevid.dependency dependency";
    private List<QFilter> detailFilters;
    private ReportQueryParam reportQueryParam;
    private WTCPluginProxy<AttRecordDailyItemRptExtPlugin> extPlugin;

    public AttRecordListBatchQuery(ReportQueryParam reportQueryParam, WTCPluginProxy<AttRecordDailyItemRptExtPlugin> extPlugin) {
        this.detailFilters = AttRecordService.getDetailFilter((boolean)false, (ReportQueryParam)reportQueryParam, extPlugin);
        this.reportQueryParam = reportQueryParam;
        this.extPlugin = extPlugin;
    }

    @Override
    public DataSet call(QFilter qFilter) {
        DataSet dataSetBase = ReportListHelper.getInstance().queryDataSet("wtdtd_attrecordbase", SELECTS_BASE, new QFilter[]{qFilter}, null);
        Set ids = this.reportQueryParam.byBatchInfo().getCurrentBatchRows().stream().map(row -> row.getLong(0)).collect(Collectors.toSet());
        List<Object> detailFilter = new ArrayList<QFilter>(this.detailFilters);
        if (CollectionUtils.isNotEmpty((Collection)this.extPlugin.getPlugins())) {
            detailFilter = AttRecordService.getExtDetailQFilters(this.extPlugin, detailFilter, (ReportQueryParam)this.reportQueryParam);
        }
        detailFilter.add(new QFilter("attmain", "in", ids));
        DataSet dataSetDetail = ReportListHelper.getInstance().queryDataSet("wtdtd_attrecorddetail", SELECTS_DETAIL, detailFilter.toArray(new QFilter[0]), null);
        return this.joinDataSet(dataSetBase, dataSetDetail);
    }

    @Override
    public List<QFilter> getBatchQFilter(List<Row> currentBatchRows) {
        Set mainIds = currentBatchRows.stream().map(row -> row.getLong(0)).collect(Collectors.toSet());
        return Lists.newArrayList((Object[])new QFilter[]{new QFilter("id", "in", mainIds)});
    }
}

