/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.report.attrecord.batchquery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.sdk.wtc.wtte.business.attrecord.report.AttRecordPeriodItemRptExtPlugin;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtte.business.attreport.ReportListHelper;
import kd.wtc.wtte.business.viewcalsteps.AttRecordService;
import kd.wtc.wtte.report.attrecord.batchquery.Callable;

public class RecordSumListBatchQuery
implements Callable<DataSet> {
    private static final String SELECTS_DETAIL = "id, attmain attmain, perattperiodid,attitemvid, attitemvid.isorginattitem isorginattitem, perattperiodid attperiod,  valuelong, attitemid.dataaccuracy dataaccuracy,attitemvid.number attitemnumber";
    private static final String SELECTS_BASE = "id attmain, personid personid,orgid orgid,calculatedate calculatedate, positionvid positionvid,jobvid jobvid, companyvid companyvid, departmentvid departmentvid, perattperiodid attperiod,  attfilevid.empgroup empgroup,managescopevid managescopevid,affiliateadminorgvid affiliateadminorgvid,attfilevid.dependency dependency,attfilevid.dependencytype dependencytype,attfilevid.agreedlocation agreedworkplace,attfilevid.workplace workplace,perperiodbegindate perperiodbegindate,perperiodenddate perperiodenddate,attfilevid attfilevid,attfilevid.personnum attpersonnumber,attfileid attfileid,attfileid attfile,personid.number,attperattperiodid,reckoner reckoner";
    private List<QFilter> detailFilters;
    private ReportQueryParam reportQueryParam;
    private WTCPluginProxy<AttRecordPeriodItemRptExtPlugin> extPlugin;

    public RecordSumListBatchQuery(ReportQueryParam reportQueryParam, WTCPluginProxy<AttRecordPeriodItemRptExtPlugin> extPlugin) {
        this.detailFilters = AttRecordService.getDetailFilter((boolean)true, (ReportQueryParam)reportQueryParam, extPlugin);
        this.reportQueryParam = reportQueryParam;
        this.extPlugin = extPlugin;
    }

    @Override
    public DataSet call(QFilter qFilter) {
        Set ids = this.reportQueryParam.byBatchInfo().getCurrentBatchRows().stream().map(row -> row.getLong(0)).collect(Collectors.toSet());
        DataSet dataSetBase = ReportListHelper.getInstance().queryDataSet("wtctd_atttotalbase", SELECTS_BASE, new QFilter[]{new QFilter("id", "in", ids)}, null);
        List<Object> detailFilter = new ArrayList<QFilter>(this.detailFilters);
        if (CollectionUtils.isNotEmpty((Collection)this.extPlugin.getPlugins())) {
            detailFilter = AttRecordService.getExtDetailQFilters(this.extPlugin, detailFilter, (ReportQueryParam)this.reportQueryParam);
        }
        detailFilter.add(new QFilter("attmain", "in", ids));
        DataSet dataSetDetail = ReportListHelper.getInstance().queryDataSet("wtctd_atttotaldetail", SELECTS_DETAIL, detailFilter.toArray(new QFilter[0]), null);
        return this.joinDataSet(dataSetBase, dataSetDetail);
    }

    @Override
    public List<QFilter> getBatchQFilter(List<Row> currentBatchRows) {
        List mainIds = currentBatchRows.stream().map(row -> row.getLong(0)).collect(Collectors.toList());
        return Lists.newArrayList((Object[])new QFilter[]{new QFilter("id", "in", mainIds)});
    }
}

