/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.report.quota;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.auth.HRAuthService;
import kd.wtc.wtbs.business.auth.WTCBizDataPermissionServiceImpl;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.business.web.mservice.HRCSMServiceImpl;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCOrgUnitServiceHelper;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtp.business.attfile.AttFileHelper;
import kd.wtc.wtp.business.cumulate.trading.QTLineDetailDBService;
import kd.wtc.wtte.business.utils.QTViewHelper;
import kd.wtc.wtte.business.viewcalsteps.AttRecordUtils;

public class QTSummaryRFPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener,
BeforeF7SelectListener,
RowClickEventListener {
    private static final Map<String, String> FORMID_MAP = Maps.newHashMapWithExpectedSize((int)10);
    protected static final String KEY_REPORT = "reportlistap";

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        for (DynamicObject row : rowData) {
            BigDecimal pastValue = row.getBigDecimal("pastvalue");
            BigDecimal invalidValue = row.getBigDecimal("invalidvalue");
            pastValue = pastValue == null ? BigDecimal.ZERO : pastValue;
            invalidValue = invalidValue == null ? BigDecimal.ZERO : invalidValue;
            row.set("pastvalue", (Object)pastValue.add(invalidValue));
            BigDecimal cdValue = row.getBigDecimal("cdedvalue");
            BigDecimal settlementValue = row.getBigDecimal("settlementvalue");
            cdValue = cdValue == null ? BigDecimal.ZERO : cdValue;
            settlementValue = settlementValue == null ? BigDecimal.ZERO : settlementValue;
            row.set("cdedvalue", (Object)cdValue.add(settlementValue));
        }
    }

    public void registerListener(EventObject event) {
        ReportList reportList = (ReportList)this.getView().getControl(KEY_REPORT);
        reportList.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit conOrg = (BasedataEdit)this.getView().getControl("con_org");
        conOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit conMultOrg = (BasedataEdit)this.getView().getControl("con_multorg");
        conMultOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit attPerson = (BasedataEdit)this.getView().getControl("con_attperson");
        attPerson.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit admingOrg = (BasedataEdit)this.getView().getControl("con_adminorg");
        admingOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit affAdminOrg = (BasedataEdit)this.getView().getControl("con_affiliateadminorg");
        affAdminOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit empGroup = (BasedataEdit)this.getView().getControl("con_empgroup");
        empGroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit qtType = (BasedataEdit)this.getView().getControl("con_qttype");
        qtType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String fieldName;
        switch (fieldName = event.getFieldName()) {
            case "attfilebo": {
                DynamicObject row = event.getRowData();
                long attFileVid = row.getLong("attfilebo.id");
                QTViewHelper.genShowAttFilePage((IFormPlugin)this, (long)attFileVid, (IFormView)this.getView());
                return;
            }
            case "frozened": {
                break;
            }
            case "usablevalue": 
            case "freezevalue": {
                return;
            }
        }
        DynamicObject rowData = event.getRowData();
        this.viewQTDetail(rowData, fieldName);
    }

    private void viewQTDetail(DynamicObject rowData, String fieldName) {
        FormConfig formConfig;
        int compare;
        ReportQueryParam queryParam = this.getView().getQueryParam();
        HashMap params = Maps.newHashMapWithExpectedSize((int)3);
        List<QFilter> qFilterList = this.makeFilters(queryParam.getFilter(), params);
        if (rowData == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u3002", (String)"QTSummaryRFPlugin_1", (String)"wtc-wtte-report", (Object[])new Object[0]));
            return;
        }
        long attFileBoId = rowData.getLong("attfilebo.id");
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
        attFileQueryParam.setUsableStatus(WTCCollections.modifiableSet((Object[])new String[]{"-1"}));
        attFileQueryParam.setBeCurrent(Boolean.TRUE);
        attFileQueryParam.setAuthCheck(Boolean.FALSE);
        attFileQueryParam.setAttStatus(null);
        attFileQueryParam.setBoId(attFileBoId);
        List discardFile = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
        if (WTCCollections.isNotEmpty((Collection)discardFile)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u3002", (String)"QTSummaryRFPlugin_1", (String)"wtc-wtte-report", (Object[])new Object[0]));
            return;
        }
        long qtType = rowData.getLong("qtname.id");
        qFilterList.add(new QFilter("attfilebo", "=", (Object)attFileBoId));
        qFilterList.add(new QFilter("qttype", "=", (Object)qtType));
        List<Long> detailIds = this.getDetailIds(fieldName, qFilterList, params);
        BigDecimal fieldValue = rowData.getBigDecimal(fieldName);
        if ("pastvalue".equals(fieldName)) {
            fieldValue = fieldValue.add(rowData.getBigDecimal("invalidvalue"));
        }
        if ("cdedvalue".equals(fieldName)) {
            fieldValue = fieldValue.add(rowData.getBigDecimal("settlementvalue"));
        }
        if ((compare = fieldValue.compareTo(new BigDecimal(0))) == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b9a\u989d\u6838\u7b97\u672a\u751f\u6210\u6b64\u6570\u636e\uff0c\u65e0\u6cd5\u8df3\u8f6c\u3002", (String)"QTSummaryRFPlugin_0", (String)"wtc-wtte-report", (Object[])new Object[0]));
            return;
        }
        params.put("detailIds", detailIds);
        params.put("fieldName", fieldName);
        FormShowParameter formShowParameter = new FormShowParameter();
        String formId = this.getFormId(fieldName);
        formShowParameter.setFormId(formId);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setStatus(OperationStatus.VIEW);
        formShowParameter.setCustomParams((Map)params);
        if (HRStringUtils.isNotEmpty((String)formId) && (formConfig = FormMetadataCache.getFormConfig((String)formId)) != null) {
            formShowParameter.setCaption(formConfig.getCaption().getLocaleValue() + "-" + rowData.getString("attfilebo.name"));
        }
        formShowParameter.setPageId(this.getView().getPageId() + attFileBoId + qtType + fieldName);
        this.getView().showForm(formShowParameter);
    }

    private List<Long> getDetailIds(String fieldName, List<QFilter> qFilterList, Map<String, Object> params) {
        DynamicObject[] dynamicObjects = QTLineDetailDBService.lineDetailDao.query(fieldName + "id,genstartdate,genenddate,usestartdate,useenddate,periodcircleid,periodnum,qttype,attfileid,ownvalue,usedvalue,useodvalue,genvalueid,genvalueid.attitemvid,genvalueid.gentime,invalidvalueid,invalidvalueid.attitemvid,invalidvalueid.gentime,slementvalueid,slementvalueid.attitemvid,slementvalueid.gentime", qFilterList.toArray(new QFilter[0]));
        HashMap lineToDetailMap = Maps.newHashMapWithExpectedSize((int)dynamicObjects.length);
        ArrayList detailIdList = Lists.newArrayListWithExpectedSize((int)10);
        for (DynamicObject dynamicObject : dynamicObjects) {
            long id = dynamicObject.getLong(fieldName + "id.id");
            if (0L == id) {
                id = Long.MIN_VALUE;
            }
            lineToDetailMap.put(dynamicObject.getLong("id"), id);
            detailIdList.add(id);
            if ("pastvalue".equals(fieldName)) {
                long invalidValueId = dynamicObject.getLong("invalidvalueId.id");
                detailIdList.add(invalidValueId);
            }
            if (!"cdedvalue".equals(fieldName)) continue;
            long settlementValueId = dynamicObject.getLong("slementvalueid.id");
            detailIdList.add(settlementValueId);
        }
        params.put("lineToDetailMap", lineToDetailMap);
        return detailIdList;
    }

    private String getFormId(String fieldName) {
        return FORMID_MAP.get(fieldName);
    }

    private List<QFilter> makeFilters(FilterInfo filterInfo, Map<String, Object> params) {
        ArrayList qFilterList = Lists.newArrayListWithCapacity((int)3);
        List filterItems = filterInfo.getFilterItems();
        for (FilterItemInfo filterItem : filterItems) {
            String propName = filterItem.getPropName();
            Object value = this.typeCast(filterItem.getValue());
            if (value == null) continue;
            switch (propName) {
                case "con_useyear": {
                    qFilterList.add(new QFilter("usestartdate", "<=", (Object)WTCDateUtils.getEndDayOfYear((Date)((Date)value))));
                    qFilterList.add(new QFilter("useenddate", ">=", (Object)WTCDateUtils.getBeginDayOfYear((Date)((Date)value))));
                    params.put("year", value);
                    params.put("querytype", "2");
                    break;
                }
                case "con_genyear": {
                    qFilterList.add(new QFilter("genstartdate", "<=", (Object)WTCDateUtils.getEndDayOfYear((Date)((Date)value))));
                    qFilterList.add(new QFilter("genenddate", ">=", (Object)WTCDateUtils.getBeginDayOfYear((Date)((Date)value))));
                    params.put("year", value);
                    params.put("querytype", "1");
                    break;
                }
            }
        }
        qFilterList.add(new QFilter("busstatus", "=", (Object)"0"));
        qFilterList.add(new QFilter("initstatus", "=", (Object)"2"));
        return qFilterList;
    }

    private Object typeCast(Object value) {
        Object result = null;
        result = value instanceof String ? Long.valueOf(Long.parseLong((String)value)) : (value instanceof Long ? value : (value instanceof Date ? value : value));
        return result;
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        HasPermOrgResult allPermOrgs;
        String name = event.getProperty().getName();
        if ("con_attperson".equals(name)) {
            QFilter authQFilter = QTViewHelper.getF7ViewAuthQFilter((String)"attfileid");
            if (authQFilter != null) {
                event.addCustomQFilter(authQFilter);
            }
            ListShowParameter listShowParameter = (ListShowParameter)event.getFormShowParameter();
            QTViewHelper.setAuthAttFileTree((ListShowParameter)listShowParameter);
        } else if ("con_adminorg".equals(name)) {
            ListShowParameter listShowParameter = (ListShowParameter)event.getFormShowParameter();
            listShowParameter.setCustomParam("customHREntityNumber", (Object)"wtp_qtlinedetail");
            listShowParameter.setCustomParam("customHRPermItemId", (Object)"47150e89000000ac");
            listShowParameter.setCustomParam("custom_parent_f7_prop", (Object)"attfileid.adminorg");
            listShowParameter.setAppId("wtte");
            HRAuthService.getInstance().genPermOrgResultWithSubCache(listShowParameter, true, new PageCache(listShowParameter.getPageId()));
            QFilter dataRule = HRCSMServiceImpl.getInstance().getDataRuleForBdProp(Long.valueOf(RequestContext.get().getCurrUserId()), "wtte", "wtp_qtlinedetail", "attfileid.adminorg.id", "47150e89000000ac", new HashMap());
            if (dataRule != null) {
                event.addCustomQFilter(dataRule);
            }
        } else if ("con_affiliateadminorg".equals(name)) {
            ListShowParameter listShowParameter = (ListShowParameter)event.getFormShowParameter();
            listShowParameter.setCustomParam("customHREntityNumber", (Object)"wtp_qtlinedetail");
            listShowParameter.setCustomParam("customHRPermItemId", (Object)"47150e89000000ac");
            listShowParameter.setCustomParam("custom_parent_f7_prop", (Object)"attfileid.affiliateadminorg");
            listShowParameter.setAppId("wtte");
            HRAuthService.getInstance().genPermOrgResultWithSubCache(listShowParameter, true, new PageCache(listShowParameter.getPageId()));
            QFilter dataRule = HRCSMServiceImpl.getInstance().getDataRuleForBdProp(Long.valueOf(RequestContext.get().getCurrUserId()), "wtte", "wtp_qtlinedetail", "attfileid.affiliateadminorg.id", "47150e89000000ac", new HashMap());
            if (dataRule != null) {
                event.addCustomQFilter(dataRule);
            }
        } else if ("con_empgroup".equals(name)) {
            QFilter authQFilter = QTViewHelper.getF7ViewAuthQFilter((String)"attfileid.empgroup.number");
            if (authQFilter != null) {
                event.addCustomQFilter(authQFilter);
            }
            event.addCustomQFilter(new QFilter("bussinessfield", "in", (Object)AttFileHelper.getAuthEmpGroupType()));
        } else if ("con_qttype".equals(name)) {
            FormShowParameter formShowParameter = event.getFormShowParameter();
            ListShowParameter listShowParameter = (ListShowParameter)formShowParameter;
            long orgId = RequestContext.get().getOrgId() == 0L ? WTCOrgUnitServiceHelper.getHRDefaultRootOrgId() : RequestContext.get().getOrgId();
            listShowParameter.setUseOrgId(orgId);
        } else if ("con_org".equals(name)) {
            HasPermOrgResult allPermOrgs2 = WTCBizDataPermissionServiceImpl.getInstance().getAllPermOrgs("wtte", "wtp_qtlinedetail");
            if (!allPermOrgs2.hasAllOrgPerm()) {
                List hasPermOrgs = allPermOrgs2.getHasPermOrgs();
                QFilter orgFilter = new QFilter("id", "in", (Object)hasPermOrgs);
                event.addCustomQFilter(orgFilter);
            }
        } else if ("con_multorg".equals(name) && !(allPermOrgs = WTCBizDataPermissionServiceImpl.getInstance().getAllPermOrgs("wtte", "wtp_qtlinedetail")).hasAllOrgPerm()) {
            List hasPermOrgs = allPermOrgs.getHasPermOrgs();
            QFilter orgFilter = new QFilter("id", "in", (Object)hasPermOrgs);
            event.addCustomQFilter(orgFilter);
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        DynamicObjectCollection dynamicObjectCollection = filterInfo.getDynamicObjectCollection("con_multorg");
        DynamicObject dynamicObject = filterInfo.getDynamicObject("con_org");
        if (dynamicObjectCollection == null) {
            dynamicObjectCollection = new DynamicObjectCollection();
        }
        if (dynamicObject != null) {
            dynamicObjectCollection.add((Object)dynamicObject);
        }
        if (!AttRecordUtils.checkOrg((DynamicObjectCollection)dynamicObjectCollection, (IFormView)this.getView())) {
            return false;
        }
        if (filterInfo.getDate("con_useyear") == null && filterInfo.getDate("con_genyear") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u751f\u6210\u5e74\u4efd\u201d\u548c\u201c\u4f7f\u7528\u5e74\u4efd\u201d\u81f3\u5c111\u9879\u5fc5\u586b\u3002", (String)"QTSummaryRFListPlugin_0", (String)"wtc-wtte-report", (Object[])new Object[0]));
            return false;
        }
        if (filterInfo.getDate("con_useyear") != null && filterInfo.getDate("con_genyear") != null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u751f\u6210\u5e74\u4efd\u201d\u548c\u201c\u4f7f\u7528\u5e74\u4efd\u201d\u53ea\u80fd\u4fdd\u75591\u9879\u3002", (String)"QTSummaryRFListPlugin_1", (String)"wtc-wtte-report", (Object[])new Object[0]));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    static {
        FORMID_MAP.put("usablevalue", "wtte_usabledetail");
        FORMID_MAP.put("freezevalue", "wtte_freezedetail");
        FORMID_MAP.put("usedvalue", "wtte_useddetail");
        FORMID_MAP.put("useodvalue", "wtte_useoddetail");
        FORMID_MAP.put("pastvalue", "wtte_pastdetail");
        FORMID_MAP.put("cdedvalue", "wtte_cdeddetail");
        FORMID_MAP.put("ownvalue", "wtte_owndetail");
    }
}

