/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.business.abnormal;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.support.util.Assert;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.url.UrlService;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.personfilter.PersonFilterServiceImpl;
import kd.wtc.wtbs.business.plugin.PluginServiceHelper;
import kd.wtc.wtbs.business.servicehelper.WTCServiceHelper;
import kd.wtc.wtbs.business.web.mservice.HRPIMServiceImpl;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.lang.WTCException;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCSymbolMultiLanguageUtil;
import kd.wtc.wtbs.common.util.WTTESystemParamQueryUtil;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.tuple.Pair;
import kd.wtc.wtp.business.abnormalpush.IAbnormalPushDateRange;
import kd.wtc.wtte.business.abnormal.AbnormalPushInfo;
import kd.wtc.wtte.business.abnormal.ExPushRecipientService;
import kd.wtc.wtte.common.abnormal.ExRecipientInfo;
import kd.wtc.wtte.common.abnormal.ExRecipientRapidProcess;
import kd.wtc.wtte.common.abnormal.ExRecipientReq;

public class AbnormalPushService {
    private static final Log logger = LogFactory.getLog(AbnormalPushService.class);
    private static final ExecutorService EXECUTOR_SERVICE;
    private static final String WTC_WTTE_EX_PUSH_ENGINE_POOL_NAME = "WTC_WTTE_EX_PUSH_ENGINE_POOL_NAME";
    static final int DEFAULT_POOL_SIZE;
    static final int ENGINE_POOL_SIZE;
    private final AbnormalPushService COND_SERVICE = AbnormalPushService.getInstance();
    public static HRBaseServiceHelper ruleServiceHelper;
    public static HRBaseServiceHelper exRecordServiceHelper;
    public static HRBaseServiceHelper exPushRecordServiceHelper;
    public static HRBaseServiceHelper exPushBlockRecordServiceHelper;
    private final int MAX_NUMBER = WTCAppContextHelper.getProjectParams().getIntValue("kd.wtc.wtte.ex.exPushBatchSize", 50000);

    public static AbnormalPushService getInstance() {
        return Instance.INSTANCE;
    }

    public void manualPush(List<Long> exRecordIdList) {
        logger.info("AbnormalPushService.manualPush.exRecordIdList:{}", exRecordIdList);
        QFilter exRecordFilter = new QFilter("id", "in", exRecordIdList);
        DynamicObject[] abnormals = exRecordServiceHelper.loadDynamicObjectArray(exRecordFilter.toArray());
        QFilter sysPresetRuleFilter = new QFilter("issyspreset", "=", (Object)Boolean.TRUE);
        DynamicObject[] sysPresetRules = ruleServiceHelper.loadDynamicObjectArray(sysPresetRuleFilter.toArray());
        ArrayList<DynamicObject> ruleList = new ArrayList<DynamicObject>(10);
        Collections.addAll(ruleList, sysPresetRules);
        this.pushLogic(abnormals, ruleList, true, false, null, null);
    }

    public void pushLogic(DynamicObject[] abnormals, List<DynamicObject> ruleList, final boolean isManualPush, boolean isBlockRetry, DynamicObject blockRecord, Long scheduleId) {
        if (!isBlockRetry) {
            blockRecord = null;
        }
        Map<DynamicObject, Map<DynamicObject, List<DynamicObject>>> ruleSortMap = AbnormalPushService.getRuleSortMap(ruleList, abnormals, isManualPush, isBlockRetry, blockRecord);
        Map<DynamicObject, ExRecipientRapidProcess> exPushRecordMap = AbnormalPushService.generateExPushRecord(ruleSortMap, isManualPush, isBlockRetry, scheduleId);
        logger.info("AbnormalPushService.pushLogic exPushRecordList={}", (Object)exPushRecordMap.size());
        ArrayList<Map.Entry<DynamicObject, ExRecipientRapidProcess>> collect = new ArrayList<Map.Entry<DynamicObject, ExRecipientRapidProcess>>(exPushRecordMap.entrySet());
        List partition = Lists.partition(collect, (int)this.MAX_NUMBER);
        long[] ids = ID.genLongIds((int)collect.size());
        ArrayList idList = Lists.newArrayListWithExpectedSize((int)ids.length);
        for (long id : ids) {
            idList.add(id);
        }
        List partitionIds = Lists.partition((List)idList, (int)this.MAX_NUMBER);
        logger.info("AbnormalPushService.pushLogic batch={}", (Object)this.MAX_NUMBER);
        for (int i = 0; i < partition.size(); ++i) {
            final List subExPushRecordList = (List)partition.get(i);
            final List subIds = (List)partitionIds.get(i);
            EXECUTOR_SERVICE.execute(new Runnable(){

                @Override
                public void run() {
                    ArrayList pushRecordDyList = Lists.newArrayListWithExpectedSize((int)subExPushRecordList.size());
                    HashMap idAndRapProcess = Maps.newHashMapWithExpectedSize((int)subExPushRecordList.size());
                    for (int index = 0; index < subExPushRecordList.size(); ++index) {
                        Map.Entry dp = (Map.Entry)subExPushRecordList.get(index);
                        Long id = (Long)subIds.get(index);
                        DynamicObject dy = (DynamicObject)dp.getKey();
                        dy.set("id", (Object)id);
                        pushRecordDyList.add(dy);
                        idAndRapProcess.put(id, dp.getValue());
                    }
                    exPushRecordServiceHelper.save(pushRecordDyList.toArray(new DynamicObject[0]));
                    DynamicObject[] exPushRecords = exPushRecordServiceHelper.loadDynamicObjectArray(new QFilter("id", "in", idAndRapProcess.keySet()).toArray());
                    AbnormalPushService.sendMessage(exPushRecords, isManualPush, idAndRapProcess);
                }
            });
        }
    }

    public static Map<DynamicObject, Map<DynamicObject, List<DynamicObject>>> getRuleSortMap(List<DynamicObject> ruleList, DynamicObject[] abnormals, boolean isManualPush, boolean isBlockRetry, DynamicObject blockRecord) {
        HashMap<DynamicObject, Map<DynamicObject, List<DynamicObject>>> ruleSortMap = new HashMap<DynamicObject, Map<DynamicObject, List<DynamicObject>>>(16);
        HashSet<Long> personIdSet = new HashSet<Long>(16);
        for (DynamicObject abnormal : abnormals) {
            DynamicObject person = abnormal.getDynamicObject("personid");
            if (person == null) continue;
            personIdSet.add(person.getLong("id"));
        }
        logger.info("AbnormalPushService.getRuleSortMap.personIdSet:{}", personIdSet);
        for (DynamicObject rule : ruleList) {
            Map infoMap = PersonFilterServiceImpl.getInstance().getFilterInfo(Long.valueOf(rule.getLong("id")), "wtp_expushrule", personIdSet);
            Set attPersonIdSet = (Set)infoMap.get("attperson");
            Set attFileVIdSet = (Set)infoMap.get("attfile");
            Map attFileAndDateMap = (Map)infoMap.get("attfile_effdate");
            for (DynamicObject abnormal : abnormals) {
                DynamicObject attFileV;
                DynamicObject person;
                String confirmStatus = abnormal.getString("confirmstatus");
                if ("1".equals(confirmStatus) || (person = abnormal.getDynamicObject("personid")) == null || attPersonIdSet != null && !attPersonIdSet.contains(person.getLong("id")) || (attFileV = abnormal.getDynamicObject("attfilevid")) == null || attFileVIdSet != null && !attFileVIdSet.contains(attFileV.getLong("id"))) continue;
                if (attFileAndDateMap != null && !attFileAndDateMap.isEmpty()) {
                    Pair dateDatePair = (Pair)attFileAndDateMap.get(attFileV.getLong("id"));
                    Date recordDate = abnormal.getDate("recorddate");
                    if (dateDatePair == null || recordDate == null || recordDate.compareTo((Date)dateDatePair.getLeft()) < 0 || recordDate.compareTo((Date)dateDatePair.getRight()) > 0) continue;
                }
                if (!AbnormalPushService.isAccord(rule, abnormal, isManualPush, isBlockRetry, blockRecord)) continue;
                Map personSortMap = (Map)ruleSortMap.get(rule);
                if (personSortMap == null) {
                    HashMap newPersonSortMap = new HashMap(16);
                    ArrayList<DynamicObject> recordList = new ArrayList<DynamicObject>(10);
                    recordList.add(abnormal);
                    newPersonSortMap.put(abnormal.getDynamicObject("personid"), recordList);
                    ruleSortMap.put(rule, newPersonSortMap);
                    continue;
                }
                ArrayList<DynamicObject> recordList = personSortMap.get(abnormal.getDynamicObject("personid")) == null ? new ArrayList<DynamicObject>(10) : (List)personSortMap.get(abnormal.getDynamicObject("personid"));
                recordList.add(abnormal);
                personSortMap.put(abnormal.getDynamicObject("personid"), recordList);
                ruleSortMap.put(rule, personSortMap);
            }
        }
        return ruleSortMap;
    }

    public static boolean isAccord(DynamicObject rule, DynamicObject abnormal, boolean isManualPush, boolean isBlockRetry, DynamicObject blockRecord) {
        boolean isAttItemAccord = false;
        boolean isDateAccord = false;
        DynamicObject attItem = abnormal.getDynamicObject("attitemid");
        if (attItem != null) {
            DynamicObjectCollection messageContentEntity = rule.getDynamicObjectCollection("messetentity");
            for (DynamicObject entry : messageContentEntity) {
                if (entry.getLong("attenditem.boid") != attItem.getLong("boid")) continue;
                isAttItemAccord = true;
            }
        }
        if (isManualPush) {
            isDateAccord = true;
        } else if (isBlockRetry) {
            Date recordDate = abnormal.getDate("recorddate");
            String pushDataRange = blockRecord.getString("pushdatarange");
            if ("C".equals(pushDataRange)) {
                boolean includeSat = blockRecord.getBoolean("includesat");
                boolean includeSun = blockRecord.getBoolean("includesun");
                isDateAccord = AbnormalPushService.filterSatAndSunByBlockRange(recordDate, includeSat, includeSun);
            } else if ("D".equals(pushDataRange)) {
                DynamicObject dataRangeDy = blockRecord.getDynamicObject("datarange");
                if (dataRangeDy != null) {
                    DynamicObject attFile = AbnormalPushService.getPersonAttFile(abnormal.getDynamicObject("personid").getLong("id"));
                    isDateAccord = AbnormalPushService.isPluginDateAccord(rule, recordDate, attFile, dataRangeDy.getLong("id"));
                }
            } else {
                isDateAccord = true;
            }
        } else {
            String pushDataRange = rule.getString("pushdatarange");
            Date recordDate = abnormal.getDate("recorddate");
            if ("A".equals(pushDataRange)) {
                isDateAccord = AbnormalPushService.isMonthDateAccord(rule, isDateAccord, recordDate);
            } else if ("B".equals(pushDataRange)) {
                isDateAccord = AbnormalPushService.isWeekDateAccord(rule, isDateAccord, recordDate);
            } else if ("C".equals(pushDataRange)) {
                isDateAccord = AbnormalPushService.isDayDateAccord(rule, isDateAccord, recordDate);
            } else if ("D".equals(pushDataRange)) {
                DynamicObject attFile = AbnormalPushService.getPersonAttFile(abnormal.getDynamicObject("personid").getLong("id"));
                isDateAccord = AbnormalPushService.isPluginDateAccord(rule, recordDate, attFile, null);
            }
        }
        return isAttItemAccord && isDateAccord;
    }

    public static boolean isPluginDateAccord(DynamicObject rule, Date recordDate, DynamicObject attendance, Long pluginId) {
        if (pluginId == null || pluginId == 0L) {
            pluginId = rule.getLong("datarange.id");
        }
        IAbnormalPushDateRange abnormalPushDateRange = (IAbnormalPushDateRange)PluginServiceHelper.getPluginObject(IAbnormalPushDateRange.class, (Long)pluginId);
        List dateList = abnormalPushDateRange.getDateRange(attendance, rule);
        String recordDateStr = HRDateTimeUtils.format((Date)recordDate, (String)"yyyy-MM-dd");
        return null != dateList && dateList.contains(recordDateStr);
    }

    public static boolean isDayDateAccord(DynamicObject rule, boolean isDateAccord, Date recordDate) {
        Calendar startCalendar = Calendar.getInstance();
        Calendar endCalendar = Calendar.getInstance();
        int stepDays = rule.getInt("stepdays");
        boolean includeDay = rule.getBoolean("includeday");
        boolean includeSat = rule.getBoolean("includesat");
        boolean includeSun = rule.getBoolean("includesun");
        Calendar recordDateCalendar = Calendar.getInstance();
        recordDateCalendar.setTime(recordDate);
        int recordDayOfWeek = recordDateCalendar.get(7);
        try {
            for (int index = 0; index < stepDays; ++index) {
                int dayOfWeek;
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(new Date());
                if (includeDay) {
                    calendar.set(5, calendar.get(5) - index);
                } else {
                    calendar.set(5, calendar.get(5) - index - 1);
                }
                if (!includeSat && (dayOfWeek = calendar.get(7)) == 7) {
                    ++stepDays;
                }
                if (includeSun || (dayOfWeek = calendar.get(7)) != 1) continue;
                ++stepDays;
            }
            startCalendar.setTime(new Date());
            endCalendar.setTime(new Date());
            if (includeDay) {
                startCalendar.set(5, startCalendar.get(5) - stepDays + 1);
                endCalendar.set(5, endCalendar.get(5));
            } else {
                startCalendar.set(5, startCalendar.get(5) - stepDays);
                endCalendar.set(5, endCalendar.get(5) - 1);
            }
            Date startCalendarTime = startCalendar.getTime();
            String startFormat = DateUtils.formatDate((Date)startCalendarTime, (Object[])new Object[]{"yyyy-MM-dd"}) + " " + "00:00:00";
            Date startTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(startFormat);
            Date endCalendarTime = endCalendar.getTime();
            String endFormat = DateUtils.formatDate((Date)endCalendarTime, (Object[])new Object[]{"yyyy-MM-dd"}) + " " + "00:00:00";
            Date endTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(endFormat);
            if (!includeSat && recordDayOfWeek == 7) {
                return isDateAccord;
            }
            if (!includeSun && recordDayOfWeek == 1) {
                return isDateAccord;
            }
            if (recordDate.before(startTime) || recordDate.after(endTime)) {
                return isDateAccord;
            }
            isDateAccord = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isDateAccord;
    }

    public static boolean isWeekDateAccord(DynamicObject rule, boolean isDateAccord, Date recordDate) {
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setFirstDayOfWeek(2);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setFirstDayOfWeek(2);
        String startWeekType = rule.getString("startweektype");
        String startWeek = rule.getString("startweek");
        String endWeekType = rule.getString("endweektype");
        String endWeek = rule.getString("endweek");
        if ("A".equals(startWeekType)) {
            startCalendar.add(4, -1);
        } else {
            startCalendar.add(4, 0);
        }
        if ("A".equals(endWeekType)) {
            endCalendar.add(4, -1);
        } else {
            endCalendar.add(4, 0);
        }
        startCalendar.set(7, Integer.parseInt(startWeek));
        endCalendar.set(7, Integer.parseInt(endWeek));
        try {
            Date startCalendarTime = startCalendar.getTime();
            String startFormat = DateUtils.formatDate((Date)startCalendarTime, (Object[])new Object[]{"yyyy-MM-dd"}) + " " + "00:00:00";
            Date startTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(startFormat);
            Date endCalendarTime = endCalendar.getTime();
            String endFormat = DateUtils.formatDate((Date)endCalendarTime, (Object[])new Object[]{"yyyy-MM-dd"}) + " " + "00:00:00";
            Date endTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(endFormat);
            if (!recordDate.before(startTime) && !recordDate.after(endTime)) {
                isDateAccord = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isDateAccord;
    }

    public static boolean isMonthDateAccord(DynamicObject rule, boolean isDateAccord, Date recordDate) {
        Calendar startCalendar = Calendar.getInstance();
        Calendar endCalendar = Calendar.getInstance();
        String startMonth = rule.getString("startmonth");
        String startDays = rule.getString("startdays");
        String endMonth = rule.getString("endmonth");
        String endDays = rule.getString("enddays");
        if ("A".equals(startMonth)) {
            startCalendar.add(2, -1);
        } else {
            startCalendar.add(2, 0);
        }
        if ("A".equals(endMonth)) {
            endCalendar.add(2, -1);
        } else {
            endCalendar.add(2, 0);
        }
        if ("29".equals(startDays)) {
            startCalendar.set(5, startCalendar.getActualMaximum(5));
        } else {
            startCalendar.set(5, Integer.parseInt(startDays));
        }
        if ("29".equals(endDays)) {
            endCalendar.set(5, endCalendar.getActualMaximum(5));
        } else {
            endCalendar.set(5, Integer.parseInt(endDays));
        }
        try {
            Date startCalendarTime = startCalendar.getTime();
            String startFormat = DateUtils.formatDate((Date)startCalendarTime, (Object[])new Object[]{"yyyy-MM-dd"}) + " " + "00:00:00";
            Date startTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(startFormat);
            Date endCalendarTime = endCalendar.getTime();
            String endFormat = DateUtils.formatDate((Date)endCalendarTime, (Object[])new Object[]{"yyyy-MM-dd"}) + " " + "00:00:00";
            Date endTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(endFormat);
            if (!recordDate.before(startTime) && !recordDate.after(endTime)) {
                isDateAccord = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isDateAccord;
    }

    public static QFilter getExRecordFilter(List<DynamicObject> ruleList) {
        QFilter exRecordFilter = null;
        if (ruleList == null || ruleList.isEmpty()) {
            return null;
        }
        ArrayList attItemBoIdList = Lists.newArrayListWithExpectedSize((int)16);
        for (DynamicObject rule : ruleList) {
            DynamicObjectCollection messageContentEntity = rule.getDynamicObjectCollection("messetentity");
            for (DynamicObject entry : messageContentEntity) {
                attItemBoIdList.add(entry.getLong("attenditem.boid"));
            }
        }
        if (attItemBoIdList.isEmpty()) {
            return null;
        }
        exRecordFilter = new QFilter("attitemid.boid", "in", (Object)attItemBoIdList);
        exRecordFilter.and(new QFilter("confirmstatus", "=", (Object)"0"));
        exRecordFilter.and(new QFilter("personid", "!=", (Object)0));
        exRecordFilter.and(new QFilter("attfilevid", "!=", (Object)0));
        return exRecordFilter;
    }

    public static List<DynamicObject> getAccordRules(boolean execPresetRule, Object execOtherRuleObj) {
        logger.info("AbnormalPushService.getAccordRules.execPresetRule:{}", (Object)execPresetRule);
        logger.info("AbnormalPushService.getAccordRules.execOtherRuleObj:{}", execOtherRuleObj);
        ArrayList<DynamicObject> ruleList = new ArrayList<DynamicObject>(10);
        if (execPresetRule) {
            QFilter filter = new QFilter("issyspreset", "=", (Object)Boolean.TRUE);
            DynamicObject[] sysPresetRules = ruleServiceHelper.loadDynamicObjectArray(filter.toArray());
            Collections.addAll(ruleList, sysPresetRules);
        }
        if (execOtherRuleObj != null && !"".equals(execOtherRuleObj)) {
            DynamicObject[] otherRules;
            String execOtherRuleStr = String.valueOf(execOtherRuleObj);
            String[] execOtherRules = execOtherRuleStr.split(",");
            QFilter filter = null;
            for (String execOtherRule : execOtherRules) {
                String execOtherRuleTransStr1 = execOtherRule.replaceAll("_", "\\\\\\_");
                String execOtherRuleTransStr2 = execOtherRuleTransStr1.replaceAll("\\?", "_");
                QFilter execOtherRuleFilter = new QFilter("number", "like", (Object)execOtherRuleTransStr2);
                execOtherRuleFilter.and(new QFilter("status", "=", (Object)"C"));
                execOtherRuleFilter.and(new QFilter("enable", "=", (Object)"1"));
                if (filter == null) {
                    filter = execOtherRuleFilter;
                    continue;
                }
                filter.or(execOtherRuleFilter);
            }
            if (filter == null) {
                return new ArrayList<DynamicObject>(10);
            }
            logger.info("AbnormalPushService.getAccordRules.filter:{}", filter);
            for (DynamicObject otherRule : otherRules = ruleServiceHelper.loadDynamicObjectArray(filter.toArray())) {
                if (ruleList.contains(otherRule)) continue;
                ruleList.add(otherRule);
            }
        }
        return ruleList;
    }

    private static Map<DynamicObject, ExRecipientRapidProcess> generateExPushRecord(Map<DynamicObject, Map<DynamicObject, List<DynamicObject>>> ruleSortMap, boolean isManualPush, boolean isBlockRetry, Long scheduleId) {
        boolean openExPushBlock = isBlockRetry || isManualPush ? false : WTTESystemParamQueryUtil.getExPushBlock();
        Map<String, List<Long>> personAllInfo = AbnormalPushService.getPersonAllInfo(ruleSortMap);
        HashMap<DynamicObject, ExRecipientRapidProcess> exPushRecordMap = new HashMap<DynamicObject, ExRecipientRapidProcess>(16);
        Set<Map.Entry<DynamicObject, Map<DynamicObject, List<DynamicObject>>>> ruleSortEntries = ruleSortMap.entrySet();
        HashMap<DynamicObject, Integer> blockRuleMap = new HashMap<DynamicObject, Integer>();
        for (Map.Entry<DynamicObject, Map<DynamicObject, List<DynamicObject>>> ruleSortNext : ruleSortEntries) {
            DynamicObject rule = ruleSortNext.getKey();
            Map<DynamicObject, List<DynamicObject>> personSortMap = ruleSortNext.getValue();
            Set<Map.Entry<DynamicObject, List<DynamicObject>>> personSortEntries = personSortMap.entrySet();
            HashMap<DynamicObject, ExRecipientRapidProcess> ruleExPushRecordMap = new HashMap<DynamicObject, ExRecipientRapidProcess>(16);
            for (Map.Entry<DynamicObject, List<DynamicObject>> personSortNext : personSortEntries) {
                DynamicObject person = personSortNext.getKey();
                List<DynamicObject> recordList = personSortNext.getValue();
                ruleExPushRecordMap.putAll(AbnormalPushService.emptyExPushRecordAssignment(isManualPush, rule, person, recordList, personAllInfo));
            }
            if (!openExPushBlock || ruleExPushRecordMap.size() < WTTESystemParamQueryUtil.getExPushThresholdValue()) {
                exPushRecordMap.putAll(ruleExPushRecordMap);
                continue;
            }
            blockRuleMap.put(rule, ruleExPushRecordMap.size());
        }
        if (openExPushBlock && !HRMapUtils.isEmpty(blockRuleMap)) {
            AbnormalPushService.blockExPush(blockRuleMap, WTTESystemParamQueryUtil.getExPushThresholdValue(), scheduleId);
        }
        return exPushRecordMap;
    }

    private static Map<DynamicObject, ExRecipientRapidProcess> emptyExPushRecordAssignment(boolean isManualPush, DynamicObject rule, DynamicObject person, List<DynamicObject> recordList, Map<String, List<Long>> personAllInfo) {
        HashMap exPushRecordMap = Maps.newHashMapWithExpectedSize((int)recordList.size());
        Set<AbnormalPushInfo> personTypeSortList = AbnormalPushService.getPersonTypeTpl(rule, person, personAllInfo);
        AbnormalPushService.defaultReceiverRapidProcess(personTypeSortList);
        Set<AbnormalPushInfo> personTypeTplByPlugin = AbnormalPushService.getPersonTypeTplByPlugin(recordList, rule);
        AbnormalPushService.handleCustomRapidProcess(personTypeTplByPlugin);
        personTypeTplByPlugin.addAll(personTypeSortList);
        for (AbnormalPushInfo next : personTypeTplByPlugin) {
            DynamicObject exPushDy = AbnormalPushService.getExPushDy(person, next, isManualPush);
            if (exPushDy == null) continue;
            String exRecordMessage = AbnormalPushService.getExRecordMessage(recordList, rule);
            logger.info("AbnormalPushService.emptyExPushRecordAssignment.exRecordMessage:{}", (Object)exRecordMessage);
            exPushDy.set("exinfo", (Object)exRecordMessage);
            exPushRecordMap.put(exPushDy, next.getProcess());
        }
        return exPushRecordMap;
    }

    private static void handleCustomRapidProcess(Set<AbnormalPushInfo> abnormalPushInfos) {
        HashMap userAndRapid = Maps.newHashMapWithExpectedSize((int)abnormalPushInfos.size());
        Date first = WTCDateUtils.getMinEndDate();
        for (AbnormalPushInfo abnormalPushInfo : abnormalPushInfos) {
            Date attFileEffect;
            DynamicObject attFileBoDy = abnormalPushInfo.getAttFileBoDy();
            if (attFileBoDy == null || (attFileEffect = attFileBoDy.getDate("startdate")) == null || !attFileEffect.after(first)) continue;
            userAndRapid.put(abnormalPushInfo.getUserId(), abnormalPushInfo.getProcess());
            first = attFileEffect;
        }
        for (AbnormalPushInfo abnormalPushInfo : abnormalPushInfos) {
            ExRecipientRapidProcess exRecipientRapidProcess = (ExRecipientRapidProcess)userAndRapid.get(abnormalPushInfo.getUserId());
            if (exRecipientRapidProcess == null) continue;
            abnormalPushInfo.setProcess(exRecipientRapidProcess);
        }
    }

    private static DynamicObject getExPushDy(DynamicObject person, AbnormalPushInfo abnormalPushInfo, boolean isManualPush) {
        DynamicObject exPushRecord = exPushRecordServiceHelper.generateEmptyDynamicObject();
        exPushRecord.set("name", (Object)ResManager.loadKDString((String)"%s\u7684\u8003\u52e4\u5f02\u5e38\u63d0\u9192\u3002", (String)"AbnormalPushService_0", (String)"wtc-wtte-business", (Object[])new Object[]{person.getString("name")}));
        if (abnormalPushInfo.getUserId() == null || abnormalPushInfo.getMessageTmpId() == null) {
            logger.info("AbnormalPushService.emptyExPushRecordAssignment next.getUserId() == null?{} || next.getMessageTmpId() == null:{})", (Object)(abnormalPushInfo.getUserId() == null ? 1 : 0), (Object)(abnormalPushInfo.getMessageTmpId() == null ? 1 : 0));
            return null;
        }
        if (logger.isInfoEnabled()) {
            logger.info("AbnormalPushService.emptyExPushRecordAssignment.personType:{}", (Object)abnormalPushInfo.getType());
        }
        exPushRecord.set("rectype", (Object)abnormalPushInfo.getType());
        long userId = Long.parseLong(abnormalPushInfo.getUserId());
        exPushRecord.set("receiver", (Object)userId);
        AbnormalPushService.generateOneCodeRule("number", "wtte_expushrecord", exPushRecord);
        exPushRecord.set("msgtemplate", (Object)Long.valueOf(abnormalPushInfo.getMessageTmpId()));
        exPushRecord.set("pushstatus", (Object)"0");
        if (isManualPush) {
            exPushRecord.set("bizcreator", (Object)(UserServiceHelper.getCurrentUser((String)"name").getString("name") + "-" + UserServiceHelper.getCurrentUser((String)"number").getString("number")));
        } else {
            exPushRecord.set("bizcreator", (Object)ResManager.loadKDString((String)"\u7cfb\u7edf", (String)"AbnormalPushService_1", (String)"wtc-wtte-business", (Object[])new Object[0]));
        }
        exPushRecord.set("pushtime", (Object)new Date());
        return exPushRecord;
    }

    private static void defaultReceiverRapidProcess(Set<AbnormalPushInfo> personTypeSortList) {
        personTypeSortList.forEach(data -> {
            if (HRStringUtils.equals((String)data.getType(), (String)"A")) {
                ExRecipientRapidProcess exRecipientRapidProcess = ExRecipientRapidProcess.buildFormParamView((String)"wtss", (String)"wtss_pcpersonhome");
                data.setProcess(exRecipientRapidProcess);
            }
        });
    }

    private static Set<AbnormalPushInfo> getPersonTypeTpl(DynamicObject rule, DynamicObject person, Map<String, List<Long>> personAllInfo) {
        DynamicObjectCollection pushEntity = rule.getDynamicObjectCollection("pussetentity");
        HashSet<AbnormalPushInfo> personTypeSortList = new HashSet<AbnormalPushInfo>(16);
        for (DynamicObject entry : pushEntity) {
            String[] personTypes;
            String personTypeStr = entry.getString("recipient");
            for (String personType : personTypes = personTypeStr.split(",")) {
                if ("A".equals(personType)) {
                    List<Long> userIdList = personAllInfo.get(person.getLong("id") + "A");
                    if (userIdList == null || userIdList.size() == 0) continue;
                    AbnormalPushInfo info = new AbnormalPushInfo();
                    info.setType("A");
                    info.setMessageTmpId(entry.getString("msgtemplate.id"));
                    info.setUserId(userIdList.get(0) + "");
                    personTypeSortList.add(info);
                    continue;
                }
                if (!"B".equals(personType)) continue;
                personTypeSortList.addAll(AbnormalPushService.getPersonTypeByDirect(entry, person, personAllInfo));
            }
        }
        logger.info("AbnormalPushService.getPersonTypeTpl.personTypeSortList:{}", personTypeSortList);
        return personTypeSortList;
    }

    private static Set<AbnormalPushInfo> getPersonTypeByDirect(DynamicObject entry, DynamicObject person, Map<String, List<Long>> personAllInfo) {
        List<Long> userIdList = personAllInfo.get(person.getLong("id") + "B");
        if (userIdList == null) {
            return Collections.emptySet();
        }
        HashSet<AbnormalPushInfo> result = new HashSet<AbnormalPushInfo>(16);
        for (Long userId : userIdList) {
            AbnormalPushInfo info = new AbnormalPushInfo();
            info.setType("B");
            info.setMessageTmpId(entry.getString("msgtemplate.id"));
            info.setUserId(userId + "");
            result.add(info);
        }
        return result;
    }

    private static Set<AbnormalPushInfo> getPersonTypeTplByPlugin(List<DynamicObject> exRecordList, DynamicObject rule) {
        if (CollectionUtils.isEmpty(exRecordList)) {
            return Collections.emptySet();
        }
        HashSet result = Sets.newHashSetWithExpectedSize((int)exRecordList.size());
        HashMap attFileBoId = Maps.newHashMapWithExpectedSize((int)exRecordList.size());
        for (DynamicObject exRecordDy : exRecordList) {
            DynamicObject attFileBoDy = exRecordDy.getDynamicObject("attfileid");
            if (attFileBoDy == null) continue;
            attFileBoId.put(attFileBoDy.getLong("id"), attFileBoDy);
        }
        DynamicObjectCollection pushEntity = rule.getDynamicObjectCollection("pussetentity");
        for (DynamicObject entry : pushEntity) {
            if (!AbnormalPushService.isPlugin(entry)) continue;
            result.addAll(AbnormalPushService.getPersonTypeTplByPlugin_0(attFileBoId, entry, rule));
        }
        return result;
    }

    private static Set<AbnormalPushInfo> getPersonTypeTplByPlugin_0(Map<Long, DynamicObject> attFileBoIdAndDy, DynamicObject entry, DynamicObject rule) {
        if (attFileBoIdAndDy == null) {
            return Collections.emptySet();
        }
        HashSet result = Sets.newHashSetWithExpectedSize((int)attFileBoIdAndDy.size());
        for (Map.Entry<Long, DynamicObject> longDynamicObjectEntry : attFileBoIdAndDy.entrySet()) {
            ExRecipientInfo infoByPlugin = AbnormalPushService.getInfoByPlugin(rule, longDynamicObjectEntry.getValue(), entry);
            DynamicObject infoTmpDy = entry.getDynamicObject("msgtemplate");
            String infoTmpId = infoTmpDy == null ? "" : infoTmpDy.getLong("id") + "";
            List<AbnormalPushInfo> abnormalPushInfos = AbnormalPushService.genTplByPluginResult(infoByPlugin, infoTmpId);
            for (AbnormalPushInfo abnormalPushInfo : abnormalPushInfos) {
                abnormalPushInfo.setAttFileBoId(longDynamicObjectEntry.getKey());
                abnormalPushInfo.setAttFileBoDy(longDynamicObjectEntry.getValue());
            }
            result.addAll(abnormalPushInfos);
        }
        return result;
    }

    private static List<AbnormalPushInfo> genTplByPluginResult(ExRecipientInfo infoByPlugin, String infoTmpId) {
        if (infoByPlugin == null) {
            return Collections.emptyList();
        }
        Map userAndRapidProcess = infoByPlugin.getUserAndRapidProcess();
        if (userAndRapidProcess == null || userAndRapidProcess.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList tplInfo = Lists.newArrayListWithExpectedSize((int)userAndRapidProcess.size());
        for (Map.Entry next : userAndRapidProcess.entrySet()) {
            AbnormalPushInfo info = new AbnormalPushInfo();
            info.setType("C");
            info.setUserId(next.getKey() + "");
            info.setMessageTmpId(infoTmpId);
            info.setProcess((ExRecipientRapidProcess)next.getValue());
            tplInfo.add(info);
        }
        return tplInfo;
    }

    private static boolean isPlugin(DynamicObject entry) {
        String[] personTypes;
        String personTypeStr = entry.getString("recipient");
        for (String personType : personTypes = personTypeStr.split(",")) {
            if (!"C".equals(personType)) continue;
            return true;
        }
        return false;
    }

    private static ExRecipientInfo getInfoByPlugin(DynamicObject rule, DynamicObject attFileBo, DynamicObject entry) {
        DynamicObject pluginDy = entry.getDynamicObject("recipientplugin");
        if (pluginDy == null) {
            return null;
        }
        String pluginFullPath = pluginDy.getString("classpath");
        try {
            Class<?> calzz = Class.forName(pluginFullPath);
            Object obj = calzz.newInstance();
            if (!(obj instanceof ExPushRecipientService)) {
                String tip = ResManager.loadKDString((String)"\u63d2\u4ef6\u7ee7\u627f\u672a\u7b26\u5408\u89c4\u8303\uff0c\u89c4\u5219\u4e3a{0},\u6a21\u677f\u4e3a{1}\u3002", (String)"AbnormalPushService_4", (String)"wtc-wtte-business", (Object[])new Object[0]);
                throw new KDBizException(MessageFormat.format(tip, rule.getLocaleString("name"), entry.getLocaleString("msgtemplate.name")));
            }
            ExPushRecipientService service = (ExPushRecipientService)obj;
            ExRecipientReq exRecipientReq = new ExRecipientReq();
            exRecipientReq.setExPushRuleDy(rule);
            exRecipientReq.setAttFileBoDy(attFileBo);
            return service.getPushInfo(exRecipientReq);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            logger.warn("AbnormalPushService_getPersonTypeTpl  ClassNotFoundException,class patch = {}", (Object)pluginFullPath, (Object)e);
            String tip = ResManager.loadKDString((String)"\u65e0\u6cd5\u5904\u7406\u8be5\u63d2\u4ef6,\u89c4\u5219\u4e3a{0},\u6a21\u677f\u4e3a{1}\u3002", (String)"AbnormalPushService_3", (String)"wtc-wtte-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(tip, rule.getLocaleString("name"), entry.getLocaleString("msgtemplate.name")));
        }
    }

    private static String getExRecordMessage(List<DynamicObject> recordList, DynamicObject rule) {
        StringBuilder exRecordMsg = new StringBuilder();
        HashMap<Date, Map<String, String>> exRecordSortMap = new HashMap<Date, Map<String, String>>(16);
        HashMap countTimes = Maps.newHashMapWithExpectedSize((int)recordList.size());
        for (DynamicObject record : recordList) {
            Date recordDate = record.getDate("recorddate");
            Map exRecordStr = exRecordSortMap.computeIfAbsent(recordDate, key -> new HashMap(16));
            DynamicObject attItem = record.getDynamicObject("attitemid");
            DynamicObjectCollection messageContentEntity = rule.getDynamicObjectCollection("messetentity");
            for (DynamicObject entry : messageContentEntity) {
                long attItemBoId = attItem.getLong("id");
                if (attItemBoId != entry.getLong("attenditem.id")) continue;
                String sign = AbnormalPushService.genSignatureCode("", recordDate, attItemBoId);
                String messageContent = entry.getString("mescontent");
                Integer num = countTimes.computeIfAbsent(sign, key -> 0);
                if (num == 0) {
                    exRecordStr.put(sign, messageContent);
                }
                num = num + 1;
                countTimes.put(sign, num);
            }
            exRecordSortMap.put(recordDate, exRecordStr);
        }
        LinkedHashMap resultMap = new LinkedHashMap(16);
        Map<Date, String> dateStringMap = AbnormalPushService.handleOneDayAndAttItemTimes(exRecordSortMap, countTimes);
        dateStringMap.entrySet().stream().sorted(Collections.reverseOrder(Map.Entry.comparingByKey())).forEachOrdered(param -> {
            String cfr_ignored_0 = (String)resultMap.put(param.getKey(), param.getValue());
        });
        Set resultEntries = resultMap.entrySet();
        for (Map.Entry resultNext : resultEntries) {
            Date exRecordDate = (Date)resultNext.getKey();
            String exRecordDateStr = DateUtils.formatDate((Date)exRecordDate, (Object[])new Object[]{"yyyy-MM-dd"});
            String exRecordStr = (String)resultNext.getValue();
            exRecordMsg.append(exRecordDateStr).append('\uff1a').append(exRecordStr).append('\n');
        }
        return exRecordMsg.toString();
    }

    private static Map<Date, String> handleOneDayAndAttItemTimes(Map<Date, Map<String, String>> messageContent, Map<String, Integer> countTimes) {
        if (messageContent == null) {
            return Collections.emptyMap();
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)messageContent.size());
        for (Map.Entry<Date, Map<String, String>> entryInfo : messageContent.entrySet()) {
            Map<String, String> singAndVal = entryInfo.getValue();
            ArrayList infoInOneDay = Lists.newArrayListWithExpectedSize((int)singAndVal.size());
            for (Map.Entry<String, String> signAndMsg : singAndVal.entrySet()) {
                String sign = signAndMsg.getKey();
                String message = signAndMsg.getValue();
                int time = countTimes.get(sign);
                if (time > 1) {
                    String timeTip = ResManager.loadKDString((String)"\uff08{0}\u6b21\uff09", (String)"AbnormalPushService_5", (String)"wtc-wtte-business", (Object[])new Object[0]);
                    message = message + MessageFormat.format(timeTip, time);
                }
                infoInOneDay.add(message);
            }
            result.put(entryInfo.getKey(), String.join((CharSequence)WTCSymbolMultiLanguageUtil.getSemicolonSymbol(), infoInOneDay));
        }
        return result;
    }

    private static void generateOneCodeRule(String numberKey, String entityId, DynamicObject dynamicObject) {
        Assert.notNull((Object)entityId, (String)"entityId");
        Assert.notNull((Object)dynamicObject, (String)"dynamicObject");
        Assert.notNull((Object)numberKey, (String)"numberKey");
        String number = CodeRuleServiceHelper.getNumber((String)entityId, (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)entityId), null);
        Assert.hasText((String)number, (String)"please configure rules on the platform");
        dynamicObject.set(numberKey, (Object)number);
    }

    private static void sendMessage(DynamicObject[] exPushRecords, boolean isManualPush, Map<Long, ExRecipientRapidProcess> idAndRapProcess) {
        DynamicObject[] userDataArr;
        if (exPushRecords == null || exPushRecords.length == 0) {
            return;
        }
        HashSet sysUserIds = Sets.newHashSetWithExpectedSize((int)exPushRecords.length);
        for (DynamicObject exPushRecord : exPushRecords) {
            DynamicObject receiverDy = exPushRecord.getDynamicObject("receiver");
            if (receiverDy == null) continue;
            sysUserIds.add(receiverDy.getLong("id"));
        }
        HRBaseServiceHelper sysUser = new HRBaseServiceHelper("bos_user");
        for (DynamicObject dynamicObject : userDataArr = sysUser.query("id", new QFilter[]{new QFilter("id", "in", (Object)sysUserIds)})) {
            sysUserIds.add(dynamicObject.getLong("id"));
        }
        for (DynamicObject exPushRecord : exPushRecords) {
            MessageInfo message = new MessageInfo();
            message.setType("message");
            String msgChannel = exPushRecord.getString("msgtemplate.msgchannel");
            message.setNotifyType(msgChannel);
            DynamicObject receiverDy = exPushRecord.getDynamicObject("receiver");
            if (HRStringUtils.equals((String)"mcenter", (String)msgChannel)) {
                exPushRecord.set("pushstatus", (Object)"1");
            }
            if (receiverDy == null || !sysUserIds.contains(receiverDy.getLong("id"))) {
                exPushRecord.set("pushstatus", (Object)"2");
            }
            message.setEntityNumber("wtte_expushrecord");
            message.setTemplateNumber(exPushRecord.getString("msgtemplate.number"));
            message.setBizDataId(Long.valueOf(exPushRecord.getLong("id")));
            ArrayList<Long> userIds = new ArrayList<Long>(10);
            userIds.add(exPushRecord.getLong("receiver.id"));
            message.setUserIds(userIds);
            if (isManualPush) {
                message.setSenderId(Long.valueOf(UserServiceHelper.getCurrentUserId()));
            }
            message.setTag(ResManager.loadKDString((String)"\u8003\u52e4\u5f02\u5e38", (String)"AbnormalPushService_2", (String)"wtc-wtte-business", (Object[])new Object[0]));
            ExRecipientRapidProcess exRecipientRapidProcess = idAndRapProcess.get(exPushRecord.getLong("id"));
            if (exRecipientRapidProcess != null) {
                message.setContentUrl(AbnormalPushService.buildRapidProcessUrl(exRecipientRapidProcess));
            }
            long msgId = MessageCenterServiceHelper.sendMessage((MessageInfo)message);
            exPushRecord.set("msgid", (Object)msgId);
            String number = exPushRecord.getString("number");
            String newNumber = number.replaceAll("__", "_" + exPushRecord.getString("receiver.number") + "_");
            exPushRecord.set("number", (Object)newNumber);
        }
        exPushRecordServiceHelper.update(exPushRecords);
    }

    private static String buildRapidProcessUrl(ExRecipientRapidProcess process) {
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("formId", "wtbs_rapidprocess");
        params.put("type", "base");
        params.put("openStyle", "modal");
        params.put("appName", process.getAppName());
        params.put("pkId", process.getPkId());
        params.put("entityNumber", process.getEntityNumber());
        params.put("outSysUrl", process.getOutSysUrl());
        if (process.getOperationStatus() != null) {
            params.put("operationStatus", process.getOperationStatus().getValue() + "");
        }
        return AbnormalPushService.getUrl(params);
    }

    private static String getUrl(Map<String, String> params) {
        StringBuilder stringBuilder = new StringBuilder(UrlService.getDomainContextUrl()).append("/?");
        Iterator<Map.Entry<String, String>> iterator = params.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> next = iterator.next();
            if (!HRStringUtils.isNotEmpty((String)next.getValue())) continue;
            stringBuilder.append(next.getKey()).append("=").append(next.getValue());
            if (!iterator.hasNext()) continue;
            stringBuilder.append("&");
        }
        return stringBuilder.toString();
    }

    private static DynamicObject getPersonAttFile(Long personId) {
        QFilter filter = new QFilter("attperson", "=", (Object)personId);
        filter.and(new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE));
        return new HRBaseServiceHelper("wtp_attfilebase").loadDynamicObject(filter);
    }

    public static Tuple<String, String> getMsgDetailContent(long msgId) {
        HRBaseServiceHelper msgServiceHelper = new HRBaseServiceHelper("wf_msg_message");
        DynamicObject msgDetail = msgServiceHelper.loadDynamicObject(new QFilter("id", "=", (Object)msgId));
        if (msgDetail != null) {
            return new Tuple((Object)msgDetail.getString("title"), (Object)msgDetail.getString("content"));
        }
        return new Tuple((Object)"", (Object)"");
    }

    private static Map<String, List<Long>> getPersonAllInfo(Map<DynamicObject, Map<DynamicObject, List<DynamicObject>>> ruleSortMap) {
        HashMap<String, List<Long>> personAllInfoMap = new HashMap<String, List<Long>>(16);
        List<Long> personIdList = AbnormalPushService.getAttPersonIdList(ruleSortMap);
        HashMap idMaps = new HashMap(16);
        ArrayList<Long> pids = new ArrayList<Long>(10);
        pids.addAll(personIdList);
        idMaps.put("person", pids);
        logger.info("AbnormalPushService.getPersonAllInfo.idMaps:{}", idMaps);
        Map userMap = (Map)WTCServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getUserIdByPersonInfo", (Object[])new Object[]{idMaps});
        logger.info("AbnormalPushService.getPersonAllInfo.userMap:{}", (Object)userMap);
        Map userAllInfoMap = (Map)userMap.get("data");
        if (userAllInfoMap != null) {
            Set userEntries = userAllInfoMap.entrySet();
            for (Map.Entry userEntry : userEntries) {
                DynamicObject[] personId = (DynamicObject[])userEntry.getKey();
                Map userInfo = (Map)userEntry.getValue();
                ArrayList userIdList = new ArrayList(10);
                userIdList.add(userInfo.get("user"));
                personAllInfoMap.put(personId + "A", userIdList);
            }
        }
        QFilter filter = new QFilter("attperson", "in", personIdList);
        filter.and(new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE));
        DynamicObject[] attFiles = new HRBaseServiceHelper("wtp_attfilebase").loadDynamicObjectArray(filter.toArray());
        ArrayList<Long> depempIds = new ArrayList<Long>(10);
        for (DynamicObject dynamicObject : attFiles) {
            DynamicObject depemp = dynamicObject.getDynamicObject("depemp");
            if (depemp == null) continue;
            depempIds.add(depemp.getLong("id"));
        }
        logger.info("AbnormalPushService.getPersonAllInfo.depempIds:{}", depempIds);
        Map superiorPerson = HRPIMServiceImpl.getInstance().getDirectSuperiorByDepempId(depempIds);
        logger.info("AbnormalPushService.getPersonAllInfo.superiorPerson.size():{}", superiorPerson == null ? null : Integer.valueOf(superiorPerson.size()));
        if (superiorPerson != null && superiorPerson.size() != 0) {
            HashMap superiorIdMaps = new HashMap(16);
            ArrayList<Long> superiorPids = new ArrayList<Long>(10);
            for (DynamicObject attFile : attFiles) {
                DynamicObject depemp = attFile.getDynamicObject("depemp");
                List superiorPersonList = (List)superiorPerson.get(depemp.getLong("id"));
                if (superiorPersonList == null) continue;
                for (Map superior : superiorPersonList) {
                    Object superiorId = superior.get("person.id");
                    if (superiorId == null) continue;
                    superiorPids.add((Long)superiorId);
                }
            }
            superiorIdMaps.put("person", superiorPids);
            logger.info("AbnormalPushService.getPersonAllInfo.superiorIdMaps:{}", superiorIdMaps);
            Map map = (Map)WTCServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getUserIdByPersonInfo", (Object[])new Object[]{superiorIdMaps});
            logger.info("AbnormalPushService.getPersonAllInfo.superiorUserMap:{}", (Object)map);
            for (DynamicObject attFile : attFiles) {
                List superiorPersonList;
                DynamicObject attPerson = attFile.getDynamicObject("attperson");
                DynamicObject depemp = attFile.getDynamicObject("depemp");
                ArrayList superiorUserList = (ArrayList)personAllInfoMap.get(attPerson.getLong("id") + "B");
                if (superiorUserList == null) {
                    superiorUserList = new ArrayList(10);
                }
                if ((superiorPersonList = (List)superiorPerson.get(depemp.getLong("id"))) == null) continue;
                for (Map superior : superiorPersonList) {
                    Object superiorId = superior.get("person.id");
                    if (superiorId == null) continue;
                    Map superiorUser = (Map)((Map)map.get("data")).get((Long)superiorId);
                    if (superiorUser != null) {
                        superiorUserList.add(superiorUser.get("user"));
                        continue;
                    }
                    logger.info("AbnormalPushService.getPersonAllInfoNoUser.superiorId:{},superiorUser:{}", superiorId, (Object)superiorUser);
                }
                personAllInfoMap.put(attPerson.getLong("id") + "B", superiorUserList);
            }
        }
        return personAllInfoMap;
    }

    private static List<Long> getAttPersonIdList(Map<DynamicObject, Map<DynamicObject, List<DynamicObject>>> ruleSortMap) {
        ArrayList<Long> personIdList = new ArrayList<Long>(10);
        Set<Map.Entry<DynamicObject, Map<DynamicObject, List<DynamicObject>>>> ruleSortEntries = ruleSortMap.entrySet();
        for (Map.Entry<DynamicObject, Map<DynamicObject, List<DynamicObject>>> ruleSortNext : ruleSortEntries) {
            Map<DynamicObject, List<DynamicObject>> personSortMap = ruleSortNext.getValue();
            Set<Map.Entry<DynamicObject, List<DynamicObject>>> personSortEntries = personSortMap.entrySet();
            for (Map.Entry<DynamicObject, List<DynamicObject>> personSortNext : personSortEntries) {
                DynamicObject person = personSortNext.getKey();
                personIdList.add(person.getLong("id"));
            }
        }
        return personIdList;
    }

    private static String genSignatureCode(String sendDimension, Date date, long exAttItemBoId) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String recordDateStr = dateFormat.format(date);
        return recordDateStr + sendDimension + exAttItemBoId;
    }

    private static void blockExPush(Map<DynamicObject, Integer> ruleMap, Integer thresholdValue, Long scheduleId) {
        AtomicInteger taskIdIndex = new AtomicInteger(0);
        AtomicInteger fidIndex = new AtomicInteger(0);
        List userIds = WTTESystemParamQueryUtil.getExPushBlockingNotification();
        LinkedHashMap msgTmp = WTTESystemParamQueryUtil.getExPushBlockNoticeTpl();
        if (WTCCollections.isEmpty((Collection)userIds) || msgTmp == null) {
            return;
        }
        long[] ids = ID.genLongIds((int)(ruleMap.size() * userIds.size()));
        long[] taskIds = ID.genLongIds((int)ruleMap.size());
        ArrayList blockRecords = new ArrayList(ruleMap.size());
        ruleMap.entrySet().iterator().forEachRemaining(e -> {
            long taskId = taskIds[taskIdIndex.getAndAdd(1)];
            Integer blockSize = (Integer)e.getValue();
            DynamicObject rule = (DynamicObject)e.getKey();
            for (Long userId : userIds) {
                DynamicObject dy = AbnormalPushService.generateBlockRecord(rule, thresholdValue, scheduleId);
                dy.set("taskid", (Object)taskId);
                dy.set("blocksize", (Object)blockSize);
                dy.set("receiver", (Object)userId);
                long fid = ids[fidIndex.getAndAdd(1)];
                dy.set("id", (Object)fid);
                blockRecords.add(dy);
            }
        });
        exPushBlockRecordServiceHelper.save(blockRecords.toArray(new DynamicObject[0]));
        String msgChannel = String.valueOf(msgTmp.get("msgchannel"));
        for (DynamicObject dy : blockRecords) {
            long msgId;
            MessageInfo message = new MessageInfo();
            message.setType("warning");
            message.setNotifyType(msgChannel);
            message.setEntityNumber("wtte_epblockrecord");
            message.setTemplateNumber(String.valueOf(msgTmp.get("number")));
            message.setBizDataId(Long.valueOf(dy.getLong("id")));
            message.setUserIds(Collections.singletonList(dy.getLong("receiver")));
            message.setTitle(ResManager.loadKDString((String)"\u8003\u52e4\u5f02\u5e38\u63a8\u9001\u963b\u65ad\u9884\u8b66\u3002", (String)"AbnormalPushService_7", (String)"wtc-wtte-business", (Object[])new Object[0]));
            message.setContentUrl(AbnormalPushService.buildBlockRapidProcessUrl(dy.getLong("id")));
            if (HRStringUtils.equals((String)"mcenter", (String)msgChannel)) {
                dy.set("pushstatus", (Object)"1");
            }
            if (0L == (msgId = MessageCenterServiceHelper.sendMessage((MessageInfo)message))) continue;
            dy.set("msgid", (Object)msgId);
        }
        exPushBlockRecordServiceHelper.save(blockRecords.toArray(new DynamicObject[0]));
    }

    private static DynamicObject generateBlockRecord(DynamicObject rule, Integer thresholdValue, Long scheduleId) {
        DynamicObject exPushBlockRecord = exPushBlockRecordServiceHelper.generateEmptyDynamicObject();
        exPushBlockRecord.set("expushruleid", (Object)rule.getLong("id"));
        exPushBlockRecord.set("pushstatus", (Object)"0");
        exPushBlockRecord.set("retry", (Object)"0");
        exPushBlockRecord.set("thresholdvalue", (Object)thresholdValue);
        exPushBlockRecord.set("scheduleid", (Object)scheduleId);
        AbnormalPushService.setBlockExDate(rule, exPushBlockRecord);
        return exPushBlockRecord;
    }

    private static void setBlockExDate(DynamicObject rule, DynamicObject exPushBlockRecord) {
        String pushDataRange = rule.getString("pushdatarange");
        if ("D".equals(pushDataRange)) {
            exPushBlockRecord.set("datarange", (Object)rule.getLong("datarange.id"));
            return;
        }
        Date begin = null;
        Date end = null;
        boolean includeSat = false;
        boolean includeSun = false;
        if ("A".equals(pushDataRange)) {
            begin = AbnormalPushService.getBlockExByMonth(rule, true);
            end = AbnormalPushService.getBlockExByMonth(rule, false);
        } else if ("B".equals(pushDataRange)) {
            begin = AbnormalPushService.getBlockExByWeek(rule, true);
            end = AbnormalPushService.getBlockExByWeek(rule, false);
        } else if ("C".equals(pushDataRange)) {
            begin = AbnormalPushService.getBlockExByDay(rule, true);
            end = AbnormalPushService.getBlockExByDay(rule, false);
            includeSat = rule.getBoolean("includesat");
            exPushBlockRecord.set("includesat", (Object)includeSat);
            includeSun = rule.getBoolean("includesun");
            exPushBlockRecord.set("includesun", (Object)includeSun);
        }
        exPushBlockRecord.set("exblockbegindate", (Object)begin);
        exPushBlockRecord.set("exblockenddate", (Object)end);
        String dateRangeStr = ResManager.loadKDString((String)"{0}\u5230{1}", (String)"AbnormalPushService_8", (String)"wtc-wtte-business", (Object[])new Object[0]);
        String beginDateStr = WTCDateUtils.date2Str((Date)begin, (String)"yyyy-MM-dd");
        String endDateStr = WTCDateUtils.date2Str((Date)end, (String)"yyyy-MM-dd");
        if (includeSat || includeSun) {
            String includeStr = ResManager.loadKDString((String)"\uff08\u542b\u5468{0}{1}\uff09", (String)"AbnormalPushService_9", (String)"wtc-wtte-business", (Object[])new Object[0]);
            String includeSatStr = includeSat ? ResManager.loadKDString((String)"\u516d", (String)"AbnormalPushService_10", (String)"wtc-wtte-business", (Object[])new Object[0]) : "";
            String includeSatSun = includeSun ? ResManager.loadKDString((String)"\u65e5", (String)"AbnormalPushService_11", (String)"wtc-wtte-business", (Object[])new Object[0]) : "";
            endDateStr = endDateStr + MessageFormat.format(includeStr, includeSatStr, includeSatSun);
        }
        exPushBlockRecord.set("daterangestr", (Object)MessageFormat.format(dateRangeStr, beginDateStr, endDateStr));
        exPushBlockRecord.set("pushdatarange", (Object)pushDataRange);
    }

    private static Date getBlockExByDay(DynamicObject rule, boolean begin) {
        Date ret = null;
        Calendar startCalendar = Calendar.getInstance();
        Calendar endCalendar = Calendar.getInstance();
        int stepDays = rule.getInt("stepdays");
        boolean includeDay = rule.getBoolean("includeday");
        boolean includeSat = rule.getBoolean("includesat");
        boolean includeSun = rule.getBoolean("includesun");
        try {
            for (int index = 0; index < stepDays; ++index) {
                int dayOfWeek;
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(new Date());
                if (includeDay) {
                    calendar.set(5, calendar.get(5) - index);
                } else {
                    calendar.set(5, calendar.get(5) - index - 1);
                }
                if (!includeSat && (dayOfWeek = calendar.get(7)) == 7) {
                    ++stepDays;
                }
                if (includeSun || (dayOfWeek = calendar.get(7)) != 1) continue;
                ++stepDays;
            }
            startCalendar.setTime(new Date());
            endCalendar.setTime(new Date());
            if (includeDay) {
                startCalendar.set(5, startCalendar.get(5) - stepDays + 1);
                endCalendar.set(5, endCalendar.get(5));
            } else {
                startCalendar.set(5, startCalendar.get(5) - stepDays);
                endCalendar.set(5, endCalendar.get(5) - 1);
            }
            Date startCalendarTime = startCalendar.getTime();
            String startFormat = DateUtils.formatDate((Date)startCalendarTime, (Object[])new Object[]{"yyyy-MM-dd"}) + " " + "00:00:00";
            Date startTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(startFormat);
            logger.info("AbnormalPushService.getBlockExByDay.startTime:{}", (Object)startTime);
            Date endCalendarTime = endCalendar.getTime();
            String endFormat = DateUtils.formatDate((Date)endCalendarTime, (Object[])new Object[]{"yyyy-MM-dd"}) + " " + "00:00:00";
            Date endTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(endFormat);
            logger.info("AbnormalPushService.getBlockExByDay.endTime:{}", (Object)endTime);
            ret = begin ? startTime : endTime;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    private static Date getBlockExByWeek(DynamicObject rule, boolean begin) {
        Date ret = null;
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setFirstDayOfWeek(2);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setFirstDayOfWeek(2);
        String startWeekType = rule.getString("startweektype");
        String startWeek = rule.getString("startweek");
        String endWeekType = rule.getString("endweektype");
        String endWeek = rule.getString("endweek");
        if ("A".equals(startWeekType)) {
            startCalendar.add(4, -1);
        } else {
            startCalendar.add(4, 0);
        }
        if ("A".equals(endWeekType)) {
            endCalendar.add(4, -1);
        } else {
            endCalendar.add(4, 0);
        }
        startCalendar.set(7, Integer.parseInt(startWeek));
        endCalendar.set(7, Integer.parseInt(endWeek));
        try {
            Date startCalendarTime = startCalendar.getTime();
            String startFormat = DateUtils.formatDate((Date)startCalendarTime, (Object[])new Object[]{"yyyy-MM-dd"}) + " " + "00:00:00";
            Date startTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(startFormat);
            logger.info("AbnormalPushService.getBlockExByWeek.startTime:{}", (Object)startTime);
            Date endCalendarTime = endCalendar.getTime();
            String endFormat = DateUtils.formatDate((Date)endCalendarTime, (Object[])new Object[]{"yyyy-MM-dd"}) + " " + "00:00:00";
            Date endTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(endFormat);
            logger.info("AbnormalPushService.getBlockExByWeek.endTime:{}", (Object)endTime);
            ret = begin ? startTime : endTime;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    private static Date getBlockExByMonth(DynamicObject rule, boolean begin) {
        Date ret = null;
        Calendar startCalendar = Calendar.getInstance();
        Calendar endCalendar = Calendar.getInstance();
        String startMonth = rule.getString("startmonth");
        String startDays = rule.getString("startdays");
        String endMonth = rule.getString("endmonth");
        String endDays = rule.getString("enddays");
        if ("A".equals(startMonth)) {
            startCalendar.add(2, -1);
        } else {
            startCalendar.add(2, 0);
        }
        if ("A".equals(endMonth)) {
            endCalendar.add(2, -1);
        } else {
            endCalendar.add(2, 0);
        }
        if ("29".equals(startDays)) {
            startCalendar.set(5, startCalendar.getActualMaximum(5));
        } else {
            startCalendar.set(5, Integer.parseInt(startDays));
        }
        if ("29".equals(endDays)) {
            endCalendar.set(5, endCalendar.getActualMaximum(5));
        } else {
            endCalendar.set(5, Integer.parseInt(endDays));
        }
        try {
            Date startCalendarTime = startCalendar.getTime();
            String startFormat = DateUtils.formatDate((Date)startCalendarTime, (Object[])new Object[]{"yyyy-MM-dd"}) + " " + "00:00:00";
            Date startTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(startFormat);
            logger.info("AbnormalPushService.getBlockExByMonth.startTime:{}", (Object)startTime);
            Date endCalendarTime = endCalendar.getTime();
            String endFormat = DateUtils.formatDate((Date)endCalendarTime, (Object[])new Object[]{"yyyy-MM-dd"}) + " " + "00:00:00";
            Date endTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(endFormat);
            logger.info("AbnormalPushService.getBlockExByMonth.endTime:{}", (Object)endTime);
            ret = begin ? startTime : endTime;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    private static boolean filterSatAndSunByBlockRange(Date recordDate, boolean includeSat, boolean includeSun) {
        boolean isDateAccord = true;
        Calendar recordDateCalendar = Calendar.getInstance();
        recordDateCalendar.setTime(recordDate);
        int recordDayOfWeek = recordDateCalendar.get(7);
        if (!includeSat && recordDayOfWeek == 7) {
            isDateAccord = false;
        } else if (!includeSun && recordDayOfWeek == 1) {
            isDateAccord = false;
        }
        return isDateAccord;
    }

    private static String buildBlockRapidProcessUrl(Long blockId) {
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("formId", "wtte_blockrapidprocess");
        params.put("type", "base");
        params.put("openStyle", "modal");
        params.put("pkId", String.valueOf(blockId));
        return AbnormalPushService.getUrl(params);
    }

    static {
        DEFAULT_POOL_SIZE = Runtime.getRuntime().availableProcessors() + 1;
        ENGINE_POOL_SIZE = DEFAULT_POOL_SIZE * 2;
        ruleServiceHelper = new HRBaseServiceHelper("wtp_expushrule");
        exRecordServiceHelper = new HRBaseServiceHelper("wtte_exrecord");
        exPushRecordServiceHelper = new HRBaseServiceHelper("wtte_expushrecord");
        exPushBlockRecordServiceHelper = new HRBaseServiceHelper("wtte_epblockrecord");
        try {
            EXECUTOR_SERVICE = ThreadPools.newExecutorService((String)WTC_WTTE_EX_PUSH_ENGINE_POOL_NAME, (int)ENGINE_POOL_SIZE);
        }
        catch (Exception e) {
            throw new WTCException((Throwable)e, "ExecExPushRecordPool init error...");
        }
    }

    private static class Instance {
        private static AbnormalPushService INSTANCE = new AbnormalPushService();

        private Instance() {
        }
    }
}

