/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtte.business.abnormal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtte.business.abnormal.AbnormalPushService;

public class AbnormalPushTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(AbnormalPushTask.class);
    public static final String EX_QUERY_PROPERTIES = "id,confirmstatus,personid,attitemvid,recorddate,attitemid,attfileid,attfilevid";
    public static final int INT_LIMIT = 1000;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        String scheduleId = this.taskId;
        Object execPresetRuleObj = map.get("exec_preset_rule");
        if (execPresetRuleObj == null) {
            return;
        }
        boolean execPresetRule = Boolean.parseBoolean(execPresetRuleObj.toString());
        Object execOtherRuleObj = map.get("exec_other_rule");
        if (execOtherRuleObj == null) {
            return;
        }
        List<DynamicObject> ruleList = AbnormalPushService.getAccordRules(execPresetRule, execOtherRuleObj);
        logger.info("AbnormalPushTask.execute.ruleList:{}", (Object)ruleList.size());
        QFilter exRecordFilter = AbnormalPushService.getExRecordFilter(ruleList);
        if (exRecordFilter == null) {
            return;
        }
        ArrayList<DynamicObject> allAbnormalList = new ArrayList<DynamicObject>(10);
        DataSet abnormalDataSet = AbnormalPushService.exRecordServiceHelper.queryDataSet(((Object)((Object)this)).getClass().getName(), "id", exRecordFilter.toArray());
        ArrayList<Long> abnormalIdList = new ArrayList<Long>(10);
        for (Row row : abnormalDataSet) {
            Long abnormalId = row.getLong("id");
            abnormalIdList.add(abnormalId);
        }
        logger.info("AbnormalPushTask.execute.abnormalIdList:{}", abnormalIdList);
        int count = abnormalIdList.size();
        logger.info("AbnormalPushTask.execute.count:{}", (Object)count);
        int batch = count / 1000;
        if (count % 1000 > 0) {
            ++batch;
        }
        logger.info("AbnormalPushTask.execute.batch:{}", (Object)batch);
        ArrayList<List> abnormalIdAllList = new ArrayList<List>(10);
        for (int index = 0; index < batch; ++index) {
            List idList = index < batch - 1 ? WTCCollections.subList(abnormalIdList, (int)(index * 1000), (int)((index + 1) * 1000)) : WTCCollections.subList(abnormalIdList, (int)(index * 1000), (int)abnormalIdList.size());
            abnormalIdAllList.add(idList);
        }
        logger.info("AbnormalPushTask.execute.abnormalIdAllList:{}", abnormalIdAllList);
        for (List idList : abnormalIdAllList) {
            if (WTCCollections.isEmpty((Collection)idList)) {
                logger.warn("AbnormalPushTask.execute.idList is empty");
                continue;
            }
            QFilter filter = new QFilter("id", "in", (Object)idList);
            DynamicObject[] exRecord = AbnormalPushService.exRecordServiceHelper.query(EX_QUERY_PROPERTIES, filter.toArray());
            List<DynamicObject> abnormalList = Arrays.asList(exRecord);
            allAbnormalList.addAll(abnormalList);
        }
        logger.info("AbnormalPushTask.execute.allAbnormalList:{}", (Object)allAbnormalList.size());
        AbnormalPushService.getInstance().pushLogic(allAbnormalList.toArray(new DynamicObject[0]), ruleList, false, false, null, Long.valueOf(scheduleId));
    }
}

